/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import javafx.beans.value.ChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebCamWindow
extends Overlay<WebCamWindow> {
    private static final Logger log = LoggerFactory.getLogger(WebCamWindow.class);
    private ImageView imageView = new ImageView();
    private ChangeListener<Image> listener;

    public WebCamWindow(double width, double height) {
        this.type = Overlay.Type.Feedback;
        this.imageView.setFitWidth(width);
        this.imageView.setFitHeight(height);
    }

    @Override
    public void show() {
        this.headLine = Res.get((String)"account.notifications.webCamWindow.headline");
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    private void addContent() {
        GridPane.setHalignment((Node)this.headLineLabel, (HPos)HPos.CENTER);
        Label label = FormBuilder.addLabel(this.gridPane, ++this.rowIndex, Res.get((String)"account.notifications.waitingForWebCam"));
        label.setAlignment(Pos.CENTER);
        GridPane.setColumnSpan((Node)label, (Integer)2);
        GridPane.setHalignment((Node)label, (HPos)HPos.CENTER);
        GridPane.setRowIndex((Node)this.imageView, (Integer)this.rowIndex);
        GridPane.setColumnSpan((Node)this.imageView, (Integer)2);
        this.gridPane.getChildren().add((Object)this.imageView);
    }

    @Override
    protected void addButtons() {
        super.addButtons();
        this.closeButton.setText(Res.get((String)"shared.cancel"));
        this.listener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                UserThread.execute(() -> this.closeButton.setText(Res.get((String)"shared.close")));
            }
        };
        this.imageView.imageProperty().addListener(this.listener);
    }

    @Override
    public void hide() {
        super.hide();
        if (this.listener != null) {
            this.imageView.imageProperty().removeListener(this.listener);
        }
    }

    public ImageView getImageView() {
        return this.imageView;
    }
}

