/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.common.util.Tuple2;
import haveno.core.api.CoreAccountService;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOfferManager;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.PasswordTextField;
import haveno.desktop.main.SharedPresentation;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bitcoinj.wallet.DeterministicSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletPasswordWindow
extends Overlay<WalletPasswordWindow> {
    private static final Logger log = LoggerFactory.getLogger(WalletPasswordWindow.class);
    private final CoreAccountService accountService;
    private final WalletsManager walletsManager;
    private final OpenOfferManager openOfferManager;
    private File storageDir;
    private Button unlockButton;
    private WalletPasswordHandler passwordHandler;
    private PasswordTextField passwordTextField;
    private Button forgotPasswordButton;
    private Button restoreButton;
    private TextArea seedWordsTextArea;
    private DatePicker datePicker;
    private final SimpleBooleanProperty seedWordsValid = new SimpleBooleanProperty(false);
    private final BooleanProperty seedWordsEdited = new SimpleBooleanProperty();
    private ChangeListener<String> changeListener;
    private ChangeListener<String> wordsTextAreaChangeListener;
    private ChangeListener<Boolean> seedWordsValidChangeListener;
    private boolean hideForgotPasswordButton = false;

    @Inject
    private WalletPasswordWindow(CoreAccountService accountService, WalletsManager walletsManager, OpenOfferManager openOfferManager, @Named(value="storageDir") File storageDir) {
        this.accountService = accountService;
        this.walletsManager = walletsManager;
        this.openOfferManager = openOfferManager;
        this.storageDir = storageDir;
        this.type = Overlay.Type.Attention;
        this.width = 900.0;
    }

    @Override
    public void show() {
        if (this.gridPane != null) {
            this.rowIndex = -1;
            this.gridPane.getChildren().clear();
        }
        if (this.headLine == null) {
            this.headLine = Res.get((String)"walletPasswordWindow.headline");
        }
        this.createGridPane();
        this.addHeadLine();
        this.addInputFields();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    public WalletPasswordWindow onSuccess(WalletPasswordHandler passwordHandler) {
        this.passwordHandler = passwordHandler;
        return this;
    }

    public WalletPasswordWindow hideForgotPasswordButton() {
        this.hideForgotPasswordButton = true;
        return this;
    }

    @Override
    protected void cleanup() {
        if (this.passwordTextField != null) {
            this.passwordTextField.textProperty().removeListener(this.changeListener);
        }
        if (this.seedWordsValidChangeListener != null) {
            this.seedWordsValid.removeListener(this.seedWordsValidChangeListener);
            this.seedWordsTextArea.textProperty().removeListener(this.wordsTextAreaChangeListener);
            this.restoreButton.disableProperty().unbind();
            this.restoreButton.setOnAction(null);
            this.seedWordsTextArea.setText("");
            this.datePicker.setValue(null);
            this.seedWordsTextArea.getStyleClass().remove((Object)"validation-error");
            this.datePicker.getStyleClass().remove((Object)"validation-error");
        }
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    private void addInputFields() {
        this.passwordTextField = FormBuilder.addPasswordTextField(this.gridPane, ++this.rowIndex, Res.get((String)"password.enterPassword"), 23.0);
        GridPane.setColumnSpan((Node)this.passwordTextField, (Integer)1);
        GridPane.setHalignment((Node)this.passwordTextField, (HPos)HPos.LEFT);
        this.changeListener = (observable, oldValue, newValue) -> this.unlockButton.setDisable(!this.passwordTextField.validate());
        this.passwordTextField.textProperty().addListener(this.changeListener);
    }

    @Override
    protected void addButtons() {
        BusyAnimation busyAnimation = new BusyAnimation(false);
        AutoTooltipLabel deriveStatusLabel = new AutoTooltipLabel();
        this.unlockButton = new AutoTooltipButton(Res.get((String)"shared.unlock"));
        this.unlockButton.setDefaultButton(true);
        this.unlockButton.getStyleClass().add((Object)"action-button");
        this.unlockButton.setDisable(true);
        this.unlockButton.setOnAction(e -> {
            String password = this.passwordTextField.getText();
            Preconditions.checkArgument((password.length() < 500 ? 1 : 0) != 0, (Object)Res.get((String)"password.tooLong"));
            try {
                this.accountService.verifyPassword(password);
                if (this.passwordHandler != null) {
                    this.passwordHandler.onSuccess();
                }
                this.hide();
            }
            catch (IncorrectPasswordException e2) {
                busyAnimation.stop();
                deriveStatusLabel.setText("");
                ((Popup)((Popup)new Popup().warning(Res.get((String)"password.wrongPw"))).onClose(() -> this.blurAgain())).show();
            }
        });
        this.forgotPasswordButton = new AutoTooltipButton(Res.get((String)"password.forgotPassword"));
        this.forgotPasswordButton.setOnAction(e -> {
            this.forgotPasswordButton.setDisable(true);
            this.unlockButton.setDefaultButton(false);
            this.showRestoreScreen();
        });
        AutoTooltipButton cancelButton = new AutoTooltipButton(Res.get((String)"shared.cancel"));
        cancelButton.setOnAction(event -> {
            this.hide();
            this.closeHandlerOptional.ifPresent(Runnable::run);
        });
        HBox hBox = new HBox();
        hBox.setMinWidth(560.0);
        hBox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        hBox.setSpacing(10.0);
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().add((Object)this.unlockButton);
        if (!this.hideForgotPasswordButton) {
            hBox.getChildren().add((Object)this.forgotPasswordButton);
        }
        if (!this.hideCloseButton) {
            hBox.getChildren().add((Object)cancelButton);
        }
        hBox.getChildren().addAll((Object[])new Node[]{busyAnimation, deriveStatusLabel});
        this.gridPane.getChildren().add((Object)hBox);
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHalignment(HPos.LEFT);
        columnConstraints1.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1});
    }

    private void showRestoreScreen() {
        AutoTooltipLabel headLine2Label = new AutoTooltipLabel(Res.get((String)"seed.restore.title"));
        headLine2Label.getStyleClass().add((Object)"popup-headline");
        headLine2Label.setMouseTransparent(true);
        GridPane.setHalignment((Node)headLine2Label, (HPos)HPos.LEFT);
        GridPane.setRowIndex((Node)headLine2Label, (Integer)(++this.rowIndex));
        GridPane.setMargin((Node)headLine2Label, (Insets)new Insets(30.0, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)headLine2Label);
        this.seedWordsTextArea = FormBuilder.addTextArea(this.gridPane, ++this.rowIndex, Res.get((String)"seed.enterSeedWords"), 5.0);
        this.seedWordsTextArea.setPrefHeight(60.0);
        Tuple2<Label, DatePicker> labelDatePickerTuple2 = FormBuilder.addTopLabelDatePicker(this.gridPane, ++this.rowIndex, Res.get((String)"seed.creationDate"), 10.0);
        this.datePicker = (DatePicker)labelDatePickerTuple2.second;
        this.restoreButton = FormBuilder.addPrimaryActionButton(this.gridPane, ++this.rowIndex, Res.get((String)"seed.restore"), 0.0);
        this.restoreButton.setDefaultButton(true);
        this.stage.setHeight(570.0);
        LocalDate walletCreationDate = Instant.ofEpochSecond(this.walletsManager.getChainSeedCreationTimeSeconds()).atZone(ZoneId.systemDefault()).toLocalDate();
        log.info("walletCreationDate " + String.valueOf(walletCreationDate));
        this.datePicker.setValue((Object)walletCreationDate);
        this.restoreButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.seedWordsValid.get() || !this.seedWordsEdited.get(), (Observable[])new Observable[]{this.seedWordsValid, this.seedWordsEdited}));
        this.seedWordsValidChangeListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.seedWordsTextArea.getStyleClass().remove((Object)"validation-error");
            } else {
                this.seedWordsTextArea.getStyleClass().add((Object)"validation-error");
            }
        };
        this.wordsTextAreaChangeListener = (observable, oldValue, newValue) -> {
            this.seedWordsEdited.set(true);
            try {
                MnemonicCode codec = new MnemonicCode();
                codec.check(Splitter.on((String)" ").splitToList((CharSequence)newValue));
                this.seedWordsValid.set(true);
            }
            catch (IOException | MnemonicException e) {
                this.seedWordsValid.set(false);
            }
        };
        this.seedWordsValid.addListener(this.seedWordsValidChangeListener);
        this.seedWordsTextArea.textProperty().addListener(this.wordsTextAreaChangeListener);
        this.restoreButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.seedWordsValid.get() || !this.seedWordsEdited.get(), (Observable[])new Observable[]{this.seedWordsValid, this.seedWordsEdited}));
        this.restoreButton.setOnAction(e -> this.onRestore());
        this.seedWordsTextArea.getStyleClass().remove((Object)"validation-error");
        this.datePicker.getStyleClass().remove((Object)"validation-error");
        this.layout();
    }

    private void onRestore() {
        if (this.walletsManager.hasPositiveBalance()) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"seed.warn.walletNotEmpty.msg"))).actionButtonText(Res.get((String)"seed.warn.walletNotEmpty.restore"))).onAction(this::checkIfEncrypted)).closeButtonText(Res.get((String)"seed.warn.walletNotEmpty.emptyWallet"))).show();
        } else {
            this.checkIfEncrypted();
        }
    }

    private void checkIfEncrypted() {
        if (this.walletsManager.areWalletsEncrypted()) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"seed.warn.notEncryptedAnymore"))).closeButtonText(Res.get((String)"shared.no"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(this::doRestore)).show();
        } else {
            this.doRestore();
        }
    }

    private void doRestore() {
        LocalDate value = (LocalDate)this.datePicker.getValue();
        long date = value != null ? value.atStartOfDay().toEpochSecond(ZoneOffset.UTC) : 0L;
        DeterministicSeed seed = new DeterministicSeed(Splitter.on((String)" ").splitToList((CharSequence)this.seedWordsTextArea.getText()), null, "", date);
        SharedPresentation.restoreSeedWords(this.walletsManager, this.openOfferManager, seed, this.storageDir);
    }

    public static interface WalletPasswordHandler {
        public void onSuccess();
    }
}

