/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.core.locale.Res;
import haveno.core.support.dispute.DisputeSummaryVerification;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyDisputeResultSignatureWindow
extends Overlay<VerifyDisputeResultSignatureWindow> {
    private static final Logger log = LoggerFactory.getLogger(VerifyDisputeResultSignatureWindow.class);
    private TextArea textArea;
    private TextField resultTextField;
    private final ArbitratorManager arbitratorManager;

    public VerifyDisputeResultSignatureWindow(ArbitratorManager arbitratorManager) {
        this.arbitratorManager = arbitratorManager;
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"support.sigCheck.popup.header");
        }
        this.width = 1050.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
        this.textArea.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                DisputeSummaryVerification.verifySignature((String)newValue, (ArbitratorManager)this.arbitratorManager);
                this.resultTextField.setText(Res.get((String)"support.sigCheck.popup.success"));
            }
            catch (Exception e) {
                this.resultTextField.setText(e.getMessage());
            }
        });
    }

    @Override
    protected void createGridPane() {
        this.gridPane = new GridPane();
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(64.0, 64.0, 64.0, 64.0));
        this.gridPane.setPrefWidth(this.width);
        this.gridPane.getStyleClass().add((Object)"popup-with-input");
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHalignment(HPos.RIGHT);
        columnConstraints1.setHgrow(Priority.SOMETIMES);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1});
    }

    private void addContent() {
        FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, Res.get((String)"support.sigCheck.popup.info"), 0.0, this.width);
        this.textArea = (TextArea)FormBuilder.addTopLabelTextArea((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"support.sigCheck.popup.msg.label"), (String)Res.get((String)"support.sigCheck.popup.msg.prompt")).second;
        this.resultTextField = (TextField)FormBuilder.addTopLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"support.sigCheck.popup.result")).second;
    }
}

