/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.core.locale.Res;
import haveno.core.payment.RevolutAccount;
import haveno.core.payment.validation.RevolutValidator;
import haveno.core.user.User;
import haveno.core.util.validation.InputValidator;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import javafx.scene.Scene;

public class UpdateRevolutAccountWindow
extends Overlay<UpdateRevolutAccountWindow> {
    private final RevolutValidator revolutValidator;
    private final RevolutAccount revolutAccount;
    private final User user;
    private InputTextField userNameInputTextField;

    public UpdateRevolutAccountWindow(RevolutAccount revolutAccount, User user) {
        this.revolutAccount = revolutAccount;
        this.user = user;
        this.type = Overlay.Type.Attention;
        this.hideCloseButton = true;
        this.revolutValidator = new RevolutValidator();
        this.actionButtonText = Res.get((String)"shared.save");
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"payment.revolut.addUserNameInfo.headLine");
        }
        this.width = 868.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    private void addContent() {
        FormBuilder.addLabel(this.gridPane, ++this.rowIndex, Res.get((String)"payment.account.revolut.addUserNameInfo", (Object[])new Object[]{Res.get((String)"payment.revolut.info"), this.revolutAccount.getAccountName()}));
        this.userNameInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"payment.account.username"), 10.0);
        this.userNameInputTextField.setValidator((InputValidator)this.revolutValidator);
        this.userNameInputTextField.textProperty().addListener((observable, oldValue, newValue) -> this.actionButton.setDisable(!this.revolutValidator.validate((String)newValue).isValid));
    }

    @Override
    protected void addButtons() {
        super.addButtons();
        this.actionButton.setOnAction(event -> {
            String userName = this.userNameInputTextField.getText();
            if (this.revolutValidator.validate((String)userName).isValid) {
                this.revolutAccount.setUsername(userName);
                this.user.requestPersistence();
                this.closeHandlerOptional.ifPresent(Runnable::run);
                this.hide();
            }
        });
        this.actionButton.setDisable(true);
    }
}

