/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.UserThread;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.user.User;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;

public class UpdateAmazonGiftCardAccountWindow
extends Overlay<UpdateAmazonGiftCardAccountWindow> {
    private final AmazonGiftCardAccount amazonGiftCardAccount;
    private final User user;
    private ComboBox<Country> countryCombo;

    public UpdateAmazonGiftCardAccountWindow(AmazonGiftCardAccount amazonGiftCardAccount, User user) {
        this.amazonGiftCardAccount = amazonGiftCardAccount;
        this.user = user;
        this.type = Overlay.Type.Attention;
        this.hideCloseButton = true;
        this.actionButtonText = Res.get((String)"shared.save");
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"payment.amazonGiftCard.upgrade.headLine");
        }
        this.width = 868.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
        if (this.countryCombo.getItems().size() == 1) {
            this.countryCombo.setValue((Object)((Country)this.countryCombo.getItems().get(0)));
            UserThread.runAfter(() -> this.actionButton.fire(), (long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void addContent() {
        FormBuilder.addLabel(this.gridPane, ++this.rowIndex, Res.get((String)"payment.account.amazonGiftCard.addCountryInfo", (Object[])new Object[]{Res.get((String)"payment.amazonGiftCard.upgrade"), this.amazonGiftCardAccount.getAccountName()}));
        FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.currency"), this.amazonGiftCardAccount.getSingleTradeCurrency().getNameAndCode());
        this.countryCombo = FormBuilder.addComboBox(this.gridPane, ++this.rowIndex, Res.get((String)"shared.country"));
        this.countryCombo.setPromptText(Res.get((String)"payment.select.country"));
        this.countryCombo.setItems(FXCollections.observableArrayList(UpdateAmazonGiftCardAccountWindow.getAppropriateCountries(this.amazonGiftCardAccount.getSingleTradeCurrency().getCode())));
        this.countryCombo.setConverter((StringConverter)new StringConverter<Country>(this){

            public String toString(Country country) {
                return country.name + " (" + country.code + ")";
            }

            public Country fromString(String s) {
                return null;
            }
        });
        this.countryCombo.setOnAction(e -> {
            Country countryCode = (Country)this.countryCombo.getValue();
            this.actionButton.setDisable(countryCode == null || countryCode.code == null || countryCode.code.length() < 1);
        });
    }

    @Override
    protected void addButtons() {
        super.addButtons();
        Country countryCode = (Country)this.countryCombo.getValue();
        if (countryCode == null || countryCode.code == null || countryCode.code.isEmpty()) {
            this.actionButton.setDisable(true);
        }
        this.actionButton.setOnAction(event -> {
            Country chosenCountryCode = (Country)this.countryCombo.getValue();
            if (chosenCountryCode != null && chosenCountryCode.code != null && !chosenCountryCode.code.isEmpty()) {
                this.amazonGiftCardAccount.setCountry(chosenCountryCode);
                this.user.requestPersistence();
                this.closeHandlerOptional.ifPresent(Runnable::run);
                this.hide();
            }
        });
    }

    public static List<Country> getAppropriateCountries(String currency) {
        ArrayList<Country> list = new ArrayList();
        if (currency.equalsIgnoreCase("EUR")) {
            list = CountryUtil.getAllAmazonGiftCardCountries();
            list = list.stream().filter(e -> e.code.matches("FR|DE|IT|NL|ES")).collect(Collectors.toList());
        } else {
            HashMap<String, String> mapCcyToCountry = new HashMap<String, String>(Map.of("AUD", "AU", "CAD", "CA", "GBP", "GB", "INR", "IN", "JPY", "JP", "SAR", "SA", "SEK", "SE", "SGD", "SG", "TRY", "TR", "USD", "US"));
            Optional found = CountryUtil.findCountryByCode((String)mapCcyToCountry.get(currency));
            if (found.isPresent()) {
                list.add((Country)found.get());
            }
        }
        return list;
    }
}

