/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.core.locale.Res;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class UnlockDisputeAgentRegistrationWindow
extends Overlay<UnlockDisputeAgentRegistrationWindow> {
    private final boolean useDevPrivilegeKeys;
    private Button unlockButton;
    private InputTextField keyInputTextField;
    private PrivKeyHandler privKeyHandler;
    private ChangeListener<String> changeListener;

    public UnlockDisputeAgentRegistrationWindow(boolean useDevPrivilegeKeys) {
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        if (this.keyInputTextField != null) {
            this.keyInputTextField.textProperty().addListener(this.changeListener);
        }
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        if (this.gridPane != null) {
            this.rowIndex = -1;
            this.gridPane.getChildren().clear();
        }
        if (this.headLine == null) {
            this.headLine = Res.get((String)"enterPrivKeyWindow.headline");
        }
        this.createGridPane();
        this.addHeadLine();
        this.addInputFields();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    public UnlockDisputeAgentRegistrationWindow onKey(PrivKeyHandler privKeyHandler) {
        this.privKeyHandler = privKeyHandler;
        return this;
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    private void addInputFields() {
        Tuple3<Label, InputTextField, VBox> labelInputTextFieldTuple2 = FormBuilder.addTopLabelInputTextFieldWithVBox(this.gridPane, ++this.rowIndex, Res.get((String)"shared.enterPrivKey"), 3.0);
        GridPane.setColumnSpan((Node)((Node)labelInputTextFieldTuple2.third), (Integer)2);
        Label label = (Label)labelInputTextFieldTuple2.first;
        label.setWrapText(true);
        this.keyInputTextField = (InputTextField)((Object)labelInputTextFieldTuple2.second);
        if (this.useDevPrivilegeKeys) {
            this.keyInputTextField.setText("6ac43ea1df2a290c1c8391736aa42e4339c5cb4f110ff0257a13b63211977b7a");
        }
        this.changeListener = (observable, oldValue, newValue) -> this.unlockButton.setDisable(newValue.length() == 0);
        this.keyInputTextField.textProperty().addListener(this.changeListener);
    }

    @Override
    protected void addButtons() {
        Tuple2<Button, Button> buttonButtonTuple2 = FormBuilder.add2ButtonsAfterGroup(this.gridPane, ++this.rowIndex, Res.get((String)"shared.unlock"), Res.get((String)"shared.close"));
        this.unlockButton = (Button)buttonButtonTuple2.first;
        this.unlockButton.setDisable(this.keyInputTextField.getText().length() == 0);
        this.unlockButton.setOnAction(e -> {
            if (this.privKeyHandler.checkKey(this.keyInputTextField.getText())) {
                this.hide();
            } else {
                ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"shared.invalidKey"))).width(300.0)).onClose(() -> this.blurAgain())).show();
            }
        });
        Button closeButton = (Button)buttonButtonTuple2.second;
        closeButton.setOnAction(event -> {
            this.hide();
            this.closeHandlerOptional.ifPresent(Runnable::run);
        });
    }

    public static interface PrivKeyHandler {
        public boolean checkKey(String var1);
    }
}

