/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.main.funds.transactions.TransactionsListItem;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import java.math.BigInteger;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import monero.wallet.model.MoneroTxWallet;

public class TxDetailsWindow
extends Overlay<TxDetailsWindow> {
    private XmrWalletService xmrWalletService;
    private TransactionsListItem item;

    @Inject
    public TxDetailsWindow(XmrWalletService xmrWalletService) {
        this.xmrWalletService = xmrWalletService;
    }

    public void show(TransactionsListItem item) {
        this.item = item;
        this.rowIndex = -1;
        this.width = 918.0;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"txDetailsWindow.headline");
        }
        this.createGridPane();
        this.gridPane.setHgap(15.0);
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    protected void addContent() {
        BigInteger amount;
        boolean isOutgoing;
        MoneroTxWallet tx = this.item.getTx();
        String memo = tx.getNote();
        String txKey = null;
        boolean bl = isOutgoing = tx.getOutgoingTransfer() != null;
        if (isOutgoing) {
            try {
                txKey = this.xmrWalletService.getWallet().getTxKey(tx.getHash());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String resKey = isOutgoing ? "txDetailsWindow.xmr.noteSent" : "txDetailsWindow.xmr.noteReceived";
        GridPane.setColumnSpan((Node)FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, Res.get((String)resKey), 0.0), (Integer)2);
        Region spacer = new Region();
        spacer.setMinHeight(15.0);
        this.gridPane.add((Node)spacer, 0, ++this.rowIndex);
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.dateTime"), this.item.getDateString());
        if (isOutgoing) {
            FormBuilder.addConfirmationLabelTextFieldWithCopyIcon(this.gridPane, ++this.rowIndex, Res.get((String)"txDetailsWindow.sentTo"), this.item.getAddressString());
            amount = tx.getOutgoingAmount();
        } else {
            FormBuilder.addConfirmationLabelTextFieldWithCopyIcon(this.gridPane, ++this.rowIndex, Res.get((String)"txDetailsWindow.receivedWith"), this.item.getAddressString());
            amount = tx.getIncomingAmount();
        }
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.amount"), HavenoUtils.formatXmr((BigInteger)amount));
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.txFee"), HavenoUtils.formatXmr((BigInteger)tx.getFee()));
        if (memo != null && !"".equals(memo)) {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"funds.withdrawal.memoLabel"), memo);
        }
        if (txKey != null && !"".equals(txKey)) {
            FormBuilder.addConfirmationLabelTextFieldWithCopyIcon(this.gridPane, ++this.rowIndex, Res.get((String)"txDetailsWindow.txKey"), txKey);
        }
        FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"txDetailsWindow.txId"), tx.getHash());
    }
}

