/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.desktop.components.HavenoTextArea;
import haveno.desktop.main.MainView;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import java.lang.invoke.StringConcatFactory;
import java.math.BigInteger;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeDetailsWindow
extends Overlay<TradeDetailsWindow> {
    protected static final Logger log = LoggerFactory.getLogger(TradeDetailsWindow.class);
    private final CoinFormatter formatter;
    private final ArbitrationManager arbitrationManager;
    private final TradeManager tradeManager;
    private final BtcWalletService btcWalletService;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private Trade trade;
    private ChangeListener<Number> changeListener;
    private TextArea textArea;
    private String buyersAccountAge;
    private String sellersAccountAge;

    @Inject
    public TradeDetailsWindow(@Named(value="BTC") CoinFormatter formatter, ArbitrationManager arbitrationManager, TradeManager tradeManager, BtcWalletService btcWalletService, AccountAgeWitnessService accountAgeWitnessService) {
        this.formatter = formatter;
        this.arbitrationManager = arbitrationManager;
        this.tradeManager = tradeManager;
        this.btcWalletService = btcWalletService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.type = Overlay.Type.Confirmation;
    }

    public void show(Trade trade) {
        this.trade = trade;
        this.rowIndex = -1;
        this.width = 950.0;
        this.createGridPane();
        this.addContent();
        this.display();
    }

    @Override
    protected void cleanup() {
        if (this.textArea != null) {
            this.textArea.scrollTopProperty().addListener(this.changeListener);
        }
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.getStyleClass().add((Object)"grid-pane");
    }

    private void addContent() {
        boolean showDisputedTx;
        String xmrDirectionInfo;
        String counterCurrencyDirectionInfo;
        Offer offer = this.trade.getOffer();
        Contract contract = this.trade.getContract();
        int rows = 9;
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, rows, Res.get((String)"tradeDetailsWindow.headline"));
        boolean myOffer = this.tradeManager.isMyOffer(offer);
        String toReceive = " " + Res.get((String)"shared.toReceive");
        String toSpend = " " + Res.get((String)"shared.toSpend");
        String offerType = Res.get((String)"shared.offerType");
        if (this.tradeManager.isBuyer(offer)) {
            FormBuilder.addConfirmationLabelTextField(this.gridPane, this.rowIndex, offerType, DisplayUtils.getDirectionForBuyer(myOffer, offer.getCounterCurrencyCode()), 40.0);
            counterCurrencyDirectionInfo = toSpend;
            xmrDirectionInfo = toReceive;
        } else {
            FormBuilder.addConfirmationLabelTextField(this.gridPane, this.rowIndex, offerType, DisplayUtils.getDirectionForSeller(myOffer, offer.getCounterCurrencyCode()), 40.0);
            counterCurrencyDirectionInfo = toReceive;
            xmrDirectionInfo = toSpend;
        }
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.xmrAmount") + xmrDirectionInfo, HavenoUtils.formatXmr((BigInteger)this.trade.getAmount(), (boolean)true));
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, VolumeUtil.formatVolumeLabel((String)offer.getCounterCurrencyCode()) + counterCurrencyDirectionInfo, VolumeUtil.formatVolumeWithCode((Volume)this.trade.getVolume()));
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.tradePrice"), FormattingUtils.formatPrice((Price)this.trade.getPrice()));
        String paymentMethodText = Res.get((String)offer.getPaymentMethod().getId());
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.paymentMethod"), paymentMethodText);
        rows = 5;
        if (offer.getCombinedExtraInfo() != null && !offer.getCombinedExtraInfo().isEmpty()) {
            ++rows;
        }
        PaymentAccountPayload buyerPaymentAccountPayload = null;
        PaymentAccountPayload sellerPaymentAccountPayload = null;
        if (contract != null) {
            ++rows;
            buyerPaymentAccountPayload = this.trade.getBuyer().getPaymentAccountPayload();
            sellerPaymentAccountPayload = this.trade.getSeller().getPaymentAccountPayload();
            if (buyerPaymentAccountPayload != null) {
                ++rows;
            }
            if (sellerPaymentAccountPayload != null) {
                ++rows;
            }
            if (buyerPaymentAccountPayload == null && sellerPaymentAccountPayload == null) {
                ++rows;
            }
        }
        boolean bl = showDisputedTx = this.arbitrationManager.findOwnDispute(this.trade.getId()).isPresent() && ((Dispute)this.arbitrationManager.findOwnDispute(this.trade.getId()).get()).getDisputePayoutTxId() != null;
        if (showDisputedTx) {
            ++rows;
        } else if (this.trade.getPayoutTxId() != null) {
            ++rows;
        }
        if (this.trade.hasFailed()) {
            rows += 2;
        }
        if (this.trade.getTradePeerNodeAddress() != null) {
            ++rows;
        }
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, rows, Res.get((String)"shared.details"), 30.0);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, this.rowIndex, Res.get((String)"shared.tradeId"), this.trade.getId(), 70.0);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"tradeDetailsWindow.tradeDate"), DisplayUtils.formatDateTime(this.trade.getDate()));
        String securityDeposit = Res.getWithColAndCap((String)"shared.buyer") + " " + HavenoUtils.formatXmr((BigInteger)this.trade.getBuyerSecurityDepositBeforeMiningFee(), (boolean)true) + " / " + Res.getWithColAndCap((String)"shared.seller") + " " + HavenoUtils.formatXmr((BigInteger)this.trade.getSellerSecurityDepositBeforeMiningFee(), (boolean)true);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.securityDeposit"), securityDeposit);
        NodeAddress arbitratorNodeAddress = this.trade.getArbitratorNodeAddress();
        if (arbitratorNodeAddress != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"tradeDetailsWindow.agentAddresses"), arbitratorNodeAddress.getFullAddress());
        }
        if (this.trade.getTradePeerNodeAddress() != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"tradeDetailsWindow.tradePeersOnion"), this.trade.getTradePeerNodeAddress().getFullAddress());
        }
        if (offer.getCombinedExtraInfo() != null && !offer.getCombinedExtraInfo().isEmpty()) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            TextArea textArea = (TextArea)FormBuilder.addConfirmationLabelTextArea((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"payment.shared.extraInfo.offer"), (String)"", (double)0.0).second;
            textArea.setText(offer.getCombinedExtraInfo().trim());
            textArea.setMaxHeight(150.0);
            textArea.setEditable(false);
            GUIUtil.adjustHeightAutomatically(textArea, 150.0);
        }
        if (contract != null) {
            String postFix;
            String paymentDetails;
            this.buyersAccountAge = DisplayUtils.getAccountWitnessDescription(this.accountAgeWitnessService, offer.getPaymentMethod(), buyerPaymentAccountPayload, contract.getBuyerPubKeyRing());
            this.sellersAccountAge = DisplayUtils.getAccountWitnessDescription(this.accountAgeWitnessService, offer.getPaymentMethod(), sellerPaymentAccountPayload, contract.getSellerPubKeyRing());
            if (buyerPaymentAccountPayload != null) {
                paymentDetails = buyerPaymentAccountPayload.getPaymentDetails();
                postFix = " / " + this.buyersAccountAge;
                FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
                ((TextField)FormBuilder.addConfirmationLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"shared.paymentDetails", (Object[])new Object[]{Res.get((String)"shared.buyer")}), (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)paymentDetails, (String)postFix))).second).setTooltip(new Tooltip(paymentDetails + postFix));
            }
            if (sellerPaymentAccountPayload != null) {
                paymentDetails = sellerPaymentAccountPayload.getPaymentDetails();
                postFix = " / " + this.sellersAccountAge;
                FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
                ((TextField)FormBuilder.addConfirmationLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"shared.paymentDetails", (Object[])new Object[]{Res.get((String)"shared.seller")}), (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)paymentDetails, (String)postFix))).second).setTooltip(new Tooltip(paymentDetails + postFix));
            }
            if (buyerPaymentAccountPayload == null && sellerPaymentAccountPayload == null) {
                FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
                FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.paymentMethod"), Res.get((String)contract.getPaymentMethodId()));
            }
        }
        if (this.trade.getMaker().getDepositTxHash() != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.makerDepositTransactionId"), this.trade.getMaker().getDepositTxHash());
        }
        if (this.trade.getTaker().getDepositTxHash() != null) {
            FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.takerDepositTransactionId"), this.trade.getTaker().getDepositTxHash());
        }
        if (showDisputedTx) {
            FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"tradeDetailsWindow.disputedPayoutTxId"), ((Dispute)this.arbitrationManager.findOwnDispute(this.trade.getId()).get()).getDisputePayoutTxId());
        } else if (this.trade.getPayoutTxId() != null && !this.trade.getPayoutTxId().isBlank()) {
            FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.payoutTxId"), this.trade.getPayoutTxId());
        }
        if (this.trade.hasFailed()) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            this.textArea = (TextArea)FormBuilder.addConfirmationLabelTextArea((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"shared.errorMessage"), (String)"", (double)0.0).second;
            this.textArea.setText(this.trade.getErrorMessage());
            this.textArea.setEditable(false);
            SimpleIntegerProperty count = new SimpleIntegerProperty(20);
            int rowHeight = 10;
            this.textArea.prefHeightProperty().bindBidirectional((Property)count);
            this.changeListener = (arg_0, arg_1, arg_2) -> TradeDetailsWindow.lambda$addContent$0(rowHeight, (IntegerProperty)count, arg_0, arg_1, arg_2);
            this.textArea.scrollTopProperty().addListener(this.changeListener);
            this.textArea.setScrollTop(30.0);
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"tradeDetailsWindow.tradePhase"), this.trade.getPhase().name());
        }
        Tuple3<Button, Button, HBox> tuple = FormBuilder.add2ButtonsWithBox(this.gridPane, ++this.rowIndex, Res.get((String)"tradeDetailsWindow.detailData"), Res.get((String)"shared.close"), 15.0, false);
        Button viewContractButton = (Button)tuple.first;
        viewContractButton.setMaxWidth(-1.0);
        Button closeButton = (Button)tuple.second;
        closeButton.setMaxWidth(-1.0);
        HBox hBox = (HBox)tuple.third;
        GridPane.setColumnSpan((Node)hBox, (Integer)2);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        hBox.getChildren().add(0, (Object)spacer);
        String buyerWitnessHash = this.trade.getBuyer().getAccountAgeWitness() == null ? "null" : Utilities.bytesAsHexString((byte[])this.trade.getBuyer().getAccountAgeWitness().getHash());
        String buyerPubKeyRingHash = Utilities.bytesAsHexString((byte[])this.trade.getBuyer().getPubKeyRing().getSignaturePubKeyBytes());
        String sellerWitnessHash = this.trade.getSeller().getAccountAgeWitness() == null ? "null" : Utilities.bytesAsHexString((byte[])this.trade.getSeller().getAccountAgeWitness().getHash());
        String sellerPubKeyRingHash = Utilities.bytesAsHexString((byte[])this.trade.getSeller().getPubKeyRing().getSignaturePubKeyBytes());
        viewContractButton.setOnAction(e -> {
            HavenoTextArea textArea = new HavenoTextArea();
            textArea.setText(this.trade.getContractAsJson());
            String data = "Trade state: " + String.valueOf(this.trade.getState());
            data = data + "\nTrade payout state: " + String.valueOf(this.trade.getPayoutState());
            data = data + "\nTrade dispute state: " + String.valueOf(this.trade.getDisputeState());
            data = data + "\n\nContract as json:\n";
            data = data + this.trade.getContractAsJson();
            data = data + "\n\nOther detail data:";
            if (!this.trade.isDepositsPublished()) {
                data = data + "\n\n" + (this.trade.getMaker() == this.trade.getBuyer() ? "Buyer" : "Seller") + " as maker reserve tx hex: " + this.trade.getMaker().getReserveTxHex();
                data = data + "\n\n" + (this.trade.getTaker() == this.trade.getBuyer() ? "Buyer" : "Seller") + " as taker reserve tx hex: " + this.trade.getTaker().getReserveTxHex();
            }
            if (offer.isTraditionalOffer()) {
                data = data + "\n\nBuyers witness hash,pub key ring hash: " + buyerWitnessHash + "," + buyerPubKeyRingHash;
                data = data + "\nBuyers account age: " + this.buyersAccountAge;
                data = data + "\nSellers witness hash,pub key ring hash: " + sellerWitnessHash + "," + sellerPubKeyRingHash;
                data = data + "\nSellers account age: " + this.sellersAccountAge;
            }
            data = data + "\n\nSelected arbitrator: " + String.valueOf(this.trade.getArbitrator().getNodeAddress());
            textArea.setText(data);
            textArea.setPrefHeight(50.0);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setPrefSize(800.0, 600.0);
            Scene viewContractScene = new Scene((Parent)textArea);
            Stage viewContractStage = new Stage();
            viewContractStage.setTitle(Res.get((String)"shared.contract.title", (Object[])new Object[]{this.trade.getShortId()}));
            viewContractStage.setScene(viewContractScene);
            if (this.owner == null) {
                this.owner = MainView.getRootContainer();
            }
            Scene rootScene = this.owner.getScene();
            viewContractStage.initOwner(rootScene.getWindow());
            viewContractStage.initModality(Modality.NONE);
            viewContractStage.initStyle(StageStyle.UTILITY);
            viewContractStage.setOpacity(0.0);
            viewContractStage.show();
            Window window = rootScene.getWindow();
            double titleBarHeight = window.getHeight() - rootScene.getHeight();
            viewContractStage.setX((double)(Math.round(window.getX() + (this.owner.getWidth() - viewContractStage.getWidth()) / 2.0) + 200L));
            viewContractStage.setY((double)(Math.round(window.getY() + titleBarHeight + (this.owner.getHeight() - viewContractStage.getHeight()) / 2.0) + 50L));
            UserThread.execute(() -> viewContractStage.setOpacity(1.0));
            viewContractScene.setOnKeyPressed(ev -> {
                if (ev.getCode() == KeyCode.ESCAPE) {
                    ev.consume();
                    viewContractStage.hide();
                }
            });
        });
        closeButton.setOnAction(e -> {
            this.closeHandlerOptional.ifPresent(Runnable::run);
            this.hide();
        });
    }

    private static /* synthetic */ void lambda$addContent$0(int rowHeight, IntegerProperty count, ObservableValue ov, Number old, Number newVal) {
        if (newVal.intValue() > rowHeight) {
            count.setValue((Number)(count.get() + newVal.intValue() + 10));
        }
    }
}

