/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.UserThread;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple4;
import haveno.common.util.Utilities;
import haveno.core.app.TorSetup;
import haveno.core.locale.Res;
import haveno.core.user.Preferences;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import haveno.network.p2p.network.DefaultPluggableTransports;
import haveno.network.p2p.network.NetworkNode;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javafx.collections.FXCollections;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TorNetworkSettingsWindow
extends Overlay<TorNetworkSettingsWindow> {
    private static final Logger log = LoggerFactory.getLogger(TorNetworkSettingsWindow.class);
    private final Preferences preferences;
    private final NetworkNode networkNode;
    private final TorSetup torSetup;
    private Label enterBridgeLabel;
    private ComboBox<Transport> transportTypeComboBox;
    private TextArea bridgeEntriesTextArea;
    private BridgeOption selectedBridgeOption = BridgeOption.NONE;
    private Transport selectedTorTransportOrdinal = Transport.OBFS_4;
    private String customBridges = "";

    @Inject
    public TorNetworkSettingsWindow(Preferences preferences, NetworkNode networkNode, TorSetup torSetup) {
        this.preferences = preferences;
        this.networkNode = networkNode;
        this.torSetup = torSetup;
        this.type = Overlay.Type.Attention;
        this.useShutDownButton();
    }

    @Override
    public void show() {
        if (!this.isDisplayed) {
            if (this.headLine == null) {
                this.headLine = Res.get((String)"torNetworkSettingWindow.header");
            }
            this.width = 1068.0;
            this.rowIndex = 0;
            this.createGridPane();
            ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setHalignment(HPos.LEFT);
            this.addContent();
            this.addButtons();
            this.applyStyles();
            this.display();
        }
    }

    @Override
    protected void addButtons() {
        this.closeButton = new AutoTooltipButton(this.closeButtonText == null ? Res.get((String)"shared.close") : this.closeButtonText);
        this.closeButton.setOnAction(event -> this.doClose());
        if (this.actionHandlerOptional.isPresent()) {
            this.actionButton = new AutoTooltipButton(Res.get((String)"shared.shutDown"));
            this.actionButton.setDefaultButton(true);
            this.actionButton.setOnAction(event -> this.saveAndShutDown());
            AutoTooltipButton urlButton = new AutoTooltipButton(Res.get((String)"torNetworkSettingWindow.openTorWebPage"));
            urlButton.setOnAction(event -> {
                try {
                    Utilities.openURI((URI)URI.create("https://bridges.torproject.org"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Pane spacer = new Pane();
            HBox hBox = new HBox();
            hBox.setSpacing(10.0);
            hBox.getChildren().addAll((Object[])new Node[]{spacer, urlButton, this.closeButton, this.actionButton});
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            GridPane.setHalignment((Node)hBox, (HPos)HPos.RIGHT);
            GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
            GridPane.setColumnSpan((Node)hBox, (Integer)2);
            GridPane.setMargin((Node)hBox, (Insets)new Insets(this.buttonDistance, 0.0, 0.0, 0.0));
            this.gridPane.getChildren().add((Object)hBox);
        } else if (!this.hideCloseButton) {
            this.closeButton.setDefaultButton(true);
            GridPane.setHalignment((Node)this.closeButton, (HPos)HPos.RIGHT);
            GridPane.setMargin((Node)this.closeButton, (Insets)new Insets(this.buttonDistance, 0.0, 0.0, 0.0));
            GridPane.setRowIndex((Node)this.closeButton, (Integer)this.rowIndex);
            GridPane.setColumnIndex((Node)this.closeButton, (Integer)1);
            this.gridPane.getChildren().add((Object)this.closeButton);
        }
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                } else if (e.getCode() == KeyCode.ENTER) {
                    e.consume();
                    this.saveAndShutDown();
                }
            });
        }
    }

    @Override
    protected void applyStyles() {
        super.applyStyles();
        this.gridPane.setId("popup-grid-pane-bg");
    }

    private void addContent() {
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, 2, Res.get((String)"torNetworkSettingWindow.deleteFiles.header"));
        Label deleteFilesLabel = FormBuilder.addLabel(this.gridPane, this.rowIndex, Res.get((String)"torNetworkSettingWindow.deleteFiles.info"), 40.0);
        deleteFilesLabel.setWrapText(true);
        GridPane.setColumnIndex((Node)deleteFilesLabel, (Integer)0);
        GridPane.setColumnSpan((Node)deleteFilesLabel, (Integer)2);
        GridPane.setHalignment((Node)deleteFilesLabel, (HPos)HPos.LEFT);
        GridPane.setValignment((Node)deleteFilesLabel, (VPos)VPos.TOP);
        Tuple4<Button, BusyAnimation, Label, HBox> tuple = FormBuilder.addButtonBusyAnimationLabelAfterGroup(this.gridPane, ++this.rowIndex, Res.get((String)"torNetworkSettingWindow.deleteFiles.button"));
        Button deleteFilesButton = (Button)tuple.first;
        deleteFilesButton.getStyleClass().remove((Object)"action-button");
        deleteFilesButton.setOnAction(e -> {
            ((BusyAnimation)((Object)((Object)tuple.second))).play();
            ((Label)tuple.third).setText(Res.get((String)"torNetworkSettingWindow.deleteFiles.progress"));
            this.gridPane.setMouseTransparent(true);
            deleteFilesButton.setDisable(true);
            this.cleanTorDir(() -> {
                ((BusyAnimation)((Object)((Object)((Object)tuple.second)))).stop();
                ((Label)tuple.third).setText("");
                ((Popup)((Popup)((Popup)new Popup().feedback(Res.get((String)"torNetworkSettingWindow.deleteFiles.success"))).useShutDownButton()).hideCloseButton()).show();
            });
        });
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, 8, Res.get((String)"torNetworkSettingWindow.bridges.header"), 40.0);
        titledGroupBg.getStyleClass().add((Object)"last");
        Label bridgesLabel = FormBuilder.addLabel(this.gridPane, this.rowIndex, Res.get((String)"torNetworkSettingWindow.bridges.info"), 80.0);
        bridgesLabel.setWrapText(true);
        GridPane.setColumnIndex((Node)bridgesLabel, (Integer)0);
        GridPane.setColumnSpan((Node)bridgesLabel, (Integer)2);
        GridPane.setHalignment((Node)bridgesLabel, (HPos)HPos.LEFT);
        GridPane.setValignment((Node)bridgesLabel, (VPos)VPos.TOP);
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioButton noBridgesRadioButton = FormBuilder.addRadioButton(this.gridPane, ++this.rowIndex, toggleGroup, Res.get((String)"torNetworkSettingWindow.noBridges"));
        noBridgesRadioButton.setUserData((Object)BridgeOption.NONE);
        GridPane.setMargin((Node)noBridgesRadioButton, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        RadioButton providedBridgesRadioButton = FormBuilder.addRadioButton(this.gridPane, ++this.rowIndex, toggleGroup, Res.get((String)"torNetworkSettingWindow.providedBridges"));
        providedBridgesRadioButton.setUserData((Object)BridgeOption.PROVIDED);
        this.transportTypeComboBox = FormBuilder.addComboBox(this.gridPane, ++this.rowIndex, Res.get((String)"torNetworkSettingWindow.transportType"));
        this.transportTypeComboBox.setItems(FXCollections.observableArrayList(Arrays.asList(Transport.OBFS_4, Transport.OBFS_3, Transport.MEEK_AMAZON, Transport.MEEK_AZURE)));
        this.transportTypeComboBox.setConverter((StringConverter)new StringConverter<Transport>(this){

            public String toString(Transport transport) {
                switch (transport.ordinal()) {
                    case 1: {
                        return Res.get((String)"torNetworkSettingWindow.obfs3");
                    }
                    case 2: {
                        return Res.get((String)"torNetworkSettingWindow.meekAmazon");
                    }
                    case 3: {
                        return Res.get((String)"torNetworkSettingWindow.meekAzure");
                    }
                }
                return Res.get((String)"torNetworkSettingWindow.obfs4");
            }

            public Transport fromString(String string) {
                return null;
            }
        });
        RadioButton customBridgesRadioButton = FormBuilder.addRadioButton(this.gridPane, ++this.rowIndex, toggleGroup, Res.get((String)"torNetworkSettingWindow.customBridges"));
        customBridgesRadioButton.setUserData((Object)BridgeOption.CUSTOM);
        Tuple2<Label, TextArea> labelTextAreaTuple2 = FormBuilder.addTopLabelTextArea(this.gridPane, ++this.rowIndex, Res.get((String)"torNetworkSettingWindow.enterBridge"), Res.get((String)"torNetworkSettingWindow.enterBridgePrompt"));
        this.enterBridgeLabel = (Label)labelTextAreaTuple2.first;
        this.bridgeEntriesTextArea = (TextArea)labelTextAreaTuple2.second;
        this.bridgeEntriesTextArea.setPrefHeight(60.0);
        Label label2 = FormBuilder.addLabel(this.gridPane, ++this.rowIndex, Res.get((String)"torNetworkSettingWindow.restartInfo"));
        label2.setWrapText(true);
        GridPane.setColumnSpan((Node)label2, (Integer)2);
        GridPane.setHalignment((Node)label2, (HPos)HPos.LEFT);
        GridPane.setValignment((Node)label2, (VPos)VPos.TOP);
        GridPane.setMargin((Node)label2, (Insets)new Insets(10.0, 10.0, 20.0, 0.0));
        this.selectedBridgeOption = BridgeOption.values()[this.preferences.getBridgeOptionOrdinal()];
        switch (this.selectedBridgeOption.ordinal()) {
            case 1: {
                toggleGroup.selectToggle((Toggle)providedBridgesRadioButton);
                break;
            }
            case 2: {
                toggleGroup.selectToggle((Toggle)customBridgesRadioButton);
                break;
            }
            default: {
                toggleGroup.selectToggle((Toggle)noBridgesRadioButton);
            }
        }
        this.applyToggleSelection();
        this.selectedTorTransportOrdinal = Transport.values()[this.preferences.getTorTransportOrdinal()];
        this.transportTypeComboBox.getSelectionModel().select((Object)this.selectedTorTransportOrdinal);
        this.customBridges = this.preferences.getCustomBridges();
        this.bridgeEntriesTextArea.setText(this.customBridges);
        toggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            this.selectedBridgeOption = (BridgeOption)((Object)((Object)newValue.getUserData()));
            this.preferences.setBridgeOptionOrdinal(this.selectedBridgeOption.ordinal());
            this.applyToggleSelection();
        });
        this.transportTypeComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.selectedTorTransportOrdinal = newValue;
            this.preferences.setTorTransportOrdinal(this.selectedTorTransportOrdinal.ordinal());
            this.setBridgeAddressesByTransport();
        });
        this.bridgeEntriesTextArea.textProperty().addListener((observable, oldValue, newValue) -> {
            this.customBridges = newValue;
            this.preferences.setCustomBridges(this.customBridges);
            this.setBridgeAddressesByCustomBridges();
        });
    }

    private void cleanTorDir(Runnable resultHandler) {
        this.networkNode.shutDown(() -> UserThread.runAfter(() -> this.torSetup.cleanupTorFiles(resultHandler, errorMessage -> ((Popup)new Popup().error(errorMessage)).show()), (long)3L));
    }

    private void applyToggleSelection() {
        switch (this.selectedBridgeOption.ordinal()) {
            case 1: {
                this.transportTypeComboBox.setDisable(false);
                this.enterBridgeLabel.setDisable(true);
                this.bridgeEntriesTextArea.setDisable(true);
                this.setBridgeAddressesByTransport();
                break;
            }
            case 2: {
                this.enterBridgeLabel.setDisable(false);
                this.bridgeEntriesTextArea.setDisable(false);
                this.transportTypeComboBox.setDisable(true);
                this.setBridgeAddressesByCustomBridges();
                break;
            }
            default: {
                this.transportTypeComboBox.setDisable(true);
                this.enterBridgeLabel.setDisable(true);
                this.bridgeEntriesTextArea.setDisable(true);
                this.preferences.setBridgeAddresses(null);
            }
        }
    }

    private void setBridgeAddressesByTransport() {
        switch (this.selectedTorTransportOrdinal.ordinal()) {
            case 1: {
                this.preferences.setBridgeAddresses(DefaultPluggableTransports.OBFS_3);
                break;
            }
            case 2: {
                this.preferences.setBridgeAddresses(DefaultPluggableTransports.MEEK_AMAZON);
                break;
            }
            case 3: {
                this.preferences.setBridgeAddresses(DefaultPluggableTransports.MEEK_AZURE);
                break;
            }
            default: {
                this.preferences.setBridgeAddresses(DefaultPluggableTransports.OBFS_4);
            }
        }
    }

    private void setBridgeAddressesByCustomBridges() {
        this.preferences.setBridgeAddresses(this.customBridges != null ? Arrays.asList(this.customBridges.split("\\n")) : null);
    }

    private void saveAndShutDown() {
        UserThread.runAfter(() -> this.actionHandlerOptional.ifPresent(Runnable::run), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.hide();
    }

    public static enum BridgeOption {
        NONE,
        PROVIDED,
        CUSTOM;

    }

    public static enum Transport {
        OBFS_4,
        OBFS_3,
        MEEK_AMAZON,
        MEEK_AZURE;

    }
}

