/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.desktop.app.HavenoApp;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.stage.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TacWindow
extends Overlay<TacWindow> {
    private static final Logger log = LoggerFactory.getLogger(TacWindow.class);
    private final boolean smallScreen;

    @Inject
    public TacWindow() {
        this.type = Overlay.Type.Attention;
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        double primaryScreenBoundsWidth = primaryScreenBounds.getWidth();
        boolean bl = this.smallScreen = primaryScreenBoundsWidth < 1024.0;
        if (this.smallScreen) {
            this.width = primaryScreenBoundsWidth * 0.8;
            log.warn("Very small screen: primaryScreenBounds=" + primaryScreenBounds.toString());
        } else {
            this.width = 1250.0;
        }
    }

    @Override
    public void show() {
        this.headLine(Res.get((String)"tacWindow.headline"));
        String text = "1. In no event, unless for damages caused by acts of intent and gross negligence, damages resulting from personal injury, or damages ensuing from other instances where liability is required by applicable law or agreed to in writing, will any developer, copyright holder and/or any other party who modifies and/or conveys the software as permitted above or facilitates its operation, be liable for damages, including any general, special, incidental or consequential damages arising out of the use or inability to use the software (including but not limited to loss of data or data being rendered inaccurate or losses sustained by you or third parties or a failure of the software to operate with any other software), even if such developer, copyright holder and/or other party has been advised of the possibility of such damages.\n\n2. The user is responsible for using the software in compliance with local laws. Don't use the software if using it is not legal in your jurisdiction.\n\n3. Any " + Res.getBaseCurrencyName() + " market prices, network fee estimates, or other data obtained from servers operated by Haveno is provided on an 'as is, as available' basis without representation or warranty of any kind. It is your responsibility to verify any data provided in regards to inaccuracies or omissions.\n\n4. Any Fiat payment method carries a potential risk for bank chargeback. By accepting the \"User Agreement\" the user confirms to be aware of those risks and in no case will claim legal responsibility to the authors or copyright holders of the software.\n\n5. Any dispute, controversy or claim arising out of or relating to the use of the software shall be settled by arbitration in accordance with the Haveno arbitration rules as at present in force. The arbitration is conducted online. The language to be used in the arbitration proceedings shall be English if not otherwise stated.\n\n6. The user confirms that they have read and agreed to the rules regarding the trade and dispute processes:\n    - You must complete trades within the maximum duration specified for each payment method.\n    - Leave the \"reason for payment\" field empty. DO NOT put the trade ID or any other text like 'monero', 'XMR', or 'Haveno'.\n    - If the bank of the fiat sender charges fees, the fiat sender (" + Res.getBaseCurrencyCode() + " buyer) has to cover the fees.\n    - If either trader opens a dispute, the arbitrator can settle the dispute and pay out trade funds accordingly.\n    - In case of arbitration, you must cooperate with the arbitrator and respond to each message within 48 hours.\n    - The arbitrator may penalize offer makers and traders for breaching Haveno rules and the principle of acting in good faith within the network, up to the value of the security deposit.\n";
        this.message(text);
        this.actionButtonText(Res.get((String)"tacWindow.agree"));
        this.closeButtonText(Res.get((String)"tacWindow.disagree"));
        this.onClose(HavenoApp.getShutDownHandler());
        super.show();
    }

    @Override
    protected void addMessage() {
        super.addMessage();
        String fontStyleClass = this.smallScreen ? "small-text" : "normal-text";
        this.messageTextArea.getStyleClass().add((Object)fontStyleClass);
        HyperlinkWithIcon hyperlinkWithIcon = FormBuilder.addHyperlinkWithIcon(this.gridPane, ++this.rowIndex, Res.get((String)"tacWindow.arbitrationSystem"), "https://docs.haveno.exchange/the-project/dispute-resolution");
        hyperlinkWithIcon.getStyleClass().add((Object)fontStyleClass);
        GridPane.setMargin((Node)hyperlinkWithIcon, (Insets)new Insets(-6.0, 0.0, -20.0, -4.0));
    }

    @Override
    protected void setTruncatedMessage() {
        this.truncatedMessage = this.message;
    }

    @Override
    protected void onShow() {
        this.display();
    }
}

