/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.util.Utilities;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Volume;
import haveno.core.payment.payload.SwiftAccountPayload;
import haveno.core.trade.Trade;
import haveno.core.util.VolumeUtil;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;

public class SwiftPaymentDetails
extends Overlay<SwiftPaymentDetails> {
    private final SwiftAccountPayload payload;
    private final Trade trade;
    private final List<String> copyToClipboardData = new ArrayList<String>();

    public SwiftPaymentDetails(SwiftAccountPayload swiftAccountPayload, Trade trade) {
        this.payload = swiftAccountPayload;
        this.trade = trade;
    }

    @Override
    public void show() {
        this.rowIndex = -1;
        this.width = 918.0;
        this.createGridPane();
        this.addContent();
        this.addButtons();
        this.display();
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.setPadding(new Insets(35.0, 40.0, 30.0, 40.0));
        this.gridPane.getStyleClass().add((Object)"grid-pane");
    }

    private void addContent() {
        int rows = this.payload.usesIntermediaryBank() ? 22 : 16;
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, rows, Res.get((String)"payment.swift.headline"));
        this.gridPane.add((Node)new Label(""), 0, ++this.rowIndex);
        this.addLabelsAndCopy(Res.get((String)"portfolio.pending.step2_buyer.amountToTransfer"), VolumeUtil.formatVolumeWithCode((Volume)this.trade.getVolume()));
        this.addLabelsAndCopy(Res.get((String)"payment.swift.swiftCode.bank"), this.payload.getBankSwiftCode());
        this.addLabelsAndCopy(Res.get((String)"payment.swift.name.bank"), this.payload.getBankName());
        this.addLabelsAndCopy(Res.get((String)"payment.swift.branch.bank"), this.payload.getBankBranch());
        this.addLabelsAndCopy(Res.get((String)"payment.swift.address.bank"), Utilities.cleanString((String)this.payload.getBankAddress()));
        this.addLabelsAndCopy(Res.get((String)"payment.swift.country.bank"), CountryUtil.getNameAndCode((String)this.payload.getBankCountryCode()));
        if (this.payload.usesIntermediaryBank()) {
            this.gridPane.add((Node)new Label(""), 0, ++this.rowIndex);
            this.addLabelsAndCopy(Res.get((String)"payment.swift.swiftCode.intermediary"), this.payload.getIntermediarySwiftCode());
            this.addLabelsAndCopy(Res.get((String)"payment.swift.name.intermediary"), this.payload.getIntermediaryName());
            this.addLabelsAndCopy(Res.get((String)"payment.swift.branch.intermediary"), this.payload.getIntermediaryBranch());
            this.addLabelsAndCopy(Res.get((String)"payment.swift.address.intermediary"), Utilities.cleanString((String)this.payload.getIntermediaryAddress()));
            this.addLabelsAndCopy(Res.get((String)"payment.swift.country.intermediary"), CountryUtil.getNameAndCode((String)this.payload.getIntermediaryCountryCode()));
        }
        this.gridPane.add((Node)new Label(""), 0, ++this.rowIndex);
        this.addLabelsAndCopy(Res.get((String)"payment.account.owner"), this.payload.getBeneficiaryName());
        this.addLabelsAndCopy(Res.get((String)"payment.swift.account"), this.payload.getBeneficiaryAccountNr());
        this.addLabelsAndCopy(Res.get((String)"payment.swift.address.beneficiary"), Utilities.cleanString((String)this.payload.getBeneficiaryAddress()));
        this.addLabelsAndCopy(Res.get((String)"payment.swift.phone.beneficiary"), this.payload.getBeneficiaryPhone());
        this.addLabelsAndCopy(Res.get((String)"payment.account.city"), this.payload.getBeneficiaryCity());
        this.addLabelsAndCopy(Res.get((String)"payment.country"), CountryUtil.getNameAndCode((String)this.payload.getBankCountryCode()));
        this.addLabelsAndCopy(Res.get((String)"payment.shared.extraInfo"), Utilities.cleanString((String)this.payload.getSpecialInstructions()));
        this.actionButtonText(Res.get((String)"shared.copyToClipboard"));
        this.onAction(() -> {
            StringBuilder work = new StringBuilder();
            for (String s : this.copyToClipboardData) {
                work.append(s).append(System.lineSeparator());
            }
            Utilities.copyToClipboard((String)work.toString());
        });
    }

    private void addLabelsAndCopy(String title, String value) {
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, title, value);
        this.copyToClipboardData.add(title + " : " + value);
    }
}

