/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import haveno.common.crypto.Hash;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.account.sign.SignedWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUnsignedPubKeysWindow
extends Overlay<SignUnsignedPubKeysWindow> {
    private static final Logger log = LoggerFactory.getLogger(SignUnsignedPubKeysWindow.class);
    private ListView<SignedWitness> unsignedPubKeys = new ListView();
    private InputTextField privateKey;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final ArbitratorManager arbitratorManager;
    private List<SignedWitness> signedWitnessList = new ArrayList<SignedWitness>();
    private List<String> failed = new ArrayList<String>();
    private Callback<ListView<SignedWitness>, ListCell<SignedWitness>> signedWitnessCellFactory;

    @Inject
    public SignUnsignedPubKeysWindow(AccountAgeWitnessService accountAgeWitnessService, ArbitratorManager arbitratorManager) {
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.arbitratorManager = arbitratorManager;
        this.signedWitnessCellFactory = new Callback<ListView<SignedWitness>, ListCell<SignedWitness>>(this){

            public ListCell<SignedWitness> call(ListView<SignedWitness> param) {
                return new ListCell<SignedWitness>(this){

                    protected void updateItem(SignedWitness item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(Utilities.bytesAsHexString((byte[])Hash.getRipemd160hash((byte[])item.getSignerPubKey())));
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        };
    }

    @Override
    public void show() {
        this.width = 1000.0;
        this.rowIndex = -1;
        this.createGridPane();
        this.gridPane.setPrefHeight(600.0);
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(1)).setHgrow(Priority.NEVER);
        this.gridPane.getStyleClass().add((Object)"popup-with-input");
        this.headLine(Res.get((String)"popup.accountSigning.singleAccountSelect.headline"));
        this.type = Overlay.Type.Attention;
        this.addHeadLine();
        this.addUnsignedPubKeysContent();
        this.addECKeyField();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    private void addUnsignedPubKeysContent() {
        Tuple3 unsignedPubKeysTuple = FormBuilder.addTopLabelListView(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.unsignedPubKeys.headline"));
        this.unsignedPubKeys = (ListView)unsignedPubKeysTuple.second;
        this.unsignedPubKeys.setCellFactory(this.signedWitnessCellFactory);
        this.unsignedPubKeys.setItems(FXCollections.observableArrayList((Collection)this.accountAgeWitnessService.getUnsignedSignerPubKeys()));
    }

    private void addECKeyField() {
        this.privateKey = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.signAccounts.ECKey"));
        GridPane.setVgrow((Node)this.privateKey, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)this.privateKey, (VPos)VPos.TOP);
    }

    private void removeContent() {
        FormBuilder.removeRowsFromGridPane(this.gridPane, 1, 3);
        this.rowIndex = 1;
    }

    private void signPubKeys() {
        this.removeContent();
        this.headLineLabel.setText(Res.get((String)"popup.accountSigning.unsignedPubKeys.signed"));
        ECKey arbitratorKey = this.arbitratorManager.getRegistrationKey(this.privateKey.getText());
        if (arbitratorKey != null) {
            String arbitratorPubKeyAsHex = Utils.HEX.encode(arbitratorKey.getPubKey());
            boolean isKeyValid = this.arbitratorManager.isPublicKeyInList(arbitratorPubKeyAsHex);
            this.failed.clear();
            if (isKeyValid) {
                this.unsignedPubKeys.getItems().forEach(signedWitness -> {
                    String result = this.accountAgeWitnessService.arbitratorSignOrphanPubKey(arbitratorKey, signedWitness.getSignerPubKey(), signedWitness.getDate());
                    if (result.isEmpty()) {
                        this.signedWitnessList.add((SignedWitness)signedWitness);
                    } else {
                        this.failed.add("Signing pubkey " + Utilities.bytesAsHexString((byte[])Hash.getRipemd160hash((byte[])signedWitness.getSignerPubKey())) + " failed with error " + result);
                    }
                });
                this.showResult();
            }
        } else {
            ((Popup)((Popup)new Popup().error(Res.get((String)"popup.accountSigning.signAccounts.ECKey.error"))).onClose(this::hide)).show();
        }
    }

    private void showResult() {
        this.removeContent();
        this.closeButton.setVisible(false);
        this.closeButton.setManaged(false);
        Tuple3 signedTuple = FormBuilder.addTopLabelListView(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.unsignedPubKeys.result.signed"));
        ListView signedWitnessListView = (ListView)signedTuple.second;
        signedWitnessListView.setCellFactory(this.signedWitnessCellFactory);
        signedWitnessListView.setItems(FXCollections.observableArrayList(this.signedWitnessList));
        Tuple3 failedTuple = FormBuilder.addTopLabelListView(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.unsignedPubKeys.result.failed"));
        ListView failedView = (ListView)failedTuple.second;
        failedView.setItems(FXCollections.observableArrayList(this.failed));
        ((AutoTooltipButton)this.actionButton).updateText(Res.get((String)"shared.ok"));
        this.actionButton.setOnAction(a -> this.hide());
    }

    @Override
    protected void addButtons() {
        Tuple2<Button, Button> buttonTuple = FormBuilder.add2ButtonsAfterGroup(this.gridPane, ++this.rowIndex + 1, Res.get((String)"popup.accountSigning.unsignedPubKeys.sign"), Res.get((String)"shared.cancel"));
        this.actionButton = (Button)buttonTuple.first;
        this.actionButton.setDisable(this.unsignedPubKeys.getItems().size() == 0);
        this.actionButton.setOnAction(e -> this.signPubKeys());
        this.closeButton = (AutoTooltipButton)((Object)buttonTuple.second);
        this.closeButton.setOnAction(e -> this.hide());
    }
}

