/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.HavenoTextArea;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import java.util.Date;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignSpecificWitnessWindow
extends Overlay<SignSpecificWitnessWindow> {
    private static final Logger log = LoggerFactory.getLogger(SignSpecificWitnessWindow.class);
    private Tuple2<AccountAgeWitness, byte[]> signInfo;
    private InputTextField privateKey;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final ArbitratorManager arbitratorManager;

    @Inject
    public SignSpecificWitnessWindow(AccountAgeWitnessService accountAgeWitnessService, ArbitratorManager arbitratorManager) {
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.arbitratorManager = arbitratorManager;
    }

    @Override
    public void show() {
        this.width = 1000.0;
        this.rowIndex = -1;
        this.createGridPane();
        this.gridPane.setPrefHeight(600.0);
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(1)).setHgrow(Priority.NEVER);
        this.gridPane.getStyleClass().add((Object)"popup-with-input");
        this.headLine(Res.get((String)"popup.accountSigning.singleAccountSelect.headline"));
        this.type = Overlay.Type.Attention;
        this.addHeadLine();
        this.addSelectWitnessContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    private void addSelectWitnessContent() {
        HavenoTextArea accountInfoText = new HavenoTextArea();
        accountInfoText.setPrefHeight(270.0);
        accountInfoText.setWrapText(true);
        GridPane.setRowIndex((Node)accountInfoText, (Integer)(++this.rowIndex));
        this.gridPane.getChildren().add((Object)accountInfoText);
        accountInfoText.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                return;
            }
            this.signInfo = this.accountAgeWitnessService.getSignInfoFromString(newValue);
            if (this.signInfo == null) {
                this.actionButton.setDisable(true);
                return;
            }
            this.actionButton.setDisable(false);
        });
    }

    private void addECKeyField() {
        this.privateKey = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.signAccounts.ECKey"));
        this.actionButton.setDisable(true);
        GridPane.setVgrow((Node)this.privateKey, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)this.privateKey, (VPos)VPos.TOP);
        this.privateKey.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.checkedArbitratorKey() == null) {
                this.actionButton.setDisable(true);
                return;
            }
            this.actionButton.setDisable(false);
        });
    }

    private void removeContent() {
        FormBuilder.removeRowsFromGridPane(this.gridPane, 1, 3);
        this.rowIndex = 1;
    }

    private void importAccountAgeWitness() {
        this.removeContent();
        this.headLineLabel.setText(Res.get((String)"popup.accountSigning.confirmSingleAccount.headline"));
        TextField selectedWitnessTextField = (TextField)FormBuilder.addTopLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"popup.accountSigning.confirmSingleAccount.selectedHash")).second;
        selectedWitnessTextField.setText(Utilities.bytesAsHexString((byte[])((AccountAgeWitness)this.signInfo.first).getHash()));
        this.addECKeyField();
        ((AutoTooltipButton)this.actionButton).updateText(Res.get((String)"popup.accountSigning.confirmSingleAccount.button"));
        this.actionButton.setOnAction(a -> {
            ECKey arbitratorKey = this.checkedArbitratorKey();
            if (arbitratorKey != null) {
                this.accountAgeWitnessService.arbitratorSignAccountAgeWitness((AccountAgeWitness)this.signInfo.first, arbitratorKey, (byte[])this.signInfo.second, new Date().getTime());
                this.addSuccessContent();
            } else {
                ((Popup)((Popup)new Popup().error(Res.get((String)"popup.accountSigning.signAccounts.ECKey.error"))).onClose(this::hide)).show();
            }
        });
    }

    private void addSuccessContent() {
        this.removeContent();
        this.closeButton.setVisible(false);
        this.closeButton.setManaged(false);
        this.headLineLabel.setText(Res.get((String)"popup.accountSigning.successSingleAccount.success.headline"));
        Label descriptionLabel = FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.successSingleAccount.description", (Object[])new Object[]{Utilities.bytesAsHexString((byte[])((AccountAgeWitness)this.signInfo.first).getHash())}));
        GridPane.setVgrow((Node)descriptionLabel, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)descriptionLabel, (VPos)VPos.TOP);
        ((AutoTooltipButton)this.actionButton).updateText(Res.get((String)"shared.ok"));
        this.actionButton.setOnAction(a -> this.hide());
    }

    @Override
    protected void addButtons() {
        Tuple2<Button, Button> buttonTuple = FormBuilder.add2ButtonsAfterGroup(this.gridPane, ++this.rowIndex + 2, Res.get((String)"popup.accountSigning.singleAccountSelect.headline"), Res.get((String)"shared.cancel"));
        this.actionButton = (Button)buttonTuple.first;
        this.actionButton.setDisable(true);
        this.actionButton.setOnAction(e -> this.importAccountAgeWitness());
        this.closeButton = (AutoTooltipButton)((Object)buttonTuple.second);
        this.closeButton.setOnAction(e -> this.hide());
    }

    private ECKey checkedArbitratorKey() {
        ECKey arbitratorKey = this.arbitratorManager.getRegistrationKey(this.privateKey.getText());
        if (arbitratorKey == null) {
            return null;
        }
        String arbitratorPubKeyAsHex = Utils.HEX.encode(arbitratorKey.getPubKey());
        boolean isKeyValid = this.arbitratorManager.isPublicKeyInList(arbitratorPubKeyAsHex);
        return isKeyValid ? arbitratorKey : null;
    }
}

