/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.arbitration.TraderDataItem;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.util.FormattingUtils;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignPaymentAccountsWindow
extends Overlay<SignPaymentAccountsWindow> {
    private static final Logger log = LoggerFactory.getLogger(SignPaymentAccountsWindow.class);
    private Label descriptionLabel;
    private ComboBox<PaymentMethod> paymentMethodComboBox;
    private CheckBox signAllCheckbox;
    private DatePicker datePicker;
    private InputTextField privateKey;
    private ListView<TraderDataItem> selectedPaymentAccountsList = new ListView();
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final ArbitratorManager arbitratorManager;
    private final ArbitrationManager arbitrationManager;
    private final MediationManager mediationManager;
    private final String appName;
    private final boolean useDevPrivilegeKeys;

    @Inject
    public SignPaymentAccountsWindow(AccountAgeWitnessService accountAgeWitnessService, ArbitratorManager arbitratorManager, ArbitrationManager arbitrationManager, MediationManager mediationManager, @Named(value="appName") String appName, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.arbitratorManager = arbitratorManager;
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.appName = appName;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
    }

    @Override
    public void show() {
        this.width = 1000.0;
        this.rowIndex = -1;
        this.createGridPane();
        this.gridPane.setPrefHeight(600.0);
        this.gridPane.getStyleClass().add((Object)"popup-with-input");
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(1)).setHgrow(Priority.NEVER);
        this.headLine(Res.get((String)"popup.accountSigning.selectAccounts.headline"));
        this.type = Overlay.Type.Attention;
        this.addHeadLine();
        this.addSelectAccountsContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    private void addSelectAccountsContent() {
        this.descriptionLabel = FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.selectAccounts.description"));
        this.paymentMethodComboBox = FormBuilder.addComboBox(this.gridPane, ++this.rowIndex, Res.get((String)"shared.selectPaymentMethod"));
        this.paymentMethodComboBox.setVisibleRowCount(11);
        this.paymentMethodComboBox.setConverter((StringConverter)new StringConverter<PaymentMethod>(this){

            public String toString(PaymentMethod paymentMethod) {
                return paymentMethod != null ? Res.get((String)paymentMethod.getId()) : "";
            }

            public PaymentMethod fromString(String s) {
                return null;
            }
        });
        this.paymentMethodComboBox.setItems(FXCollections.observableArrayList(this.getPaymentMethods()));
        this.paymentMethodComboBox.setOnAction(e -> this.updateAccountSelectionState());
        this.signAllCheckbox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.selectAccounts.signAll"));
        GridPane.setHalignment((Node)this.signAllCheckbox, (HPos)HPos.LEFT);
        this.signAllCheckbox.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.paymentMethodComboBox.setDisable(newValue.booleanValue());
            this.updateAccountSelectionState();
        });
        this.datePicker = (DatePicker)FormBuilder.addTopLabelDatePicker((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"popup.accountSigning.selectAccounts.datePicker"), (double)0.0).second;
        this.datePicker.setOnAction(e -> this.updateAccountSelectionState());
        this.datePicker.setValue((Object)Instant.ofEpochMilli(new Date().getTime()).minus(60L, ChronoUnit.DAYS).atZone(ZoneId.systemDefault()).toLocalDate());
    }

    private List<PaymentMethod> getPaymentMethods() {
        return PaymentMethod.paymentMethods.stream().filter(PaymentMethod::isTraditional).filter(PaymentMethod::hasChargebackRisk).collect(Collectors.toList());
    }

    private void addECKeyField() {
        this.privateKey = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.signAccounts.ECKey"));
        GridPane.setVgrow((Node)this.privateKey, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)this.privateKey, (VPos)VPos.TOP);
    }

    private void updateAccountSelectionState() {
        this.actionButton.setDisable(!this.signAllCheckbox.isSelected() && this.paymentMethodComboBox.getSelectionModel().isEmpty() || this.datePicker.getValue() == null);
    }

    private void removeContent() {
        FormBuilder.removeRowsFromGridPane(this.gridPane, 2, 3);
        this.rowIndex = 1;
    }

    private void addSelectedAccountsContent() {
        List traderDataItemList;
        this.removeContent();
        Tuple3 selectedPaymentAccountsTuple = FormBuilder.addTopLabelListView(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.confirmSelectedAccounts.headline"));
        GridPane.setRowSpan((Node)((Node)selectedPaymentAccountsTuple.third), (Integer)2);
        this.selectedPaymentAccountsList = (ListView)selectedPaymentAccountsTuple.second;
        ObservableList disputesAsObservableList = this.arbitrationManager.getDisputesAsObservableList();
        long safeDate = ((LocalDate)this.datePicker.getValue()).atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000L;
        StringBuilder sb = new StringBuilder("Summary for ").append(this.appName).append("\n");
        if (this.signAllCheckbox.isSelected()) {
            traderDataItemList = new ArrayList();
            this.getPaymentMethods().forEach(paymentMethod -> {
                List list = this.accountAgeWitnessService.getTraderPaymentAccounts(safeDate, paymentMethod, (List)disputesAsObservableList);
                traderDataItemList.addAll(list);
                sb.append("\nPayment method: ").append(Res.get((String)paymentMethod.getId())).append(" (No. of signed accounts: ").append(list.size()).append(")\n");
                list.forEach(traderDataItem -> sb.append("Account created: ").append(FormattingUtils.formatDateTime((Date)new Date(traderDataItem.getAccountAgeWitness().getDate()), (boolean)true)).append(" Account: ").append(traderDataItem.getPaymentAccountPayload().getPaymentDetails()).append("\n"));
            });
            sb.append("\nTotal accounts signed: ").append(traderDataItemList.size());
        } else {
            PaymentMethod paymentMethod2 = (PaymentMethod)this.paymentMethodComboBox.getSelectionModel().getSelectedItem();
            traderDataItemList = this.accountAgeWitnessService.getTraderPaymentAccounts(safeDate, paymentMethod2, (List)disputesAsObservableList);
            sb.append("\nPayment method: ").append(Res.get((String)paymentMethod2.getId())).append(" (No. of signed accounts: ").append(traderDataItemList.size()).append(")\n");
            traderDataItemList.forEach(traderDataItem -> sb.append("Account created: ").append(FormattingUtils.formatDateTime((Date)new Date(traderDataItem.getAccountAgeWitness().getDate()), (boolean)true)).append(" Account: ").append(traderDataItem.getPaymentAccountPayload().getPaymentDetails()).append("\n"));
        }
        log.info(sb.toString());
        Utilities.copyToClipboard((String)sb.toString());
        this.selectedPaymentAccountsList.setItems(FXCollections.observableArrayList(traderDataItemList));
        this.headLineLabel.setText(Res.get((String)"popup.accountSigning.confirmSelectedAccounts.headline"));
        this.descriptionLabel.setText(Res.get((String)"popup.accountSigning.confirmSelectedAccounts.description", (Object[])new Object[]{this.selectedPaymentAccountsList.getItems().size()}));
        ((AutoTooltipButton)this.actionButton).updateText(Res.get((String)"popup.accountSigning.confirmSelectedAccounts.button"));
        this.updateAccountSelectionState();
        this.actionButton.setOnAction(e -> this.addAccountsToSignContent());
        this.selectedPaymentAccountsList.setCellFactory((Callback)new Callback<ListView<TraderDataItem>, ListCell<TraderDataItem>>(this){

            public ListCell<TraderDataItem> call(ListView<TraderDataItem> param) {
                return new ListCell<TraderDataItem>(this){

                    protected void updateItem(TraderDataItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(item.getPaymentAccountPayload().getPaymentDetails());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        });
    }

    private void addAccountsToSignContent() {
        this.removeContent();
        this.addECKeyField();
        this.headLineLabel.setText(Res.get((String)"popup.accountSigning.signAccounts.headline"));
        this.descriptionLabel.setText(Res.get((String)"popup.accountSigning.signAccounts.description", (Object[])new Object[]{this.selectedPaymentAccountsList.getItems().size()}));
        ((AutoTooltipButton)this.actionButton).updateText(Res.get((String)"popup.accountSigning.signAccounts.button"));
        this.actionButton.setOnAction(a -> {
            ECKey arbitratorKey = this.arbitratorManager.getRegistrationKey(this.privateKey.getText());
            if (arbitratorKey != null) {
                String arbitratorPubKeyAsHex = Utils.HEX.encode(arbitratorKey.getPubKey());
                boolean isKeyValid = this.arbitratorManager.isPublicKeyInList(arbitratorPubKeyAsHex);
                if (isKeyValid) {
                    this.selectedPaymentAccountsList.getItems().forEach(item -> this.accountAgeWitnessService.arbitratorSignAccountAgeWitness(item.getTradeAmount(), item.getAccountAgeWitness(), arbitratorKey, item.getPeersPubKey()));
                    this.addSuccessContent();
                }
            } else {
                ((Popup)((Popup)new Popup().error(Res.get((String)"popup.accountSigning.signAccounts.ECKey.error"))).onClose(this::hide)).show();
            }
        });
    }

    private void addSuccessContent() {
        this.removeContent();
        GridPane.setVgrow((Node)this.descriptionLabel, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)this.descriptionLabel, (VPos)VPos.TOP);
        this.closeButton.setVisible(false);
        this.closeButton.setManaged(false);
        this.headLineLabel.setText(Res.get((String)"popup.accountSigning.success.headline"));
        this.descriptionLabel.setText(Res.get((String)"popup.accountSigning.success.description", (Object[])new Object[]{this.selectedPaymentAccountsList.getItems().size()}));
        ((AutoTooltipButton)this.actionButton).updateText(Res.get((String)"shared.ok"));
        this.actionButton.setOnAction(a -> this.hide());
    }

    @Override
    protected void addButtons() {
        Tuple2<Button, Button> buttonTuple = FormBuilder.add2ButtonsAfterGroup(this.gridPane, ++this.rowIndex, Res.get((String)"popup.accountSigning.selectAccounts.headline"), Res.get((String)"shared.cancel"));
        this.actionButton = (Button)buttonTuple.first;
        this.actionButton.setDisable(true);
        this.actionButton.setOnAction(e -> this.addSelectedAccountsContent());
        this.closeButton = (AutoTooltipButton)((Object)buttonTuple.second);
        this.closeButton.setOnAction(e -> this.hide());
    }
}

