/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.HPos;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;

public class ShowWalletDataWindow
extends Overlay<ShowWalletDataWindow> {
    private final WalletsManager walletsManager;

    public ShowWalletDataWindow(WalletsManager walletsManager) {
        this.walletsManager = walletsManager;
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"showWalletDataWindow.walletData");
        }
        this.width = 1000.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    private void addContent() {
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setHalignment(HPos.LEFT);
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setHgrow(Priority.ALWAYS);
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(1)).setHgrow(Priority.SOMETIMES);
        Tuple2<Label, TextArea> labelTextAreaTuple2 = FormBuilder.addTopLabelTextArea(this.gridPane, ++this.rowIndex, Res.get((String)"showWalletDataWindow.walletData"), "");
        TextArea textArea = (TextArea)labelTextAreaTuple2.second;
        Label label = (Label)labelTextAreaTuple2.first;
        label.setMinWidth(150.0);
        textArea.setPrefHeight(500.0);
        textArea.getStyleClass().add((Object)"small-text");
        CheckBox isUpdateCheckBox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.rowIndex, Res.get((String)"showWalletDataWindow.includePrivKeys"));
        isUpdateCheckBox.setSelected(false);
        isUpdateCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.showWallet(textArea, isUpdateCheckBox));
        this.showWallet(textArea, isUpdateCheckBox);
        this.actionButtonText(Res.get((String)"shared.copyToClipboard"));
        this.onAction(() -> Utilities.copyToClipboard((String)textArea.getText()));
    }

    private void showWallet(TextArea textArea, CheckBox includePrivKeysCheckBox) {
        textArea.setText(this.walletsManager.getWalletsAsString(includePrivKeysCheckBox.isSelected()));
    }
}

