/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.util.Tuple2;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.alert.PrivateNotificationPayload;
import haveno.core.locale.Res;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendMailboxMessageListener;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendPrivateNotificationWindow
extends Overlay<SendPrivateNotificationWindow> {
    private static final Logger log = LoggerFactory.getLogger(SendPrivateNotificationWindow.class);
    private final PrivateNotificationManager privateNotificationManager;
    private final PubKeyRing pubKeyRing;
    private final NodeAddress nodeAddress;
    private final boolean useDevPrivilegeKeys;

    public SendPrivateNotificationWindow(PrivateNotificationManager privateNotificationManager, PubKeyRing pubKeyRing, NodeAddress nodeAddress, boolean useDevPrivilegeKeys) {
        this.privateNotificationManager = privateNotificationManager;
        this.pubKeyRing = pubKeyRing;
        this.nodeAddress = nodeAddress;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"sendPrivateNotificationWindow.headline");
        }
        this.width = 868.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.applyStyles();
        this.display();
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    private void addContent() {
        InputTextField keyInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.unlock"), 10.0);
        if (this.useDevPrivilegeKeys) {
            keyInputTextField.setText("6ac43ea1df2a290c1c8391736aa42e4339c5cb4f110ff0257a13b63211977b7a");
        }
        Tuple2<Label, TextArea> labelTextAreaTuple2 = FormBuilder.addTopLabelTextArea(this.gridPane, ++this.rowIndex, Res.get((String)"sendPrivateNotificationWindow.privateNotification"), Res.get((String)"sendPrivateNotificationWindow.enterNotification"));
        TextArea alertMessageTextArea = (TextArea)labelTextAreaTuple2.second;
        Label first = (Label)labelTextAreaTuple2.first;
        first.setMinWidth(200.0);
        AutoTooltipButton sendButton = new AutoTooltipButton(Res.get((String)"sendPrivateNotificationWindow.send"));
        sendButton.setOnAction(e -> {
            if (alertMessageTextArea.getText().length() > 0 && keyInputTextField.getText().length() > 0) {
                PrivateNotificationPayload privateNotification = new PrivateNotificationPayload(alertMessageTextArea.getText());
                boolean wasKeyValid = this.privateNotificationManager.sendPrivateNotificationMessageIfKeyIsValid(privateNotification, this.pubKeyRing, this.nodeAddress, keyInputTextField.getText(), new SendMailboxMessageListener(){

                    public void onArrived() {
                        log.info("PrivateNotificationPayload arrived at peer {}.", (Object)SendPrivateNotificationWindow.this.nodeAddress);
                        UserThread.runAfter(() -> ((Popup)((Popup)new Popup().feedback(Res.get((String)"shared.messageArrived"))).onClose(SendPrivateNotificationWindow.this::hide)).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }

                    public void onStoredInMailbox() {
                        log.info("PrivateNotificationPayload stored in mailbox for peer {}.", (Object)SendPrivateNotificationWindow.this.nodeAddress);
                        UserThread.runAfter(() -> ((Popup)((Popup)new Popup().feedback(Res.get((String)"shared.messageStoredInMailbox"))).onClose(SendPrivateNotificationWindow.this::hide)).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }

                    public void onFault(String errorMessage) {
                        log.error("PrivateNotificationPayload failed: Peer {}, errorMessage={}", (Object)SendPrivateNotificationWindow.this.nodeAddress, (Object)errorMessage);
                        UserThread.runAfter(() -> ((Popup)((Popup)new Popup().feedback(Res.get((String)"shared.messageSendingFailed", (Object[])new Object[]{errorMessage}))).onClose(SendPrivateNotificationWindow.this::hide)).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                });
                if (wasKeyValid) {
                    this.doClose();
                } else {
                    UserThread.runAfter(() -> ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"shared.invalidKey"))).width(300.0)).onClose(() -> this.blurAgain())).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
        });
        this.closeButton = new AutoTooltipButton(Res.get((String)"shared.close"));
        this.closeButton.setOnAction(e -> {
            this.hide();
            this.closeHandlerOptional.ifPresent(Runnable::run);
        });
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)hBox, (Integer)2);
        GridPane.setColumnIndex((Node)hBox, (Integer)0);
        hBox.getChildren().addAll((Object[])new Node[]{sendButton, this.closeButton});
        this.gridPane.getChildren().add((Object)hBox);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
    }
}

