/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.FileTransferSender;
import haveno.core.support.dispute.mediation.FileTransferSession;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeWizardItem;
import haveno.desktop.main.portfolio.pendingtrades.steps.buyer.BuyerStep1View;
import haveno.desktop.main.portfolio.pendingtrades.steps.buyer.BuyerStep2View;
import haveno.desktop.main.portfolio.pendingtrades.steps.buyer.BuyerStep3View;
import haveno.desktop.util.FormBuilder;
import java.io.IOException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Separator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendLogFilesWindow
extends Overlay<SendLogFilesWindow>
implements FileTransferSession.FtpCallback {
    private static final Logger log = LoggerFactory.getLogger(SendLogFilesWindow.class);
    private final String tradeId;
    private final int traderId;
    private final ArbitrationManager arbitrationManager;
    private Label statusLabel;
    private Button sendButton;
    private Button stopButton;
    private final DoubleProperty ftpProgress = new SimpleDoubleProperty(-1.0);
    TradeWizardItem step1;
    TradeWizardItem step2;
    TradeWizardItem step3;
    private FileTransferSender fileTransferSender;

    public SendLogFilesWindow(String tradeId, int traderId, ArbitrationManager arbitrationManager) {
        this.tradeId = tradeId;
        this.traderId = traderId;
        this.arbitrationManager = arbitrationManager;
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        this.headLine = Res.get((String)"support.sendLogs.title");
        this.width = 668.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    @Override
    protected void createGridPane() {
        this.gridPane = new GridPane();
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(64.0, 64.0, 64.0, 64.0));
        this.gridPane.setPrefWidth(this.width);
    }

    void addWizardsToGridPane(TradeWizardItem tradeWizardItem) {
        GridPane.setRowIndex((Node)tradeWizardItem, (Integer)this.rowIndex++);
        GridPane.setColumnIndex((Node)tradeWizardItem, (Integer)0);
        GridPane.setHalignment((Node)tradeWizardItem, (HPos)HPos.LEFT);
        this.gridPane.getChildren().add((Object)tradeWizardItem);
    }

    void addLineSeparatorToGridPane() {
        Separator separator = new Separator(Orientation.VERTICAL);
        separator.setMinHeight(22.0);
        GridPane.setMargin((Node)separator, (Insets)new Insets(0.0, 0.0, 0.0, 13.0));
        GridPane.setHalignment((Node)separator, (HPos)HPos.LEFT);
        GridPane.setRowIndex((Node)separator, (Integer)this.rowIndex++);
        this.gridPane.getChildren().add((Object)separator);
    }

    void addRegionToGridPane() {
        Region region = new Region();
        region.setMinHeight(22.0);
        GridPane.setMargin((Node)region, (Insets)new Insets(0.0, 0.0, 0.0, 13.0));
        GridPane.setRowIndex((Node)region, (Integer)this.rowIndex++);
        this.gridPane.getChildren().add((Object)region);
    }

    private void addContent() {
        this.hideCloseButton = true;
        FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, Res.get((String)"support.sendLogs.backgroundInfo"), 0.0);
        this.addRegionToGridPane();
        this.step1 = new TradeWizardItem(BuyerStep1View.class, Res.get((String)"support.sendLogs.step1"), "1");
        this.step2 = new TradeWizardItem(BuyerStep2View.class, Res.get((String)"support.sendLogs.step2"), "2");
        this.step3 = new TradeWizardItem(BuyerStep3View.class, Res.get((String)"support.sendLogs.step3"), "3");
        this.addRegionToGridPane();
        this.addRegionToGridPane();
        this.addWizardsToGridPane(this.step1);
        this.addLineSeparatorToGridPane();
        this.addWizardsToGridPane(this.step2);
        this.addLineSeparatorToGridPane();
        this.addWizardsToGridPane(this.step3);
        this.addRegionToGridPane();
        ProgressBar progressBar = new ProgressBar();
        progressBar.setMinHeight(19.0);
        progressBar.setMaxHeight(19.0);
        progressBar.setPrefWidth(9305.0);
        progressBar.setVisible(false);
        progressBar.progressProperty().bind((ObservableValue)this.ftpProgress);
        this.gridPane.add((Node)progressBar, 0, ++this.rowIndex);
        this.statusLabel = FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, "", -23.0);
        this.statusLabel.getStyleClass().add((Object)"sub-info");
        this.addRegionToGridPane();
        this.sendButton = new AutoTooltipButton(Res.get((String)"support.sendLogs.send"));
        this.stopButton = new AutoTooltipButton(Res.get((String)"support.sendLogs.cancel"));
        this.stopButton.setDisable(true);
        this.closeButton = new AutoTooltipButton(Res.get((String)"shared.close"));
        this.sendButton.setOnAction(e -> {
            try {
                progressBar.setVisible(true);
                if (this.fileTransferSender == null) {
                    this.setActiveStep(1);
                    this.statusLabel.setText(Res.get((String)"support.sendLogs.init"));
                    this.fileTransferSender = this.arbitrationManager.initLogUpload((FileTransferSession.FtpCallback)this, this.tradeId, this.traderId);
                    UserThread.runAfter(() -> {
                        this.fileTransferSender.createZipFileToSend();
                        this.setActiveStep(2);
                        UserThread.runAfter(() -> {
                            this.setActiveStep(3);
                            try {
                                this.fileTransferSender.initSend();
                            }
                            catch (IOException ioe) {
                                log.error(ioe.toString());
                                this.statusLabel.setText(ioe.toString());
                                ioe.printStackTrace();
                            }
                        }, (long)1L);
                    }, (long)1L);
                    this.sendButton.setDisable(true);
                    this.stopButton.setDisable(false);
                } else {
                    this.statusLabel.setText(Res.get((String)"support.sendLogs.retry"));
                    this.fileTransferSender.retrySend();
                    this.sendButton.setDisable(true);
                }
            }
            catch (IOException ex) {
                log.error(ex.toString());
                this.statusLabel.setText(ex.toString());
                ex.printStackTrace();
            }
        });
        this.stopButton.setOnAction(e -> {
            if (this.fileTransferSender != null) {
                this.fileTransferSender.resetSession();
                this.statusLabel.setText(Res.get((String)"support.sendLogs.stopped"));
                this.stopButton.setDisable(true);
            }
        });
        this.closeButton.setOnAction(e -> {
            this.hide();
            this.closeHandlerOptional.ifPresent(Runnable::run);
        });
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)hBox, (Integer)2);
        GridPane.setColumnIndex((Node)hBox, (Integer)0);
        hBox.getChildren().addAll((Object[])new Node[]{this.sendButton, this.stopButton, this.closeButton});
        this.gridPane.getChildren().add((Object)hBox);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
    }

    void setActiveStep(int step) {
        if (step < 1) {
            this.step1.setDisabled();
            this.step2.setDisabled();
            this.step3.setDisabled();
        } else if (step == 1) {
            this.step1.setActive();
        } else if (step == 2) {
            this.step1.setCompleted();
            this.step2.setActive();
        } else if (step == 3) {
            this.step2.setCompleted();
            this.step3.setActive();
        } else {
            this.step3.setCompleted();
        }
    }

    public void onFtpProgress(double progressPct) {
        UserThread.execute(() -> {
            if (progressPct > 0.0) {
                this.statusLabel.setText(String.format(Res.get((String)"support.sendLogs.progress"), progressPct * 100.0));
                this.sendButton.setDisable(true);
            }
            this.ftpProgress.set(progressPct);
        });
    }

    public void onFtpComplete(FileTransferSession session) {
        UserThread.execute(() -> {
            this.setActiveStep(4);
            this.statusLabel.setText(Res.get((String)"support.sendLogs.finished"));
            this.stopButton.setDisable(true);
        });
    }

    public void onFtpTimeout(String statusMsg, FileTransferSession session) {
        UserThread.execute(() -> {
            this.statusLabel.setText(statusMsg + "\r\n" + Res.get((String)"support.sendLogs.command"));
            this.sendButton.setDisable(false);
        });
    }
}

