/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.util.Tuple2;
import haveno.core.alert.Alert;
import haveno.core.alert.AlertManager;
import haveno.core.locale.Res;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class SendAlertMessageWindow
extends Overlay<SendAlertMessageWindow> {
    private final AlertManager alertManager;
    private final boolean useDevPrivilegeKeys;

    @Inject
    public SendAlertMessageWindow(AlertManager alertManager, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        this.alertManager = alertManager;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"sendAlertMessageWindow.headline");
        }
        this.width = 968.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.applyStyles();
        this.display();
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    private void addContent() {
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setHalignment(HPos.LEFT);
        this.gridPane.getColumnConstraints().remove(1);
        InputTextField keyInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.unlock"), 10.0);
        if (this.useDevPrivilegeKeys) {
            keyInputTextField.setText("6ac43ea1df2a290c1c8391736aa42e4339c5cb4f110ff0257a13b63211977b7a");
        }
        Tuple2<Label, TextArea> labelTextAreaTuple2 = FormBuilder.addTopLabelTextArea(this.gridPane, ++this.rowIndex, Res.get((String)"sendAlertMessageWindow.alertMsg"), Res.get((String)"sendAlertMessageWindow.enterMsg"));
        TextArea alertMessageTextArea = (TextArea)labelTextAreaTuple2.second;
        Label first = (Label)labelTextAreaTuple2.first;
        first.setMinWidth(150.0);
        CheckBox isSoftwareUpdateCheckBox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.rowIndex, Res.get((String)"sendAlertMessageWindow.isSoftwareUpdate"));
        HBox hBoxRelease = new HBox();
        hBoxRelease.setSpacing(10.0);
        GridPane.setRowIndex((Node)hBoxRelease, (Integer)(++this.rowIndex));
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioButton isUpdateCheckBox = FormBuilder.addRadioButton(this.gridPane, this.rowIndex, toggleGroup, Res.get((String)"sendAlertMessageWindow.isUpdate"));
        RadioButton isPreReleaseCheckBox = FormBuilder.addRadioButton(this.gridPane, this.rowIndex, toggleGroup, Res.get((String)"sendAlertMessageWindow.isPreRelease"));
        hBoxRelease.getChildren().addAll((Object[])new Node[]{new Label(""), isUpdateCheckBox, isPreReleaseCheckBox});
        this.gridPane.getChildren().add((Object)hBoxRelease);
        isSoftwareUpdateCheckBox.setSelected(true);
        isUpdateCheckBox.setSelected(true);
        InputTextField versionInputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"sendAlertMessageWindow.version"));
        versionInputTextField.disableProperty().bind((ObservableValue)isSoftwareUpdateCheckBox.selectedProperty().not());
        isUpdateCheckBox.disableProperty().bind((ObservableValue)isSoftwareUpdateCheckBox.selectedProperty().not());
        isPreReleaseCheckBox.disableProperty().bind((ObservableValue)isSoftwareUpdateCheckBox.selectedProperty().not());
        AutoTooltipButton sendButton = new AutoTooltipButton(Res.get((String)"sendAlertMessageWindow.send"));
        sendButton.getStyleClass().add((Object)"action-button");
        sendButton.setDefaultButton(true);
        sendButton.setOnAction(e -> {
            boolean isPreRelease;
            String version = versionInputTextField.getText();
            boolean versionOK = false;
            boolean isUpdate = isSoftwareUpdateCheckBox.isSelected() && isUpdateCheckBox.isSelected();
            boolean bl = isPreRelease = isSoftwareUpdateCheckBox.isSelected() && isPreReleaseCheckBox.isSelected();
            if (isUpdate || isPreRelease) {
                String[] split = version.split("\\.");
                boolean bl2 = versionOK = split.length == 3;
                if (!versionOK) {
                    ((Popup)((Popup)new Popup().warning("Version number must be in semantic version format (contain 2 '.'). version=" + version)).onClose(() -> this.blurAgain())).show();
                }
            }
            if ((!isSoftwareUpdateCheckBox.isSelected() || versionOK) && alertMessageTextArea.getText().length() > 0 && keyInputTextField.getText().length() > 0) {
                if (this.alertManager.addAlertMessageIfKeyIsValid(new Alert(alertMessageTextArea.getText(), isUpdate, isPreRelease, version), keyInputTextField.getText())) {
                    this.hide();
                } else {
                    ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"shared.invalidKey"))).width(300.0)).onClose(() -> this.blurAgain())).show();
                }
            }
        });
        AutoTooltipButton removeAlertMessageButton = new AutoTooltipButton(Res.get((String)"sendAlertMessageWindow.remove"));
        removeAlertMessageButton.setOnAction(e -> {
            if (keyInputTextField.getText().length() > 0) {
                if (this.alertManager.removeAlertMessageIfKeyIsValid(keyInputTextField.getText())) {
                    this.hide();
                } else {
                    ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"shared.invalidKey"))).width(300.0)).onClose(() -> this.blurAgain())).show();
                }
            }
        });
        this.closeButton = new AutoTooltipButton(Res.get((String)"shared.close"));
        this.closeButton.setOnAction(e -> {
            this.hide();
            this.closeHandlerOptional.ifPresent(Runnable::run);
        });
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
        hBox.getChildren().addAll((Object[])new Node[]{sendButton, removeAlertMessageButton, this.closeButton});
        this.gridPane.getChildren().add((Object)hBox);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
    }
}

