/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import org.bitcoinj.core.Transaction;

public class SelectDepositTxWindow
extends Overlay<SelectDepositTxWindow> {
    private ComboBox<Transaction> transactionsComboBox;
    private List<Transaction> transactions;
    private Optional<Consumer<Transaction>> selectHandlerOptional;

    @Inject
    public SelectDepositTxWindow() {
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"selectDepositTxWindow.headline");
        }
        this.width = 768.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    public SelectDepositTxWindow onSelect(Consumer<Transaction> selectHandler) {
        this.selectHandlerOptional = Optional.of(selectHandler);
        return this;
    }

    public SelectDepositTxWindow transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    private void addContent() {
        Label label = FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, Res.get((String)"selectDepositTxWindow.msg"), 10.0);
        GridPane.setMargin((Node)label, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        this.transactionsComboBox = FormBuilder.addComboBox(this.gridPane, ++this.rowIndex, Res.get((String)"selectDepositTxWindow.select"));
        this.transactionsComboBox.setConverter((StringConverter)new StringConverter<Transaction>(this){

            public String toString(Transaction transaction) {
                return transaction.getTxId().toString();
            }

            public Transaction fromString(String string) {
                return null;
            }
        });
        this.transactionsComboBox.setItems(FXCollections.observableArrayList(this.transactions));
        this.transactionsComboBox.setOnAction(event -> {
            if (this.selectHandlerOptional.isPresent()) {
                this.selectHandlerOptional.get().accept((Transaction)this.transactionsComboBox.getSelectionModel().getSelectedItem());
            }
            this.hide();
        });
    }
}

