/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.GUIUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeWindow
extends Overlay<QRCodeWindow> {
    private static final Logger log = LoggerFactory.getLogger(QRCodeWindow.class);
    private final StackPane qrCodePane;
    private final String moneroUri;

    public QRCodeWindow(String moneroUri) {
        this.moneroUri = moneroUri;
        Tuple2<StackPane, ImageView> qrCodeTuple = GUIUtil.getBigXmrQrCodePane();
        this.qrCodePane = (StackPane)qrCodeTuple.first;
        ImageView qrCodeImageView = (ImageView)qrCodeTuple.second;
        byte[] imageBytes = QRCode.from((String)moneroUri).withSize(300, 300).to(ImageType.PNG).stream().toByteArray();
        Image qrImage = new Image((InputStream)new ByteArrayInputStream(imageBytes));
        qrCodeImageView.setImage(qrImage);
        this.type = Overlay.Type.Information;
        this.width = 468.0;
        this.headLine(Res.get((String)"qRCodeWindow.headline"));
        this.message(Res.get((String)"qRCodeWindow.msg"));
    }

    @Override
    public void show() {
        this.createGridPane();
        this.addHeadLine();
        this.addMessage();
        this.qrCodePane.setOnMouseClicked(event -> this.openWallet());
        GridPane.setRowIndex((Node)this.qrCodePane, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)this.qrCodePane, (Integer)2);
        GridPane.setHalignment((Node)this.qrCodePane, (HPos)HPos.CENTER);
        this.gridPane.getChildren().add((Object)this.qrCodePane);
        String request = this.moneroUri.replace("%20", " ").replace("?", "\n?").replace("&", "\n&");
        AutoTooltipLabel infoLabel = new AutoTooltipLabel(Res.get((String)"qRCodeWindow.request", (Object[])new Object[]{request}));
        infoLabel.setMouseTransparent(true);
        infoLabel.setWrapText(true);
        infoLabel.setId("popup-qr-code-info");
        GridPane.setHalignment((Node)infoLabel, (HPos)HPos.CENTER);
        GridPane.setHgrow((Node)infoLabel, (Priority)Priority.ALWAYS);
        GridPane.setMargin((Node)infoLabel, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
        GridPane.setRowIndex((Node)infoLabel, (Integer)(++this.rowIndex));
        GridPane.setColumnIndex((Node)infoLabel, (Integer)0);
        GridPane.setColumnSpan((Node)infoLabel, (Integer)2);
        this.gridPane.getChildren().add((Object)infoLabel);
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    @Override
    public String getClipboardText() {
        return this.moneroUri;
    }

    private void openWallet() {
        try {
            Utilities.openURI((URI)URI.create(this.moneroUri));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }
}

