/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIconView;
import haveno.common.UserThread;
import haveno.common.crypto.KeyRing;
import haveno.common.util.Tuple4;
import haveno.common.util.Utilities;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.editor.PasswordPopup;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Layout;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferDetailsWindow
extends Overlay<OfferDetailsWindow> {
    protected static final Logger log = LoggerFactory.getLogger(OfferDetailsWindow.class);
    private final CoinFormatter formatter;
    private final User user;
    private final KeyRing keyRing;
    private final Navigation navigation;
    private Offer offer;
    private BigInteger tradeAmount;
    private Price tradePrice;
    private Optional<Runnable> placeOfferHandlerOptional = Optional.empty();
    private Optional<Runnable> takeOfferHandlerOptional = Optional.empty();
    private BusyAnimation busyAnimation;
    private TradeManager tradeManager;
    private Subscription numTradesSubscription;
    private Subscription initProgressSubscription;

    @Inject
    public OfferDetailsWindow(@Named(value="BTC") CoinFormatter formatter, User user, KeyRing keyRing, Navigation navigation, TradeManager tradeManager) {
        this.formatter = formatter;
        this.user = user;
        this.keyRing = keyRing;
        this.navigation = navigation;
        this.tradeManager = tradeManager;
        this.type = Overlay.Type.Confirmation;
    }

    public void show(Offer offer, BigInteger tradeAmount, Price tradePrice) {
        this.offer = offer;
        this.tradeAmount = tradeAmount;
        this.tradePrice = tradePrice;
        this.rowIndex = -1;
        this.width = 1050.0;
        this.createGridPane();
        this.addContent();
        this.display();
    }

    public void show(Offer offer) {
        this.offer = offer;
        this.rowIndex = -1;
        this.width = 1050.0;
        this.createGridPane();
        this.addContent();
        this.display();
    }

    public OfferDetailsWindow onPlaceOffer(Runnable placeOfferHandler) {
        this.placeOfferHandlerOptional = Optional.of(placeOfferHandler);
        return this;
    }

    public OfferDetailsWindow onTakeOffer(Runnable takeOfferHandler) {
        this.takeOfferHandlerOptional = Optional.of(takeOfferHandler);
        return this;
    }

    @Override
    protected void onHidden() {
        if (this.busyAnimation != null) {
            this.busyAnimation.stop();
        }
        if (this.numTradesSubscription != null) {
            this.numTradesSubscription.unsubscribe();
            this.numTradesSubscription = null;
        }
        if (this.initProgressSubscription != null) {
            this.initProgressSubscription.unsubscribe();
            this.initProgressSubscription = null;
        }
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.setPadding(new Insets(35.0, 40.0, 30.0, 40.0));
        this.gridPane.getStyleClass().add((Object)"grid-pane");
    }

    private void addContent() {
        boolean showOfferExtraInfo;
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setMinWidth(224.0);
        int rows = 5;
        List acceptedBanks = this.offer.getAcceptedBankIds();
        boolean showAcceptedBanks = acceptedBanks != null && !acceptedBanks.isEmpty();
        List acceptedCountryCodes = this.offer.getAcceptedCountryCodes();
        boolean showAcceptedCountryCodes = acceptedCountryCodes != null && !acceptedCountryCodes.isEmpty();
        boolean isF2F = this.offer.getPaymentMethod().equals((Object)PaymentMethod.F2F);
        boolean bl = showOfferExtraInfo = this.offer.getCombinedExtraInfo() != null && !this.offer.getCombinedExtraInfo().isEmpty();
        if (!this.takeOfferHandlerOptional.isPresent()) {
            ++rows;
        }
        if (showAcceptedBanks) {
            ++rows;
        }
        if (showAcceptedCountryCodes) {
            ++rows;
        }
        if (showOfferExtraInfo) {
            ++rows;
        }
        if (isF2F) {
            ++rows;
        }
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, rows, Res.get((String)"shared.Offer"));
        Object counterCurrencyDirectionInfo = "";
        Object xmrDirectionInfo = "";
        OfferDirection direction = this.offer.getDirection();
        String currencyCode = this.offer.getCounterCurrencyCode();
        String offerTypeLabel = Res.get((String)"shared.offerType");
        String toReceive = " " + Res.get((String)"shared.toReceive");
        String toSpend = " " + Res.get((String)"shared.toSpend");
        double firstRowDistance = 40.0;
        if (this.takeOfferHandlerOptional.isPresent()) {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, this.rowIndex, offerTypeLabel, DisplayUtils.getDirectionForTakeOffer(direction, currencyCode), firstRowDistance);
            counterCurrencyDirectionInfo = direction == OfferDirection.BUY ? toReceive : toSpend;
            xmrDirectionInfo = direction == OfferDirection.SELL ? toReceive : toSpend;
        } else if (this.placeOfferHandlerOptional.isPresent()) {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, this.rowIndex, offerTypeLabel, DisplayUtils.getOfferDirectionForCreateOffer(direction, currencyCode, this.offer.isPrivateOffer()), firstRowDistance);
            counterCurrencyDirectionInfo = direction == OfferDirection.SELL ? toReceive : toSpend;
            xmrDirectionInfo = direction == OfferDirection.BUY ? toReceive : toSpend;
        } else {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, this.rowIndex, offerTypeLabel, DisplayUtils.getDirectionBothSides(direction, this.offer.isPrivateOffer()), firstRowDistance);
        }
        String amount = Res.get((String)"shared.xmrAmount");
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        if (this.takeOfferHandlerOptional.isPresent()) {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, amount + (String)xmrDirectionInfo, HavenoUtils.formatXmr((BigInteger)this.tradeAmount, (boolean)true));
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, VolumeUtil.formatVolumeLabel((String)currencyCode) + (String)counterCurrencyDirectionInfo, VolumeUtil.formatVolumeWithCode((Volume)this.offer.getVolumeByAmount(this.tradeAmount, this.offer.getMinAmount(), this.tradeAmount)));
        } else {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, amount + (String)xmrDirectionInfo, HavenoUtils.formatXmr((BigInteger)this.offer.getAmount(), (boolean)true));
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"offerDetailsWindow.minXmrAmount"), HavenoUtils.formatXmr((BigInteger)this.offer.getMinAmount(), (boolean)true));
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            String volume = VolumeUtil.formatVolumeWithCode((Volume)this.offer.getVolume());
            Object minVolume = "";
            if (this.offer.getVolume() != null && this.offer.getMinVolume() != null && !this.offer.getVolume().equals((Object)this.offer.getMinVolume())) {
                minVolume = " " + Res.get((String)"offerDetailsWindow.min", (Object[])new Object[]{VolumeUtil.formatVolumeWithCode((Volume)this.offer.getMinVolume())});
            }
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, VolumeUtil.formatVolumeLabel((String)currencyCode) + (String)counterCurrencyDirectionInfo, volume + (String)minVolume);
        }
        String priceLabel = Res.get((String)"shared.price");
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        if (this.takeOfferHandlerOptional.isPresent()) {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, priceLabel, FormattingUtils.formatPrice((Price)this.tradePrice));
        } else {
            Price price = this.offer.getPrice();
            if (this.offer.isUseMarketBasedPrice()) {
                FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, priceLabel, FormattingUtils.formatPrice((Price)price) + " " + Res.get((String)"offerDetailsWindow.distance", (Object[])new Object[]{FormattingUtils.formatPercentagePrice((double)this.offer.getMarketPriceMarginPct())}));
            } else {
                FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, priceLabel, FormattingUtils.formatPrice((Price)price));
            }
        }
        PaymentMethod paymentMethod = this.offer.getPaymentMethod();
        Object bankId = this.offer.getBankId();
        bankId = bankId == null || ((String)bankId).equals("null") ? "" : " (" + (String)bankId + ")";
        boolean isSpecificBanks = paymentMethod.equals((Object)PaymentMethod.SPECIFIC_BANKS);
        boolean isNationalBanks = paymentMethod.equals((Object)PaymentMethod.NATIONAL_BANK);
        boolean isSepa = paymentMethod.equals((Object)PaymentMethod.SEPA);
        String makerPaymentAccountId = this.offer.getMakerPaymentAccountId();
        PaymentAccount myPaymentAccount = this.user.getPaymentAccount(makerPaymentAccountId);
        String countryCode = this.offer.getCountryCode();
        boolean isMyOffer = this.offer.isMyOffer(this.keyRing);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        if (isMyOffer && makerPaymentAccountId != null && myPaymentAccount != null) {
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"offerDetailsWindow.myTradingAccount"), myPaymentAccount.getAccountName());
        } else {
            String method = Res.get((String)paymentMethod.getId());
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.paymentMethod"), method);
        }
        if (showAcceptedBanks) {
            if (paymentMethod.equals((Object)PaymentMethod.SAME_BANK)) {
                FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
                FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"offerDetailsWindow.bankId"), (String)acceptedBanks.get(0));
            } else if (isSpecificBanks) {
                FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
                String value = Joiner.on((String)", ").join((Iterable)acceptedBanks);
                String acceptedBanksLabel = Res.get((String)"shared.acceptedBanks");
                Tooltip tooltip = new Tooltip(acceptedBanksLabel + " " + value);
                Label acceptedBanksTextField = (Label)FormBuilder.addConfirmationLabelLabel((GridPane)this.gridPane, (int)(++this.rowIndex), (String)acceptedBanksLabel, (String)value).second;
                acceptedBanksTextField.setMouseTransparent(false);
                acceptedBanksTextField.setTooltip(tooltip);
            }
        }
        if (showAcceptedCountryCodes) {
            String countries;
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            Tooltip tooltip = null;
            if (CountryUtil.containsAllSepaEuroCountries((List)acceptedCountryCodes)) {
                countries = Res.get((String)"shared.allEuroCountries");
            } else if (acceptedCountryCodes.size() == 1) {
                countries = CountryUtil.getNameAndCode((String)((String)acceptedCountryCodes.get(0)));
                tooltip = new Tooltip(countries);
            } else {
                countries = CountryUtil.getCodesString((List)acceptedCountryCodes);
                tooltip = new Tooltip(CountryUtil.getNamesByCodesString((List)acceptedCountryCodes));
            }
            Label acceptedCountries = (Label)FormBuilder.addConfirmationLabelLabel((GridPane)this.gridPane, (boolean)true, (int)(++this.rowIndex), (String)Res.get((String)"shared.acceptedTakerCountries"), (String)countries).second;
            if (tooltip != null) {
                acceptedCountries.setMouseTransparent(false);
                acceptedCountries.setTooltip(tooltip);
            }
        }
        if (isF2F) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"payment.f2f.city"), this.offer.getF2FCity());
        }
        if (showOfferExtraInfo) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            TextArea textArea = (TextArea)FormBuilder.addConfirmationLabelTextArea((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"payment.shared.extraInfo"), (String)"", (double)0.0).second;
            textArea.setText(this.offer.getCombinedExtraInfo().trim());
            textArea.setMaxHeight(150.0);
            textArea.setEditable(false);
            GUIUtil.adjustHeightAutomatically(textArea, 150.0);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.SOMETIMES);
        }
        BigInteger reservedAmount = isMyOffer ? this.offer.getReservedAmount() : null;
        OpenOffer myOpenOffer = HavenoUtils.openOfferManager.getOpenOffer(this.offer.getId()).orElse(null);
        String offerChallenge = myOpenOffer == null ? null : myOpenOffer.getChallenge();
        rows = 3;
        if (countryCode != null) {
            ++rows;
        }
        if (!isF2F) {
            ++rows;
        }
        if (reservedAmount != null) {
            ++rows;
        }
        if (offerChallenge != null) {
            ++rows;
        }
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, rows, Res.get((String)"shared.details"), 30.0);
        FormBuilder.addConfirmationLabelTextFieldWithCopyIcon(this.gridPane, this.rowIndex, Res.get((String)"shared.offerId"), this.offer.getId(), 70.0);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextFieldWithCopyIcon(this.gridPane, ++this.rowIndex, Res.get((String)"offerDetailsWindow.makersOnion"), this.offer.getMakerNodeAddress().getFullAddress());
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"offerDetailsWindow.creationDate"), DisplayUtils.formatDateTime(this.offer.getDate()));
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        String value = Res.getWithColAndCap((String)"shared.buyer") + " " + HavenoUtils.formatXmr((BigInteger)(this.takeOfferHandlerOptional.isPresent() ? this.offer.getOfferPayload().getBuyerSecurityDepositForTradeAmount(this.tradeAmount) : this.offer.getOfferPayload().getMaxBuyerSecurityDeposit()), (boolean)true) + " / " + Res.getWithColAndCap((String)"shared.seller") + " " + HavenoUtils.formatXmr((BigInteger)(this.takeOfferHandlerOptional.isPresent() ? this.offer.getOfferPayload().getSellerSecurityDepositForTradeAmount(this.tradeAmount) : this.offer.getOfferPayload().getMaxSellerSecurityDeposit()), (boolean)true);
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.securityDeposit"), value);
        if (reservedAmount != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.reservedAmount"), HavenoUtils.formatXmr((BigInteger)reservedAmount, (boolean)true));
        }
        if (countryCode != null && !isF2F) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"offerDetailsWindow.countryBank"), CountryUtil.getNameAndCode((String)countryCode));
        }
        if (offerChallenge != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            Label label = FormBuilder.addLabel(this.gridPane, ++this.rowIndex, Res.get((String)"offerDetailsWindow.challenge"), 0.0);
            label.getStyleClass().addAll((Object[])new String[]{"confirmation-label", "regular-text-color"});
            GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
            GridPane.setValignment((Node)label, (VPos)VPos.TOP);
            VBox vbox = new VBox(13.0);
            vbox.setAlignment(Pos.TOP_CENTER);
            VBox.setVgrow((Node)vbox, (Priority)Priority.ALWAYS);
            vbox.getStyleClass().addAll((Object[])new String[]{"passphrase-copy-box"});
            JFXTextField centerLabel = new JFXTextField(offerChallenge);
            centerLabel.getStyleClass().add((Object)"confirmation-value");
            centerLabel.setAlignment(Pos.CENTER);
            centerLabel.setFocusTraversable(false);
            Label copyLabel = new Label();
            copyLabel.getStyleClass().addAll((Object[])new String[]{"icon"});
            copyLabel.setTooltip(new Tooltip(Res.get((String)"shared.copyToClipboard")));
            MaterialDesignIconView copyIcon = new MaterialDesignIconView(MaterialDesignIcon.CONTENT_COPY, "1.2em");
            copyIcon.setFill((Paint)Color.WHITE);
            copyLabel.setGraphic((Node)copyIcon);
            JFXButton copyButton = new JFXButton(Res.get((String)"offerDetailsWindow.challenge.copy"), (Node)copyLabel);
            copyButton.setContentDisplay(ContentDisplay.LEFT);
            copyButton.setGraphicTextGap(8.0);
            copyButton.setOnMouseClicked(e -> {
                Utilities.copyToClipboard((String)offerChallenge);
                Tooltip tp = new Tooltip(Res.get((String)"shared.copiedToClipboard"));
                Node node = (Node)e.getSource();
                UserThread.runAfter(() -> tp.hide(), (long)1L);
                tp.show(node, e.getScreenX() + Layout.PADDING, e.getScreenY() + Layout.PADDING);
            });
            copyButton.setId("copy-button-thin");
            copyButton.setFocusTraversable(false);
            vbox.getChildren().addAll((Object[])new Node[]{centerLabel, copyButton});
            GridPane.setRowIndex((Node)vbox, (Integer)this.rowIndex);
            GridPane.setColumnIndex((Node)vbox, (Integer)1);
            this.gridPane.getChildren().add((Object)vbox);
        }
        if (this.placeOfferHandlerOptional.isPresent()) {
            FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, 1, Res.get((String)"offerDetailsWindow.commitment"), 30.0);
            labelLabelTuple2 = FormBuilder.addConfirmationLabelLabel(this.gridPane, this.rowIndex, Res.get((String)"offerDetailsWindow.agree"), Res.get((String)"createOffer.tac"), 70.0);
            ((Label)labelLabelTuple2.second).setWrapText(true);
            ((Label)labelLabelTuple2.second).setMinHeight(Double.NEGATIVE_INFINITY);
            GridPane.setVgrow((Node)((Node)labelLabelTuple2.second), (Priority)Priority.ALWAYS);
            this.addConfirmAndCancelButtons(true);
        } else if (this.takeOfferHandlerOptional.isPresent()) {
            FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, 1, Res.get((String)"shared.contract"), 30.0);
            labelLabelTuple2 = FormBuilder.addConfirmationLabelLabel(this.gridPane, this.rowIndex, Res.get((String)"offerDetailsWindow.tac"), Res.get((String)"takeOffer.tac"), 70.0);
            ((Label)labelLabelTuple2.second).setWrapText(true);
            this.addConfirmAndCancelButtons(false);
        } else {
            Button closeButton = FormBuilder.addButtonAfterGroup(this.gridPane, ++this.rowIndex, Res.get((String)"shared.close"));
            GridPane.setColumnIndex((Node)closeButton, (Integer)1);
            GridPane.setHalignment((Node)closeButton, (HPos)HPos.RIGHT);
            closeButton.setOnAction(e -> {
                this.closeHandlerOptional.ifPresent(Runnable::run);
                this.hide();
            });
        }
    }

    private void addConfirmAndCancelButtons(boolean isPlaceOffer) {
        boolean isBuyOffer = this.offer.isBuyOffer();
        boolean isBuyerRole = isPlaceOffer == isBuyOffer;
        String placeOfferButtonText = isBuyerRole ? Res.get((String)"offerDetailsWindow.confirm.maker.buy", (Object[])new Object[]{this.offer.getCounterCurrencyCode()}) : Res.get((String)"offerDetailsWindow.confirm.maker.sell", (Object[])new Object[]{this.offer.getCounterCurrencyCode()});
        String takeOfferButtonText = isBuyerRole ? Res.get((String)"offerDetailsWindow.confirm.taker.buy", (Object[])new Object[]{this.offer.getCounterCurrencyCode()}) : Res.get((String)"offerDetailsWindow.confirm.taker.sell", (Object[])new Object[]{this.offer.getCounterCurrencyCode()});
        Tuple4<Button, BusyAnimation, Label, HBox> placeOfferTuple = FormBuilder.addButtonBusyAnimationLabelAfterGroup(this.gridPane, ++this.rowIndex, 1, isPlaceOffer ? placeOfferButtonText : takeOfferButtonText);
        AutoTooltipButton confirmButton = (AutoTooltipButton)((Object)placeOfferTuple.first);
        confirmButton.setMinHeight(40.0);
        confirmButton.setPadding(new Insets(0.0, 20.0, 0.0, 20.0));
        confirmButton.setGraphicTextGap(10.0);
        confirmButton.setId(isBuyerRole ? "buy-button-big" : "sell-button-big");
        confirmButton.updateText(isPlaceOffer ? placeOfferButtonText : takeOfferButtonText);
        if (this.offer.hasBuyerAsTakerWithoutDeposit()) {
            confirmButton.setGraphic((Node)GUIUtil.getLockLabel());
        } else {
            ImageView iconView = new ImageView();
            iconView.setId(isBuyerRole ? "image-buy-white" : "image-sell-white");
            confirmButton.setGraphic((Node)iconView);
        }
        this.busyAnimation = (BusyAnimation)((Object)placeOfferTuple.second);
        Label spinnerInfoLabel = (Label)placeOfferTuple.third;
        AutoTooltipButton cancelButton = new AutoTooltipButton(Res.get((String)"shared.cancel"));
        cancelButton.setDefaultButton(false);
        cancelButton.setOnAction(e -> {
            this.closeHandlerOptional.ifPresent(Runnable::run);
            this.hide();
        });
        ((HBox)placeOfferTuple.fourth).getChildren().add((Object)cancelButton);
        confirmButton.setOnAction(arg_0 -> this.lambda$addConfirmAndCancelButtons$5(isPlaceOffer, confirmButton, (Button)cancelButton, spinnerInfoLabel, arg_0));
    }

    private void confirmTakeOfferAux(Button button, Button cancelButton, Label spinnerInfoLabel, boolean isPlaceOffer) {
        button.setDisable(true);
        cancelButton.setDisable(!isPlaceOffer);
        if (isPlaceOffer) {
            spinnerInfoLabel.setText(Res.get((String)"createOffer.fundsBox.placeOfferSpinnerInfo"));
            this.placeOfferHandlerOptional.ifPresent(Runnable::run);
        } else {
            spinnerInfoLabel.setText(Res.get((String)"takeOffer.fundsBox.takeOfferSpinnerInfo", (Object[])new Object[]{"0%"}));
            this.numTradesSubscription = EasyBind.subscribe((ObservableValue)this.tradeManager.getNumPendingTrades(), newNum -> this.subscribeToProgress(spinnerInfoLabel));
            this.takeOfferHandlerOptional.ifPresent(Runnable::run);
        }
    }

    private void subscribeToProgress(Label spinnerInfoLabel) {
        Trade trade = this.tradeManager.getTrade(this.offer.getId());
        if (trade == null || this.initProgressSubscription != null) {
            return;
        }
        this.initProgressSubscription = EasyBind.subscribe((ObservableValue)trade.initProgressProperty(), newProgress -> {
            String progress = (int)(newProgress.doubleValue() * 100.0) + "%";
            UserThread.execute(() -> spinnerInfoLabel.setText(Res.get((String)"takeOffer.fundsBox.takeOfferSpinnerInfo", (Object[])new Object[]{progress})));
        });
    }

    private /* synthetic */ void lambda$addConfirmAndCancelButtons$5(boolean isPlaceOffer, AutoTooltipButton confirmButton, Button cancelButton, Label spinnerInfoLabel, ActionEvent e) {
        if (GUIUtil.canCreateOrTakeOfferOrShowPopup(this.user, this.navigation)) {
            if (!isPlaceOffer && this.offer.isPrivateOffer()) {
                ((PasswordPopup)((PasswordPopup)new PasswordPopup().headLine(Res.get((String)"offerbook.takeOffer.enterChallenge"))).onAction((String password) -> {
                    if (this.offer.getChallengeHash().equals(HavenoUtils.getChallengeHash((String)password))) {
                        this.offer.setChallenge(password);
                        this.confirmTakeOfferAux((Button)confirmButton, cancelButton, spinnerInfoLabel, isPlaceOffer);
                    } else {
                        ((Popup)new Popup().warning(Res.get((String)"password.wrongPw"))).show();
                    }
                }).closeButtonText(Res.get((String)"shared.cancel"))).show();
            } else {
                this.confirmTakeOfferAux((Button)confirmButton, cancelButton, spinnerInfoLabel, isPlaceOffer);
            }
        }
    }
}

