/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.common.base.Preconditions;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;

public class GenericMessageWindow
extends Overlay<GenericMessageWindow> {
    private String preamble;
    private static final double MAX_TEXT_AREA_HEIGHT = 250.0;

    @Override
    public void show() {
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    public GenericMessageWindow preamble(String preamble) {
        this.preamble = preamble;
        return this;
    }

    private void addContent() {
        if (this.preamble != null) {
            Label label = FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, this.preamble, 10.0);
            label.setPrefSize(1200.0, 71.0);
        }
        Preconditions.checkNotNull((Object)this.message, (Object)"message must not be null");
        TextArea textArea = FormBuilder.addTextArea(this.gridPane, ++this.rowIndex, "", 10.0);
        textArea.getStyleClass().add((Object)"flat-text-area-with-border");
        textArea.setText(this.message);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setPrefWidth(1200.0);
        GUIUtil.adjustHeightAutomatically(textArea, 250.0);
    }
}

