/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.core.filter.Filter;
import haveno.core.filter.FilterManager;
import haveno.core.filter.PaymentAccountFilter;
import haveno.core.locale.Res;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.FormBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import org.apache.commons.lang3.StringUtils;

public class FilterWindow
extends Overlay<FilterWindow> {
    private final FilterManager filterManager;
    private final boolean useDevPrivilegeKeys;
    private ScrollPane scrollPane;

    @Inject
    public FilterWindow(FilterManager filterManager, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        this.filterManager = filterManager;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        this.type = Overlay.Type.Attention;
    }

    @Override
    protected Region getRootContainer() {
        return this.scrollPane;
    }

    @Override
    public void show() {
        if (this.headLine == null) {
            this.headLine = Res.get((String)"filterWindow.headline");
        }
        this.width = 1000.0;
        this.createGridPane();
        this.scrollPane = new ScrollPane();
        this.scrollPane.setContent((Node)this.gridPane);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setMaxHeight(700.0);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.addHeadLine();
        this.addContent();
        this.applyStyles();
        this.display();
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    private void addContent() {
        this.gridPane.getColumnConstraints().remove(1);
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setHalignment(HPos.LEFT);
        InputTextField keyTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.unlock"), 10.0);
        if (this.useDevPrivilegeKeys) {
            keyTF.setText("6ac43ea1df2a290c1c8391736aa42e4339c5cb4f110ff0257a13b63211977b7a");
        }
        InputTextField offerIdsTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.offers"));
        InputTextField bannedFromTradingTF = (InputTextField)((Object)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"filterWindow.onions")).second);
        InputTextField bannedFromNetworkTF = (InputTextField)((Object)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"filterWindow.bannedFromNetwork")).second);
        bannedFromTradingTF.setPromptText("E.g. zqnzx6o3nifef5df.onion:9999");
        InputTextField paymentAccountFilterTF = (InputTextField)((Object)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"filterWindow.accounts")).second);
        GridPane.setHalignment((Node)paymentAccountFilterTF, (HPos)HPos.RIGHT);
        paymentAccountFilterTF.setPromptText("E.g. PERFECT_MONEY|getAccountNr|12345");
        InputTextField bannedCurrenciesTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.bannedCurrencies"));
        InputTextField bannedPaymentMethodsTF = (InputTextField)((Object)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"filterWindow.bannedPaymentMethods")).second);
        bannedPaymentMethodsTF.setPromptText("E.g. PERFECT_MONEY");
        InputTextField bannedAccountWitnessSignerPubKeysTF = (InputTextField)((Object)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"filterWindow.bannedAccountWitnessSignerPubKeys")).second);
        bannedAccountWitnessSignerPubKeysTF.setPromptText("E.g. 7f66117aa084e5a2c54fe17d29dd1fee2b241257");
        InputTextField arbitratorsTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.arbitrators"));
        InputTextField mediatorsTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.mediators"));
        InputTextField refundAgentsTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.refundAgents"));
        InputTextField xmrFeeReceiverAddressesTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.xmrFeeReceiverAddresses"));
        InputTextField seedNodesTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.seedNode"));
        InputTextField priceRelayNodesTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.priceRelayNode"));
        InputTextField xmrNodesTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.xmrNode"));
        CheckBox preventPublicXmrNetworkCheckBox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.preventPublicXmrNetwork"));
        CheckBox disableAutoConfCheckBox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.disableAutoConf"));
        InputTextField disableTradeBelowVersionTF = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.disableTradeBelowVersion"));
        InputTextField bannedPrivilegedDevPubKeysTF = (InputTextField)((Object)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"filterWindow.bannedPrivilegedDevPubKeys")).second);
        InputTextField autoConfExplorersTF = (InputTextField)((Object)FormBuilder.addTopLabelInputTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"filterWindow.autoConfExplorers")).second);
        CheckBox disableMempoolValidationCheckBox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.disableMempoolValidation"));
        CheckBox disableApiCheckBox = FormBuilder.addLabelCheckBox(this.gridPane, ++this.rowIndex, Res.get((String)"filterWindow.disableApi"));
        Filter filter = this.filterManager.getDevFilter();
        if (filter != null) {
            this.setupFieldFromList(offerIdsTF, filter.getBannedOfferIds());
            this.setupFieldFromList(bannedFromTradingTF, filter.getNodeAddressesBannedFromTrading());
            this.setupFieldFromList(bannedFromNetworkTF, filter.getNodeAddressesBannedFromNetwork());
            this.setupFieldFromPaymentAccountFiltersList(paymentAccountFilterTF, filter.getBannedPaymentAccounts());
            this.setupFieldFromList(bannedCurrenciesTF, filter.getBannedCurrencies());
            this.setupFieldFromList(bannedPaymentMethodsTF, filter.getBannedPaymentMethods());
            this.setupFieldFromList(bannedAccountWitnessSignerPubKeysTF, filter.getBannedAccountWitnessSignerPubKeys());
            this.setupFieldFromList(arbitratorsTF, filter.getArbitrators());
            this.setupFieldFromList(mediatorsTF, filter.getMediators());
            this.setupFieldFromList(refundAgentsTF, filter.getRefundAgents());
            this.setupFieldFromList(xmrFeeReceiverAddressesTF, filter.getXmrFeeReceiverAddresses());
            this.setupFieldFromList(seedNodesTF, filter.getSeedNodes());
            this.setupFieldFromList(priceRelayNodesTF, filter.getPriceRelayNodes());
            this.setupFieldFromList(xmrNodesTF, filter.getXmrNodes());
            this.setupFieldFromList(bannedPrivilegedDevPubKeysTF, filter.getBannedPrivilegedDevPubKeys());
            this.setupFieldFromList(autoConfExplorersTF, filter.getBannedAutoConfExplorers());
            preventPublicXmrNetworkCheckBox.setSelected(filter.isPreventPublicXmrNetwork());
            disableAutoConfCheckBox.setSelected(filter.isDisableAutoConf());
            disableTradeBelowVersionTF.setText(filter.getDisableTradeBelowVersion());
            disableMempoolValidationCheckBox.setSelected(filter.isDisableMempoolValidation());
            disableApiCheckBox.setSelected(filter.isDisableApi());
        }
        AutoTooltipButton removeFilterMessageButton = new AutoTooltipButton(Res.get((String)"filterWindow.remove"));
        removeFilterMessageButton.setDisable(this.filterManager.getDevFilter() == null);
        AutoTooltipButton sendButton = new AutoTooltipButton(Res.get((String)"filterWindow.add"));
        sendButton.setOnAction(arg_0 -> this.lambda$addContent$3(keyTF, offerIdsTF, bannedFromTradingTF, paymentAccountFilterTF, bannedCurrenciesTF, bannedPaymentMethodsTF, arbitratorsTF, seedNodesTF, priceRelayNodesTF, preventPublicXmrNetworkCheckBox, xmrNodesTF, disableTradeBelowVersionTF, mediatorsTF, refundAgentsTF, bannedAccountWitnessSignerPubKeysTF, xmrFeeReceiverAddressesTF, bannedPrivilegedDevPubKeysTF, disableAutoConfCheckBox, autoConfExplorersTF, bannedFromNetworkTF, disableMempoolValidationCheckBox, disableApiCheckBox, (Button)removeFilterMessageButton, arg_0));
        removeFilterMessageButton.setOnAction(e -> {
            String privKeyString = keyTF.getText();
            if (this.filterManager.canRemoveDevFilter(privKeyString)) {
                this.filterManager.removeDevFilter(privKeyString);
                this.hide();
            } else {
                ((Popup)((Popup)new Popup().warning(Res.get((String)"shared.invalidKey"))).onClose(() -> this.blurAgain())).show();
            }
        });
        this.closeButton = new AutoTooltipButton(Res.get((String)"shared.close"));
        this.closeButton.setOnAction(e -> {
            this.hide();
            this.closeHandlerOptional.ifPresent(Runnable::run);
        });
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
        hBox.getChildren().addAll((Object[])new Node[]{sendButton, removeFilterMessageButton, this.closeButton});
        this.gridPane.getChildren().add((Object)hBox);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
    }

    private void addDevFilter(Button removeFilterMessageButton, String privKeyString, Filter newFilter) {
        this.filterManager.addDevFilter(newFilter, privKeyString);
        removeFilterMessageButton.setDisable(this.filterManager.getDevFilter() == null);
        this.hide();
    }

    private void setupFieldFromList(InputTextField field, Collection<String> values) {
        if (values != null) {
            field.setText(String.join((CharSequence)", ", values));
        }
    }

    private void setupFieldFromPaymentAccountFiltersList(InputTextField field, List<PaymentAccountFilter> values) {
        if (values != null) {
            StringBuilder sb = new StringBuilder();
            values.forEach(e -> {
                if (e != null && e.getPaymentMethodId() != null) {
                    sb.append(e.getPaymentMethodId()).append("|").append(e.getGetMethodName()).append("|").append(e.getValue()).append(", ");
                }
            });
            field.setText(sb.toString());
        }
    }

    private List<String> readAsList(InputTextField field) {
        if (field.getText().isEmpty()) {
            return FXCollections.emptyObservableList();
        }
        return Arrays.asList(StringUtils.deleteWhitespace((String)field.getText()).split(","));
    }

    private List<PaymentAccountFilter> readAsPaymentAccountFiltersList(InputTextField field) {
        return this.readAsList(field).stream().map(item -> {
            String[] list = item.split("\\|");
            if (list.length == 3) {
                return new PaymentAccountFilter(list[0], list[1], list[2]);
            }
            return new PaymentAccountFilter("", "", "");
        }).collect(Collectors.toList());
    }

    private /* synthetic */ void lambda$addContent$3(InputTextField keyTF, InputTextField offerIdsTF, InputTextField bannedFromTradingTF, InputTextField paymentAccountFilterTF, InputTextField bannedCurrenciesTF, InputTextField bannedPaymentMethodsTF, InputTextField arbitratorsTF, InputTextField seedNodesTF, InputTextField priceRelayNodesTF, CheckBox preventPublicXmrNetworkCheckBox, InputTextField xmrNodesTF, InputTextField disableTradeBelowVersionTF, InputTextField mediatorsTF, InputTextField refundAgentsTF, InputTextField bannedAccountWitnessSignerPubKeysTF, InputTextField xmrFeeReceiverAddressesTF, InputTextField bannedPrivilegedDevPubKeysTF, CheckBox disableAutoConfCheckBox, InputTextField autoConfExplorersTF, InputTextField bannedFromNetworkTF, CheckBox disableMempoolValidationCheckBox, CheckBox disableApiCheckBox, Button removeFilterMessageButton, ActionEvent e) {
        String privKeyString = keyTF.getText();
        if (this.filterManager.canAddDevFilter(privKeyString)) {
            String signerPubKeyAsHex = this.filterManager.getSignerPubKeyAsHex(privKeyString);
            Filter newFilter = new Filter(this.readAsList(offerIdsTF), this.readAsList(bannedFromTradingTF), this.readAsPaymentAccountFiltersList(paymentAccountFilterTF), this.readAsList(bannedCurrenciesTF), this.readAsList(bannedPaymentMethodsTF), this.readAsList(arbitratorsTF), this.readAsList(seedNodesTF), this.readAsList(priceRelayNodesTF), preventPublicXmrNetworkCheckBox.isSelected(), this.readAsList(xmrNodesTF), disableTradeBelowVersionTF.getText(), this.readAsList(mediatorsTF), this.readAsList(refundAgentsTF), this.readAsList(bannedAccountWitnessSignerPubKeysTF), this.readAsList(xmrFeeReceiverAddressesTF), this.filterManager.getOwnerPubKey(), signerPubKeyAsHex, this.readAsList(bannedPrivilegedDevPubKeysTF), disableAutoConfCheckBox.isSelected(), this.readAsList(autoConfExplorersTF), new HashSet<String>(this.readAsList(bannedFromNetworkTF)), disableMempoolValidationCheckBox.isSelected(), disableApiCheckBox.isSelected());
            if (this.filterManager.canRemoveDevFilter(privKeyString)) {
                this.filterManager.removeDevFilter(privKeyString);
                UserThread.runAfter(() -> this.addDevFilter(removeFilterMessageButton, privKeyString, newFilter), (long)5L);
            } else {
                this.addDevFilter(removeFilterMessageButton, privKeyString, newFilter);
            }
        } else {
            ((Popup)((Popup)new Popup().warning(Res.get((String)"shared.invalidKey"))).onClose(() -> this.blurAgain())).show();
        }
    }
}

