/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import haveno.common.util.Tuple2;
import haveno.core.locale.Res;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.user.BlockChainExplorer;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.UrlInputValidator;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import java.util.ArrayList;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class EditCustomExplorerWindow
extends Overlay<EditCustomExplorerWindow> {
    private InputTextField nameInputTextField;
    private InputTextField txUrlInputTextField;
    private UrlInputValidator urlInputValidator;
    private BlockChainExplorer currentExplorer;
    private ListView<BlockChainExplorer> listView;

    public EditCustomExplorerWindow(String coin, BlockChainExplorer currentExplorer, ArrayList<BlockChainExplorer> availableExplorers) {
        this.currentExplorer = currentExplorer;
        this.listView = new ListView();
        this.listView.setItems(FXCollections.observableArrayList(availableExplorers));
        this.headLine = coin + " " + Res.get((String)"settings.preferences.editCustomExplorer.headline");
    }

    public BlockChainExplorer getEditedBlockChainExplorer() {
        return new BlockChainExplorer(this.nameInputTextField.getText(), this.txUrlInputTextField.getText());
    }

    @Override
    public void show() {
        this.width = 1000.0;
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.urlInputValidator = new UrlInputValidator();
        this.txUrlInputTextField.setValidator((InputValidator)this.urlInputValidator);
        this.nameInputTextField.setValidator((InputValidator)new LengthValidator(1, 50));
        this.actionButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            String name = this.nameInputTextField.getText();
            String txUrl = this.txUrlInputTextField.getText();
            return !this.nameInputTextField.getValidator().validate((String)name).isValid || !this.txUrlInputTextField.getValidator().validate((String)txUrl).isValid;
        }, (Observable[])new Observable[]{this.nameInputTextField.textProperty(), this.txUrlInputTextField.textProperty()}));
        this.applyStyles();
        this.display();
    }

    @Override
    protected void createGridPane() {
        this.gridPane = new GridPane();
        this.gridPane.setHgap(15.0);
        this.gridPane.setVgap(15.0);
        this.gridPane.setPadding(new Insets(64.0, 64.0, 64.0, 64.0));
        this.gridPane.setPrefWidth(this.width);
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints1.setPercentWidth(45.0);
        columnConstraints2.setPercentWidth(55.0);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1, columnConstraints2});
    }

    private void addContent() {
        Label mlm = FormBuilder.addMultilineLabel(this.gridPane, this.rowIndex++, Res.get((String)"settings.preferences.editCustomExplorer.description"), 0.0);
        GridPane.setColumnSpan((Node)mlm, (Integer)2);
        GridPane.setMargin((Node)mlm, (Insets)new Insets(40.0, 0.0, 0.0, 0.0));
        AutoTooltipButton button = new AutoTooltipButton(">>");
        button.setOnAction(e -> {
            BlockChainExplorer blockChainExplorer = (BlockChainExplorer)this.listView.getSelectionModel().getSelectedItem();
            if (blockChainExplorer != null) {
                this.nameInputTextField.setText(blockChainExplorer.name);
                this.txUrlInputTextField.setText(blockChainExplorer.txUrl);
            }
        });
        button.setStyle("-fx-pref-width: 50px; -fx-pref-height: 30; -fx-padding: 3 3 3 3;");
        VBox vBox = new VBox(new Node[]{button});
        vBox.setAlignment(Pos.CENTER);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.getTopLabelWithVBox(Res.get((String)"settings.preferences.editCustomExplorer.available"), this.listView);
        this.listView.setPrefWidth(300.0);
        HBox hBox = new HBox(new Node[]{(Node)topLabelWithVBox.second, vBox});
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setSpacing(20.0);
        hBox.setMaxHeight(200.0);
        this.gridPane.add((Node)hBox, 0, this.rowIndex);
        GridPane.setColumnIndex((Node)hBox, (Integer)0);
        GridPane.setValignment((Node)hBox, (VPos)VPos.TOP);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        this.listView.setCellFactory((Callback)new Callback<ListView<BlockChainExplorer>, ListCell<BlockChainExplorer>>(){

            public ListCell<BlockChainExplorer> call(ListView<BlockChainExplorer> list) {
                ListCell<BlockChainExplorer> cell = new ListCell<BlockChainExplorer>(this){
                    final Label label = new AutoTooltipLabel();
                    final AnchorPane pane = new AnchorPane(new Node[]{this.label});

                    public void updateItem(BlockChainExplorer item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.label.setText(item.name);
                            this.setGraphic((Node)this.pane);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                cell.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        if (event.getClickCount() == 2) {
                            BlockChainExplorer blockChainExplorer = (BlockChainExplorer)EditCustomExplorerWindow.this.listView.getSelectionModel().getSelectedItem();
                            EditCustomExplorerWindow.this.nameInputTextField.setText(blockChainExplorer.name);
                            EditCustomExplorerWindow.this.txUrlInputTextField.setText(blockChainExplorer.txUrl);
                        }
                    }
                });
                return cell;
            }
        });
        GridPane autoConfirmGridPane = new GridPane();
        autoConfirmGridPane.setPrefHeight(150.0);
        GridPane.setMargin((Node)autoConfirmGridPane, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        this.gridPane.add((Node)autoConfirmGridPane, 1, this.rowIndex);
        FormBuilder.addTitledGroupBg(autoConfirmGridPane, 0, 6, Res.get((String)"settings.preferences.editCustomExplorer.chosen"), 0.0);
        int localRowIndex = 0;
        this.nameInputTextField = FormBuilder.addInputTextField(autoConfirmGridPane, ++localRowIndex, Res.get((String)"settings.preferences.editCustomExplorer.name"), 20.0);
        this.nameInputTextField.setPrefWidth(1200.0);
        this.txUrlInputTextField = FormBuilder.addInputTextField(autoConfirmGridPane, ++localRowIndex, Res.get((String)"settings.preferences.editCustomExplorer.txUrl"));
        this.nameInputTextField.setText(this.currentExplorer.name);
        this.txUrlInputTextField.setText(this.currentExplorer.txUrl);
    }
}

