/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.handlers.ResultHandler;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.core.api.CoreDisputesService;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.components.AutoTooltipRadioButton;
import haveno.desktop.components.HavenoTextArea;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisputeSummaryWindow
extends Overlay<DisputeSummaryWindow> {
    private static final Logger log = LoggerFactory.getLogger(DisputeSummaryWindow.class);
    private final CoinFormatter formatter;
    private final TradeManager tradeManager;
    private final ArbitrationManager arbitrationManager;
    private final MediationManager mediationManager;
    private final CoreDisputesService disputesService;
    private Dispute dispute;
    private Trade trade;
    private ToggleGroup tradeAmountToggleGroup;
    private ToggleGroup reasonToggleGroup;
    private DisputeResult disputeResult;
    private RadioButton buyerGetsTradeAmountRadioButton;
    private RadioButton sellerGetsTradeAmountRadioButton;
    private RadioButton buyerGetsAllRadioButton;
    private RadioButton sellerGetsAllRadioButton;
    private RadioButton customRadioButton;
    private RadioButton reasonWasBugRadioButton;
    private RadioButton reasonWasUsabilityIssueRadioButton;
    private RadioButton reasonProtocolViolationRadioButton;
    private RadioButton reasonNoReplyRadioButton;
    private RadioButton reasonWasScamRadioButton;
    private RadioButton reasonWasOtherRadioButton;
    private RadioButton reasonWasBankRadioButton;
    private RadioButton reasonWasOptionTradeRadioButton;
    private RadioButton reasonWasSellerNotRespondingRadioButton;
    private RadioButton reasonWasWrongSenderAccountRadioButton;
    private RadioButton reasonWasPeerWasLateRadioButton;
    private RadioButton reasonWasTradeAlreadySettledRadioButton;
    private CoreDisputesService.PayoutSuggestion payoutSuggestion;
    private Optional<Dispute> peersDisputeOptional;
    private String role;
    private TextArea summaryNotesTextArea;
    private ChangeListener<Boolean> customRadioButtonSelectedListener;
    private ChangeListener<Toggle> reasonToggleSelectionListener;
    private InputTextField buyerPayoutAmountInputTextField;
    private InputTextField sellerPayoutAmountInputTextField;
    private ChangeListener<Boolean> buyerPayoutAmountListener;
    private ChangeListener<Boolean> sellerPayoutAmountListener;
    private ChangeListener<Toggle> tradeAmountToggleGroupListener;

    @Inject
    public DisputeSummaryWindow(@Named(value="BTC") CoinFormatter formatter, TradeManager tradeManager, ArbitrationManager arbitrationManager, MediationManager mediationManager, XmrWalletService walletService, TradeWalletService tradeWalletService, CoreDisputesService disputesService) {
        this.formatter = formatter;
        this.tradeManager = tradeManager;
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.disputesService = disputesService;
        this.type = Overlay.Type.Confirmation;
    }

    public void show(Dispute dispute) {
        this.dispute = dispute;
        this.trade = this.tradeManager.getTrade(dispute.getTradeId());
        this.payoutSuggestion = null;
        this.rowIndex = -1;
        this.width = 1150.0;
        this.createGridPane();
        this.addContent();
        this.display();
        if (DevEnv.isDevMode()) {
            UserThread.execute(() -> this.summaryNotesTextArea.setText("dummy result...."));
        }
    }

    @Override
    protected void cleanup() {
        if (this.reasonToggleGroup != null) {
            this.reasonToggleGroup.selectedToggleProperty().removeListener(this.reasonToggleSelectionListener);
        }
        if (this.customRadioButton != null) {
            this.customRadioButton.selectedProperty().removeListener(this.customRadioButtonSelectedListener);
        }
        if (this.tradeAmountToggleGroup != null) {
            this.tradeAmountToggleGroup.selectedToggleProperty().removeListener(this.tradeAmountToggleGroupListener);
        }
        this.removePayoutAmountListeners();
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.setPadding(new Insets(35.0, 40.0, 30.0, 40.0));
        this.gridPane.getStyleClass().addAll((Object[])new String[]{"grid-pane", "popup-with-input"});
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setHalignment(HPos.LEFT);
        this.gridPane.setPrefWidth(this.width);
    }

    private void addContent() {
        boolean applyPeersDisputeResult;
        Contract contract = this.dispute.getContract();
        this.disputeResult = this.dispute.getDisputeResultProperty().get() == null ? new DisputeResult(this.dispute.getTradeId(), this.dispute.getTraderId()) : (DisputeResult)this.dispute.getDisputeResultProperty().get();
        this.peersDisputeOptional = ((DisputeManager)Preconditions.checkNotNull(this.getDisputeManager(this.dispute))).getDisputesAsObservableList().stream().filter(d -> this.dispute.getTradeId().equals(d.getTradeId()) && this.dispute.getTraderId() != d.getTraderId()).findFirst();
        this.addInfoPane();
        this.addTradeAmountPayoutControls();
        this.addPayoutAmountTextFields();
        this.addReasonControls();
        boolean bl = applyPeersDisputeResult = this.peersDisputeOptional.isPresent() && this.peersDisputeOptional.get().isClosed() && this.peersDisputeOptional.get().getDisputeResultProperty().get() != null;
        if (applyPeersDisputeResult) {
            DisputeResult peersDisputeResult = (DisputeResult)this.peersDisputeOptional.get().getDisputeResultProperty().get();
            this.disputeResult.setBuyerPayoutAmountBeforeCost(peersDisputeResult.getBuyerPayoutAmountBeforeCost());
            this.disputeResult.setSellerPayoutAmountBeforeCost(peersDisputeResult.getSellerPayoutAmountBeforeCost());
            this.disputeResult.setWinner(peersDisputeResult.getWinner());
            this.disputeResult.setReason(peersDisputeResult.getReason());
            this.disputeResult.setSummaryNotes((String)peersDisputeResult.summaryNotesProperty().get());
            this.disputeResult.setSubtractFeeFrom(peersDisputeResult.getSubtractFeeFrom());
            this.disableTradeAmountPayoutControls();
            this.applyTradeAmountRadioButtonStates();
        } else if (this.trade.isPayoutPublished()) {
            log.info("Payout is already published for {} {}, disabling payout controls", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
            this.disableTradeAmountPayoutControls();
        } else if (this.trade.isDepositTxMissing()) {
            log.warn("Missing deposit tx for {} {}, disabling some payout controls", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
            this.disableTradeAmountPayoutControlsWhenDepositMissing();
        }
        this.setReasonRadioButtonState();
        this.addSummaryNotes();
        this.addButtons(contract);
    }

    private void disableTradeAmountPayoutControls() {
        this.buyerGetsTradeAmountRadioButton.setDisable(true);
        this.buyerGetsAllRadioButton.setDisable(true);
        this.sellerGetsTradeAmountRadioButton.setDisable(true);
        this.sellerGetsAllRadioButton.setDisable(true);
        this.customRadioButton.setDisable(true);
        this.buyerPayoutAmountInputTextField.setDisable(true);
        this.sellerPayoutAmountInputTextField.setDisable(true);
        this.buyerPayoutAmountInputTextField.setEditable(false);
        this.sellerPayoutAmountInputTextField.setEditable(false);
        this.reasonWasBugRadioButton.setDisable(true);
        this.reasonWasUsabilityIssueRadioButton.setDisable(true);
        this.reasonProtocolViolationRadioButton.setDisable(true);
        this.reasonNoReplyRadioButton.setDisable(true);
        this.reasonWasScamRadioButton.setDisable(true);
        this.reasonWasOtherRadioButton.setDisable(true);
        this.reasonWasBankRadioButton.setDisable(true);
        this.reasonWasOptionTradeRadioButton.setDisable(true);
        this.reasonWasSellerNotRespondingRadioButton.setDisable(true);
        this.reasonWasWrongSenderAccountRadioButton.setDisable(true);
        this.reasonWasPeerWasLateRadioButton.setDisable(true);
        this.reasonWasTradeAlreadySettledRadioButton.setDisable(true);
    }

    private void disableTradeAmountPayoutControlsWhenDepositMissing() {
        this.buyerGetsTradeAmountRadioButton.setDisable(true);
        this.sellerGetsTradeAmountRadioButton.setDisable(true);
    }

    private void addInfoPane() {
        Contract contract = this.dispute.getContract();
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, 17, Res.get((String)"disputeSummaryWindow.title")).getStyleClass().add((Object)"last");
        FormBuilder.addConfirmationLabelLabel(this.gridPane, this.rowIndex, Res.get((String)"shared.tradeId"), this.dispute.getShortTradeId(), 40.0);
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"disputeSummaryWindow.openDate"), DisplayUtils.formatDateTime(this.dispute.getOpeningDate()));
        this.role = this.dispute.isDisputeOpenerIsMaker() ? (this.dispute.isDisputeOpenerIsBuyer() ? Res.get((String)"support.buyerMaker") : Res.get((String)"support.sellerMaker")) : (this.dispute.isDisputeOpenerIsBuyer() ? Res.get((String)"support.buyerTaker") : Res.get((String)"support.sellerTaker"));
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"disputeSummaryWindow.role"), this.role);
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.tradeAmount"), HavenoUtils.formatXmr((BigInteger)contract.getTradeAmount(), (boolean)true));
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.tradePrice"), FormattingUtils.formatPrice((Price)contract.getPrice()));
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.tradeVolume"), VolumeUtil.formatVolumeWithCode((Volume)contract.getTradeVolume()));
        String tradeFee = Res.getWithColAndCap((String)"shared.buyer") + " " + HavenoUtils.formatXmr((BigInteger)(this.trade.getBuyer() == this.trade.getMaker() ? this.trade.getMakerFee() : this.trade.getTakerFee()), (boolean)true) + " / " + Res.getWithColAndCap((String)"shared.seller") + " " + HavenoUtils.formatXmr((BigInteger)(this.trade.getSeller() == this.trade.getMaker() ? this.trade.getMakerFee() : this.trade.getTakerFee()), (boolean)true);
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.tradeFee"), tradeFee);
        String securityDeposit = Res.getWithColAndCap((String)"shared.buyer") + " " + HavenoUtils.formatXmr((BigInteger)this.trade.getBuyer().getSecurityDeposit(), (boolean)true) + " / " + Res.getWithColAndCap((String)"shared.seller") + " " + HavenoUtils.formatXmr((BigInteger)this.trade.getSeller().getSecurityDeposit(), (boolean)true);
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"shared.securityDeposit"), securityDeposit);
    }

    private void addTradeAmountPayoutControls() {
        this.buyerGetsTradeAmountRadioButton = new AutoTooltipRadioButton(Res.get((String)"disputeSummaryWindow.payout.getsTradeAmount", (Object[])new Object[]{Res.get((String)"shared.buyer")}));
        this.buyerGetsAllRadioButton = new AutoTooltipRadioButton(Res.get((String)"disputeSummaryWindow.payout.getsAll", (Object[])new Object[]{Res.get((String)"shared.buyer")}));
        this.sellerGetsTradeAmountRadioButton = new AutoTooltipRadioButton(Res.get((String)"disputeSummaryWindow.payout.getsTradeAmount", (Object[])new Object[]{Res.get((String)"shared.seller")}));
        this.sellerGetsAllRadioButton = new AutoTooltipRadioButton(Res.get((String)"disputeSummaryWindow.payout.getsAll", (Object[])new Object[]{Res.get((String)"shared.seller")}));
        this.customRadioButton = new AutoTooltipRadioButton(Res.get((String)"disputeSummaryWindow.payout.custom"));
        VBox radioButtonPane = new VBox();
        radioButtonPane.setSpacing(10.0);
        radioButtonPane.getChildren().addAll((Object[])new Node[]{this.buyerGetsTradeAmountRadioButton, this.buyerGetsAllRadioButton, this.sellerGetsTradeAmountRadioButton, this.sellerGetsAllRadioButton, this.customRadioButton});
        FormBuilder.addTopLabelWithVBox(this.gridPane, ++this.rowIndex, Res.get((String)"disputeSummaryWindow.payout"), (Node)radioButtonPane, 0.0);
        this.tradeAmountToggleGroup = new ToggleGroup();
        this.buyerGetsTradeAmountRadioButton.setToggleGroup(this.tradeAmountToggleGroup);
        this.buyerGetsAllRadioButton.setToggleGroup(this.tradeAmountToggleGroup);
        this.sellerGetsTradeAmountRadioButton.setToggleGroup(this.tradeAmountToggleGroup);
        this.sellerGetsAllRadioButton.setToggleGroup(this.tradeAmountToggleGroup);
        this.customRadioButton.setToggleGroup(this.tradeAmountToggleGroup);
        this.tradeAmountToggleGroupListener = (observable, oldValue, newValue) -> this.applyPayoutAmounts((Toggle)newValue);
        this.tradeAmountToggleGroup.selectedToggleProperty().addListener(this.tradeAmountToggleGroupListener);
        this.buyerPayoutAmountListener = (observable, oldValue, newValue) -> this.applyCustomAmounts(this.buyerPayoutAmountInputTextField, (boolean)oldValue, (boolean)newValue);
        this.sellerPayoutAmountListener = (observable, oldValue, newValue) -> this.applyCustomAmounts(this.sellerPayoutAmountInputTextField, (boolean)oldValue, (boolean)newValue);
        this.customRadioButtonSelectedListener = (observable, oldValue, newValue) -> {
            this.buyerPayoutAmountInputTextField.setEditable((boolean)newValue);
            this.sellerPayoutAmountInputTextField.setEditable((boolean)newValue);
            if (newValue.booleanValue()) {
                this.buyerPayoutAmountInputTextField.focusedProperty().addListener(this.buyerPayoutAmountListener);
                this.sellerPayoutAmountInputTextField.focusedProperty().addListener(this.sellerPayoutAmountListener);
            } else {
                this.removePayoutAmountListeners();
            }
        };
        this.customRadioButton.selectedProperty().addListener(this.customRadioButtonSelectedListener);
    }

    private void removePayoutAmountListeners() {
        if (this.buyerPayoutAmountInputTextField != null && this.buyerPayoutAmountListener != null) {
            this.buyerPayoutAmountInputTextField.focusedProperty().removeListener(this.buyerPayoutAmountListener);
        }
        if (this.sellerPayoutAmountInputTextField != null && this.sellerPayoutAmountListener != null) {
            this.sellerPayoutAmountInputTextField.focusedProperty().removeListener(this.sellerPayoutAmountListener);
        }
    }

    private boolean isPayoutAmountValid() {
        BigInteger buyerAmount = HavenoUtils.parseXmr((String)this.buyerPayoutAmountInputTextField.getText());
        BigInteger sellerAmount = HavenoUtils.parseXmr((String)this.sellerPayoutAmountInputTextField.getText());
        Contract contract = this.dispute.getContract();
        BigInteger tradeAmount = contract.getTradeAmount();
        BigInteger expected = tradeAmount.add(this.trade.getBuyer().getSecurityDeposit()).add(this.trade.getSeller().getSecurityDeposit());
        BigInteger totalAmount = buyerAmount.add(sellerAmount);
        return totalAmount.compareTo(expected) == 0 || totalAmount.compareTo(this.trade.getWallet().getBalance()) == 0;
    }

    private void applyCustomAmounts(InputTextField inputTextField, boolean oldFocusValue, boolean newFocusValue) {
        BigInteger sellerAmount;
        BigInteger buyerAmount;
        if (!oldFocusValue || newFocusValue) {
            return;
        }
        BigInteger available = this.trade.getWallet().getBalance();
        BigInteger enteredAmount = HavenoUtils.parseXmr((String)inputTextField.getText());
        if (enteredAmount.compareTo(available) > 0) {
            BigInteger finalEnteredAmount = enteredAmount = available;
            inputTextField.setText(HavenoUtils.formatXmr((BigInteger)finalEnteredAmount));
        }
        BigInteger counterPart = available.subtract(enteredAmount);
        String formattedCounterPartAmount = HavenoUtils.formatXmr((BigInteger)counterPart);
        if (inputTextField == this.buyerPayoutAmountInputTextField) {
            buyerAmount = enteredAmount;
            sellerAmount = counterPart;
            this.sellerPayoutAmountInputTextField.setText(formattedCounterPartAmount);
        } else {
            sellerAmount = enteredAmount;
            buyerAmount = counterPart;
            this.buyerPayoutAmountInputTextField.setText(formattedCounterPartAmount);
        }
        this.disputeResult.setBuyerPayoutAmountBeforeCost(buyerAmount);
        this.disputeResult.setSellerPayoutAmountBeforeCost(sellerAmount);
        this.disputeResult.setWinner(buyerAmount.compareTo(sellerAmount) > 0 ? DisputeResult.Winner.BUYER : DisputeResult.Winner.SELLER);
        this.disputeResult.setSubtractFeeFrom(buyerAmount.compareTo(sellerAmount) > 0 ? DisputeResult.SubtractFeeFrom.SELLER_ONLY : DisputeResult.SubtractFeeFrom.BUYER_ONLY);
    }

    private void addPayoutAmountTextFields() {
        this.buyerPayoutAmountInputTextField = new InputTextField();
        this.buyerPayoutAmountInputTextField.setLabelFloat(true);
        this.buyerPayoutAmountInputTextField.getStyleClass().add((Object)"label-float");
        this.buyerPayoutAmountInputTextField.setEditable(false);
        this.buyerPayoutAmountInputTextField.setPromptText(Res.get((String)"disputeSummaryWindow.payoutAmount.buyer"));
        this.sellerPayoutAmountInputTextField = new InputTextField();
        this.sellerPayoutAmountInputTextField.setLabelFloat(true);
        this.sellerPayoutAmountInputTextField.getStyleClass().add((Object)"label-float");
        this.sellerPayoutAmountInputTextField.setPromptText(Res.get((String)"disputeSummaryWindow.payoutAmount.seller"));
        this.sellerPayoutAmountInputTextField.setEditable(false);
        VBox vBox = new VBox();
        vBox.setSpacing(15.0);
        vBox.getChildren().addAll((Object[])new Node[]{this.buyerPayoutAmountInputTextField, this.sellerPayoutAmountInputTextField});
        GridPane.setMargin((Node)vBox, (Insets)new Insets(60.0, 0.0, 0.0, 0.0));
        GridPane.setRowIndex((Node)vBox, (Integer)this.rowIndex);
        GridPane.setColumnIndex((Node)vBox, (Integer)1);
        this.gridPane.getChildren().add((Object)vBox);
    }

    private void addReasonControls() {
        this.reasonWasBugRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.BUG.name())));
        this.reasonWasUsabilityIssueRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.USABILITY.name())));
        this.reasonProtocolViolationRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.PROTOCOL_VIOLATION.name())));
        this.reasonNoReplyRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.NO_REPLY.name())));
        this.reasonWasScamRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.SCAM.name())));
        this.reasonWasBankRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.BANK_PROBLEMS.name())));
        this.reasonWasOtherRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.OTHER.name())));
        this.reasonWasOptionTradeRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.OPTION_TRADE.name())));
        this.reasonWasSellerNotRespondingRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.SELLER_NOT_RESPONDING.name())));
        this.reasonWasWrongSenderAccountRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.WRONG_SENDER_ACCOUNT.name())));
        this.reasonWasPeerWasLateRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.PEER_WAS_LATE.name())));
        this.reasonWasTradeAlreadySettledRadioButton = new AutoTooltipRadioButton(Res.get((String)("disputeSummaryWindow.reason." + DisputeResult.Reason.TRADE_ALREADY_SETTLED.name())));
        HBox feeRadioButtonPane = new HBox();
        feeRadioButtonPane.setSpacing(20.0);
        feeRadioButtonPane.getChildren().addAll((Object[])new Node[]{this.reasonWasTradeAlreadySettledRadioButton, this.reasonWasPeerWasLateRadioButton, this.reasonWasOptionTradeRadioButton, this.reasonWasSellerNotRespondingRadioButton, this.reasonWasWrongSenderAccountRadioButton, this.reasonWasBugRadioButton, this.reasonWasUsabilityIssueRadioButton, this.reasonWasBankRadioButton, this.reasonWasOtherRadioButton});
        VBox vBox = (VBox)FormBuilder.addTopLabelWithVBox((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"disputeSummaryWindow.reason"), (Node)feeRadioButtonPane, (double)10.0).second;
        GridPane.setColumnSpan((Node)vBox, (Integer)2);
        this.reasonToggleGroup = new ToggleGroup();
        this.reasonWasBugRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasUsabilityIssueRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonProtocolViolationRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonNoReplyRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasScamRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasOtherRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasBankRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasOptionTradeRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasSellerNotRespondingRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasWrongSenderAccountRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasPeerWasLateRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonWasTradeAlreadySettledRadioButton.setToggleGroup(this.reasonToggleGroup);
        this.reasonToggleSelectionListener = (observable, oldValue, newValue) -> {
            if (newValue == this.reasonWasBugRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.BUG);
            } else if (newValue == this.reasonWasUsabilityIssueRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.USABILITY);
            } else if (newValue == this.reasonProtocolViolationRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.PROTOCOL_VIOLATION);
            } else if (newValue == this.reasonNoReplyRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.NO_REPLY);
            } else if (newValue == this.reasonWasScamRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.SCAM);
            } else if (newValue == this.reasonWasBankRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.BANK_PROBLEMS);
            } else if (newValue == this.reasonWasOtherRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.OTHER);
            } else if (newValue == this.reasonWasOptionTradeRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.OPTION_TRADE);
            } else if (newValue == this.reasonWasSellerNotRespondingRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.SELLER_NOT_RESPONDING);
            } else if (newValue == this.reasonWasWrongSenderAccountRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.WRONG_SENDER_ACCOUNT);
            } else if (newValue == this.reasonWasTradeAlreadySettledRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.TRADE_ALREADY_SETTLED);
            } else if (newValue == this.reasonWasPeerWasLateRadioButton) {
                this.disputeResult.setReason(DisputeResult.Reason.PEER_WAS_LATE);
            }
        };
        this.reasonToggleGroup.selectedToggleProperty().addListener(this.reasonToggleSelectionListener);
    }

    private void setReasonRadioButtonState() {
        if (this.disputeResult.getReason() != null) {
            switch (this.disputeResult.getReason()) {
                case BUG: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasBugRadioButton);
                    break;
                }
                case USABILITY: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasUsabilityIssueRadioButton);
                    break;
                }
                case PROTOCOL_VIOLATION: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonProtocolViolationRadioButton);
                    break;
                }
                case NO_REPLY: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonNoReplyRadioButton);
                    break;
                }
                case SCAM: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasScamRadioButton);
                    break;
                }
                case BANK_PROBLEMS: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasBankRadioButton);
                    break;
                }
                case OTHER: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasOtherRadioButton);
                    break;
                }
                case OPTION_TRADE: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasOptionTradeRadioButton);
                    break;
                }
                case SELLER_NOT_RESPONDING: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasSellerNotRespondingRadioButton);
                    break;
                }
                case WRONG_SENDER_ACCOUNT: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasWrongSenderAccountRadioButton);
                    break;
                }
                case PEER_WAS_LATE: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasPeerWasLateRadioButton);
                    break;
                }
                case TRADE_ALREADY_SETTLED: {
                    this.reasonToggleGroup.selectToggle((Toggle)this.reasonWasTradeAlreadySettledRadioButton);
                }
            }
        }
    }

    private void addSummaryNotes() {
        this.summaryNotesTextArea = new HavenoTextArea();
        this.summaryNotesTextArea.setPromptText(Res.get((String)"disputeSummaryWindow.addSummaryNotes"));
        this.summaryNotesTextArea.setWrapText(true);
        Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.addTopLabelWithVBox(this.gridPane, ++this.rowIndex, Res.get((String)"disputeSummaryWindow.summaryNotes"), (Node)this.summaryNotesTextArea, 0.0);
        GridPane.setColumnSpan((Node)((Node)topLabelWithVBox.second), (Integer)2);
        this.summaryNotesTextArea.setPrefHeight(50.0);
        this.summaryNotesTextArea.textProperty().bindBidirectional((Property)this.disputeResult.summaryNotesProperty());
        if (this.isClosedAndPublished()) {
            this.summaryNotesTextArea.setEditable(false);
            this.summaryNotesTextArea.setDisable(true);
        }
    }

    private void addButtons(Contract contract) {
        Tuple3<Button, Button, HBox> tuple = FormBuilder.add2ButtonsWithBox(this.gridPane, ++this.rowIndex, Res.get((String)"disputeSummaryWindow.close.button"), Res.get((String)"shared.cancel"), 15.0, true);
        Button closeTicketButton = (Button)tuple.first;
        closeTicketButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.tradeAmountToggleGroup.getSelectedToggle() == null || this.summaryNotesTextArea.getText() == null || this.summaryNotesTextArea.getText().length() == 0 || !this.isPayoutAmountValid() || this.isClosedAndPublished(), (Observable[])new Observable[]{this.tradeAmountToggleGroup.selectedToggleProperty(), this.summaryNotesTextArea.textProperty(), this.buyerPayoutAmountInputTextField.textProperty(), this.sellerPayoutAmountInputTextField.textProperty()}));
        Button cancelButton = (Button)tuple.second;
        closeTicketButton.setOnAction(e -> {
            block5: {
                closeTicketButton.disableProperty().unbind();
                closeTicketButton.setDisable(true);
                if (this.dispute.getSupportType() == SupportType.ARBITRATION && this.peersDisputeOptional.isPresent() && !this.peersDisputeOptional.get().isClosed() && !this.trade.isPayoutPublished()) {
                    try {
                        MoneroTxWallet payoutTx = this.arbitrationManager.createDisputePayoutTx(this.trade, this.dispute.getContract(), this.disputeResult, true);
                        this.showPayoutTxConfirmation(contract, payoutTx, () -> this.doClose(closeTicketButton, cancelButton), () -> {
                            closeTicketButton.setDisable(false);
                            cancelButton.setDisable(false);
                        });
                    }
                    catch (Exception ex) {
                        if (this.trade.isPayoutPublished()) {
                            this.doClose(closeTicketButton, cancelButton);
                            break block5;
                        }
                        log.error("Error creating dispute payout tx for dispute: " + ex.getMessage(), (Throwable)ex);
                        ((Popup)new Popup().error(ex.getMessage())).show();
                        closeTicketButton.setDisable(false);
                        cancelButton.setDisable(false);
                    }
                } else {
                    this.doClose(closeTicketButton, cancelButton);
                }
            }
        });
        cancelButton.setOnAction(e -> this.hide());
    }

    private boolean isClosedAndPublished() {
        return this.dispute.isClosed() && this.trade.isPayoutPublished();
    }

    private void showPayoutTxConfirmation(Contract contract, MoneroTxWallet payoutTx, ResultHandler resultHandler, ResultHandler cancelHandler) {
        BigInteger outputAmount;
        BigInteger buyerPayoutAmount;
        String buyerPayoutAddressString = contract.getBuyerPayoutAddressString();
        String sellerPayoutAddressString = contract.getSellerPayoutAddressString();
        List destinations = payoutTx.getOutgoingTransfer().getDestinations();
        boolean buyerFirst = ((MoneroDestination)destinations.get(0)).getAddress().equals(buyerPayoutAddressString);
        BigInteger bigInteger = buyerFirst ? ((MoneroDestination)destinations.get(0)).getAmount() : (buyerPayoutAmount = destinations.size() == 2 ? ((MoneroDestination)destinations.get(1)).getAmount() : BigInteger.ZERO);
        BigInteger sellerPayoutAmount = buyerFirst ? (destinations.size() == 2 ? ((MoneroDestination)destinations.get(1)).getAmount() : BigInteger.ZERO) : ((MoneroDestination)destinations.get(0)).getAmount();
        String buyerDetails = "";
        if (buyerPayoutAmount.compareTo(BigInteger.ZERO) > 0) {
            buyerDetails = Res.get((String)"disputeSummaryWindow.close.txDetails.buyer", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)buyerPayoutAmount, (boolean)true), buyerPayoutAddressString});
        }
        String sellerDetails = "";
        if (sellerPayoutAmount.compareTo(BigInteger.ZERO) > 0) {
            sellerDetails = Res.get((String)"disputeSummaryWindow.close.txDetails.seller", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)sellerPayoutAmount, (boolean)true), sellerPayoutAddressString});
        }
        if ((outputAmount = buyerPayoutAmount.add(sellerPayoutAmount).add(payoutTx.getFee())).compareTo(BigInteger.ZERO) > 0) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().width(900.0)).headLine(Res.get((String)"disputeSummaryWindow.close.txDetails.headline"))).confirmation(Res.get((String)"disputeSummaryWindow.close.txDetails", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)outputAmount, (boolean)true), buyerDetails, sellerDetails, this.formatter.formatCoinWithCode(HavenoUtils.atomicUnitsToCoin((BigInteger)payoutTx.getFee()))}))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> resultHandler.handleResult())).closeButtonText(Res.get((String)"shared.cancel"))).onClose(() -> cancelHandler.handleResult())).show();
        } else {
            ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"disputeSummaryWindow.close.noPayout.headline"))).confirmation(Res.get((String)"disputeSummaryWindow.close.noPayout.text"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(() -> ((ResultHandler)resultHandler).handleResult())).closeButtonText(Res.get((String)"shared.cancel"))).onClose(() -> cancelHandler.handleResult())).show();
        }
    }

    private void doClose(Button closeTicketButton, Button cancelButton) {
        cancelButton.setDisable(true);
        DisputeManager<? extends DisputeList<Dispute>> disputeManager = this.getDisputeManager(this.dispute);
        if (disputeManager == null) {
            return;
        }
        this.summaryNotesTextArea.textProperty().unbindBidirectional((Property)this.disputeResult.summaryNotesProperty());
        this.disputeResult.setCloseDate(new Date());
        this.disputesService.closeDisputeTicket(disputeManager, this.dispute, this.disputeResult, () -> {
            if (this.peersDisputeOptional.isPresent() && !this.peersDisputeOptional.get().isClosed() && !DevEnv.isDevMode()) {
                ((Popup)new Popup().attention(Res.get((String)"disputeSummaryWindow.close.closePeer"))).show();
            }
            disputeManager.requestPersistence();
            closeTicketButton.disableProperty().unbind();
            this.hide();
        }, (errMessage, err) -> {
            log.error("Error closing dispute ticket: " + errMessage + "\n", err);
            ((Popup)new Popup().error(err.toString())).show();
        });
    }

    private DisputeManager<? extends DisputeList<Dispute>> getDisputeManager(Dispute dispute) {
        return dispute.isMediationDispute() ? this.mediationManager : this.arbitrationManager;
    }

    private void applyPayoutAmounts(Toggle selectedTradeAmountToggle) {
        if (selectedTradeAmountToggle != this.customRadioButton && selectedTradeAmountToggle != null) {
            this.applyPayoutAmountsToDisputeResult(selectedTradeAmountToggle);
            this.applyTradeAmountRadioButtonStates();
        }
    }

    private void applyPayoutAmountsToDisputeResult(Toggle selectedTradeAmountToggle) {
        if (selectedTradeAmountToggle == this.buyerGetsTradeAmountRadioButton) {
            this.payoutSuggestion = CoreDisputesService.PayoutSuggestion.BUYER_GETS_TRADE_AMOUNT;
            this.disputeResult.setWinner(DisputeResult.Winner.BUYER);
        } else if (selectedTradeAmountToggle == this.buyerGetsAllRadioButton) {
            this.payoutSuggestion = CoreDisputesService.PayoutSuggestion.BUYER_GETS_ALL;
            this.disputeResult.setWinner(DisputeResult.Winner.BUYER);
        } else if (selectedTradeAmountToggle == this.sellerGetsTradeAmountRadioButton) {
            this.payoutSuggestion = CoreDisputesService.PayoutSuggestion.SELLER_GETS_TRADE_AMOUNT;
            this.disputeResult.setWinner(DisputeResult.Winner.SELLER);
        } else if (selectedTradeAmountToggle == this.sellerGetsAllRadioButton) {
            this.payoutSuggestion = CoreDisputesService.PayoutSuggestion.SELLER_GETS_ALL;
            this.disputeResult.setWinner(DisputeResult.Winner.SELLER);
        } else {
            throw new IllegalStateException("Unknown radio button");
        }
        this.disputesService.applyPayoutAmountsToDisputeResult(this.payoutSuggestion, this.dispute, this.disputeResult, -1L);
        this.buyerPayoutAmountInputTextField.setText(HavenoUtils.formatXmr((BigInteger)this.disputeResult.getBuyerPayoutAmountBeforeCost()));
        this.sellerPayoutAmountInputTextField.setText(HavenoUtils.formatXmr((BigInteger)this.disputeResult.getSellerPayoutAmountBeforeCost()));
    }

    private void applyTradeAmountRadioButtonStates() {
        if (this.payoutSuggestion == null) {
            this.payoutSuggestion = this.getPayoutSuggestionFromDisputeResult();
        }
        BigInteger buyerPayoutAmount = this.disputeResult.getBuyerPayoutAmountBeforeCost();
        BigInteger sellerPayoutAmount = this.disputeResult.getSellerPayoutAmountBeforeCost();
        this.buyerPayoutAmountInputTextField.setText(HavenoUtils.formatXmr((BigInteger)buyerPayoutAmount));
        this.sellerPayoutAmountInputTextField.setText(HavenoUtils.formatXmr((BigInteger)sellerPayoutAmount));
        switch (this.payoutSuggestion) {
            case BUYER_GETS_TRADE_AMOUNT: {
                this.buyerGetsTradeAmountRadioButton.setSelected(true);
                break;
            }
            case BUYER_GETS_ALL: {
                this.buyerGetsAllRadioButton.setSelected(true);
                break;
            }
            case SELLER_GETS_TRADE_AMOUNT: {
                this.sellerGetsTradeAmountRadioButton.setSelected(true);
                break;
            }
            case SELLER_GETS_ALL: {
                this.sellerGetsAllRadioButton.setSelected(true);
                break;
            }
            case CUSTOM: {
                this.customRadioButton.setSelected(true);
            }
        }
    }

    private CoreDisputesService.PayoutSuggestion getPayoutSuggestionFromDisputeResult() {
        if (this.disputeResult.getBuyerPayoutAmountBeforeCost().equals(BigInteger.ZERO)) {
            return CoreDisputesService.PayoutSuggestion.SELLER_GETS_ALL;
        }
        if (this.disputeResult.getSellerPayoutAmountBeforeCost().equals(BigInteger.ZERO)) {
            return CoreDisputesService.PayoutSuggestion.BUYER_GETS_ALL;
        }
        if (this.disputeResult.getBuyerPayoutAmountBeforeCost().equals(this.trade.getAmount().add(this.trade.getBuyer().getSecurityDeposit()))) {
            return CoreDisputesService.PayoutSuggestion.BUYER_GETS_TRADE_AMOUNT;
        }
        if (this.disputeResult.getSellerPayoutAmountBeforeCost().equals(this.trade.getAmount().add(this.trade.getSeller().getSecurityDeposit()))) {
            return CoreDisputesService.PayoutSuggestion.SELLER_GETS_TRADE_AMOUNT;
        }
        return CoreDisputesService.PayoutSuggestion.CUSTOM;
    }
}

