/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.common.base.Preconditions;
import haveno.core.alert.Alert;
import haveno.core.locale.Res;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayAlertMessageWindow
extends Overlay<DisplayAlertMessageWindow> {
    private static final Logger log = LoggerFactory.getLogger(DisplayAlertMessageWindow.class);
    private Alert alert;

    public DisplayAlertMessageWindow() {
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        this.width = 768.0;
        this.createGridPane();
        Preconditions.checkNotNull((Object)this.alert, (Object)"alertMessage must not be null");
        if (this.alert.isSoftwareUpdateNotification()) {
            this.information("");
            this.headLine = Res.get((String)"displayAlertMessageWindow.update.headline");
        } else {
            this.error("");
            this.headLine = Res.get((String)"displayAlertMessageWindow.headline");
        }
        this.headLine = Res.get((String)"displayAlertMessageWindow.headline");
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    public DisplayAlertMessageWindow alertMessage(Alert alert) {
        this.alert = alert;
        return this;
    }

    private void addContent() {
        Preconditions.checkNotNull((Object)this.alert, (Object)"alertMessage must not be null");
        this.message(this.alert.getMessage());
        this.addMessage();
        if (this.alert.isSoftwareUpdateNotification()) {
            String url = "https://haveno.exchange/downloads";
            HyperlinkWithIcon hyperlinkWithIcon = (HyperlinkWithIcon)((Object)FormBuilder.addLabelHyperlinkWithIcon((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"displayAlertMessageWindow.update.download"), (String)url, (String)url).second);
            hyperlinkWithIcon.setMaxWidth(550.0);
        }
    }
}

