/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.desktop.components.HavenoTextArea;
import haveno.desktop.components.TextFieldWithCopyIcon;
import haveno.desktop.main.MainView;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractWindow
extends Overlay<ContractWindow> {
    private static final Logger log = LoggerFactory.getLogger(ContractWindow.class);
    private final ArbitrationManager arbitrationManager;
    private final MediationManager mediationManager;
    private final RefundManager refundManager;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private Dispute dispute;

    @Inject
    public ContractWindow(ArbitrationManager arbitrationManager, MediationManager mediationManager, RefundManager refundManager, AccountAgeWitnessService accountAgeWitnessService) {
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.refundManager = refundManager;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.type = Overlay.Type.Confirmation;
    }

    public void show(Dispute dispute) {
        this.dispute = dispute;
        this.rowIndex = -1;
        this.width = 1168.0;
        this.createGridPane();
        this.addContent();
        this.display();
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(0)).setMinWidth(250.0);
        this.gridPane.setPadding(new Insets(35.0, 40.0, 30.0, 40.0));
        this.gridPane.getStyleClass().add((Object)"grid-pane");
    }

    private void addContent() {
        Tooltip tooltip;
        NodeAddress agentNodeAddress;
        Contract contract = this.dispute.getContract();
        Offer offer = new Offer(contract.getOfferPayload());
        List acceptedBanks = offer.getAcceptedBankIds();
        boolean showAcceptedBanks = acceptedBanks != null && !acceptedBanks.isEmpty();
        List acceptedCountryCodes = offer.getAcceptedCountryCodes();
        boolean showAcceptedCountryCodes = acceptedCountryCodes != null && !acceptedCountryCodes.isEmpty();
        int rows = 18;
        if (this.dispute.getPayoutTxSerialized() != null) {
            ++rows;
        }
        if (this.dispute.getDelayedPayoutTxId() != null) {
            ++rows;
        }
        if (this.dispute.getDonationAddressOfDelayedPayoutTx() != null) {
            ++rows;
        }
        if (showAcceptedCountryCodes) {
            ++rows;
        }
        if (showAcceptedBanks) {
            ++rows;
        }
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.rowIndex, rows, Res.get((String)"contractWindow.title"));
        FormBuilder.addConfirmationLabelTextField(this.gridPane, this.rowIndex, Res.get((String)"shared.offerId"), offer.getId(), 40.0);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"contractWindow.dates"), DisplayUtils.formatDateTime(offer.getDate()) + " / " + DisplayUtils.formatDateTime(this.dispute.getTradeDate()));
        String currencyCode = offer.getCounterCurrencyCode();
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.offerType"), DisplayUtils.getDirectionBothSides(offer.getDirection(), offer.isPrivateOffer()));
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.tradePrice"), FormattingUtils.formatPrice((Price)contract.getPrice()));
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.tradeAmount"), HavenoUtils.formatXmr((BigInteger)contract.getTradeAmount(), (boolean)true));
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, VolumeUtil.formatVolumeLabel((String)currencyCode, (String)":"), VolumeUtil.formatVolumeWithCode((Volume)contract.getTradeVolume()));
        String securityDeposit = Res.getWithColAndCap((String)"shared.buyer") + " " + HavenoUtils.formatXmr((BigInteger)offer.getOfferPayload().getBuyerSecurityDepositForTradeAmount(contract.getTradeAmount()), (boolean)true) + " / " + Res.getWithColAndCap((String)"shared.seller") + " " + HavenoUtils.formatXmr((BigInteger)offer.getOfferPayload().getSellerSecurityDepositForTradeAmount(contract.getTradeAmount()), (boolean)true);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.securityDeposit"), securityDeposit);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"contractWindow.xmrAddresses"), contract.getBuyerPayoutAddressString() + " / " + contract.getSellerPayoutAddressString());
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"contractWindow.onions"), contract.getBuyerNodeAddress().getFullAddress() + " / " + contract.getSellerNodeAddress().getFullAddress());
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"contractWindow.accountAge"), DisplayUtils.getAccountWitnessDescription(this.accountAgeWitnessService, offer.getPaymentMethod(), this.dispute.getBuyerPaymentAccountPayload(), contract.getBuyerPubKeyRing()) + " / " + DisplayUtils.getAccountWitnessDescription(this.accountAgeWitnessService, offer.getPaymentMethod(), this.dispute.getSellerPaymentAccountPayload(), contract.getSellerPubKeyRing()));
        DisputeManager<? extends DisputeList<Dispute>> disputeManager = this.getDisputeManager(this.dispute);
        String nrOfDisputesAsBuyer = disputeManager != null ? disputeManager.getNrOfDisputes(true, contract) : "";
        String nrOfDisputesAsSeller = disputeManager != null ? disputeManager.getNrOfDisputes(false, contract) : "";
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"contractWindow.numDisputes"), nrOfDisputesAsBuyer + " / " + nrOfDisputesAsSeller);
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.paymentDetails", (Object[])new Object[]{Res.get((String)"shared.buyer")}), this.dispute.getBuyerPaymentAccountPayload() != null ? this.dispute.getBuyerPaymentAccountPayload().getPaymentDetails() : "NA");
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.paymentDetails", (Object[])new Object[]{Res.get((String)"shared.seller")}), this.dispute.getSellerPaymentAccountPayload() != null ? this.dispute.getSellerPaymentAccountPayload().getPaymentDetails() : "NA");
        String title = "";
        String agentMatrixUserName = "";
        if (this.dispute.getSupportType() != null) {
            switch (this.dispute.getSupportType()) {
                case ARBITRATION: {
                    title = Res.get((String)"shared.selectedArbitrator");
                    break;
                }
                case MEDIATION: {
                    throw new RuntimeException("Mediation type not adapted to XMR");
                }
                case TRADE: {
                    break;
                }
                case REFUND: {
                    throw new RuntimeException("Refund type not adapted to XMR");
                }
            }
        }
        if (disputeManager != null && (agentNodeAddress = disputeManager.getAgentNodeAddress(this.dispute)) != null) {
            String value = agentMatrixUserName + " (" + agentNodeAddress.getFullAddress() + ")";
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, title, value);
        }
        if (showAcceptedCountryCodes) {
            String countries;
            tooltip = null;
            if (CountryUtil.containsAllSepaEuroCountries((List)acceptedCountryCodes)) {
                countries = Res.get((String)"shared.allEuroCountries");
            } else {
                countries = CountryUtil.getCodesString((List)acceptedCountryCodes);
                tooltip = new Tooltip(CountryUtil.getNamesByCodesString((List)acceptedCountryCodes));
            }
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            ((TextField)FormBuilder.addConfirmationLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"shared.acceptedTakerCountries"), (String)countries).second).setTooltip(tooltip);
        }
        if (showAcceptedBanks) {
            if (offer.getPaymentMethod().equals((Object)PaymentMethod.SAME_BANK)) {
                FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
                FormBuilder.addConfirmationLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.bankName"), (String)acceptedBanks.get(0));
            } else if (offer.getPaymentMethod().equals((Object)PaymentMethod.SPECIFIC_BANKS)) {
                String value = Joiner.on((String)", ").join((Iterable)acceptedBanks);
                tooltip = new Tooltip(Res.get((String)"shared.acceptedBanks") + value);
                FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
                ((TextField)FormBuilder.addConfirmationLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"shared.acceptedBanks"), (String)value).second).setTooltip(tooltip);
            }
        }
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.makerDepositTransactionId"), contract.getMakerDepositTxHash());
        if (contract.getTakerDepositTxHash() != null) {
            FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.takerDepositTransactionId"), contract.getTakerDepositTxHash());
        }
        if (this.dispute.getDelayedPayoutTxId() != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.delayedPayoutTxId"), this.dispute.getDelayedPayoutTxId());
        }
        if (this.dispute.getDonationAddressOfDelayedPayoutTx() != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addLabelExplorerAddressTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.delayedPayoutTxReceiverAddress"), this.dispute.getDonationAddressOfDelayedPayoutTx());
        }
        if (this.dispute.getPayoutTxSerialized() != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            FormBuilder.addLabelTxIdTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.payoutTxId"), this.dispute.getPayoutTxId());
        }
        if (this.dispute.getContractHash() != null) {
            FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
            ((TextFieldWithCopyIcon)((Object)FormBuilder.addConfirmationLabelTextFieldWithCopyIcon((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"contractWindow.contractHash"), (String)Utils.HEX.encode((byte[])this.dispute.getContractHash())).second)).setMouseTransparent(false);
        }
        FormBuilder.addSeparator(this.gridPane, ++this.rowIndex);
        Button viewContractButton = (Button)FormBuilder.addConfirmationLabelButton((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"shared.contractAsJson"), (String)Res.get((String)"shared.viewContractAsJson"), (double)0.0).second;
        viewContractButton.setDefaultButton(false);
        viewContractButton.setOnAction(e -> {
            HavenoTextArea textArea = new HavenoTextArea();
            String contractAsJson = this.dispute.getContractAsJson();
            textArea.setText(contractAsJson);
            textArea.setPrefHeight(50.0);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setPrefSize(800.0, 600.0);
            Scene viewContractScene = new Scene((Parent)textArea);
            Stage viewContractStage = new Stage();
            viewContractStage.setTitle(Res.get((String)"shared.contract.title", (Object[])new Object[]{this.dispute.getShortTradeId()}));
            viewContractStage.setScene(viewContractScene);
            if (this.owner == null) {
                this.owner = MainView.getRootContainer();
            }
            Scene rootScene = this.owner.getScene();
            viewContractStage.initOwner(rootScene.getWindow());
            viewContractStage.initModality(Modality.NONE);
            viewContractStage.initStyle(StageStyle.UTILITY);
            viewContractStage.setOpacity(0.0);
            viewContractStage.show();
            Window window = rootScene.getWindow();
            double titleBarHeight = window.getHeight() - rootScene.getHeight();
            viewContractStage.setX((double)(Math.round(window.getX() + (this.owner.getWidth() - viewContractStage.getWidth()) / 2.0) + 200L));
            viewContractStage.setY((double)(Math.round(window.getY() + titleBarHeight + (this.owner.getHeight() - viewContractStage.getHeight()) / 2.0) + 50L));
            UserThread.execute(() -> viewContractStage.setOpacity(1.0));
            viewContractScene.setOnKeyPressed(ev -> {
                if (ev.getCode() == KeyCode.ESCAPE) {
                    ev.consume();
                    viewContractStage.hide();
                }
            });
        });
        Button closeButton = FormBuilder.addButtonAfterGroup(this.gridPane, ++this.rowIndex, Res.get((String)"shared.close"));
        GridPane.setColumnSpan((Node)closeButton, (Integer)2);
        closeButton.setOnAction(e -> {
            this.closeHandlerOptional.ifPresent(Runnable::run);
            this.hide();
        });
    }

    private DisputeManager<? extends DisputeList<Dispute>> getDisputeManager(Dispute dispute) {
        if (dispute.getSupportType() != null) {
            switch (dispute.getSupportType()) {
                case ARBITRATION: {
                    return this.arbitrationManager;
                }
                case MEDIATION: {
                    return this.mediationManager;
                }
                case TRADE: {
                    break;
                }
                case REFUND: {
                    return this.refundManager;
                }
            }
        }
        return null;
    }
}

