/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesViewModel;
import haveno.desktop.util.FormBuilder;
import java.math.BigInteger;
import java.util.Map;
import javafx.geometry.Insets;

public class ClosedTradesSummaryWindow
extends Overlay<ClosedTradesSummaryWindow> {
    private final ClosedTradesViewModel model;

    @Inject
    public ClosedTradesSummaryWindow(ClosedTradesViewModel model) {
        this.model = model;
        this.type = Overlay.Type.Information;
    }

    @Override
    public void show() {
        this.rowIndex = 0;
        this.width = 900.0;
        this.createGridPane();
        this.addContent();
        this.addButtons();
        this.display();
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.setPadding(new Insets(35.0, 40.0, 30.0, 40.0));
        this.gridPane.getStyleClass().add((Object)"grid-pane");
    }

    private void addContent() {
        Map<String, String> totalVolumeByCurrency = this.model.getTotalVolumeByCurrency();
        int rowSpan = totalVolumeByCurrency.size() + 4;
        FormBuilder.addTitledGroupBg(this.gridPane, this.rowIndex, rowSpan, Res.get((String)"closedTradesSummaryWindow.headline"));
        BigInteger totalTradeAmount = this.model.getTotalTradeAmount();
        FormBuilder.addConfirmationLabelLabel(this.gridPane, this.rowIndex, Res.get((String)"closedTradesSummaryWindow.totalAmount.title"), this.model.getTotalAmountWithVolume(totalTradeAmount), 40.0);
        totalVolumeByCurrency.entrySet().forEach(entry -> FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"closedTradesSummaryWindow.totalVolume.title", (Object[])new Object[]{entry.getKey()}), (String)entry.getValue()));
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"closedTradesSummaryWindow.totalMinerFee.title"), this.model.getTotalTxFee(totalTradeAmount));
        FormBuilder.addConfirmationLabelLabel(this.gridPane, ++this.rowIndex, Res.get((String)"closedTradesSummaryWindow.totalTradeFeeInXmr.title"), this.model.getTotalTradeFee(totalTradeAmount));
    }
}

