/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.popups;

import haveno.common.UserThread;
import haveno.desktop.main.overlays.popups.Popup;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupManager {
    private static final Logger log = LoggerFactory.getLogger(PopupManager.class);
    private static final Queue<Popup> popups = new LinkedBlockingQueue<Popup>(5);
    private static Popup displayedPopup;

    public static void queueForDisplay(Popup popup) {
        if (PopupManager.hasDuplicatePopup(popup)) {
            log.warn("The popup is already in the queue or displayed.\n\tNew popup not added=" + String.valueOf(popup));
            return;
        }
        boolean result = popups.offer(popup);
        if (!result) {
            log.warn("The capacity is full with popups in the queue.\n\tNew popup not added=" + String.valueOf(popup));
        }
        PopupManager.displayNext();
    }

    public static void onHidden(Popup popup) {
        if (displayedPopup == null || displayedPopup == popup) {
            displayedPopup = null;
            UserThread.runAfter(() -> PopupManager.displayNext(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            log.warn("We got a isHidden called with a wrong popup.\n\tpopup (argument)=" + String.valueOf(popup) + "\n\tdisplayedPopup=" + String.valueOf(displayedPopup));
        }
    }

    private static void displayNext() {
        if (displayedPopup == null && !popups.isEmpty()) {
            displayedPopup = popups.poll();
            displayedPopup.onReadyForDisplay();
        }
    }

    private static boolean hasDuplicatePopup(Popup popup) {
        if (displayedPopup != null && displayedPopup.toString().equals(popup.toString())) {
            return true;
        }
        for (Popup p : popups) {
            if (!p.toString().equals(popup.toString())) continue;
            return true;
        }
        return false;
    }
}

