/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.notifications;

import haveno.desktop.main.overlays.notifications.Notification;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(NotificationManager.class);
    private static final Queue<Notification> popups = new LinkedBlockingQueue<Notification>(5);
    private static Notification displayedPopup;

    public static void queueForDisplay(Notification popup) {
        boolean result = popups.offer(popup);
        if (!result) {
            log.warn("The capacity is full with popups in the queue.\n\tNot added new popup=" + String.valueOf(popup));
        }
        NotificationManager.displayNext();
    }

    public static void onHidden(Notification popup) {
        if (displayedPopup == null || displayedPopup == popup) {
            displayedPopup = null;
            NotificationManager.displayNext();
        } else {
            log.warn("We got a isHidden called with a wrong popup.\n\tpopup (argument)=" + String.valueOf(popup) + "\n\tdisplayedPopup=" + String.valueOf(displayedPopup));
        }
    }

    private static void displayNext() {
        if (displayedPopup == null && !popups.isEmpty()) {
            displayedPopup = popups.poll();
            displayedPopup.onReadyForDisplay();
        }
    }
}

