/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.notifications;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.core.api.NotificationListener;
import haveno.core.locale.Res;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.desktop.Navigation;
import haveno.desktop.main.MainView;
import haveno.desktop.main.overlays.notifications.Notification;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.portfolio.PortfolioView;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesView;
import haveno.desktop.main.support.SupportView;
import haveno.desktop.main.support.dispute.DisputeView;
import haveno.desktop.main.support.dispute.agent.arbitration.ArbitratorView;
import haveno.desktop.main.support.dispute.client.arbitration.ArbitrationClientView;
import haveno.desktop.main.support.dispute.client.mediation.MediationClientView;
import haveno.desktop.main.support.dispute.client.refund.RefundClientView;
import haveno.proto.grpc.NotificationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NotificationCenter {
    private static final Logger log = LoggerFactory.getLogger(NotificationCenter.class);
    private static final List<Notification> notifications = new ArrayList<Notification>();
    private Consumer<String> selectItemByTradeIdConsumer;
    static boolean useAnimations;
    private final TradeManager tradeManager;
    private final ArbitrationManager arbitrationManager;
    private final MediationManager mediationManager;
    private final RefundManager refundManager;
    private final Navigation navigation;
    private final Map<String, Subscription> disputeStateSubscriptionsMap = new HashMap<String, Subscription>();
    private final Map<String, Subscription> tradePhaseSubscriptionsMap = new HashMap<String, Subscription>();
    @Nullable
    private String selectedTradeId;

    static void add(Notification notification) {
        notifications.add(notification);
    }

    @Inject
    public NotificationCenter(TradeManager tradeManager, ArbitrationManager arbitrationManager, MediationManager mediationManager, RefundManager refundManager, Preferences preferences, Navigation navigation) {
        this.tradeManager = tradeManager;
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.refundManager = refundManager;
        this.navigation = navigation;
        EasyBind.subscribe((ObservableValue)preferences.getUseAnimationsProperty(), useAnimations -> {
            NotificationCenter.useAnimations = useAnimations;
        });
    }

    public void onAllServicesAndViewsInitialized() {
        this.tradeManager.getObservableList().addListener(change -> {
            change.next();
            if (change.wasRemoved()) {
                change.getRemoved().forEach(trade -> {
                    String tradeId = trade.getId();
                    if (this.disputeStateSubscriptionsMap.containsKey(tradeId)) {
                        this.disputeStateSubscriptionsMap.get(tradeId).unsubscribe();
                        this.disputeStateSubscriptionsMap.remove(tradeId);
                    }
                    if (this.tradePhaseSubscriptionsMap.containsKey(tradeId)) {
                        this.tradePhaseSubscriptionsMap.get(tradeId).unsubscribe();
                        this.tradePhaseSubscriptionsMap.remove(tradeId);
                    }
                });
            }
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(trade -> {
                    String tradeId = trade.getId();
                    if (this.disputeStateSubscriptionsMap.containsKey(tradeId)) {
                        log.debug("We have already an entry in disputeStateSubscriptionsMap.");
                    } else {
                        Subscription disputeStateSubscription = EasyBind.subscribe((ObservableValue)trade.disputeStateProperty(), disputeState -> ThreadUtils.submitToPool(() -> this.onDisputeStateChanged((Trade)trade, (Trade.DisputeState)disputeState)));
                        this.disputeStateSubscriptionsMap.put(tradeId, disputeStateSubscription);
                    }
                    if (this.tradePhaseSubscriptionsMap.containsKey(tradeId)) {
                        log.debug("We have already an entry in tradePhaseSubscriptionsMap.");
                    } else {
                        Subscription tradePhaseSubscription = EasyBind.subscribe((ObservableValue)trade.statePhaseProperty(), phase -> this.onTradePhaseChanged((Trade)trade, (Trade.Phase)phase));
                        this.tradePhaseSubscriptionsMap.put(tradeId, tradePhaseSubscription);
                    }
                });
            }
        });
        this.tradeManager.getObservableList().forEach(trade -> {
            String tradeId = trade.getId();
            Subscription disputeStateSubscription = EasyBind.subscribe((ObservableValue)trade.disputeStateProperty(), disputeState -> ThreadUtils.submitToPool(() -> this.onDisputeStateChanged((Trade)trade, (Trade.DisputeState)disputeState)));
            this.disputeStateSubscriptionsMap.put(tradeId, disputeStateSubscription);
            Subscription tradePhaseSubscription = EasyBind.subscribe((ObservableValue)trade.statePhaseProperty(), phase -> this.onTradePhaseChanged((Trade)trade, (Trade.Phase)phase));
            this.tradePhaseSubscriptionsMap.put(tradeId, tradePhaseSubscription);
        });
        this.tradeManager.getNotificationService().addListener(new NotificationListener(this){

            public void onMessage(@NonNull NotificationMessage message) {
                if (message == null) {
                    throw new NullPointerException("message is marked non-null but is null");
                }
                if (message.getType() == NotificationMessage.NotificationType.ERROR) {
                    ((Popup)new Popup().warning(message.getMessage())).show();
                }
            }
        });
    }

    @Nullable
    public String getSelectedTradeId() {
        return this.selectedTradeId;
    }

    public void setSelectedTradeId(@Nullable String selectedTradeId) {
        this.selectedTradeId = selectedTradeId;
    }

    public void setSelectItemByTradeIdConsumer(Consumer<String> selectItemByTradeIdConsumer) {
        this.selectItemByTradeIdConsumer = selectItemByTradeIdConsumer;
    }

    private void onTradePhaseChanged(Trade trade, Trade.Phase phase) {
        String key;
        String message = null;
        if (trade.isPayoutPublished() && !trade.isCompleted()) {
            message = Res.get((String)"notification.trade.completed");
        } else {
            if (trade instanceof MakerTrade && phase.ordinal() == Trade.Phase.DEPOSITS_PUBLISHED.ordinal()) {
                String role = trade instanceof BuyerTrade ? Res.get((String)"shared.seller") : Res.get((String)"shared.buyer");
                message = Res.get((String)"notification.trade.accepted", (Object[])new Object[]{role});
            }
            if (trade instanceof BuyerTrade) {
                if (phase.ordinal() == Trade.Phase.DEPOSITS_UNLOCKED.ordinal()) {
                    message = Res.get((String)"notification.trade.unlocked");
                } else if (phase.ordinal() == Trade.Phase.DEPOSITS_FINALIZED.ordinal()) {
                    message = Res.get((String)"notification.trade.finalized", (Object[])new Object[]{30});
                }
            } else if (trade instanceof SellerTrade && phase.ordinal() == Trade.Phase.PAYMENT_SENT.ordinal()) {
                message = Res.get((String)"notification.trade.paymentSent");
            }
        }
        if (message != null && DontShowAgainLookup.showAgain((String)(key = "NotificationCenter_" + phase.name() + trade.getId()))) {
            Notification notification = (Notification)new Notification().tradeHeadLine(trade.getShortId()).message(message);
            if (this.navigation.getCurrentPath() != null && !this.navigation.getCurrentPath().contains(PendingTradesView.class)) {
                ((Notification)((Notification)((Notification)notification.actionButtonTextWithGoTo("portfolio.tab.pendingTrades")).onAction(() -> {
                    DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
                    this.navigation.navigateTo(MainView.class, PortfolioView.class, PendingTradesView.class);
                    if (this.selectItemByTradeIdConsumer != null) {
                        UserThread.runAfter(() -> this.selectItemByTradeIdConsumer.accept(trade.getId()), (long)1L);
                    }
                })).onClose(() -> DontShowAgainLookup.dontShowAgain((String)key, (boolean)true))).show();
            } else if (this.selectedTradeId != null && !trade.getId().equals(this.selectedTradeId)) {
                ((Notification)((Notification)((Notification)notification.actionButtonText(Res.get((String)"notification.trade.selectTrade"))).onAction(() -> {
                    DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
                    if (this.selectItemByTradeIdConsumer != null) {
                        this.selectItemByTradeIdConsumer.accept(trade.getId());
                    }
                })).onClose(() -> DontShowAgainLookup.dontShowAgain((String)key, (boolean)true))).show();
            }
        }
    }

    private void onDisputeStateChanged(Trade trade, Trade.DisputeState disputeState) {
        String message = null;
        if (this.arbitrationManager.findDispute(trade.getId()).isPresent()) {
            Dispute dispute = (Dispute)this.arbitrationManager.findDispute(trade.getId()).get();
            String disputeOrTicket = dispute.isSupportTicket() ? Res.get((String)"shared.supportTicket") : Res.get((String)"shared.dispute");
            switch (disputeState) {
                case NO_DISPUTE: {
                    break;
                }
                case DISPUTE_OPENED: {
                    if (!trade.isArbitrator() && dispute.isOpener()) break;
                    message = Res.get((String)"notification.trade.peerOpenedDispute", (Object[])new Object[]{disputeOrTicket});
                    break;
                }
                case DISPUTE_CLOSED: {
                    if (trade.isArbitrator()) break;
                    message = Res.get((String)"notification.trade.disputeClosed", (Object[])new Object[]{disputeOrTicket});
                    break;
                }
            }
            if (message != null) {
                this.goToSupport(trade, message, trade.isArbitrator() ? ArbitratorView.class : ArbitrationClientView.class);
            }
        } else if (this.refundManager.findDispute(trade.getId()).isPresent()) {
            String disputeOrTicket = ((Dispute)this.refundManager.findDispute(trade.getId()).get()).isSupportTicket() ? Res.get((String)"shared.supportTicket") : Res.get((String)"shared.dispute");
            switch (disputeState) {
                case NO_DISPUTE: {
                    break;
                }
                case REFUND_REQUESTED: {
                    break;
                }
                case REFUND_REQUEST_STARTED_BY_PEER: {
                    message = Res.get((String)"notification.trade.peerOpenedDispute", (Object[])new Object[]{disputeOrTicket});
                    break;
                }
                case REFUND_REQUEST_CLOSED: {
                    message = Res.get((String)"notification.trade.disputeClosed", (Object[])new Object[]{disputeOrTicket});
                    break;
                }
            }
            if (message != null) {
                this.goToSupport(trade, message, RefundClientView.class);
            }
        } else if (this.mediationManager.findDispute(trade.getId()).isPresent()) {
            String disputeOrTicket = ((Dispute)this.mediationManager.findDispute(trade.getId()).get()).isSupportTicket() ? Res.get((String)"shared.supportTicket") : Res.get((String)"shared.mediationCase");
            switch (disputeState) {
                case MEDIATION_REQUESTED: {
                    break;
                }
                case MEDIATION_STARTED_BY_PEER: {
                    message = Res.get((String)"notification.trade.peerOpenedDispute", (Object[])new Object[]{disputeOrTicket});
                    break;
                }
                case MEDIATION_CLOSED: {
                    message = Res.get((String)"notification.trade.disputeClosed", (Object[])new Object[]{disputeOrTicket});
                    break;
                }
            }
            if (message != null) {
                this.goToSupport(trade, message, MediationClientView.class);
            }
        }
    }

    private void goToSupport(Trade trade, String message, Class<? extends DisputeView> viewClass) {
        Notification notification = (Notification)new Notification().disputeHeadLine(trade.getShortId()).message(message);
        if (this.navigation.getCurrentPath() != null && !this.navigation.getCurrentPath().contains(viewClass)) {
            ((Notification)((Notification)notification.actionButtonTextWithGoTo("mainView.menu.support")).onAction(() -> this.navigation.navigateTo(MainView.class, SupportView.class, viewClass))).show();
        } else {
            notification.show();
        }
    }
}

