/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.notifications;

import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.core.locale.Res;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.notifications.NotificationCenter;
import haveno.desktop.main.overlays.notifications.NotificationManager;
import haveno.desktop.util.FormBuilder;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Camera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Rotate;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.Duration;

public class Notification
extends Overlay<Notification> {
    private boolean hasBeenDisplayed;
    private boolean autoClose;
    private Timer autoCloseTimer;
    private static final int BORDER_PADDING = 10;

    public Notification() {
        this.width = 413.0;
        NotificationCenter.add(this);
        this.type = Overlay.Type.Notification;
    }

    void onReadyForDisplay() {
        super.display();
        if (this.autoClose && this.autoCloseTimer == null) {
            this.autoCloseTimer = UserThread.runAfter(() -> this.doClose(), (long)6L);
        }
        UserThread.execute(() -> this.stage.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.doClose()));
    }

    @Override
    public void hide() {
        this.animateHide();
    }

    @Override
    protected void onShow() {
        NotificationManager.queueForDisplay(this);
    }

    @Override
    protected void onHidden() {
        NotificationManager.onHidden(this);
    }

    public Notification tradeHeadLine(String tradeId) {
        return (Notification)this.headLine(Res.get((String)"notification.trade.headline", (Object[])new Object[]{tradeId}));
    }

    public Notification disputeHeadLine(String tradeId) {
        return (Notification)this.headLine(Res.get((String)"notification.ticket.headline", (Object[])new Object[]{tradeId}));
    }

    @Override
    public void show() {
        if (DevEnv.isDevMode()) {
            return;
        }
        super.show();
        this.hasBeenDisplayed = true;
    }

    public Notification autoClose() {
        this.autoClose = true;
        return this;
    }

    @Override
    protected void animateHide(Runnable onFinishedHandler) {
        if (this.autoCloseTimer != null) {
            this.autoCloseTimer.stop();
            this.autoCloseTimer = null;
        }
        if (NotificationCenter.useAnimations) {
            double duration = this.getDuration(400.0);
            Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            this.gridPane.setRotationAxis(Rotate.X_AXIS);
            Camera camera = this.gridPane.getScene().getCamera();
            this.gridPane.getScene().setCamera((Camera)new PerspectiveCamera());
            Timeline timeline = new Timeline();
            ObservableList keyFrames = timeline.getKeyFrames();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.rotateProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)1, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.rotateProperty(), (Object)-90, interpolator), new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)0, interpolator)}));
            timeline.setOnFinished(event -> {
                this.gridPane.setRotate(0.0);
                this.gridPane.setRotationAxis(Rotate.Z_AXIS);
                this.gridPane.getScene().setCamera(camera);
                onFinishedHandler.run();
            });
            timeline.play();
        } else {
            onFinishedHandler.run();
        }
    }

    @Override
    protected void animateDisplay() {
        if (NotificationCenter.useAnimations) {
            double startX = 320.0;
            double duration = this.getDuration(600.0);
            Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            Timeline timeline = new Timeline();
            ObservableList keyFrames = timeline.getKeyFrames();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.gridPane.translateXProperty(), (Object)startX, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)this.gridPane.translateXProperty(), (Object)0, interpolator)}));
            timeline.play();
        }
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.setPadding(new Insets(62.0, 62.0, 62.0, 62.0));
    }

    @Override
    protected void addButtons() {
        this.buttonDistance = 10.0;
        super.addButtons();
    }

    @Override
    protected void applyStyles() {
        this.gridPane.getStyleClass().add((Object)"notification-popup-bg");
        if (this.headLineLabel != null) {
            this.headLineLabel.getStyleClass().add((Object)"notification-popup-headline");
        }
        this.headlineIcon.getStyleClass().add((Object)"popup-icon-information");
        this.headlineIcon.setManaged(true);
        this.headlineIcon.setVisible(true);
        this.headlineIcon.setPadding(new Insets(1.0));
        FormBuilder.getIconForLabel(AwesomeIcon.INFO_SIGN, this.headlineIcon, "1em");
        if (this.actionButton != null) {
            this.actionButton.getStyleClass().add((Object)"compact-button");
        }
    }

    @Override
    protected void setModality() {
        this.stage.initOwner(this.owner.getScene().getWindow());
        this.stage.initModality(Modality.NONE);
    }

    @Override
    protected void layout() {
        Window window = this.owner.getScene().getWindow();
        double titleBarHeight = window.getHeight() - this.owner.getScene().getHeight();
        double shadowInset = 44.0;
        this.stage.setX((double)Math.round(window.getX() + window.getWidth() + shadowInset - this.stage.getWidth() - 10.0));
        this.stage.setY((double)Math.round(window.getY() + titleBarHeight - shadowInset + 10.0));
    }

    @Override
    protected void addEffectToBackground() {
    }

    @Override
    protected void removeEffectFromBackground() {
    }

    public boolean isHasBeenDisplayed() {
        return this.hasBeenDisplayed;
    }
}

