/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.editor;

import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.windows.SendPrivateNotificationWindow;
import haveno.desktop.util.FormBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.transform.Rotate;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerInfoWithTagEditor
extends Overlay<PeerInfoWithTagEditor> {
    private static final Logger log = LoggerFactory.getLogger(PeerInfoWithTagEditor.class);
    private final boolean useDevPrivilegeKeys;
    private InputTextField inputTextField;
    private Point2D position;
    private static PeerInfoWithTagEditor INSTANCE;
    private Consumer<String> saveHandler;
    private String hostName;
    private int numTrades;
    private ChangeListener<Boolean> focusListener;
    private final PrivateNotificationManager privateNotificationManager;
    @Nullable
    private final Trade trade;
    private final Offer offer;
    private final Preferences preferences;
    private EventHandler<KeyEvent> keyEventEventHandler;
    @Nullable
    private String accountAge;
    private String accountAgeInfo;
    @Nullable
    private String accountSigningState;
    @Nullable
    private String signAge;
    @Nullable
    private String signAgeInfo;

    public PeerInfoWithTagEditor(PrivateNotificationManager privateNotificationManager, @Nullable Trade trade, Offer offer, Preferences preferences, boolean useDevPrivilegeKeys) {
        this.privateNotificationManager = privateNotificationManager;
        this.trade = trade;
        this.offer = offer;
        this.preferences = preferences;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        this.width = 468.0;
        this.type = Overlay.Type.Undefined;
        if (INSTANCE != null) {
            INSTANCE.hide();
        }
        INSTANCE = this;
    }

    public PeerInfoWithTagEditor onSave(Consumer<String> saveHandler) {
        this.saveHandler = saveHandler;
        return this;
    }

    public PeerInfoWithTagEditor position(Point2D position) {
        this.position = position;
        return this;
    }

    public PeerInfoWithTagEditor fullAddress(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public PeerInfoWithTagEditor accountAge(@Nullable String accountAge) {
        this.accountAge = accountAge;
        return this;
    }

    public PeerInfoWithTagEditor accountAgeInfo(String accountAgeInfo) {
        this.accountAgeInfo = accountAgeInfo;
        return this;
    }

    public PeerInfoWithTagEditor signAge(@Nullable String signAge) {
        this.signAge = signAge;
        return this;
    }

    public PeerInfoWithTagEditor signAgeInfo(String signAgeInfo) {
        this.signAgeInfo = signAgeInfo;
        return this;
    }

    public PeerInfoWithTagEditor accountSigningState(@Nullable String accountSigningState) {
        this.accountSigningState = accountSigningState;
        return this;
    }

    public PeerInfoWithTagEditor numTrades(int numTrades) {
        this.numTrades = numTrades;
        if (numTrades == 0) {
            this.width = 568.0;
        }
        return this;
    }

    @Override
    public void show() {
        this.headLine(Res.get((String)"peerInfo.title"));
        this.actionButtonText(Res.get((String)"shared.save"));
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.onShow();
    }

    @Override
    protected void onShow() {
        super.display();
        if (this.stage != null) {
            this.focusListener = (observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.hide();
                }
            };
            this.stage.focusedProperty().addListener(this.focusListener);
            Scene scene = this.stage.getScene();
            if (scene != null) {
                scene.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
            }
        }
    }

    @Override
    public void hide() {
        this.animateHide();
    }

    @Override
    protected void onHidden() {
        INSTANCE = null;
        if (this.stage != null) {
            Scene scene;
            if (this.focusListener != null) {
                this.stage.focusedProperty().removeListener(this.focusListener);
            }
            if ((scene = this.stage.getScene()) != null) {
                scene.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
            }
        }
    }

    private void addContent() {
        this.gridPane.setPadding(new Insets(64.0));
        Tuple3<Label, TextField, VBox> onionTuple = FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.rowIndex, Res.get((String)"shared.onionAddress"), this.hostName);
        GridPane.setColumnSpan((Node)((Node)onionTuple.third), (Integer)2);
        ((TextField)onionTuple.second).setMouseTransparent(false);
        GridPane.setColumnSpan((Node)((Node)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"peerInfo.nrOfTrades"), (String)(this.numTrades > 0 ? String.valueOf((int)this.numTrades) : Res.get((String)"peerInfo.notTradedYet"))).third), (Integer)2);
        if (this.accountAge != null) {
            GridPane.setColumnSpan((Node)((Node)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)this.accountAgeInfo, (String)this.accountAge).third), (Integer)2);
        }
        if (this.accountSigningState != null) {
            GridPane.setColumnSpan((Node)((Node)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)Res.get((String)"shared.accountSigningState"), (String)this.accountSigningState).third), (Integer)2);
        }
        if (this.signAge != null) {
            GridPane.setColumnSpan((Node)((Node)FormBuilder.addCompactTopLabelTextField((GridPane)this.gridPane, (int)(++this.rowIndex), (String)this.signAgeInfo, (String)this.signAge).third), (Integer)2);
        }
        this.inputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, Res.get((String)"peerInfo.setTag"));
        GridPane.setColumnSpan((Node)this.inputTextField, (Integer)2);
        Map peerTagMap = this.preferences.getPeerTagMap();
        String tag = peerTagMap.getOrDefault(this.hostName, "");
        this.inputTextField.setText(tag);
        this.keyEventEventHandler = event -> {
            if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.R, (KeyEvent)event)) {
                this.doClose();
                UserThread.runAfter(() -> {
                    PubKeyRing peersPubKeyRing = null;
                    if (this.trade != null) {
                        peersPubKeyRing = this.trade.getTradePeer().getPubKeyRing();
                    } else if (this.offer != null) {
                        peersPubKeyRing = this.offer.getPubKeyRing();
                    }
                    if (peersPubKeyRing != null) {
                        new SendPrivateNotificationWindow(this.privateNotificationManager, peersPubKeyRing, this.offer.getMakerNodeAddress(), this.useDevPrivilegeKeys).show();
                    }
                }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        };
    }

    @Override
    protected void addHeadLine() {
        super.addHeadLine();
        GridPane.setHalignment((Node)this.headLineLabel, (HPos)HPos.CENTER);
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        scene.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                e.consume();
                this.doClose();
            }
            if (e.getCode() == KeyCode.ENTER) {
                e.consume();
                this.save();
            }
        });
    }

    @Override
    protected void animateHide(Runnable onFinishedHandler) {
        if (GlobalSettings.getUseAnimations()) {
            double duration = this.getDuration(300.0);
            Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            this.gridPane.setRotationAxis(Rotate.X_AXIS);
            Camera camera = this.gridPane.getScene().getCamera();
            this.gridPane.getScene().setCamera((Camera)new PerspectiveCamera());
            Timeline timeline = new Timeline();
            ObservableList keyFrames = timeline.getKeyFrames();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.rotateProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)1, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.rotateProperty(), (Object)-90, interpolator), new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)0, interpolator)}));
            timeline.setOnFinished(event -> {
                this.gridPane.setRotate(0.0);
                this.gridPane.setRotationAxis(Rotate.Z_AXIS);
                this.gridPane.getScene().setCamera(camera);
                onFinishedHandler.run();
            });
            timeline.play();
        } else {
            onFinishedHandler.run();
        }
    }

    @Override
    protected void animateDisplay() {
        if (GlobalSettings.getUseAnimations()) {
            double startY = -160.0;
            double duration = this.getDuration(400.0);
            Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            Timeline timeline = new Timeline();
            ObservableList keyFrames = timeline.getKeyFrames();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.gridPane.translateYProperty(), (Object)startY, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)this.gridPane.translateYProperty(), (Object)0, interpolator)}));
            timeline.play();
        }
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.setPadding(new Insets(15.0, 15.0, 30.0, 30.0));
    }

    @Override
    protected void addButtons() {
        this.buttonDistance = 10.0;
        super.addButtons();
        this.actionButton.setOnAction(event -> this.save());
    }

    private void save() {
        this.hide();
        if (this.saveHandler != null && this.inputTextField != null) {
            this.saveHandler.accept(this.inputTextField.getText());
        }
    }

    @Override
    protected void applyStyles() {
        this.gridPane.getStyleClass().add((Object)"peer-info-popup-bg");
        if (this.headLineLabel != null) {
            this.headLineLabel.getStyleClass().add((Object)"peer-info-popup-headline");
        }
    }

    @Override
    protected void setModality() {
        this.stage.initOwner(this.owner.getScene().getWindow());
        this.stage.initModality(Modality.NONE);
    }

    @Override
    protected void layout() {
        Window window = this.owner.getScene().getWindow();
        this.stage.setX((double)Math.round(window.getX() + this.position.getX() - this.width));
        this.stage.setY((double)Math.round(window.getY() + this.position.getY()));
    }

    @Override
    protected void addEffectToBackground() {
    }

    @Override
    protected void removeEffectFromBackground() {
    }
}

