/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.editor;

import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.common.util.Utilities;
import haveno.core.locale.GlobalSettings;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.util.FormBuilder;
import java.util.function.Consumer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.transform.Rotate;
import javafx.stage.Modality;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPopup
extends Overlay<PasswordPopup> {
    private static final Logger log = LoggerFactory.getLogger(PasswordPopup.class);
    private InputTextField inputTextField;
    private static PasswordPopup INSTANCE;
    private Consumer<String> actionHandler;
    private ChangeListener<Boolean> focusListener;
    private EventHandler<KeyEvent> keyEventEventHandler;

    public PasswordPopup() {
        this.width = 600.0;
        this.type = Overlay.Type.Confirmation;
        if (INSTANCE != null) {
            INSTANCE.hide();
        }
        INSTANCE = this;
    }

    public PasswordPopup onAction(Consumer<String> confirmHandler) {
        this.actionHandler = confirmHandler;
        return this;
    }

    @Override
    public void show() {
        this.actionButtonText("Confirm");
        this.createGridPane();
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.onShow();
    }

    @Override
    protected void onShow() {
        super.display();
        if (this.stage != null) {
            this.focusListener = (observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.hide();
                }
            };
            this.stage.focusedProperty().addListener(this.focusListener);
            Scene scene = this.stage.getScene();
            if (scene != null) {
                scene.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
            }
        }
    }

    @Override
    public void hide() {
        this.animateHide();
    }

    @Override
    protected void onHidden() {
        INSTANCE = null;
        if (this.stage != null) {
            Scene scene;
            if (this.focusListener != null) {
                this.stage.focusedProperty().removeListener(this.focusListener);
            }
            if ((scene = this.stage.getScene()) != null) {
                scene.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
            }
        }
    }

    private void addContent() {
        this.gridPane.setPadding(new Insets(64.0));
        this.inputTextField = FormBuilder.addInputTextField(this.gridPane, ++this.rowIndex, null, -10.0);
        GridPane.setColumnSpan((Node)this.inputTextField, (Integer)2);
        this.inputTextField.requestFocus();
        this.keyEventEventHandler = event -> {
            if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.R, (KeyEvent)event)) {
                this.doClose();
            }
        };
    }

    @Override
    protected void addHeadLine() {
        super.addHeadLine();
        GridPane.setHalignment((Node)this.headLineLabel, (HPos)HPos.CENTER);
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        scene.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                e.consume();
                this.doClose();
            }
            if (e.getCode() == KeyCode.ENTER) {
                e.consume();
                this.apply();
            }
        });
    }

    @Override
    protected void animateHide(Runnable onFinishedHandler) {
        if (GlobalSettings.getUseAnimations()) {
            double duration = this.getDuration(300.0);
            Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            this.gridPane.setRotationAxis(Rotate.X_AXIS);
            Camera camera = this.gridPane.getScene().getCamera();
            this.gridPane.getScene().setCamera((Camera)new PerspectiveCamera());
            Timeline timeline = new Timeline();
            ObservableList keyFrames = timeline.getKeyFrames();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.rotateProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)1, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.rotateProperty(), (Object)-90, interpolator), new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)0, interpolator)}));
            timeline.setOnFinished(event -> {
                this.gridPane.setRotate(0.0);
                this.gridPane.setRotationAxis(Rotate.Z_AXIS);
                this.gridPane.getScene().setCamera(camera);
                onFinishedHandler.run();
            });
            timeline.play();
        } else {
            onFinishedHandler.run();
        }
    }

    @Override
    protected void animateDisplay() {
        if (GlobalSettings.getUseAnimations()) {
            double startY = -160.0;
            double duration = this.getDuration(400.0);
            Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            Timeline timeline = new Timeline();
            ObservableList keyFrames = timeline.getKeyFrames();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.gridPane.translateYProperty(), (Object)startY, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.gridPane.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)this.gridPane.translateYProperty(), (Object)0, interpolator)}));
            timeline.play();
        }
    }

    @Override
    protected void createGridPane() {
        super.createGridPane();
        this.gridPane.setPadding(new Insets(15.0, 15.0, 30.0, 30.0));
    }

    @Override
    protected void addButtons() {
        this.buttonDistance = 10.0;
        super.addButtons();
        this.actionButton.setOnAction(event -> this.apply());
    }

    private void apply() {
        this.hide();
        if (this.actionHandler != null && this.inputTextField != null) {
            this.actionHandler.accept(this.inputTextField.getText());
        }
    }

    @Override
    protected void applyStyles() {
        super.applyStyles();
        FormBuilder.getIconForLabel(AwesomeIcon.LOCK, this.headlineIcon, "1.5em");
    }

    @Override
    protected void setModality() {
        this.stage.initOwner(this.owner.getScene().getWindow());
        this.stage.initModality(Modality.NONE);
    }

    @Override
    protected void addEffectToBackground() {
    }

    @Override
    protected void removeEffectFromBackground() {
    }
}

