/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays;

import com.google.common.reflect.TypeToken;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIconView;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.util.Utilities;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.LanguageUtil;
import haveno.core.locale.Res;
import haveno.core.user.DontShowAgainLookup;
import haveno.desktop.app.HavenoApp;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipCheckBox;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.main.MainView;
import haveno.desktop.util.CssTheme;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Layout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Overlay<T extends Overlay<T>> {
    private static final Logger log = LoggerFactory.getLogger(Overlay.class);
    private static int numCenterOverlays = 0;
    private static int numBlurEffects = 0;
    protected static final double DEFAULT_WIDTH = 668.0;
    protected Stage stage;
    protected GridPane gridPane;
    protected Pane owner;
    protected int rowIndex = -1;
    protected double width = 668.0;
    protected double buttonDistance = 20.0;
    protected boolean showReportErrorButtons;
    private boolean showBusyAnimation;
    protected boolean hideCloseButton;
    protected boolean isDisplayed;
    protected boolean disableActionButton;
    protected BooleanProperty isHiddenProperty = new SimpleBooleanProperty();
    protected Integer displayOrderPriority = Integer.MAX_VALUE;
    protected boolean useAnimation = true;
    protected boolean showScrollPane = false;
    protected TextArea messageTextArea;
    protected Label headlineIcon;
    protected Label copyLabel;
    protected Label headLineLabel;
    protected String headLine;
    protected String message;
    protected String closeButtonText;
    protected String actionButtonText;
    protected String secondaryActionButtonText;
    protected String dontShowAgainId;
    protected String dontShowAgainText;
    protected String truncatedMessage;
    private ArrayList<String> messageHyperlinks;
    private String headlineStyle;
    protected Button actionButton;
    protected Button secondaryActionButton;
    private HBox buttonBox;
    protected AutoTooltipButton closeButton;
    protected ScrollPane scrollPane;
    private HPos buttonAlignment = HPos.RIGHT;
    protected Optional<Runnable> closeHandlerOptional = Optional.empty();
    protected Optional<Runnable> actionHandlerOptional = Optional.empty();
    protected Optional<Runnable> secondaryActionHandlerOptional = Optional.empty();
    protected ChangeListener<Number> positionListener;
    protected Timer centerTime;
    protected Type type = Type.Undefined;
    protected int maxChar = 2200;

    private T cast() {
        return (T)this;
    }

    public Overlay() {
        TypeToken typeToken = new TypeToken<T>(this.getClass()){};
        if (!typeToken.isSupertypeOf(this.getClass())) {
            throw new RuntimeException("Subclass of Overlay<T> should be castable to T");
        }
    }

    public void show(boolean showAgainChecked) {
        if (this.dontShowAgainId == null || DontShowAgainLookup.showAgain((String)this.dontShowAgainId)) {
            this.createGridPane();
            if (LanguageUtil.isDefaultLanguageRTL()) {
                this.getRootContainer().setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
            }
            this.addHeadLine();
            if (this.showBusyAnimation) {
                this.addBusyAnimation();
            }
            this.addMessage();
            if (this.showReportErrorButtons) {
                this.addReportErrorButtons();
            }
            this.addButtons();
            this.addDontShowAgainCheckBox(showAgainChecked);
            this.applyStyles();
            this.onShow();
        }
    }

    public void show() {
        this.show(false);
    }

    protected void onShow() {
    }

    public void hide() {
        if (this.gridPane != null) {
            this.animateHide();
        }
        this.isDisplayed = false;
        this.isHiddenProperty.set(true);
    }

    protected void animateHide() {
        this.animateHide(() -> {
            if (this.isCentered()) {
                --numCenterOverlays;
            }
            this.removeEffectFromBackground();
            if (this.stage != null) {
                this.stage.hide();
            } else {
                log.warn("Stage is null");
            }
            this.cleanup();
            this.onHidden();
        });
    }

    protected void onHidden() {
    }

    protected void cleanup() {
        Window window;
        Scene rootScene;
        if (this.centerTime != null) {
            this.centerTime.stop();
        }
        if (this.owner == null) {
            this.owner = MainView.getRootContainer();
        }
        if ((rootScene = this.owner.getScene()) != null && (window = rootScene.getWindow()) != null && this.positionListener != null) {
            window.xProperty().removeListener(this.positionListener);
            window.yProperty().removeListener(this.positionListener);
            window.widthProperty().removeListener(this.positionListener);
        }
    }

    public T onClose(Runnable closeHandler) {
        this.closeHandlerOptional = Optional.of(closeHandler);
        return this.cast();
    }

    public T onAction(Runnable actionHandler) {
        this.actionHandlerOptional = Optional.of(actionHandler);
        return this.cast();
    }

    public T onSecondaryAction(Runnable secondaryActionHandlerOptional) {
        this.secondaryActionHandlerOptional = Optional.of(secondaryActionHandlerOptional);
        return this.cast();
    }

    public T headLine(String headLine) {
        this.headLine = headLine;
        return this.cast();
    }

    public T notification(String message) {
        this.type = Type.Notification;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.notification");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T instruction(String message) {
        this.type = Type.Instruction;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.instruction");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T attention(String message) {
        this.type = Type.Attention;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.attention");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T backgroundInfo(String message) {
        this.type = Type.BackgroundInfo;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.backgroundInfo");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T feedback(String message) {
        this.type = Type.Feedback;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.feedback");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T confirmation(String message) {
        this.type = Type.Confirmation;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.confirmation");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T information(String message) {
        this.type = Type.Information;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.information");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T warning(String message) {
        this.type = Type.Warning;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.warning");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T error(String message) {
        this.type = Type.Error;
        this.showReportErrorButtons();
        this.width = 1100.0;
        if (this.headLine == null) {
            this.headLine = Res.get((String)"popup.headline.error");
        }
        this.preProcessMessage(message);
        return this.cast();
    }

    public T showReportErrorButtons() {
        this.showReportErrorButtons = true;
        return this.cast();
    }

    public T message(String message) {
        this.preProcessMessage(message);
        return this.cast();
    }

    public T closeButtonText(String closeButtonText) {
        this.closeButtonText = closeButtonText;
        return this.cast();
    }

    public T useReportBugButton() {
        this.closeButtonText = Res.get((String)"shared.reportBug");
        this.closeHandlerOptional = Optional.of(() -> GUIUtil.openWebPage("https://github.com/haveno-dex/haveno/issues"));
        return this.cast();
    }

    public T useIUnderstandButton() {
        this.closeButtonText = Res.get((String)"shared.iUnderstand");
        return this.cast();
    }

    public T actionButtonTextWithGoTo(String target) {
        this.actionButtonText = Res.get((String)"shared.goTo", (Object[])new Object[]{Res.get((String)target)});
        return this.cast();
    }

    public T secondaryActionButtonTextWithGoTo(String target) {
        this.secondaryActionButtonText = Res.get((String)"shared.goTo", (Object[])new Object[]{Res.get((String)target)});
        return this.cast();
    }

    public T closeButtonTextWithGoTo(String target) {
        this.closeButtonText = Res.get((String)"shared.goTo", (Object[])new Object[]{Res.get((String)target)});
        return this.cast();
    }

    public T actionButtonText(String actionButtonText) {
        this.actionButtonText = actionButtonText;
        return this.cast();
    }

    public T secondaryActionButtonText(String secondaryActionButtonText) {
        this.secondaryActionButtonText = secondaryActionButtonText;
        return this.cast();
    }

    public T useShutDownButton() {
        this.actionButtonText = Res.get((String)"shared.shutDown");
        this.actionHandlerOptional = Optional.ofNullable(HavenoApp.getShutDownHandler());
        return this.cast();
    }

    public T buttonAlignment(HPos pos) {
        this.buttonAlignment = pos;
        return this.cast();
    }

    public T width(double width) {
        this.width = width;
        return this.cast();
    }

    public T maxMessageLength(int maxChar) {
        this.maxChar = maxChar;
        return this.cast();
    }

    public T showBusyAnimation() {
        this.showBusyAnimation = true;
        return this.cast();
    }

    public T dontShowAgainId(String key) {
        this.dontShowAgainId = key;
        return this.cast();
    }

    public T dontShowAgainText(String dontShowAgainText) {
        this.dontShowAgainText = dontShowAgainText;
        return this.cast();
    }

    public T hideCloseButton() {
        this.hideCloseButton = true;
        return this.cast();
    }

    public T useAnimation(boolean useAnimation) {
        this.useAnimation = useAnimation;
        return this.cast();
    }

    public T setHeadlineStyle(String headlineStyle) {
        this.headlineStyle = headlineStyle;
        return this.cast();
    }

    public T disableActionButton() {
        this.disableActionButton = true;
        return this.cast();
    }

    public T showScrollPane() {
        this.showScrollPane = true;
        return this.cast();
    }

    protected void createGridPane() {
        this.gridPane = new GridPane();
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(64.0, 64.0, 64.0, 64.0));
        this.gridPane.setPrefWidth(this.width);
        this.gridPane.setMaxHeight(850.0);
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHalignment(HPos.RIGHT);
        columnConstraints1.setHgrow(Priority.SOMETIMES);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1, columnConstraints2});
    }

    protected void blurAgain() {
        UserThread.runAfter(MainView::blurLight, (long)400L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void display() {
        Scene rootScene;
        if (this.owner == null) {
            this.owner = MainView.getRootContainer();
        }
        if (this.owner != null && (rootScene = this.owner.getScene()) != null) {
            UserThread.execute(() -> {
                Scene scene = new Scene((Parent)this.getRootContainer());
                scene.getStylesheets().setAll((Collection)rootScene.getStylesheets());
                scene.setFill((Paint)Color.TRANSPARENT);
                this.setupKeyHandler(scene);
                this.stage = new Stage();
                this.stage.setScene(scene);
                Window window = rootScene.getWindow();
                this.setModality();
                this.stage.initStyle(StageStyle.TRANSPARENT);
                this.stage.setOnCloseRequest(event -> {
                    event.consume();
                    this.doClose();
                });
                this.stage.sizeToScene();
                this.stage.show();
                this.layout();
                if (this.isCentered()) {
                    ++numCenterOverlays;
                }
                if (!CssTheme.isDarkTheme() || numCenterOverlays > 1) {
                    this.getRootContainer().getStyleClass().add((Object)"popup-dropshadow");
                }
                this.addEffectToBackground();
                this.positionListener = (observable, oldValue, newValue) -> {
                    if (this.stage != null) {
                        this.layout();
                        if (this.centerTime != null) {
                            this.centerTime.stop();
                        }
                        this.centerTime = UserThread.runAfter(this::layout, (long)3L);
                    }
                };
                window.xProperty().addListener(this.positionListener);
                window.yProperty().addListener(this.positionListener);
                window.widthProperty().addListener(this.positionListener);
                this.animateDisplay();
                this.isDisplayed = true;
            });
        }
    }

    protected Region getRootContainer() {
        return this.gridPane;
    }

    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE || e.getCode() == KeyCode.ENTER) {
                    e.consume();
                    this.doClose();
                }
            });
        }
    }

    protected void animateDisplay() {
        Region rootContainer = this.getRootContainer();
        rootContainer.setOpacity(0.0);
        Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
        double duration = this.getDuration(400.0);
        Timeline timeline = new Timeline();
        ObservableList keyFrames = timeline.getKeyFrames();
        if (this.type.animationType == AnimationType.SlideDownFromCenterTop) {
            double startY = -rootContainer.getHeight();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.translateYProperty(), (Object)startY, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.translateYProperty(), (Object)-50, interpolator)}));
        } else if (this.type.animationType == AnimationType.ScaleFromCenter) {
            double startScale = 0.25;
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)startScale, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)startScale, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)1, interpolator)}));
        } else if (this.type.animationType == AnimationType.ScaleYFromCenter) {
            double startYScale = 0.25;
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)startYScale, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)1, interpolator)}));
        } else if (this.type.animationType == AnimationType.ScaleDownToCenter) {
            double startScale = 1.1;
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)startScale, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)startScale, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)1, interpolator)}));
        } else if (this.type.animationType == AnimationType.FadeInAtCenter) {
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator)}));
        }
        timeline.play();
    }

    protected void animateHide(Runnable onFinishedHandler) {
        Interpolator interpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
        double duration = this.getDuration(200.0);
        Timeline timeline = new Timeline();
        ObservableList keyFrames = timeline.getKeyFrames();
        Region rootContainer = this.getRootContainer();
        if (this.type.animationType == AnimationType.SlideDownFromCenterTop) {
            double endY = -rootContainer.getHeight();
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.translateYProperty(), (Object)-10, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.translateYProperty(), (Object)endY, interpolator)}));
            timeline.setOnFinished(e -> onFinishedHandler.run());
            timeline.play();
        } else if (this.type.animationType == AnimationType.ScaleFromCenter) {
            double endScale = 0.25;
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)1, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)endScale, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)endScale, interpolator)}));
        } else if (this.type.animationType == AnimationType.ScaleYFromCenter) {
            rootContainer.setRotationAxis(Rotate.X_AXIS);
            rootContainer.getScene().setCamera((Camera)new PerspectiveCamera());
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.rotateProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.rotateProperty(), (Object)-90, interpolator), new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator)}));
        } else if (this.type.animationType == AnimationType.ScaleDownToCenter) {
            double endScale = 0.1;
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)1, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)1, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)rootContainer.scaleXProperty(), (Object)endScale, interpolator), new KeyValue((WritableValue)rootContainer.scaleYProperty(), (Object)endScale, interpolator)}));
        } else if (this.type.animationType == AnimationType.FadeInAtCenter) {
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)1, interpolator)}));
            keyFrames.add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[]{new KeyValue((WritableValue)rootContainer.opacityProperty(), (Object)0, interpolator)}));
        }
        timeline.setOnFinished(e -> onFinishedHandler.run());
        timeline.play();
    }

    protected void layout() {
        Scene rootScene;
        if (this.owner == null) {
            this.owner = MainView.getRootContainer();
        }
        if ((rootScene = this.owner.getScene()) != null) {
            Window window = rootScene.getWindow();
            double titleBarHeight = window.getHeight() - rootScene.getHeight();
            if (Utilities.isWindows()) {
                titleBarHeight -= 9.0;
            }
            this.stage.setX((double)Math.round(window.getX() + (this.owner.getWidth() - this.stage.getWidth()) / 2.0));
            if (this.type.animationType == AnimationType.SlideDownFromCenterTop) {
                this.stage.setY((double)Math.round(window.getY() + titleBarHeight));
            } else {
                this.stage.setY((double)Math.round(window.getY() + titleBarHeight + (this.owner.getHeight() - this.stage.getHeight()) / 2.0));
            }
        }
    }

    protected void addEffectToBackground() {
        if (++numBlurEffects > 1) {
            return;
        }
        if (this.type.changeBackgroundType == ChangeBackgroundType.BlurUltraLight) {
            MainView.blurUltraLight();
        } else if (this.type.changeBackgroundType == ChangeBackgroundType.BlurLight) {
            MainView.blurLight();
        } else {
            MainView.darken();
        }
    }

    protected void applyStyles() {
        Region rootContainer = this.getRootContainer();
        if (this.type.animationType == AnimationType.SlideDownFromCenterTop) {
            rootContainer.getStyleClass().add((Object)"popup-bg-top");
        } else {
            rootContainer.getStyleClass().add((Object)"popup-bg");
        }
        if (this.headLineLabel != null) {
            if (this.copyLabel != null) {
                this.copyLabel.getStyleClass().add((Object)"popup-icon-information");
                this.copyLabel.setManaged(true);
                this.copyLabel.setVisible(true);
                MaterialDesignIconView copyIcon = new MaterialDesignIconView(MaterialDesignIcon.CONTENT_COPY, "1.2em");
                this.copyLabel.setGraphic((Node)copyIcon);
                this.copyLabel.setCursor(Cursor.HAND);
                this.copyLabel.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                    if (this.message != null) {
                        Utilities.copyToClipboard((String)this.getClipboardText());
                        Tooltip tp = new Tooltip(Res.get((String)"shared.copiedToClipboard"));
                        Node node = (Node)mouseEvent.getSource();
                        UserThread.runAfter(() -> tp.hide(), (long)1L);
                        tp.show(node, mouseEvent.getScreenX() + Layout.PADDING, mouseEvent.getScreenY() + Layout.PADDING);
                    }
                });
            }
            switch (this.type.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.headLineLabel.getStyleClass().add((Object)"popup-headline-information");
                    this.headlineIcon.getStyleClass().add((Object)"popup-icon-information");
                    this.headlineIcon.setManaged(true);
                    this.headlineIcon.setVisible(true);
                    FormBuilder.getIconForLabel(AwesomeIcon.INFO_SIGN, this.headlineIcon, "1.5em");
                    break;
                }
                case 8: 
                case 9: {
                    this.headLineLabel.getStyleClass().add((Object)"popup-headline-warning");
                    this.headlineIcon.getStyleClass().add((Object)"popup-icon-warning");
                    this.headlineIcon.setManaged(true);
                    this.headlineIcon.setVisible(true);
                    FormBuilder.getIconForLabel(AwesomeIcon.EXCLAMATION_SIGN, this.headlineIcon, "1.5em");
                    break;
                }
                default: {
                    this.headLineLabel.getStyleClass().add((Object)"popup-headline");
                }
            }
        }
    }

    protected void setModality() {
        this.stage.initOwner(this.owner.getScene().getWindow());
        this.stage.initModality(Modality.WINDOW_MODAL);
    }

    protected void removeEffectFromBackground() {
        if (--numBlurEffects > 0) {
            return;
        }
        MainView.removeEffect();
    }

    protected void addHeadLine() {
        if (this.headLine != null) {
            ++this.rowIndex;
            HBox hBox = new HBox();
            hBox.setSpacing(7.0);
            this.headLineLabel = new AutoTooltipLabel(this.headLine);
            this.headlineIcon = new Label();
            this.headlineIcon.setManaged(false);
            this.headlineIcon.setVisible(false);
            this.headlineIcon.setPadding(new Insets(3.0));
            this.headLineLabel.setMouseTransparent(true);
            if (this.headlineStyle != null) {
                this.headLineLabel.setStyle(this.headlineStyle);
            }
            if (this.message != null) {
                this.copyLabel = new Label();
                this.copyLabel.setManaged(false);
                this.copyLabel.setVisible(false);
                this.copyLabel.setPadding(new Insets(3.0));
                this.copyLabel.setTooltip(new Tooltip(Res.get((String)"shared.copyToClipboard")));
                Pane spacer = new Pane();
                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                spacer.setMinSize(Layout.PADDING, 1.0);
                hBox.getChildren().addAll((Object[])new Node[]{this.headlineIcon, this.headLineLabel, spacer, this.copyLabel});
            } else {
                hBox.getChildren().addAll((Object[])new Node[]{this.headlineIcon, this.headLineLabel});
            }
            GridPane.setHalignment((Node)hBox, (HPos)HPos.LEFT);
            GridPane.setRowIndex((Node)hBox, (Integer)this.rowIndex);
            GridPane.setColumnSpan((Node)hBox, (Integer)2);
            this.gridPane.getChildren().addAll((Object[])new Node[]{hBox});
        }
    }

    protected void addMessage() {
        if (this.message != null) {
            TextArea messageRegion;
            this.messageTextArea = new TextArea(this.truncatedMessage);
            this.messageTextArea.setEditable(false);
            this.messageTextArea.getStyleClass().add((Object)"text-area-popup");
            GUIUtil.adjustHeightAutomatically(this.messageTextArea);
            this.messageTextArea.setWrapText(true);
            if (this.showScrollPane) {
                this.scrollPane = new ScrollPane((Node)this.messageTextArea);
                this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
                this.scrollPane.setFitToWidth(true);
                messageRegion = this.scrollPane;
            } else {
                messageRegion = this.messageTextArea;
            }
            GridPane.setHalignment((Node)messageRegion, (HPos)HPos.LEFT);
            GridPane.setHgrow((Node)messageRegion, (Priority)Priority.ALWAYS);
            GridPane.setMargin((Node)messageRegion, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
            GridPane.setRowIndex((Node)messageRegion, (Integer)(++this.rowIndex));
            GridPane.setColumnIndex((Node)messageRegion, (Integer)0);
            GridPane.setColumnSpan((Node)messageRegion, (Integer)2);
            this.gridPane.getChildren().add((Object)messageRegion);
            this.addFooter();
        }
    }

    private void addFooter() {
        if (this.messageHyperlinks != null && this.messageHyperlinks.size() > 0) {
            VBox footerBox = new VBox();
            GridPane.setRowIndex((Node)footerBox, (Integer)(++this.rowIndex));
            GridPane.setColumnSpan((Node)footerBox, (Integer)2);
            GridPane.setMargin((Node)footerBox, (Insets)new Insets(this.buttonDistance, 0.0, 0.0, 0.0));
            this.gridPane.getChildren().add((Object)footerBox);
            for (int i = 0; i < this.messageHyperlinks.size(); ++i) {
                Label label = new Label(String.format("[%d]", i + 1));
                Hyperlink link = new Hyperlink(this.messageHyperlinks.get(i));
                link.setOnAction(event -> GUIUtil.openWebPageNoPopup(link.getText()));
                footerBox.getChildren().addAll((Object[])new Node[]{new HBox(new Node[]{label, link})});
            }
        }
    }

    private void addReportErrorButtons() {
        this.messageTextArea.setText(Res.get((String)"popup.reportError", (Object[])new Object[]{this.truncatedMessage}));
        AutoTooltipButton logButton = new AutoTooltipButton(Res.get((String)"popup.reportError.log"));
        GridPane.setMargin((Node)logButton, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)logButton, (HPos)HPos.LEFT);
        GridPane.setRowIndex((Node)logButton, (Integer)(++this.rowIndex));
        this.gridPane.getChildren().add((Object)logButton);
        logButton.setOnAction(event -> {
            try {
                File dataDir = Config.appDataDir();
                File logFile = new File(dataDir, "haveno.log");
                Utilities.openFile((File)logFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        });
        AutoTooltipButton gitHubButton = new AutoTooltipButton(Res.get((String)"popup.reportError.gitHub"));
        GridPane.setHalignment((Node)gitHubButton, (HPos)HPos.RIGHT);
        GridPane.setRowIndex((Node)gitHubButton, (Integer)(++this.rowIndex));
        this.gridPane.getChildren().add((Object)gitHubButton);
        gitHubButton.setOnAction(event -> {
            if (this.message != null) {
                Utilities.copyToClipboard((String)this.message);
            }
            GUIUtil.openWebPage("https://github.com/haveno-dex/haveno/issues");
            this.hide();
        });
    }

    protected void addBusyAnimation() {
        BusyAnimation busyAnimation = new BusyAnimation();
        GridPane.setHalignment((Node)busyAnimation, (HPos)HPos.CENTER);
        GridPane.setRowIndex((Node)busyAnimation, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)busyAnimation, (Integer)2);
        this.gridPane.getChildren().add((Object)busyAnimation);
    }

    protected void addDontShowAgainCheckBox(boolean isChecked) {
        if (this.dontShowAgainId != null) {
            if (this.dontShowAgainText == null) {
                this.dontShowAgainText = Res.get((String)"popup.doNotShowAgain");
            }
            AutoTooltipCheckBox dontShowAgainCheckBox = new AutoTooltipCheckBox(this.dontShowAgainText);
            HBox.setHgrow((Node)dontShowAgainCheckBox, (Priority)Priority.NEVER);
            this.buttonBox.getChildren().add(0, (Object)dontShowAgainCheckBox);
            dontShowAgainCheckBox.setSelected(isChecked);
            DontShowAgainLookup.dontShowAgain((String)this.dontShowAgainId, (boolean)isChecked);
            dontShowAgainCheckBox.setOnAction(arg_0 -> this.lambda$addDontShowAgainCheckBox$13((CheckBox)dontShowAgainCheckBox, arg_0));
        }
    }

    protected void addDontShowAgainCheckBox() {
        this.addDontShowAgainCheckBox(false);
    }

    protected void addButtons() {
        if (!this.hideCloseButton) {
            this.closeButton = new AutoTooltipButton(this.closeButtonText == null ? Res.get((String)"shared.close") : this.closeButtonText);
            this.closeButton.getStyleClass().add((Object)"compact-button");
            this.closeButton.setOnAction(event -> this.doClose());
            this.closeButton.setMinWidth(70.0);
            HBox.setHgrow((Node)this.closeButton, (Priority)Priority.SOMETIMES);
        }
        Pane spacer = new Pane();
        if (this.buttonAlignment == HPos.RIGHT) {
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            spacer.setMaxWidth(Double.MAX_VALUE);
        }
        this.buttonBox = new HBox();
        GridPane.setHalignment((Node)this.buttonBox, (HPos)this.buttonAlignment);
        GridPane.setRowIndex((Node)this.buttonBox, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)this.buttonBox, (Integer)2);
        GridPane.setMargin((Node)this.buttonBox, (Insets)new Insets(this.buttonDistance, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.buttonBox);
        if (this.actionHandlerOptional.isPresent() || this.actionButtonText != null) {
            this.actionButton = new AutoTooltipButton(this.actionButtonText == null ? Res.get((String)"shared.ok") : this.actionButtonText);
            if (!this.disableActionButton) {
                this.actionButton.setDefaultButton(true);
            } else {
                this.actionButton.setDisable(true);
            }
            HBox.setHgrow((Node)this.actionButton, (Priority)Priority.SOMETIMES);
            this.actionButton.getStyleClass().add((Object)"action-button");
            if (!this.disableActionButton) {
                this.actionButton.setOnAction(event -> {
                    this.hide();
                    this.actionHandlerOptional.ifPresent(Runnable::run);
                });
            }
            this.buttonBox.setSpacing(10.0);
            this.buttonBox.setAlignment(Pos.CENTER);
            if (this.buttonAlignment == HPos.RIGHT) {
                this.buttonBox.getChildren().add((Object)spacer);
            }
            this.buttonBox.getChildren().addAll((Object[])new Node[]{this.actionButton});
            if (this.secondaryActionButtonText != null && this.secondaryActionHandlerOptional.isPresent()) {
                this.secondaryActionButton = new AutoTooltipButton(this.secondaryActionButtonText);
                this.secondaryActionButton.setOnAction(event -> {
                    this.hide();
                    this.secondaryActionHandlerOptional.ifPresent(Runnable::run);
                });
                this.buttonBox.getChildren().add((Object)this.secondaryActionButton);
            }
            if (!this.hideCloseButton) {
                this.buttonBox.getChildren().add((Object)this.closeButton);
            }
        } else if (!this.hideCloseButton) {
            this.closeButton.setDefaultButton(true);
            this.buttonBox.getChildren().addAll((Object[])new Node[]{spacer, this.closeButton});
        }
    }

    protected void doClose() {
        this.hide();
        this.closeHandlerOptional.ifPresent(Runnable::run);
    }

    protected void setTruncatedMessage() {
        this.truncatedMessage = this.message != null && this.message.length() > this.maxChar ? StringUtils.abbreviate((String)this.message, (int)this.maxChar) : Objects.requireNonNullElse(this.message, "");
    }

    private void preProcessMessage(String message) {
        Pattern pattern = Pattern.compile("\\[HYPERLINK:(.*?)\\]");
        Matcher matcher = pattern.matcher(message);
        String work = message;
        while (matcher.find()) {
            if (this.messageHyperlinks == null) {
                this.messageHyperlinks = new ArrayList();
            }
            this.messageHyperlinks.add(matcher.group(1));
            work = work.replaceFirst(pattern.toString(), String.format("[%d]", this.messageHyperlinks.size()));
        }
        this.message = work;
        this.setTruncatedMessage();
    }

    protected double getDuration(double duration) {
        return this.useAnimation && GlobalSettings.getUseAnimations() ? duration : 1.0;
    }

    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    public String getClipboardText() {
        return this.headLineLabel.getText() + System.lineSeparator() + this.message + System.lineSeparator() + (this.messageHyperlinks == null ? "" : this.messageHyperlinks.toString());
    }

    public String toString() {
        return "Popup{headLine='" + this.headLine + "', message='" + this.message + "'}";
    }

    private boolean isCentered() {
        if (this.type.animationType == AnimationType.SlideDownFromCenterTop) {
            return false;
        }
        return this.type.animationType != AnimationType.SlideFromRightTop;
    }

    public BooleanProperty getIsHiddenProperty() {
        return this.isHiddenProperty;
    }

    public void setDisplayOrderPriority(Integer displayOrderPriority) {
        this.displayOrderPriority = displayOrderPriority;
    }

    public Integer getDisplayOrderPriority() {
        return this.displayOrderPriority;
    }

    private /* synthetic */ void lambda$addDontShowAgainCheckBox$13(CheckBox dontShowAgainCheckBox, ActionEvent e) {
        DontShowAgainLookup.dontShowAgain((String)this.dontShowAgainId, (boolean)dontShowAgainCheckBox.isSelected());
    }

    protected static enum Type {
        Undefined(AnimationType.ScaleFromCenter, ChangeBackgroundType.BlurLight),
        Notification(AnimationType.SlideFromRightTop, ChangeBackgroundType.BlurLight),
        BackgroundInfo(AnimationType.SlideDownFromCenterTop, ChangeBackgroundType.BlurUltraLight),
        Feedback(AnimationType.SlideDownFromCenterTop, ChangeBackgroundType.BlurLight),
        Information(AnimationType.FadeInAtCenter, ChangeBackgroundType.BlurLight),
        Instruction(AnimationType.ScaleFromCenter, ChangeBackgroundType.BlurLight),
        Attention(AnimationType.ScaleFromCenter, ChangeBackgroundType.BlurLight),
        Confirmation(AnimationType.ScaleYFromCenter, ChangeBackgroundType.BlurLight),
        Warning(AnimationType.ScaleDownToCenter, ChangeBackgroundType.BlurLight),
        Error(AnimationType.ScaleDownToCenter, ChangeBackgroundType.BlurLight);

        public final AnimationType animationType;
        public final ChangeBackgroundType changeBackgroundType;

        private Type(AnimationType animationType, ChangeBackgroundType changeBackgroundType) {
            this.animationType = animationType;
            this.changeBackgroundType = changeBackgroundType;
        }
    }

    private static enum AnimationType {
        FadeInAtCenter,
        SlideDownFromCenterTop,
        SlideFromRightTop,
        ScaleDownToCenter,
        ScaleFromCenter,
        ScaleYFromCenter;

    }

    private static enum ChangeBackgroundType {
        BlurLight,
        BlurUltraLight,
        Darken;

    }
}

