/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.takeoffer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferRestrictions;
import haveno.core.offer.OfferUtil;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.validation.FiatVolumeValidator;
import haveno.core.payment.validation.XmrValidator;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.coin.CoinUtil;
import haveno.core.util.validation.AmountValidator4Decimals;
import haveno.core.util.validation.AmountValidator8Decimals;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.MonetaryValidator;
import haveno.desktop.Navigation;
import haveno.desktop.common.model.ActivatableWithDataModel;
import haveno.desktop.common.model.ViewModel;
import haveno.desktop.main.MainView;
import haveno.desktop.main.funds.FundsView;
import haveno.desktop.main.funds.deposit.DepositView;
import haveno.desktop.main.offer.OfferViewModelUtil;
import haveno.desktop.main.offer.takeoffer.TakeOfferDataModel;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import java.math.BigInteger;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;

class TakeOfferViewModel
extends ActivatableWithDataModel<TakeOfferDataModel>
implements ViewModel {
    final TakeOfferDataModel dataModel;
    private final OfferUtil offerUtil;
    private final XmrValidator xmrValidator;
    private final P2PService p2PService;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final Navigation navigation;
    private final CoinFormatter xmrFormatter;
    private final FiatVolumeValidator fiatVolumeValidator;
    private final AmountValidator4Decimals amountValidator4Decimals;
    private final AmountValidator8Decimals amountValidator8Decimals;
    private String amountRange;
    private String paymentLabel;
    private boolean takeOfferRequested;
    private boolean ignoreVolumeStringListener;
    private Trade trade;
    protected Offer offer;
    private String price;
    private String amountDescription;
    final StringProperty amount = new SimpleStringProperty();
    final StringProperty volume = new SimpleStringProperty();
    final StringProperty volumeDescriptionLabel = new SimpleStringProperty();
    final StringProperty totalToPay = new SimpleStringProperty();
    final StringProperty errorMessage = new SimpleStringProperty();
    final StringProperty offerWarning = new SimpleStringProperty();
    final StringProperty spinnerInfoText = new SimpleStringProperty("");
    final StringProperty tradeFee = new SimpleStringProperty();
    final StringProperty tradeFeeInXmrWithFiat = new SimpleStringProperty();
    final StringProperty tradeFeeDescription = new SimpleStringProperty();
    final BooleanProperty isTradeFeeVisible = new SimpleBooleanProperty(false);
    final BooleanProperty isOfferAvailable = new SimpleBooleanProperty();
    final BooleanProperty isTakeOfferButtonDisabled = new SimpleBooleanProperty(true);
    final BooleanProperty isNextButtonDisabled = new SimpleBooleanProperty(true);
    final BooleanProperty isWaitingForFunds = new SimpleBooleanProperty();
    final BooleanProperty showWarningInvalidXmrDecimalPlaces = new SimpleBooleanProperty();
    final BooleanProperty showTransactionPublishedScreen = new SimpleBooleanProperty();
    final BooleanProperty takeOfferCompleted = new SimpleBooleanProperty();
    final BooleanProperty showPayFundsScreenDisplayed = new SimpleBooleanProperty();
    final ObjectProperty<InputValidator.ValidationResult> amountValidationResult = new SimpleObjectProperty();
    final ObjectProperty<InputValidator.ValidationResult> volumeValidationResult = new SimpleObjectProperty();
    private ChangeListener<String> amountStrListener;
    private ChangeListener<BigInteger> amountListener;
    private ChangeListener<String> volumeStringListener;
    private ChangeListener<Volume> volumeListener;
    private ChangeListener<Boolean> isWalletFundedListener;
    private ChangeListener<Trade.State> tradeStateListener;
    private ChangeListener<Offer.State> offerStateListener;
    private ConnectionListener connectionListener;
    private Runnable takeOfferResultHandler;
    String marketPriceMargin;

    @Inject
    public TakeOfferViewModel(TakeOfferDataModel dataModel, FiatVolumeValidator fiatVolumeValidator, AmountValidator4Decimals amountValidator4Decimals, AmountValidator8Decimals amountValidator8Decimals, OfferUtil offerUtil, XmrValidator btcValidator, P2PService p2PService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, @Named(value="BTC") CoinFormatter btcFormatter) {
        super(dataModel);
        this.dataModel = dataModel;
        this.offerUtil = offerUtil;
        this.xmrValidator = btcValidator;
        this.p2PService = p2PService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.navigation = navigation;
        this.xmrFormatter = btcFormatter;
        this.fiatVolumeValidator = fiatVolumeValidator;
        this.amountValidator4Decimals = amountValidator4Decimals;
        this.amountValidator8Decimals = amountValidator8Decimals;
        this.createListeners();
    }

    @Override
    protected void activate() {
        this.addBindings();
        this.addListeners();
        String buyVolumeDescriptionKey = "createOffer.amountPriceBox.buy.volumeDescription";
        String sellVolumeDescriptionKey = "createOffer.amountPriceBox.sell.volumeDescription";
        if (this.dataModel.getDirection() == OfferDirection.SELL) {
            this.volumeDescriptionLabel.set((Object)Res.get((String)buyVolumeDescriptionKey, (Object[])new Object[]{this.dataModel.getCurrencyCode()}));
        } else {
            this.volumeDescriptionLabel.set((Object)Res.get((String)sellVolumeDescriptionKey, (Object[])new Object[]{this.dataModel.getCurrencyCode()}));
        }
        this.amount.set((Object)HavenoUtils.formatXmr((BigInteger)((BigInteger)this.dataModel.getAmount().get())));
        this.showTransactionPublishedScreen.set(false);
        this.isOfferAvailable.set(false);
        Preconditions.checkNotNull((Object)this.offer, (Object)"offer must not be null");
        this.offer.stateProperty().addListener(this.offerStateListener);
        this.applyOfferState((Offer.State)this.offer.stateProperty().get());
        this.updateButtonDisableState();
        this.updateSpinnerInfo();
        this.isTradeFeeVisible.setValue(Boolean.valueOf(false));
    }

    @Override
    protected void deactivate() {
        this.removeBindings();
        this.removeListeners();
    }

    void initWithData(Offer offer) {
        this.dataModel.initWithData(offer);
        this.offer = offer;
        String buyAmountDescriptionKey = offer.isTraditionalOffer() ? "takeOffer.amountPriceBox.buy.amountDescription" : "takeOffer.amountPriceBox.buy.amountDescriptionCrypto";
        String sellAmountDescriptionKey = offer.isTraditionalOffer() ? "takeOffer.amountPriceBox.sell.amountDescription" : "takeOffer.amountPriceBox.sell.amountDescriptionCrypto";
        this.amountDescription = offer.isBuyOffer() ? Res.get((String)buyAmountDescriptionKey) : Res.get((String)sellAmountDescriptionKey);
        this.amountRange = HavenoUtils.formatXmr((BigInteger)offer.getMinAmount()) + " - " + HavenoUtils.formatXmr((BigInteger)offer.getAmount());
        this.price = FormattingUtils.formatPrice((Price)this.dataModel.tradePrice);
        this.marketPriceMargin = FormattingUtils.formatToPercent((double)offer.getMarketPriceMarginPct());
        this.paymentLabel = Res.get((String)"takeOffer.fundsBox.paymentLabel", (Object[])new Object[]{offer.getShortId()});
        Preconditions.checkNotNull((Object)this.dataModel.getAddressEntry(), (Object)"dataModel.getAddressEntry() must not be null");
        this.errorMessage.set((Object)offer.getErrorMessage());
        this.xmrValidator.setMaxValue(offer.getAmount());
        this.xmrValidator.setMaxTradeLimit(this.dataModel.getMaxTradeLimit());
        this.xmrValidator.setMinValue(offer.getMinAmount());
        this.setVolumeToModel();
    }

    void onTakeOffer(Runnable resultHandler) {
        this.takeOfferResultHandler = resultHandler;
        this.takeOfferRequested = true;
        this.showTransactionPublishedScreen.set(false);
        this.dataModel.onTakeOffer(trade -> {
            this.trade = trade;
            this.takeOfferCompleted.set(true);
            trade.stateProperty().addListener(this.tradeStateListener);
            this.applyTradeState();
            this.applyTradeErrorMessage(trade.getErrorMessage());
            this.takeOfferCompleted.set(true);
        }, errMessage -> this.applyTradeErrorMessage(errMessage));
        this.updateButtonDisableState();
        this.updateSpinnerInfo();
    }

    public void onPaymentAccountSelected(PaymentAccount paymentAccount) {
        this.dataModel.onPaymentAccountSelected(paymentAccount);
        this.xmrValidator.setMaxTradeLimit(this.dataModel.getMaxTradeLimit());
        this.updateButtonDisableState();
    }

    public void onShowPayFundsScreen() {
        this.dataModel.onShowPayFundsScreen();
        this.showPayFundsScreenDisplayed.set(true);
        this.updateSpinnerInfo();
    }

    boolean fundFromSavingsWallet() {
        this.dataModel.fundFromSavingsWallet();
        if (this.dataModel.getIsXmrWalletFunded().get()) {
            this.updateButtonDisableState();
            return true;
        }
        ((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"shared.notEnoughFunds", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)((BigInteger)this.dataModel.getTotalToPay().get()), (boolean)true), HavenoUtils.formatXmr((BigInteger)this.dataModel.getTotalAvailableBalance(), (boolean)true)}))).actionButtonTextWithGoTo("funds.tab.deposit")).onAction(() -> this.navigation.navigateTo(MainView.class, FundsView.class, DepositView.class))).show();
        return false;
    }

    private void applyTakerFee() {
        this.tradeFeeDescription.set((Object)Res.get((String)"createOffer.tradeFee.descriptionXMROnly"));
        BigInteger takerFee = this.dataModel.getTakerFee();
        if (takerFee == null) {
            return;
        }
        this.isTradeFeeVisible.setValue(Boolean.valueOf(true));
        this.tradeFee.set((Object)HavenoUtils.formatXmr((BigInteger)takerFee));
        this.tradeFeeInXmrWithFiat.set((Object)OfferViewModelUtil.getTradeFeeWithFiatEquivalent(this.offerUtil, this.dataModel.getTakerFee(), this.xmrFormatter));
    }

    void onFocusOutAmountTextField(boolean oldValue, boolean newValue, String userInput) {
        if (oldValue && !newValue) {
            InputValidator.ValidationResult result = this.isXmrInputValid((String)this.amount.get());
            this.amountValidationResult.set((Object)result);
            if (result.isValid) {
                if (userInput != null) {
                    this.showWarningInvalidXmrDecimalPlaces.set(!DisplayUtils.hasBtcValidDecimals(userInput, this.xmrFormatter));
                }
                this.setAmountToModel();
                this.amount.set((Object)HavenoUtils.formatXmr((BigInteger)((BigInteger)this.dataModel.getAmount().get())));
                this.calculateVolume();
                Price tradePrice = this.dataModel.tradePrice;
                BigInteger minAmount = this.dataModel.getOffer().getMinAmount();
                BigInteger maxAmount = this.dataModel.getMaxTradeLimit();
                if (PaymentMethod.isRoundedForAtmCash((String)this.dataModel.getPaymentMethod().getId())) {
                    BigInteger adjustedAmountForAtm = CoinUtil.getRoundedAtmCashAmount((BigInteger)((BigInteger)this.dataModel.getAmount().get()), (Price)tradePrice, (BigInteger)minAmount, (BigInteger)maxAmount);
                    this.dataModel.maybeApplyAmount(adjustedAmountForAtm);
                } else if (this.dataModel.getOffer().isTraditionalOffer() && this.dataModel.getOffer().isRange()) {
                    BigInteger roundedAmount = CoinUtil.getRoundedAmount((BigInteger)((BigInteger)this.dataModel.getAmount().get()), (Price)tradePrice, (BigInteger)minAmount, (BigInteger)maxAmount, (String)this.dataModel.getOffer().getCounterCurrencyCode(), (String)this.dataModel.getOffer().getPaymentMethodId());
                    this.dataModel.maybeApplyAmount(roundedAmount);
                }
                this.amount.set((Object)HavenoUtils.formatXmr((BigInteger)((BigInteger)this.dataModel.getAmount().get())));
                if (!this.dataModel.isMinAmountLessOrEqualAmount()) {
                    this.amountValidationResult.set((Object)new InputValidator.ValidationResult(false, Res.get((String)"takeOffer.validation.amountSmallerThanMinAmount")));
                }
                if (this.dataModel.isAmountLargerThanOfferAmount()) {
                    this.amountValidationResult.set((Object)new InputValidator.ValidationResult(false, Res.get((String)"takeOffer.validation.amountLargerThanOfferAmount")));
                }
                if (this.dataModel.wouldCreateDustForMaker()) {
                    this.amountValidationResult.set((Object)new InputValidator.ValidationResult(false, Res.get((String)"takeOffer.validation.amountLargerThanOfferAmountMinusFee")));
                }
            } else if (this.xmrValidator.getMaxTradeLimit() != null && this.xmrValidator.getMaxTradeLimit().equals(OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT)) {
                if (this.dataModel.getDirection() == OfferDirection.BUY) {
                    ((Popup)((Popup)new Popup().information(Res.get((String)"popup.warning.tradeLimitDueAccountAgeRestriction.seller", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT, (boolean)true), Res.get((String)"offerbook.warning.newVersionAnnouncement")}))).width(900.0)).show();
                } else {
                    ((Popup)((Popup)new Popup().information(Res.get((String)"popup.warning.tradeLimitDueAccountAgeRestriction.buyer", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT, (boolean)true), Res.get((String)"offerbook.warning.newVersionAnnouncement")}))).width(900.0)).show();
                }
            }
        }
    }

    void onFocusOutVolumeTextField(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            InputValidator.ValidationResult result = this.isVolumeInputValid((String)this.volume.get());
            this.volumeValidationResult.set((Object)result);
            if (result.isValid) {
                this.setVolumeToModel();
                this.ignoreVolumeStringListener = true;
                Volume volume = (Volume)this.dataModel.getVolume().get();
                if (volume != null) {
                    volume = VolumeUtil.getAdjustedVolume((Volume)volume, (String)this.offer.getPaymentMethod().getId());
                    this.volume.set((Object)VolumeUtil.formatVolume((Volume)volume));
                }
                this.ignoreVolumeStringListener = false;
                this.dataModel.calculateAmount();
                if (this.amount.get() != null) {
                    this.amountValidationResult.set((Object)this.isXmrInputValid((String)this.amount.get()));
                }
            }
        }
    }

    private void applyOfferState(Offer.State state) {
        UserThread.execute(() -> {
            this.offerWarning.set(null);
            switch (state) {
                case UNKNOWN: {
                    break;
                }
                case OFFER_FEE_RESERVED: {
                    break;
                }
                case AVAILABLE: {
                    this.isOfferAvailable.set(true);
                    this.updateButtonDisableState();
                    break;
                }
                case NOT_AVAILABLE: {
                    if (this.takeOfferRequested) {
                        this.offerWarning.set((Object)Res.get((String)"takeOffer.failed.offerNotAvailable"));
                    } else {
                        this.offerWarning.set((Object)Res.get((String)"takeOffer.failed.offerTaken"));
                    }
                    this.takeOfferRequested = false;
                    break;
                }
                case INVALID: {
                    this.offerWarning.set((Object)Res.get((String)"takeOffer.failed.offerInvalid"));
                    this.takeOfferRequested = false;
                    break;
                }
                case REMOVED: {
                    this.takeOfferRequested = false;
                    break;
                }
                case MAKER_OFFLINE: {
                    if (this.takeOfferRequested) {
                        this.offerWarning.set((Object)Res.get((String)"takeOffer.failed.offererNotOnline"));
                    } else {
                        this.offerWarning.set((Object)Res.get((String)"takeOffer.failed.offererOffline"));
                    }
                    this.takeOfferRequested = false;
                    break;
                }
                default: {
                    this.log.error("Unhandled offer state: " + String.valueOf(state));
                }
            }
            this.updateSpinnerInfo();
            this.updateButtonDisableState();
        });
    }

    private void applyTradeErrorMessage(@Nullable String errorMessage) {
        if (errorMessage != null) {
            String appendMsg = "";
            if (this.trade != null) {
                if (this.trade.isPayoutPublished()) {
                    appendMsg = Res.get((String)"takeOffer.error.payoutPublished");
                } else {
                    switch (this.trade.getState().getPhase()) {
                        case INIT: {
                            appendMsg = Res.get((String)"takeOffer.error.noFundsLost");
                            break;
                        }
                        case DEPOSIT_REQUESTED: {
                            appendMsg = Res.get((String)"takeOffer.error.feePaid");
                            break;
                        }
                        case DEPOSITS_PUBLISHED: 
                        case PAYMENT_SENT: 
                        case PAYMENT_RECEIVED: {
                            appendMsg = Res.get((String)"takeOffer.error.depositPublished");
                            break;
                        }
                    }
                }
            }
            this.errorMessage.set((Object)(errorMessage + appendMsg));
            this.updateSpinnerInfo();
            if (this.takeOfferResultHandler != null) {
                this.takeOfferResultHandler.run();
            }
        } else {
            this.errorMessage.set(null);
        }
    }

    private void applyTradeState() {
        if (this.trade.isDepositRequested()) {
            if (this.takeOfferResultHandler != null) {
                this.takeOfferResultHandler.run();
            }
            this.showTransactionPublishedScreen.set(true);
            this.updateSpinnerInfo();
        }
    }

    private void updateButtonDisableState() {
        boolean inputDataValid = this.isXmrInputValid((String)((String)this.amount.get())).isValid && this.dataModel.isMinAmountLessOrEqualAmount() && !this.dataModel.isAmountLargerThanOfferAmount() && this.isOfferAvailable.get() && !this.dataModel.wouldCreateDustForMaker();
        this.isNextButtonDisabled.set(!inputDataValid);
        this.isTakeOfferButtonDisabled.set(this.takeOfferRequested || !inputDataValid || !this.dataModel.getIsXmrWalletFunded().get());
    }

    private void addBindings() {
        this.totalToPay.bind((ObservableValue)Bindings.createStringBinding(() -> HavenoUtils.formatXmr((BigInteger)((BigInteger)this.dataModel.getTotalToPay().get()), (boolean)true), (Observable[])new Observable[]{this.dataModel.getTotalToPay()}));
    }

    private void removeBindings() {
        this.volumeDescriptionLabel.unbind();
        this.totalToPay.unbind();
    }

    private void createListeners() {
        this.amountStrListener = (ov, oldValue, newValue) -> {
            if (this.isXmrInputValid((String)newValue).isValid) {
                this.setAmountToModel();
                this.calculateVolume();
                this.dataModel.calculateTotalToPay();
                this.applyTakerFee();
            }
            this.updateButtonDisableState();
        };
        this.amountListener = (ov, oldValue, newValue) -> {
            this.amount.set((Object)HavenoUtils.formatXmr((BigInteger)newValue));
            this.applyTakerFee();
        };
        this.volumeStringListener = (ov, oldValue, newValue) -> {
            if (!this.ignoreVolumeStringListener) {
                if (this.isVolumeInputValid((String)newValue).isValid) {
                    this.setVolumeToModel();
                    this.dataModel.calculateAmount();
                    this.dataModel.calculateTotalToPay();
                }
                this.updateButtonDisableState();
            }
        };
        this.volumeListener = (ov, oldValue, newValue) -> {
            this.ignoreVolumeStringListener = true;
            if (newValue != null) {
                this.volume.set((Object)VolumeUtil.formatVolume((Volume)newValue));
            } else {
                this.volume.set((Object)"");
            }
            this.ignoreVolumeStringListener = false;
        };
        this.isWalletFundedListener = (ov, oldValue, newValue) -> this.updateButtonDisableState();
        this.tradeStateListener = (ov, oldValue, newValue) -> this.applyTradeState();
        this.offerStateListener = (ov, oldValue, newValue) -> this.applyOfferState((Offer.State)newValue);
        this.connectionListener = new ConnectionListener(){

            public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
                if (TakeOfferViewModel.this.trade == null) {
                    return;
                }
                if (connection.getPeersNodeAddressOptional().isPresent() && ((NodeAddress)connection.getPeersNodeAddressOptional().get()).equals((Object)TakeOfferViewModel.this.offer.getMakerNodeAddress())) {
                    TakeOfferViewModel.this.offerWarning.set((Object)Res.get((String)"takeOffer.warning.connectionToPeerLost"));
                    TakeOfferViewModel.this.updateSpinnerInfo();
                }
            }

            public void onConnection(Connection connection) {
            }
        };
    }

    private void updateSpinnerInfo() {
        UserThread.execute(() -> {
            if (!this.showPayFundsScreenDisplayed.get() || this.offerWarning.get() != null || this.errorMessage.get() != null || this.showTransactionPublishedScreen.get()) {
                this.spinnerInfoText.set((Object)"");
            } else if (this.dataModel.getIsXmrWalletFunded().get()) {
                this.spinnerInfoText.set((Object)"");
            } else {
                this.spinnerInfoText.set((Object)Res.get((String)"shared.waitingForFunds"));
            }
            this.isWaitingForFunds.set(!((String)this.spinnerInfoText.get()).isEmpty());
        });
    }

    private void addListeners() {
        this.amount.addListener(this.amountStrListener);
        this.volume.addListener(this.volumeStringListener);
        this.dataModel.getAmount().addListener(this.amountListener);
        this.dataModel.getVolume().addListener(this.volumeListener);
        this.dataModel.getIsXmrWalletFunded().addListener(this.isWalletFundedListener);
        this.p2PService.getNetworkNode().addConnectionListener(this.connectionListener);
    }

    private void removeListeners() {
        this.amount.removeListener(this.amountStrListener);
        this.volume.removeListener(this.volumeStringListener);
        this.dataModel.getAmount().removeListener(this.amountListener);
        this.dataModel.getVolume().removeListener(this.volumeListener);
        this.dataModel.getIsXmrWalletFunded().removeListener(this.isWalletFundedListener);
        if (this.offer != null) {
            this.offer.stateProperty().removeListener(this.offerStateListener);
        }
        if (this.trade != null) {
            this.trade.stateProperty().removeListener(this.tradeStateListener);
        }
        this.p2PService.getNetworkNode().removeConnectionListener(this.connectionListener);
    }

    private void calculateVolume() {
        this.setAmountToModel();
        this.dataModel.calculateVolume();
    }

    private void setAmountToModel() {
        if (this.amount.get() != null && !((String)this.amount.get()).isEmpty()) {
            BigInteger amount = HavenoUtils.coinToAtomicUnits((Coin)DisplayUtils.parseToCoinWith4Decimals((String)this.amount.get(), this.xmrFormatter));
            BigInteger minAmount = this.dataModel.getOffer().getMinAmount();
            BigInteger maxAmount = this.dataModel.getMaxTradeLimit();
            Price price = this.dataModel.tradePrice;
            if (price != null) {
                if (this.dataModel.isRoundedForAtmCash()) {
                    amount = CoinUtil.getRoundedAtmCashAmount((BigInteger)amount, (Price)price, (BigInteger)minAmount, (BigInteger)maxAmount);
                } else if (this.dataModel.getOffer().isTraditionalOffer() && this.dataModel.getOffer().isRange()) {
                    amount = CoinUtil.getRoundedAmount((BigInteger)amount, (Price)price, (BigInteger)minAmount, (BigInteger)maxAmount, (String)this.dataModel.getOffer().getCounterCurrencyCode(), (String)this.dataModel.getOffer().getPaymentMethodId());
                }
            }
            this.dataModel.maybeApplyAmount(amount);
        }
    }

    private void setVolumeToModel() {
        if (this.volume.get() != null && !((String)this.volume.get()).isEmpty()) {
            try {
                this.dataModel.setVolume(Volume.parse((String)((String)this.volume.get()), (String)this.offer.getCounterCurrencyCode()));
            }
            catch (Throwable t) {
                this.log.debug(t.getMessage());
            }
        } else {
            this.dataModel.setVolume(null);
        }
    }

    private InputValidator.ValidationResult isVolumeInputValid(String input) {
        return this.getVolumeValidator().validate(input);
    }

    private MonetaryValidator getVolumeValidator() {
        String code = this.offer.getCounterCurrencyCode();
        if (CurrencyUtil.isFiatCurrency((String)code)) {
            return this.fiatVolumeValidator;
        }
        if (CurrencyUtil.isVolumeRoundedToNearestUnit((String)code)) {
            return this.amountValidator4Decimals;
        }
        return this.amountValidator8Decimals;
    }

    CoinFormatter getXmrFormatter() {
        return this.xmrFormatter;
    }

    boolean isSeller() {
        return this.dataModel.getDirection() == OfferDirection.BUY;
    }

    public boolean isSellingToAnUnsignedAccount(Offer offer) {
        if (offer.getDirection() == OfferDirection.BUY && PaymentMethod.hasChargebackRisk((PaymentMethod)offer.getPaymentMethod(), (String)offer.getCounterCurrencyCode())) {
            return this.accountAgeWitnessService.getSignState(offer) == AccountAgeWitnessService.SignState.UNSIGNED || this.accountAgeWitnessService.getSignState(offer) == AccountAgeWitnessService.SignState.PEER_INITIAL || this.accountAgeWitnessService.getSignState(offer) == AccountAgeWitnessService.SignState.BANNED;
        }
        return false;
    }

    private InputValidator.ValidationResult isXmrInputValid(String input) {
        return this.xmrValidator.validate(input);
    }

    public Offer getOffer() {
        return this.dataModel.getOffer();
    }

    public boolean isRange() {
        return this.dataModel.getOffer().isRange();
    }

    public String getAmountRange() {
        return this.amountRange;
    }

    public String getPaymentLabel() {
        return this.paymentLabel;
    }

    public String getPrice() {
        return this.price;
    }

    public String getAmountDescription() {
        return this.amountDescription;
    }

    String getTradeAmount() {
        return OfferViewModelUtil.getTradeFeeWithFiatEquivalent(this.offerUtil, (BigInteger)this.dataModel.getAmount().get(), this.xmrFormatter);
    }

    public String getSecurityDepositInfo() {
        return OfferViewModelUtil.getTradeFeeWithFiatEquivalentAndPercentage(this.offerUtil, this.dataModel.getSecurityDeposit(), (BigInteger)this.dataModel.getAmount().get(), this.xmrFormatter);
    }

    public String getSecurityDepositWithCode() {
        return HavenoUtils.formatXmr((BigInteger)this.dataModel.getSecurityDeposit(), (boolean)true);
    }

    public String getTradeFee() {
        return OfferViewModelUtil.getTradeFeeWithFiatEquivalentAndPercentage(this.offerUtil, this.dataModel.getTakerFee(), (BigInteger)this.dataModel.getAmount().get(), this.xmrFormatter);
    }

    public String getTakerFeePercentage() {
        BigInteger takerFee = this.dataModel.getTakerFee();
        return takerFee != null ? GUIUtil.getPercentage(takerFee, (BigInteger)this.dataModel.getAmount().get()) : Res.get((String)"shared.na");
    }

    public String getTotalToPayInfo() {
        String totalToPay = (String)this.totalToPay.get();
        return totalToPay;
    }

    ObservableList<PaymentAccount> getPossiblePaymentAccounts() {
        return this.dataModel.getPossiblePaymentAccounts();
    }

    public PaymentAccount getLastSelectedPaymentAccount() {
        return this.dataModel.getLastSelectedPaymentAccount();
    }

    public void resetOfferWarning() {
        this.offerWarning.set(null);
    }

    public Trade getTrade() {
        return this.trade;
    }

    public void resetErrorMessage() {
        this.offer.setErrorMessage(null);
    }

    public Callback<ListView<PaymentAccount>, ListCell<PaymentAccount>> getPaymentAccountListCellFactory(ComboBox<PaymentAccount> paymentAccountsComboBox) {
        return GUIUtil.getPaymentAccountListCellFactory(paymentAccountsComboBox, this.accountAgeWitnessService);
    }

    String getPercentagePriceDescription() {
        return this.dataModel.isBuyOffer() ? Res.get((String)"shared.belowInPercent") : Res.get((String)"shared.aboveInPercent");
    }
}

