/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.takeoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.jfoenix.controls.JFXTextField;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Tuple4;
import haveno.common.util.Utilities;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.payment.FasterPaymentsAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AddressTextField;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.BalanceTextField;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.FundsTextField;
import haveno.desktop.components.InfoInputTextField;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.MainView;
import haveno.desktop.main.funds.FundsView;
import haveno.desktop.main.funds.withdrawal.WithdrawalView;
import haveno.desktop.main.offer.ClosableView;
import haveno.desktop.main.offer.InitializableViewWithTakeOfferData;
import haveno.desktop.main.offer.OfferView;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.offer.SelectableView;
import haveno.desktop.main.offer.takeoffer.TakeOfferViewModel;
import haveno.desktop.main.overlays.notifications.Notification;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.GenericMessageWindow;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.overlays.windows.QRCodeWindow;
import haveno.desktop.main.portfolio.PortfolioView;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesView;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Transitions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.jetbrains.annotations.NotNull;

@FxmlView
public class TakeOfferView
extends ActivatableViewAndModel<AnchorPane, TakeOfferViewModel>
implements ClosableView,
InitializableViewWithTakeOfferData,
SelectableView {
    private final Navigation navigation;
    private final CoinFormatter formatter;
    private final OfferDetailsWindow offerDetailsWindow;
    private final Transitions transitions;
    private ScrollPane scrollPane;
    private GridPane gridPane;
    private TitledGroupBg noFundingRequiredTitledGroupBg;
    private Label noFundingRequiredLabel;
    private int gridRowNoFundingRequired;
    private TitledGroupBg payFundsTitledGroupBg;
    private TitledGroupBg advancedOptionsGroup;
    private VBox priceAsPercentageInputBox;
    private VBox amountRangeBox;
    private HBox fundingHBox;
    private HBox amountValueCurrencyBox;
    private HBox priceValueCurrencyBox;
    private HBox volumeValueCurrencyBox;
    private HBox priceAsPercentageValueCurrencyBox;
    private HBox minAmountValueCurrencyBox;
    private HBox advancedOptionsBox;
    private HBox takeOfferBox;
    private HBox nextButtonBox;
    private HBox firstRowHBox;
    private ComboBox<PaymentAccount> paymentAccountsComboBox;
    private TextArea extraInfoTextArea;
    private Label amountDescriptionLabel;
    private Label paymentMethodLabel;
    private Label priceCurrencyLabel;
    private Label priceAsPercentageLabel;
    private Label volumeCurrencyLabel;
    private Label priceDescriptionLabel;
    private Label volumeDescriptionLabel;
    private Label waitingForFundsLabel;
    private Label offerAvailabilityLabel;
    private Label priceAsPercentageDescription;
    private Label tradeFeeDescriptionLabel;
    private Label resultLabel;
    private Label tradeFeeInXmrLabel;
    private Label xLabel;
    private Label fakeXLabel;
    private Label extraInfoLabel;
    private InputTextField amountTextField;
    private InputTextField volumeTextField;
    private TextField paymentMethodTextField;
    private TextField currencyTextField;
    private TextField priceTextField;
    private TextField priceAsPercentageTextField;
    private TextField amountRangeTextField;
    private FundsTextField totalToPayTextField;
    private AddressTextField addressTextField;
    private BalanceTextField balanceTextField;
    private Text xIcon;
    private Text fakeXIcon;
    private Button nextButton;
    private Button cancelButton1;
    private Button cancelButton2;
    private AutoTooltipButton takeOfferButton;
    private AutoTooltipButton fundFromSavingsWalletButton;
    private ImageView qrCodeImageView;
    private StackPane qrCodePane;
    private BusyAnimation waitingForFundsBusyAnimation;
    private BusyAnimation offerAvailabilityBusyAnimation;
    private Notification walletFundedNotification;
    private OfferView.CloseHandler closeHandler;
    private Subscription balanceSubscription;
    private Subscription showTransactionPublishedScreenSubscription;
    private Subscription showWarningInvalidXmrDecimalPlacesSubscription;
    private Subscription isWaitingForFundsSubscription;
    private Subscription offerWarningSubscription;
    private Subscription errorMessageSubscription;
    private Subscription isOfferAvailableSubscription;
    private ChangeListener<BigInteger> missingCoinListener;
    private int gridRow = 0;
    private final HashMap<String, Boolean> paymentAccountWarningDisplayed = new HashMap();
    private boolean offerDetailsWindowDisplayed;
    private boolean extraInfoPopupDisplayed;
    private boolean zelleWarningDisplayed;
    private boolean fasterPaymentsWarningDisplayed;
    private boolean takeOfferFromUnsignedAccountWarningDisplayed;
    private boolean payByMailWarningDisplayed;
    private boolean cashAtAtmWarningDisplayed;
    private boolean australiaPayidWarningDisplayed;
    private boolean paypalWarningDisplayed;
    private boolean cashAppWarningDisplayed;
    private boolean F2FWarningDisplayed;
    private SimpleBooleanProperty errorPopupDisplayed;
    private ChangeListener<Boolean> amountFocusedListener;
    private ChangeListener<Boolean> volumeFocusedListener;
    private ChangeListener<Boolean> getShowWalletFundedNotificationListener;
    private InfoInputTextField volumeInfoTextField;

    @Inject
    private TakeOfferView(TakeOfferViewModel model, Navigation navigation, @Named(value="BTC") CoinFormatter formatter, OfferDetailsWindow offerDetailsWindow, Transitions transitions) {
        super(model);
        this.navigation = navigation;
        this.formatter = formatter;
        this.offerDetailsWindow = offerDetailsWindow;
        this.transitions = transitions;
    }

    @Override
    protected void initialize() {
        this.addScrollPane();
        this.addGridPane();
        this.addPaymentGroup();
        this.addAmountPriceGroup();
        this.addOptionsGroup();
        this.createListeners();
        this.addNextButtons();
        this.addOfferAvailabilityLabel();
        this.addFundingGroup();
        this.balanceTextField.setFormatter(((TakeOfferViewModel)this.model).getXmrFormatter());
        GUIUtil.focusWhenAddedToScene((Node)this.amountTextField);
    }

    @Override
    protected void activate() {
        this.addBindings();
        this.addSubscriptions();
        this.addListeners();
        if (this.offerAvailabilityBusyAnimation != null && !((TakeOfferViewModel)this.model).showPayFundsScreenDisplayed.get()) {
            this.offerAvailabilityLabel.setVisible(true);
            this.offerAvailabilityLabel.setManaged(true);
        } else {
            this.offerAvailabilityLabel.setVisible(false);
            this.offerAvailabilityLabel.setManaged(false);
        }
        if (this.waitingForFundsBusyAnimation != null && ((TakeOfferViewModel)this.model).isWaitingForFunds.get()) {
            this.waitingForFundsLabel.setVisible(true);
            this.waitingForFundsLabel.setManaged(true);
        } else {
            this.waitingForFundsLabel.setVisible(false);
            this.waitingForFundsLabel.setManaged(false);
        }
        String currencyCode = ((TakeOfferViewModel)this.model).dataModel.getCurrencyCode();
        this.volumeCurrencyLabel.setText(currencyCode);
        this.priceDescriptionLabel.setText(CurrencyUtil.getPriceWithCurrencyCode((String)currencyCode));
        this.volumeDescriptionLabel.setText((String)((TakeOfferViewModel)this.model).volumeDescriptionLabel.get());
        PaymentAccount lastPaymentAccount = ((TakeOfferViewModel)this.model).getLastSelectedPaymentAccount();
        if (((TakeOfferViewModel)this.model).getPossiblePaymentAccounts().size() > 1) {
            ((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"popup.info.multiplePaymentAccounts.headline"))).information(Res.get((String)"popup.info.multiplePaymentAccounts.msg"))).dontShowAgainId("MultiplePaymentAccountsAvailableWarning")).show();
            this.paymentAccountsComboBox.setItems(((TakeOfferViewModel)this.model).getPossiblePaymentAccounts());
            this.paymentAccountsComboBox.getSelectionModel().select((Object)lastPaymentAccount);
            ((TakeOfferViewModel)this.model).onPaymentAccountSelected(lastPaymentAccount);
        }
        this.balanceTextField.setTargetAmount((BigInteger)((TakeOfferViewModel)this.model).dataModel.getTotalToPay().get());
        this.maybeShowExtraInfoPopup(((TakeOfferViewModel)this.model).dataModel.getOffer());
        this.maybeShowTakeOfferFromUnsignedAccountWarning(((TakeOfferViewModel)this.model).dataModel.getOffer());
        this.maybeShowZelleWarning(lastPaymentAccount);
        this.maybeShowFasterPaymentsWarning(lastPaymentAccount);
        this.maybeShowAccountWarning(lastPaymentAccount, ((TakeOfferViewModel)this.model).dataModel.isBuyOffer());
        if (!((TakeOfferViewModel)this.model).isRange()) {
            this.nextButton.setVisible(false);
            this.cancelButton1.setVisible(false);
            if (((TakeOfferViewModel)this.model).isOfferAvailable.get()) {
                this.showNextStepAfterAmountIsSet();
            }
        }
    }

    @Override
    protected void deactivate() {
        this.removeBindings();
        this.removeSubscriptions();
        this.removeListeners();
        if (this.offerAvailabilityBusyAnimation != null) {
            this.offerAvailabilityBusyAnimation.stop();
        }
        if (this.waitingForFundsBusyAnimation != null) {
            this.waitingForFundsBusyAnimation.stop();
        }
    }

    @Override
    public void initWithData(Offer offer) {
        ((TakeOfferViewModel)this.model).initWithData(offer);
        this.priceAsPercentageInputBox.setVisible(offer.isUseMarketBasedPrice());
        if (OfferViewUtil.isShownAsSellOffer(((TakeOfferViewModel)this.model).getOffer())) {
            this.takeOfferButton.setId("buy-button-big");
            this.nextButton.setId("buy-button");
            this.fundFromSavingsWalletButton.setId("buy-button");
            this.takeOfferButton.updateText(this.getTakeOfferLabel(offer, false));
        } else {
            this.takeOfferButton.setId("sell-button-big");
            this.nextButton.setId("sell-button");
            this.fundFromSavingsWalletButton.setId("sell-button");
            this.takeOfferButton.updateText(this.getTakeOfferLabel(offer, true));
        }
        this.priceAsPercentageDescription.setText(((TakeOfferViewModel)this.model).getPercentagePriceDescription());
        boolean showComboBox = ((TakeOfferViewModel)this.model).getPossiblePaymentAccounts().size() > 1;
        this.paymentAccountsComboBox.setVisible(showComboBox);
        this.paymentAccountsComboBox.setManaged(showComboBox);
        this.paymentAccountsComboBox.setMouseTransparent(!showComboBox);
        this.paymentMethodTextField.setVisible(!showComboBox);
        this.paymentMethodTextField.setManaged(!showComboBox);
        this.paymentMethodLabel.setVisible(!showComboBox);
        this.paymentMethodLabel.setManaged(!showComboBox);
        if (!showComboBox) {
            this.paymentMethodTextField.setText(((PaymentAccount)((TakeOfferViewModel)this.model).getPossiblePaymentAccounts().get(0)).getAccountName());
        }
        this.currencyTextField.setText(((TakeOfferViewModel)this.model).dataModel.getCurrencyNameAndCode());
        this.amountDescriptionLabel.setText(((TakeOfferViewModel)this.model).getAmountDescription());
        if (((TakeOfferViewModel)this.model).isRange()) {
            this.amountRangeTextField.setText(((TakeOfferViewModel)this.model).getAmountRange());
            this.amountRangeBox.setVisible(true);
            this.amountRangeBox.setManaged(true);
            this.volumeTextField.setDisable(false);
        } else {
            this.amountTextField.setDisable(true);
            this.amountTextField.setManaged(true);
        }
        this.priceTextField.setText(((TakeOfferViewModel)this.model).getPrice());
        this.priceAsPercentageTextField.setText(((TakeOfferViewModel)this.model).marketPriceMargin);
        this.addressTextField.setPaymentLabel(((TakeOfferViewModel)this.model).getPaymentLabel());
        this.addressTextField.setAddress(((TakeOfferViewModel)this.model).dataModel.getAddressEntry().getAddressString());
        if (offer.isFiatOffer()) {
            Label popOverLabel = OfferViewUtil.createPopOverLabel(Res.get((String)"offerbook.info.roundedFiatVolume"));
            this.volumeInfoTextField.setContentForPrivacyPopOver((Node)popOverLabel);
        }
        if (offer.getPrice() == null) {
            ((Popup)((Popup)new Popup().warning(Res.get((String)"takeOffer.noPriceFeedAvailable"))).onClose(() -> this.close(false))).show();
        }
        if (offer.hasBuyerAsTakerWithoutDeposit() && offer.getCombinedExtraInfo() != null && !offer.getCombinedExtraInfo().isEmpty()) {
            Tuple2<Label, TextArea> extraInfoTuple = FormBuilder.addCompactTopLabelTextArea(this.gridPane, ++this.gridRowNoFundingRequired, Res.get((String)"payment.shared.extraInfo.noDeposit"), "");
            this.extraInfoLabel = (Label)extraInfoTuple.first;
            this.extraInfoLabel.setVisible(false);
            this.extraInfoLabel.setManaged(false);
            this.extraInfoTextArea = (TextArea)extraInfoTuple.second;
            this.extraInfoTextArea.setVisible(false);
            this.extraInfoTextArea.setManaged(false);
            this.extraInfoTextArea.setText(offer.getCombinedExtraInfo().trim());
            this.extraInfoTextArea.getStyleClass().addAll((Object[])new String[]{"text-area", "flat-text-area-with-border"});
            this.extraInfoTextArea.setWrapText(true);
            this.extraInfoTextArea.setMaxHeight(300.0);
            this.extraInfoTextArea.setEditable(false);
            GUIUtil.adjustHeightAutomatically(this.extraInfoTextArea);
            GridPane.setRowIndex((Node)this.extraInfoTextArea, (Integer)this.gridRowNoFundingRequired);
            GridPane.setColumnSpan((Node)this.extraInfoTextArea, (Integer)Integer.MAX_VALUE);
            GridPane.setColumnIndex((Node)this.extraInfoTextArea, (Integer)0);
            GridPane.setRowIndex((Node)this.takeOfferBox, (Integer)(this.gridRowNoFundingRequired + 1));
            GridPane.setMargin((Node)this.takeOfferBox, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
        }
    }

    @Override
    public void setCloseHandler(OfferView.CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
    }

    public void onClose() {
        BigInteger availableBalance = (BigInteger)((TakeOfferViewModel)this.model).dataModel.getAvailableBalance().get();
        if (availableBalance != null && availableBalance.compareTo(BigInteger.ZERO) > 0 && !((TakeOfferViewModel)this.model).takeOfferCompleted.get() && !DevEnv.isDevMode()) {
            ((TakeOfferViewModel)this.model).dataModel.swapTradeToSavings();
        }
    }

    @Override
    public void onTabSelected(boolean isSelected) {
        ((TakeOfferViewModel)this.model).dataModel.onTabSelected(isSelected);
    }

    private void onTakeOffer() {
        if (!((TakeOfferViewModel)this.model).dataModel.canTakeOffer()) {
            return;
        }
        if (DevEnv.isDevMode()) {
            this.balanceSubscription.unsubscribe();
            ((TakeOfferViewModel)this.model).onTakeOffer(() -> {});
            return;
        }
        this.offerDetailsWindow.onTakeOffer(() -> ((TakeOfferViewModel)this.model).onTakeOffer(() -> {
            this.offerDetailsWindow.hide();
            this.offerDetailsWindowDisplayed = false;
        })).show(((TakeOfferViewModel)this.model).getOffer(), (BigInteger)((TakeOfferViewModel)this.model).dataModel.getAmount().get(), ((TakeOfferViewModel)this.model).dataModel.tradePrice);
        this.offerDetailsWindowDisplayed = true;
    }

    private void onShowPayFundsScreen() {
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.nextButton.setVisible(false);
        this.nextButton.setManaged(false);
        this.nextButton.setOnAction(null);
        this.cancelButton1.setVisible(false);
        this.cancelButton1.setManaged(false);
        this.cancelButton1.setOnAction(null);
        this.offerAvailabilityBusyAnimation.stop();
        this.offerAvailabilityBusyAnimation.setVisible(false);
        this.offerAvailabilityBusyAnimation.setManaged(false);
        this.offerAvailabilityLabel.setVisible(false);
        this.offerAvailabilityLabel.setManaged(false);
        int delay = 500;
        int diff = 100;
        this.transitions.fadeOutAndRemove((Node)this.advancedOptionsGroup, delay, (EventHandler<ActionEvent>)((EventHandler)event -> {}));
        this.transitions.fadeOutAndRemove((Node)this.advancedOptionsBox, delay -= diff);
        ((TakeOfferViewModel)this.model).onShowPayFundsScreen();
        this.amountTextField.setMouseTransparent(true);
        this.amountTextField.setDisable(false);
        this.amountTextField.setFocusTraversable(false);
        this.amountRangeTextField.setMouseTransparent(true);
        this.amountRangeTextField.setDisable(false);
        this.amountRangeTextField.setFocusTraversable(false);
        this.priceTextField.setMouseTransparent(true);
        this.priceTextField.setDisable(false);
        this.priceTextField.setFocusTraversable(false);
        this.priceAsPercentageTextField.setMouseTransparent(true);
        this.priceAsPercentageTextField.setDisable(false);
        this.priceAsPercentageTextField.setFocusTraversable(false);
        this.volumeTextField.setMouseTransparent(true);
        this.volumeTextField.setDisable(false);
        this.volumeTextField.setFocusTraversable(false);
        this.updateOfferElementsStyle();
        this.balanceTextField.setTargetAmount((BigInteger)((TakeOfferViewModel)this.model).dataModel.getTotalToPay().get());
        if (!DevEnv.isDevMode() && ((TakeOfferViewModel)this.model).dataModel.hasTotalToPay()) {
            String tradeAmountText = ((TakeOfferViewModel)this.model).isSeller() ? Res.get((String)"takeOffer.takeOfferFundWalletInfo.tradeAmount", (Object[])new Object[]{((TakeOfferViewModel)this.model).getTradeAmount()}) : "";
            String message = Res.get((String)"takeOffer.takeOfferFundWalletInfo.msg", (Object[])new Object[]{((TakeOfferViewModel)this.model).getTotalToPayInfo(), tradeAmountText, ((TakeOfferViewModel)this.model).getSecurityDepositInfo(), ((TakeOfferViewModel)this.model).getTradeFee()});
            String key = "takeOfferFundWalletInfo";
            ((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"takeOffer.takeOfferFundWalletInfo.headline"))).instruction(message)).dontShowAgainId(key)).show();
        }
        this.cancelButton2.setVisible(true);
        this.cancelButton2.setManaged(true);
        if (((TakeOfferViewModel)this.model).getOffer().hasBuyerAsTakerWithoutDeposit()) {
            this.noFundingRequiredTitledGroupBg.setVisible(true);
            this.noFundingRequiredTitledGroupBg.setManaged(true);
            this.noFundingRequiredLabel.setVisible(true);
            this.noFundingRequiredLabel.setManaged(true);
            if (((TakeOfferViewModel)this.model).getOffer().getCombinedExtraInfo() != null && !((TakeOfferViewModel)this.model).getOffer().getCombinedExtraInfo().isEmpty()) {
                this.extraInfoLabel.setVisible(true);
                this.extraInfoLabel.setManaged(true);
                this.extraInfoTextArea.setVisible(true);
                this.extraInfoTextArea.setManaged(true);
            }
        } else {
            this.payFundsTitledGroupBg.setVisible(true);
            this.payFundsTitledGroupBg.setManaged(true);
            this.totalToPayTextField.setVisible(true);
            this.totalToPayTextField.setManaged(true);
            this.addressTextField.setVisible(true);
            this.addressTextField.setManaged(true);
            this.qrCodePane.setVisible(true);
            this.qrCodePane.setManaged(true);
            this.balanceTextField.setVisible(true);
            this.balanceTextField.setManaged(true);
        }
        this.totalToPayTextField.setFundsStructure(Res.get((String)"takeOffer.fundsBox.fundsStructure", (Object[])new Object[]{((TakeOfferViewModel)this.model).getSecurityDepositWithCode(), ((TakeOfferViewModel)this.model).getTakerFeePercentage()}));
        this.totalToPayTextField.setContentForInfoPopOver((Node)this.createInfoPopover());
        if (((TakeOfferViewModel)this.model).dataModel.getIsXmrWalletFunded().get() && ((TakeOfferViewModel)this.model).dataModel.hasTotalToPay() && this.walletFundedNotification == null) {
            this.walletFundedNotification = ((Notification)((Notification)new Notification().headLine(Res.get((String)"notification.walletUpdate.headline"))).notification(Res.get((String)"notification.takeOffer.walletUpdate.msg", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)((BigInteger)((TakeOfferViewModel)this.model).dataModel.getTotalToPay().get()), (boolean)true)}))).autoClose();
            this.walletFundedNotification.show();
        }
        this.updateQrCode();
    }

    private void updateQrCode() {
        byte[] imageBytes = QRCode.from((String)this.getMoneroURI()).withSize(300, 300).to(ImageType.PNG).stream().toByteArray();
        Image qrImage = new Image((InputStream)new ByteArrayInputStream(imageBytes));
        this.qrCodeImageView.setImage(qrImage);
    }

    private void updateOfferElementsStyle() {
        GridPane.setColumnSpan((Node)this.firstRowHBox, (Integer)1);
        String activeInputStyle = "offer-input";
        String readOnlyInputStyle = "offer-input-readonly";
        this.amountValueCurrencyBox.getStyleClass().remove((Object)"offer-input");
        this.amountValueCurrencyBox.getStyleClass().add((Object)"offer-input-readonly");
        this.priceAsPercentageValueCurrencyBox.getStyleClass().remove((Object)"offer-input");
        this.priceAsPercentageValueCurrencyBox.getStyleClass().add((Object)"offer-input-readonly");
        this.volumeValueCurrencyBox.getStyleClass().remove((Object)"offer-input");
        this.volumeValueCurrencyBox.getStyleClass().add((Object)"offer-input-readonly");
        this.priceValueCurrencyBox.getStyleClass().remove((Object)"offer-input");
        this.priceValueCurrencyBox.getStyleClass().add((Object)"offer-input-readonly");
        this.minAmountValueCurrencyBox.getStyleClass().remove((Object)"offer-input");
        this.minAmountValueCurrencyBox.getStyleClass().add((Object)"offer-input-readonly");
        this.resultLabel.getStyleClass().add((Object)"small");
        this.xLabel.getStyleClass().add((Object)"small");
        this.xIcon.setStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", MaterialDesignIcon.CLOSE.fontFamily(), "1em"));
        this.fakeXIcon.setStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", MaterialDesignIcon.CLOSE.fontFamily(), "1em"));
        this.fakeXLabel.getStyleClass().add((Object)"small");
    }

    private void close() {
        this.close(true);
    }

    private void close(boolean removeOffer) {
        ((TakeOfferViewModel)this.model).dataModel.onClose(removeOffer);
        if (this.closeHandler != null) {
            this.closeHandler.close();
        }
    }

    private void addBindings() {
        this.amountTextField.textProperty().bindBidirectional((Property)((TakeOfferViewModel)this.model).amount);
        this.volumeTextField.textProperty().bindBidirectional((Property)((TakeOfferViewModel)this.model).volume);
        this.totalToPayTextField.textProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).totalToPay);
        this.addressTextField.amountAsProperty().bind(((TakeOfferViewModel)this.model).dataModel.getMissingCoin());
        this.amountTextField.validationResultProperty().bind(((TakeOfferViewModel)this.model).amountValidationResult);
        this.volumeTextField.validationResultProperty().bind(((TakeOfferViewModel)this.model).volumeValidationResult);
        this.priceCurrencyLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> CurrencyUtil.getCounterCurrency((String)((TakeOfferViewModel)this.model).dataModel.getCurrencyCode()), (Observable[])new Observable[0]));
        this.priceAsPercentageLabel.prefWidthProperty().bind((ObservableValue)this.priceCurrencyLabel.widthProperty());
        this.nextButton.disableProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).isNextButtonDisabled);
        this.tradeFeeInXmrLabel.textProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).tradeFeeInXmrWithFiat);
        this.tradeFeeDescriptionLabel.textProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).tradeFeeDescription);
        this.tradeFeeInXmrLabel.visibleProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).isTradeFeeVisible);
        this.tradeFeeDescriptionLabel.visibleProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).isTradeFeeVisible);
        this.tradeFeeDescriptionLabel.managedProperty().bind((ObservableValue)this.tradeFeeDescriptionLabel.visibleProperty());
        this.fundingHBox.visibleProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).dataModel.getIsXmrWalletFunded().not().and((ObservableBooleanValue)((TakeOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.fundingHBox.managedProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).dataModel.getIsXmrWalletFunded().not().and((ObservableBooleanValue)((TakeOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.waitingForFundsLabel.textProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).spinnerInfoText);
        this.takeOfferBox.visibleProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).dataModel.getIsXmrWalletFunded().and((ObservableBooleanValue)((TakeOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.takeOfferBox.managedProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).dataModel.getIsXmrWalletFunded().and((ObservableBooleanValue)((TakeOfferViewModel)this.model).showPayFundsScreenDisplayed));
        this.takeOfferButton.disableProperty().bind((ObservableValue)((TakeOfferViewModel)this.model).isTakeOfferButtonDisabled);
    }

    private void removeBindings() {
        this.amountTextField.textProperty().unbindBidirectional((Property)((TakeOfferViewModel)this.model).amount);
        this.volumeTextField.textProperty().unbindBidirectional((Property)((TakeOfferViewModel)this.model).volume);
        this.totalToPayTextField.textProperty().unbind();
        this.addressTextField.amountAsProperty().unbind();
        this.amountTextField.validationResultProperty().unbind();
        this.priceCurrencyLabel.textProperty().unbind();
        this.priceAsPercentageLabel.prefWidthProperty().unbind();
        this.nextButton.disableProperty().unbind();
        this.tradeFeeInXmrLabel.textProperty().unbind();
        this.tradeFeeDescriptionLabel.textProperty().unbind();
        this.tradeFeeInXmrLabel.visibleProperty().unbind();
        this.tradeFeeDescriptionLabel.visibleProperty().unbind();
        this.tradeFeeDescriptionLabel.managedProperty().unbind();
        this.fundingHBox.visibleProperty().unbind();
        this.fundingHBox.managedProperty().unbind();
        this.waitingForFundsLabel.textProperty().unbind();
        this.takeOfferBox.visibleProperty().unbind();
        this.takeOfferBox.managedProperty().unbind();
        this.takeOfferButton.disableProperty().unbind();
    }

    private void addSubscriptions() {
        this.errorPopupDisplayed = new SimpleBooleanProperty();
        this.offerWarningSubscription = EasyBind.subscribe((ObservableValue)((TakeOfferViewModel)this.model).offerWarning, newValue -> {
            if (newValue != null) {
                if (this.offerDetailsWindowDisplayed) {
                    this.offerDetailsWindow.hide();
                }
                UserThread.runAfter(() -> ((Popup)((Popup)((Popup)((Popup)new Popup().warning(newValue + "\n\n" + Res.get((String)"takeOffer.alreadyPaidInFunds"))).actionButtonTextWithGoTo("funds.tab.withdrawal")).onAction(() -> {
                    this.errorPopupDisplayed.set(true);
                    ((TakeOfferViewModel)this.model).resetOfferWarning();
                    this.close();
                    this.navigation.navigateTo(MainView.class, FundsView.class, WithdrawalView.class);
                })).onClose(() -> {
                    this.errorPopupDisplayed.set(true);
                    ((TakeOfferViewModel)this.model).resetOfferWarning();
                    this.close();
                })).show(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        });
        this.errorMessageSubscription = EasyBind.subscribe((ObservableValue)((TakeOfferViewModel)this.model).errorMessage, newValue -> {
            if (newValue != null) {
                ((Popup)((Popup)new Popup().error(Res.get((String)"takeOffer.error.message", (Object[])new Object[]{((TakeOfferViewModel)this.model).errorMessage.get()}))).onClose(() -> {
                    this.errorPopupDisplayed.set(true);
                    ((TakeOfferViewModel)this.model).resetErrorMessage();
                    this.close();
                })).show();
            }
        });
        this.isOfferAvailableSubscription = EasyBind.subscribe((ObservableValue)((TakeOfferViewModel)this.model).isOfferAvailable, isOfferAvailable -> {
            if (isOfferAvailable.booleanValue()) {
                this.offerAvailabilityBusyAnimation.stop();
                this.offerAvailabilityBusyAnimation.setVisible(false);
                this.offerAvailabilityBusyAnimation.setManaged(false);
                if (!((TakeOfferViewModel)this.model).isRange() && !((TakeOfferViewModel)this.model).showPayFundsScreenDisplayed.get()) {
                    this.showNextStepAfterAmountIsSet();
                }
            }
            this.offerAvailabilityLabel.setVisible(isOfferAvailable == false);
            this.offerAvailabilityLabel.setManaged(isOfferAvailable == false);
        });
        this.isWaitingForFundsSubscription = EasyBind.subscribe((ObservableValue)((TakeOfferViewModel)this.model).isWaitingForFunds, isWaitingForFunds -> {
            this.waitingForFundsLabel.setVisible(isWaitingForFunds.booleanValue());
            this.waitingForFundsLabel.setManaged(isWaitingForFunds.booleanValue());
        });
        this.showWarningInvalidXmrDecimalPlacesSubscription = EasyBind.subscribe((ObservableValue)((TakeOfferViewModel)this.model).showWarningInvalidXmrDecimalPlaces, newValue -> {
            if (newValue.booleanValue()) {
                ((Popup)new Popup().warning(Res.get((String)"takeOffer.amountPriceBox.warning.invalidXmrDecimalPlaces"))).show();
                ((TakeOfferViewModel)this.model).showWarningInvalidXmrDecimalPlaces.set(false);
            }
        });
        this.showTransactionPublishedScreenSubscription = EasyBind.subscribe((ObservableValue)((TakeOfferViewModel)this.model).showTransactionPublishedScreen, newValue -> {
            if (newValue.booleanValue() && DevEnv.isDevMode()) {
                this.close();
            } else if (newValue.booleanValue() && ((TakeOfferViewModel)this.model).getTrade() != null && !((TakeOfferViewModel)this.model).getTrade().hasFailed()) {
                String key = "takeOfferSuccessInfo";
                if (DontShowAgainLookup.showAgain((String)key)) {
                    UserThread.runAfter(() -> ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"takeOffer.success.headline"))).feedback(Res.get((String)"takeOffer.success.info"))).actionButtonTextWithGoTo("portfolio.tab.pendingTrades")).dontShowAgainId(key)).onAction(() -> {
                        UserThread.runAfter(() -> this.navigation.navigateTo(MainView.class, PortfolioView.class, PendingTradesView.class), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                        this.close();
                    })).onClose(this::close)).show(), (long)1L);
                } else {
                    this.close();
                }
            }
        });
        this.balanceSubscription = EasyBind.subscribe(((TakeOfferViewModel)this.model).dataModel.getAvailableBalance(), this.balanceTextField::setBalance);
    }

    private void removeSubscriptions() {
        this.offerWarningSubscription.unsubscribe();
        this.errorMessageSubscription.unsubscribe();
        this.isOfferAvailableSubscription.unsubscribe();
        this.isWaitingForFundsSubscription.unsubscribe();
        this.showWarningInvalidXmrDecimalPlacesSubscription.unsubscribe();
        this.showTransactionPublishedScreenSubscription.unsubscribe();
        this.balanceSubscription.unsubscribe();
    }

    private void createListeners() {
        this.amountFocusedListener = (o, oldValue, newValue) -> {
            ((TakeOfferViewModel)this.model).onFocusOutAmountTextField((boolean)oldValue, (boolean)newValue, this.amountTextField.getText());
            this.amountTextField.setText((String)((TakeOfferViewModel)this.model).amount.get());
        };
        this.getShowWalletFundedNotificationListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                Notification walletFundedNotification = ((Notification)((Notification)new Notification().headLine(Res.get((String)"notification.walletUpdate.headline"))).notification(Res.get((String)"notification.walletUpdate.msg", (Object[])new Object[]{HavenoUtils.formatXmr((BigInteger)((BigInteger)((TakeOfferViewModel)this.model).dataModel.getTotalToPay().get()), (boolean)true)}))).autoClose();
                walletFundedNotification.show();
            }
        };
        this.volumeFocusedListener = (o, oldValue, newValue) -> {
            ((TakeOfferViewModel)this.model).onFocusOutVolumeTextField((boolean)oldValue, (boolean)newValue);
            this.volumeTextField.setText((String)((TakeOfferViewModel)this.model).volume.get());
        };
        this.missingCoinListener = (observable, oldValue, newValue) -> {
            if (!newValue.toString().equals("")) {
                this.updateQrCode();
            }
        };
    }

    private void addListeners() {
        this.amountTextField.focusedProperty().addListener(this.amountFocusedListener);
        this.volumeTextField.focusedProperty().addListener(this.volumeFocusedListener);
        ((TakeOfferViewModel)this.model).dataModel.getShowWalletFundedNotification().addListener(this.getShowWalletFundedNotificationListener);
        ((TakeOfferViewModel)this.model).dataModel.getMissingCoin().addListener(this.missingCoinListener);
    }

    private void removeListeners() {
        this.amountTextField.focusedProperty().removeListener(this.amountFocusedListener);
        this.volumeTextField.focusedProperty().removeListener(this.volumeFocusedListener);
        ((TakeOfferViewModel)this.model).dataModel.getShowWalletFundedNotification().removeListener(this.getShowWalletFundedNotificationListener);
        ((TakeOfferViewModel)this.model).dataModel.getMissingCoin().removeListener(this.missingCoinListener);
    }

    private void addScrollPane() {
        this.scrollPane = GUIUtil.createScrollPane();
        ((AnchorPane)this.root).getChildren().add((Object)this.scrollPane);
    }

    private void addGridPane() {
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add((Object)"content-pane");
        this.gridPane.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        GUIUtil.setDefaultTwoColumnConstraintsForGridPane(this.gridPane);
        this.scrollPane.setContent((Node)this.gridPane);
    }

    private void addPaymentGroup() {
        TitledGroupBg paymentAccountTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.gridRow, 1, Res.get((String)"offerbook.takeOffer"));
        GridPane.setColumnSpan((Node)paymentAccountTitledGroupBg, (Integer)2);
        Tuple4 paymentAccountTuple = FormBuilder.addComboBoxTopLabelTextField(this.gridPane, this.gridRow, Res.get((String)"shared.chooseTradingAccount"), Res.get((String)"shared.chooseTradingAccount"), 20.0);
        this.paymentAccountsComboBox = (ComboBox)paymentAccountTuple.first;
        HBox.setMargin(this.paymentAccountsComboBox, (Insets)new Insets(23.0, 0.0, 0.0, 0.0));
        this.paymentAccountsComboBox.setConverter(GUIUtil.getPaymentAccountsComboBoxStringConverter());
        this.paymentAccountsComboBox.setCellFactory(((TakeOfferViewModel)this.model).getPaymentAccountListCellFactory(this.paymentAccountsComboBox));
        this.paymentAccountsComboBox.setVisible(false);
        this.paymentAccountsComboBox.setManaged(false);
        this.paymentAccountsComboBox.setOnAction(e -> {
            PaymentAccount paymentAccount = (PaymentAccount)this.paymentAccountsComboBox.getSelectionModel().getSelectedItem();
            if (paymentAccount != null) {
                this.maybeShowZelleWarning(paymentAccount);
                this.maybeShowFasterPaymentsWarning(paymentAccount);
                this.maybeShowAccountWarning(paymentAccount, ((TakeOfferViewModel)this.model).dataModel.isBuyOffer());
            }
            ((TakeOfferViewModel)this.model).onPaymentAccountSelected(paymentAccount);
        });
        this.paymentMethodLabel = (Label)paymentAccountTuple.second;
        this.paymentMethodTextField = (TextField)paymentAccountTuple.third;
        this.paymentMethodTextField.setMinWidth(250.0);
        this.paymentMethodTextField.setEditable(false);
        this.paymentMethodTextField.setMouseTransparent(true);
        this.paymentMethodTextField.setFocusTraversable(false);
        this.currencyTextField = new JFXTextField();
        this.currencyTextField.setMinWidth(250.0);
        this.currencyTextField.setEditable(false);
        this.currencyTextField.setMouseTransparent(true);
        this.currencyTextField.setFocusTraversable(false);
        Tuple2<Label, VBox> tradeCurrencyTuple = FormBuilder.getTopLabelWithVBox(Res.get((String)"shared.tradeCurrency"), (Node)this.currencyTextField);
        HBox.setMargin((Node)((Node)tradeCurrencyTuple.second), (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        HBox hBox = (HBox)paymentAccountTuple.fourth;
        hBox.setSpacing(30.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setPadding(new Insets(10.0, 0.0, 18.0, 0.0));
        hBox.getChildren().add((Object)((Node)tradeCurrencyTuple.second));
    }

    private void addAmountPriceGroup() {
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 2, Res.get((String)"takeOffer.setAmountPrice"), 30.0);
        GridPane.setColumnSpan((Node)titledGroupBg, (Integer)2);
        this.addAmountPriceFields();
        this.addSecondRow();
    }

    private void addOptionsGroup() {
        this.advancedOptionsGroup = FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 1, Res.get((String)"shared.advancedOptions"), 30.0);
        this.advancedOptionsBox = new HBox();
        this.advancedOptionsBox.setSpacing(40.0);
        GridPane.setRowIndex((Node)this.advancedOptionsBox, (Integer)this.gridRow);
        GridPane.setColumnSpan((Node)this.advancedOptionsBox, (Integer)Integer.MAX_VALUE);
        GridPane.setColumnIndex((Node)this.advancedOptionsBox, (Integer)0);
        GridPane.setHalignment((Node)this.advancedOptionsBox, (HPos)HPos.LEFT);
        GridPane.setMargin((Node)this.advancedOptionsBox, (Insets)new Insets(50.0, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.advancedOptionsBox);
        VBox tradeFeeFieldsBox = this.getTradeFeeFieldsBox();
        tradeFeeFieldsBox.setMinWidth(240.0);
        this.advancedOptionsBox.getChildren().addAll((Object[])new Node[]{tradeFeeFieldsBox});
    }

    private void addNextButtons() {
        Tuple3<Button, Button, HBox> tuple = FormBuilder.add2ButtonsWithBox(this.gridPane, ++this.gridRow, Res.get((String)"shared.nextStep"), Res.get((String)"shared.cancel"), 15.0, true);
        this.nextButtonBox = (HBox)tuple.third;
        this.nextButton = (Button)tuple.first;
        this.nextButton.setMaxWidth(200.0);
        this.nextButton.setDefaultButton(true);
        this.nextButton.setOnAction(e -> this.nextStepCheckMakerTx());
        this.cancelButton1 = (Button)tuple.second;
        this.cancelButton1.setMaxWidth(200.0);
        this.cancelButton1.setDefaultButton(false);
        this.cancelButton1.setOnAction(e -> {
            ((TakeOfferViewModel)this.model).dataModel.swapTradeToSavings();
            this.close(false);
        });
    }

    private void nextStepCheckMakerTx() {
        this.showNextStepAfterAmountIsSet();
    }

    private void showNextStepAfterAmountIsSet() {
        this.onShowPayFundsScreen();
    }

    private void addOfferAvailabilityLabel() {
        this.offerAvailabilityBusyAnimation = new BusyAnimation(false);
        this.offerAvailabilityLabel = new AutoTooltipLabel(Res.get((String)"takeOffer.fundsBox.isOfferAvailable"));
        HBox.setMargin((Node)this.offerAvailabilityLabel, (Insets)new Insets(6.0, 0.0, 0.0, 0.0));
        this.nextButtonBox.getChildren().addAll((Object[])new Node[]{this.offerAvailabilityBusyAnimation, this.offerAvailabilityLabel});
    }

    private void addFundingGroup() {
        this.noFundingRequiredTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.gridRow, 3, Res.get((String)"takeOffer.fundsBox.noFundingRequiredTitle"), 30.0);
        this.noFundingRequiredTitledGroupBg.getStyleClass().add((Object)"last");
        GridPane.setColumnSpan((Node)this.noFundingRequiredTitledGroupBg, (Integer)2);
        this.noFundingRequiredTitledGroupBg.setVisible(false);
        this.noFundingRequiredTitledGroupBg.setManaged(false);
        this.noFundingRequiredLabel = new AutoTooltipLabel(Res.get((String)"takeOffer.fundsBox.noFundingRequiredDescription"));
        this.noFundingRequiredLabel.setVisible(false);
        this.noFundingRequiredLabel.setManaged(false);
        GridPane.setRowIndex((Node)this.noFundingRequiredLabel, (Integer)this.gridRow);
        this.noFundingRequiredLabel.setPadding(new Insets(50.0, 0.0, 0.0, 0.0));
        GridPane.setHalignment((Node)this.noFundingRequiredLabel, (HPos)HPos.LEFT);
        this.gridPane.getChildren().add((Object)this.noFundingRequiredLabel);
        this.gridRowNoFundingRequired = this.gridRow;
        this.payFundsTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.gridRow, 3, Res.get((String)"takeOffer.fundsBox.title"), 30.0);
        this.payFundsTitledGroupBg.getStyleClass().add((Object)"last");
        GridPane.setColumnSpan((Node)this.payFundsTitledGroupBg, (Integer)2);
        this.payFundsTitledGroupBg.setVisible(false);
        this.payFundsTitledGroupBg.setManaged(false);
        this.totalToPayTextField = FormBuilder.addFundsTextfield(this.gridPane, this.gridRow, Res.get((String)"shared.totalsNeeded"), 50.0);
        this.totalToPayTextField.setVisible(false);
        this.totalToPayTextField.setManaged(false);
        Tuple2<StackPane, ImageView> qrCodeTuple = GUIUtil.getSmallXmrQrCodePane();
        this.qrCodePane = (StackPane)qrCodeTuple.first;
        this.qrCodeImageView = (ImageView)qrCodeTuple.second;
        Tooltip.install((Node)this.qrCodePane, (Tooltip)new Tooltip(Res.get((String)"shared.openLargeQRWindow")));
        this.qrCodePane.setOnMouseClicked(e -> UserThread.runAfter(() -> new QRCodeWindow(this.getMoneroURI()).show(), (long)200L, (TimeUnit)TimeUnit.MILLISECONDS));
        GridPane.setRowIndex((Node)this.qrCodePane, (Integer)this.gridRow);
        GridPane.setColumnIndex((Node)this.qrCodePane, (Integer)1);
        GridPane.setRowSpan((Node)this.qrCodePane, (Integer)3);
        GridPane.setValignment((Node)this.qrCodePane, (VPos)VPos.BOTTOM);
        GridPane.setMargin((Node)this.qrCodePane, (Insets)new Insets(11.0, 0.0, 0.0, 10.0));
        this.gridPane.getChildren().add((Object)this.qrCodePane);
        this.qrCodePane.setVisible(false);
        this.qrCodePane.setManaged(false);
        this.addressTextField = FormBuilder.addAddressTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.tradeWalletAddress"));
        this.addressTextField.setVisible(false);
        this.addressTextField.setManaged(false);
        this.balanceTextField = FormBuilder.addBalanceTextField(this.gridPane, ++this.gridRow, Res.get((String)"shared.tradeWalletBalance"));
        this.balanceTextField.setVisible(false);
        this.balanceTextField.setManaged(false);
        this.fundingHBox = new HBox();
        this.fundingHBox.setVisible(false);
        this.fundingHBox.setManaged(false);
        this.fundingHBox.setSpacing(10.0);
        this.fundFromSavingsWalletButton = new AutoTooltipButton(Res.get((String)"shared.fundFromSavingsWalletButton"));
        this.fundFromSavingsWalletButton.setDefaultButton(true);
        this.fundFromSavingsWalletButton.getStyleClass().add((Object)"action-button");
        this.fundFromSavingsWalletButton.setOnAction(e -> ((TakeOfferViewModel)this.model).fundFromSavingsWallet());
        AutoTooltipLabel label = new AutoTooltipLabel(Res.get((String)"shared.OR"));
        label.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        AutoTooltipButton fundFromExternalWalletButton = new AutoTooltipButton(Res.get((String)"shared.fundFromExternalWalletButton"));
        fundFromExternalWalletButton.setDefaultButton(false);
        fundFromExternalWalletButton.setOnAction(e -> this.openWallet());
        this.waitingForFundsBusyAnimation = new BusyAnimation(false);
        this.waitingForFundsLabel = new AutoTooltipLabel();
        this.waitingForFundsLabel.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        this.fundingHBox.getChildren().addAll((Object[])new Node[]{this.fundFromSavingsWalletButton, label, fundFromExternalWalletButton, this.waitingForFundsBusyAnimation, this.waitingForFundsLabel});
        GridPane.setRowIndex((Node)this.fundingHBox, (Integer)(++this.gridRow));
        GridPane.setMargin((Node)this.fundingHBox, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.fundingHBox);
        this.takeOfferBox = new HBox();
        this.takeOfferBox.setSpacing(10.0);
        GridPane.setRowIndex((Node)this.takeOfferBox, (Integer)this.gridRow);
        GridPane.setColumnSpan((Node)this.takeOfferBox, (Integer)2);
        GridPane.setMargin((Node)this.takeOfferBox, (Insets)new Insets(5.0, 20.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.takeOfferBox);
        this.takeOfferButton = new AutoTooltipButton();
        this.takeOfferButton.setOnAction(e -> this.onTakeOffer());
        this.takeOfferButton.setMinHeight(40.0);
        this.takeOfferButton.setPadding(new Insets(0.0, 20.0, 0.0, 20.0));
        this.takeOfferBox.getChildren().add((Object)this.takeOfferButton);
        this.takeOfferBox.visibleProperty().addListener((observable, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue.booleanValue()) {
                this.fundingHBox.getChildren().remove((Object)this.cancelButton2);
                this.takeOfferBox.getChildren().add((Object)this.cancelButton2);
            } else if (!this.fundingHBox.getChildren().contains((Object)this.cancelButton2)) {
                this.takeOfferBox.getChildren().remove((Object)this.cancelButton2);
                this.fundingHBox.getChildren().add((Object)this.cancelButton2);
            }
        }));
        this.cancelButton2 = new AutoTooltipButton(Res.get((String)"shared.cancel"));
        this.fundingHBox.getChildren().add((Object)this.cancelButton2);
        this.cancelButton2.setOnAction(e -> {
            String key = "CreateOfferCancelAndFunded";
            if (((TakeOfferViewModel)this.model).dataModel.getIsXmrWalletFunded().get() && ((TakeOfferViewModel)this.model).dataModel.hasTotalToPay() && ((TakeOfferViewModel)this.model).dataModel.preferences.showAgain(key)) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().backgroundInfo(Res.get((String)"takeOffer.alreadyFunded.askCancel"))).closeButtonText(Res.get((String)"shared.no"))).actionButtonText(Res.get((String)"shared.yesCancel"))).onAction(() -> {
                    ((TakeOfferViewModel)this.model).dataModel.swapTradeToSavings();
                    this.close(false);
                })).dontShowAgainId(key)).show();
            } else {
                this.close(false);
                ((TakeOfferViewModel)this.model).dataModel.swapTradeToSavings();
            }
        });
        this.cancelButton2.setDefaultButton(false);
        this.cancelButton2.setVisible(false);
        this.cancelButton2.setManaged(false);
    }

    private void openWallet() {
        try {
            Utilities.openURI((URI)URI.create(this.getMoneroURI()));
        }
        catch (Exception ex) {
            this.log.warn(ex.getMessage());
            ((Popup)new Popup().warning(Res.get((String)"shared.openDefaultWalletFailed"))).show();
        }
    }

    @NotNull
    private String getMoneroURI() {
        return GUIUtil.getMoneroURI(((TakeOfferViewModel)this.model).dataModel.getAddressEntry().getAddressString(), (BigInteger)((TakeOfferViewModel)this.model).dataModel.getMissingCoin().get(), ((TakeOfferViewModel)this.model).getPaymentLabel());
    }

    private void addAmountPriceFields() {
        Tuple3<HBox, InputTextField, Label> amountValueCurrencyBoxTuple = FormBuilder.getEditableValueBox(Res.get((String)"takeOffer.amount.prompt"));
        this.amountValueCurrencyBox = (HBox)amountValueCurrencyBoxTuple.first;
        this.amountTextField = (InputTextField)((Object)amountValueCurrencyBoxTuple.second);
        Tuple2<Label, VBox> amountInputBoxTuple = this.getTradeInputBox(this.amountValueCurrencyBox, ((TakeOfferViewModel)this.model).getAmountDescription());
        this.amountDescriptionLabel = (Label)amountInputBoxTuple.first;
        VBox amountBox = (VBox)amountInputBoxTuple.second;
        this.xLabel = new Label();
        this.xIcon = FormBuilder.getIconForLabel((GlyphIcons)MaterialDesignIcon.CLOSE, "2em", this.xLabel);
        this.xIcon.getStyleClass().add((Object)"opaque-icon");
        this.xLabel.getStyleClass().addAll((Object[])new String[]{"opaque-icon-character"});
        Tuple3<HBox, TextField, Label> priceValueCurrencyBoxTuple = FormBuilder.getNonEditableValueBox();
        this.priceValueCurrencyBox = (HBox)priceValueCurrencyBoxTuple.first;
        this.priceTextField = (TextField)priceValueCurrencyBoxTuple.second;
        this.priceCurrencyLabel = (Label)priceValueCurrencyBoxTuple.third;
        Tuple2<Label, VBox> priceInputBoxTuple = this.getTradeInputBox(this.priceValueCurrencyBox, Res.get((String)"takeOffer.amountPriceBox.priceDescription"));
        this.priceDescriptionLabel = (Label)priceInputBoxTuple.first;
        FormBuilder.getSmallIconForLabel((GlyphIcons)MaterialDesignIcon.LOCK, this.priceDescriptionLabel, "small-icon-label");
        VBox priceBox = (VBox)priceInputBoxTuple.second;
        this.resultLabel = new AutoTooltipLabel("=");
        this.resultLabel.getStyleClass().addAll((Object[])new String[]{"opaque-icon-character"});
        Tuple3<HBox, InfoInputTextField, Label> volumeValueCurrencyBoxTuple = FormBuilder.getNonEditableValueBoxWithInfo();
        this.volumeValueCurrencyBox = (HBox)volumeValueCurrencyBoxTuple.first;
        this.volumeInfoTextField = (InfoInputTextField)((Object)volumeValueCurrencyBoxTuple.second);
        this.volumeTextField = this.volumeInfoTextField.getInputTextField();
        this.volumeCurrencyLabel = (Label)volumeValueCurrencyBoxTuple.third;
        Tuple2<Label, VBox> volumeInputBoxTuple = this.getTradeInputBox(this.volumeValueCurrencyBox, (String)((TakeOfferViewModel)this.model).volumeDescriptionLabel.get());
        this.volumeDescriptionLabel = (Label)volumeInputBoxTuple.first;
        VBox volumeBox = (VBox)volumeInputBoxTuple.second;
        this.firstRowHBox = new HBox();
        this.firstRowHBox.setSpacing(5.0);
        this.firstRowHBox.setAlignment(Pos.CENTER_LEFT);
        this.firstRowHBox.getChildren().addAll((Object[])new Node[]{amountBox, this.xLabel, priceBox, this.resultLabel, volumeBox});
        GridPane.setColumnSpan((Node)this.firstRowHBox, (Integer)2);
        GridPane.setRowIndex((Node)this.firstRowHBox, (Integer)this.gridRow);
        GridPane.setMargin((Node)this.firstRowHBox, (Insets)new Insets(50.0, 10.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.firstRowHBox);
    }

    private void addSecondRow() {
        Tuple3<HBox, TextField, Label> priceAsPercentageTuple = FormBuilder.getNonEditableValueBox();
        this.priceAsPercentageValueCurrencyBox = (HBox)priceAsPercentageTuple.first;
        this.priceAsPercentageTextField = (TextField)priceAsPercentageTuple.second;
        this.priceAsPercentageLabel = (Label)priceAsPercentageTuple.third;
        Tuple2<Label, VBox> priceAsPercentageInputBoxTuple = this.getTradeInputBox(this.priceAsPercentageValueCurrencyBox, "");
        this.priceAsPercentageDescription = (Label)priceAsPercentageInputBoxTuple.first;
        FormBuilder.getSmallIconForLabel((GlyphIcons)MaterialDesignIcon.CHART_LINE, this.priceAsPercentageDescription, "small-icon-label");
        this.priceAsPercentageInputBox = (VBox)priceAsPercentageInputBoxTuple.second;
        this.priceAsPercentageLabel.setText("%");
        Tuple3<HBox, TextField, Label> amountValueCurrencyBoxTuple = FormBuilder.getNonEditableValueBox();
        this.amountRangeTextField = (TextField)amountValueCurrencyBoxTuple.second;
        this.minAmountValueCurrencyBox = (HBox)amountValueCurrencyBoxTuple.first;
        Tuple2<Label, VBox> amountInputBoxTuple = this.getTradeInputBox(this.minAmountValueCurrencyBox, Res.get((String)"takeOffer.amountPriceBox.amountRangeDescription"));
        this.amountRangeBox = (VBox)amountInputBoxTuple.second;
        this.amountRangeBox.setVisible(false);
        this.fakeXLabel = new Label();
        this.fakeXIcon = FormBuilder.getIconForLabel((GlyphIcons)MaterialDesignIcon.CLOSE, "2em", this.fakeXLabel);
        this.fakeXLabel.setVisible(false);
        this.fakeXLabel.getStyleClass().add((Object)"opaque-icon-character");
        HBox hBox = new HBox();
        hBox.setSpacing(5.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Object[])new Node[]{this.amountRangeBox, this.fakeXLabel, this.priceAsPercentageInputBox});
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.gridRow));
        GridPane.setMargin((Node)hBox, (Insets)new Insets(0.0, 10.0, 10.0, 0.0));
        this.gridPane.getChildren().add((Object)hBox);
    }

    private VBox getTradeFeeFieldsBox() {
        this.tradeFeeInXmrLabel = new Label();
        this.tradeFeeInXmrLabel.setMouseTransparent(true);
        this.tradeFeeInXmrLabel.setId("trade-fee-textfield");
        VBox vBox = new VBox();
        vBox.setSpacing(6.0);
        vBox.setMaxWidth(300.0);
        vBox.setAlignment(Pos.CENTER_LEFT);
        vBox.getChildren().addAll((Object[])new Node[]{this.tradeFeeInXmrLabel});
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{vBox});
        hBox.setMinHeight(47.0);
        hBox.setMaxHeight(hBox.getMinHeight());
        HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
        Tuple2<Label, VBox> tradeInputBox = this.getTradeInputBox(hBox, Res.get((String)"createOffer.tradeFee.description"));
        this.tradeFeeDescriptionLabel = (Label)tradeInputBox.first;
        return (VBox)tradeInputBox.second;
    }

    private void maybeShowExtraInfoPopup(Offer offer) {
        if (offer.getCombinedExtraInfo() != null && !offer.getCombinedExtraInfo().isEmpty() && !this.extraInfoPopupDisplayed) {
            this.extraInfoPopupDisplayed = true;
            UserThread.runAfter(() -> ((GenericMessageWindow)((GenericMessageWindow)((GenericMessageWindow)((GenericMessageWindow)((GenericMessageWindow)new GenericMessageWindow().preamble(Res.get((String)"payment.tradingRestrictions")).instruction(offer.getCombinedExtraInfo().trim())).actionButtonText(Res.get((String)"shared.iConfirm"))).closeButtonText(Res.get((String)"shared.close"))).width(1200.0)).onClose(() -> this.close(false))).show(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void maybeShowTakeOfferFromUnsignedAccountWarning(Offer offer) {
        if (((TakeOfferViewModel)this.model).isSellingToAnUnsignedAccount(offer) && !this.takeOfferFromUnsignedAccountWarningDisplayed) {
            this.takeOfferFromUnsignedAccountWarningDisplayed = true;
        }
    }

    private void maybeShowZelleWarning(PaymentAccount paymentAccount) {
        if (paymentAccount.getPaymentMethod().getId().equals("ZELLE") && !this.zelleWarningDisplayed) {
            this.zelleWarningDisplayed = true;
            UserThread.runAfter(GUIUtil::showZelleWarning, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void maybeShowFasterPaymentsWarning(PaymentAccount paymentAccount) {
        if (paymentAccount.getPaymentMethod().getId().equals("FASTER_PAYMENTS") && ((FasterPaymentsAccount)paymentAccount).getHolderName().isEmpty() && !this.fasterPaymentsWarningDisplayed) {
            this.fasterPaymentsWarningDisplayed = true;
            UserThread.runAfter(() -> GUIUtil.showFasterPaymentsWarning(this.navigation), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void maybeShowAccountWarning(PaymentAccount paymentAccount, boolean isBuyer) {
        String msgKey = paymentAccount.getPreTradeMessage(!isBuyer);
        OfferViewUtil.showPaymentAccountWarning(msgKey, this.paymentAccountWarningDisplayed);
    }

    private Tuple2<Label, VBox> getTradeInputBox(HBox amountValueBox, String promptText) {
        AutoTooltipLabel descriptionLabel = new AutoTooltipLabel(promptText);
        descriptionLabel.setId("input-description-label");
        descriptionLabel.setPrefWidth(170.0);
        VBox box = new VBox();
        box.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        box.setSpacing(2.0);
        box.getChildren().addAll((Object[])new Node[]{descriptionLabel, amountValueBox});
        return new Tuple2((Object)descriptionLabel, (Object)box);
    }

    private GridPane createInfoPopover() {
        GridPane infoGridPane = new GridPane();
        infoGridPane.setHgap(5.0);
        infoGridPane.setVgap(5.0);
        infoGridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        int i = 0;
        if (((TakeOfferViewModel)this.model).isSeller()) {
            OfferViewUtil.addPayInfoEntry(infoGridPane, i++, Res.get((String)"takeOffer.fundsBox.tradeAmount"), ((TakeOfferViewModel)this.model).getTradeAmount());
        }
        OfferViewUtil.addPayInfoEntry(infoGridPane, i++, Res.getWithCol((String)"shared.yourSecurityDeposit"), ((TakeOfferViewModel)this.model).getSecurityDepositInfo());
        OfferViewUtil.addPayInfoEntry(infoGridPane, i++, Res.get((String)"takeOffer.fundsBox.offerFee"), ((TakeOfferViewModel)this.model).getTradeFee());
        Separator separator = new Separator();
        separator.setOrientation(Orientation.HORIZONTAL);
        separator.getStyleClass().add((Object)"offer-separator");
        GridPane.setConstraints((Node)separator, (int)1, (int)i++);
        infoGridPane.getChildren().add((Object)separator);
        OfferViewUtil.addPayInfoEntry(infoGridPane, i, Res.getWithCol((String)"shared.total"), ((TakeOfferViewModel)this.model).getTotalToPayInfo());
        return infoGridPane;
    }

    @NotNull
    private String getTakeOfferLabel(Offer offer, boolean isBuyOffer) {
        return Res.get((String)(isBuyOffer ? "takeOffer.takeOfferButton.sell" : "takeOffer.takeOfferButton.buy"), (Object[])new Object[]{offer.getCounterCurrencyCode()});
    }
}

