/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.takeoffer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.filter.FilterManager;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferUtil;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.TradeManager;
import haveno.core.trade.handlers.TradeResultHandler;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinUtil;
import haveno.core.xmr.listeners.XmrBalanceListener;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.OfferDataModel;
import haveno.desktop.main.offer.offerbook.OfferBook;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

class TakeOfferDataModel
extends OfferDataModel {
    private final TradeManager tradeManager;
    private final OfferBook offerBook;
    private final User user;
    private final FilterManager filterManager;
    final Preferences preferences;
    private final PriceFeedService priceFeedService;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final Navigation navigation;
    private final P2PService p2PService;
    private BigInteger securityDeposit;
    private Offer offer;
    private final ObjectProperty<BigInteger> amount = new SimpleObjectProperty();
    final ObjectProperty<Volume> volume = new SimpleObjectProperty();
    private XmrBalanceListener balanceListener;
    private PaymentAccount paymentAccount;
    private boolean isTabSelected;
    protected boolean allowAmountUpdate = true;
    Price tradePrice;
    private final Predicate<Price> isNonZeroPrice = p -> p != null && !p.isZero();
    private final Predicate<ObjectProperty<Volume>> isNonZeroVolume = v -> v.get() != null && !((Volume)v.get()).isZero();

    @Inject
    TakeOfferDataModel(TradeManager tradeManager, OfferBook offerBook, OfferUtil offerUtil, XmrWalletService xmrWalletService, User user, FilterManager filterManager, Preferences preferences, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, P2PService p2PService) {
        super(xmrWalletService, offerUtil);
        this.tradeManager = tradeManager;
        this.offerBook = offerBook;
        this.user = user;
        this.filterManager = filterManager;
        this.preferences = preferences;
        this.priceFeedService = priceFeedService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.navigation = navigation;
        this.p2PService = p2PService;
    }

    @Override
    protected void activate() {
        this.offer.setState(Offer.State.UNKNOWN);
        this.addListeners();
        this.updateBalances();
        if (this.isTabSelected) {
            this.priceFeedService.setCurrencyCode(this.offer.getCounterCurrencyCode());
        }
        if (this.canTakeOffer()) {
            this.tradeManager.checkOfferAvailability(this.offer, false, this.paymentAccount.getId(), (BigInteger)this.amount.get(), () -> {}, errorMessage -> {
                this.log.warn(errorMessage);
                if (this.offer.getState() != Offer.State.NOT_AVAILABLE && this.offer.getState() != Offer.State.INVALID) {
                    ((Popup)new Popup().warning(errorMessage)).show();
                }
            });
        }
    }

    @Override
    protected void deactivate() {
        this.removeListeners();
        if (this.offer != null) {
            this.offer.cancelAvailabilityRequest();
        }
    }

    void initWithData(Offer offer) {
        this.offer = offer;
        this.tradePrice = offer.getPrice();
        this.addressEntry = this.xmrWalletService.getOrCreateAddressEntry(offer.getId(), XmrAddressEntry.Context.OFFER_FUNDING);
        Preconditions.checkNotNull((Object)this.addressEntry, (Object)"addressEntry must not be null");
        ObservableList<PaymentAccount> possiblePaymentAccounts = this.getPossiblePaymentAccounts();
        Preconditions.checkArgument((!possiblePaymentAccounts.isEmpty() ? 1 : 0) != 0, (Object)"possiblePaymentAccounts.isEmpty()");
        this.paymentAccount = this.getLastSelectedPaymentAccount();
        this.amount.set((Object)this.getMaxTradeLimit());
        this.updateSecurityDeposit();
        this.calculateVolume();
        this.calculateTotalToPay();
        this.balanceListener = new XmrBalanceListener(this.addressEntry.getSubaddressIndex()){

            public void onBalanceChanged(BigInteger balance) {
                TakeOfferDataModel.this.updateBalances();
            }
        };
        offer.resetState();
        this.priceFeedService.setCurrencyCode(offer.getCounterCurrencyCode());
    }

    void onShowPayFundsScreen() {
        this.calculateTotalToPay();
    }

    void onTabSelected(boolean isSelected) {
        this.isTabSelected = isSelected;
        if (this.isTabSelected) {
            this.priceFeedService.setCurrencyCode(this.offer.getCounterCurrencyCode());
        }
    }

    public void onClose(boolean removeOffer) {
        if (removeOffer) {
            this.offerBook.removeOffer((Offer)Preconditions.checkNotNull((Object)this.offer));
        }
        ThreadUtils.submitToPool(() -> this.xmrWalletService.resetAddressEntriesForOpenOffer(this.offer.getId()));
    }

    @Override
    protected void updateBalances() {
        super.updateBalances();
        UserThread.await(() -> {
            this.missingCoin.set((Object)this.offerUtil.getBalanceShortage((BigInteger)this.totalToPay.get(), (BigInteger)this.balance.get()));
            this.isXmrWalletFunded.set(this.offerUtil.isBalanceSufficient((BigInteger)this.totalToPay.get(), (BigInteger)this.availableBalance.get()));
            if (this.totalToPay.get() != null && this.isXmrWalletFunded.get() && !this.showWalletFundedNotification.get()) {
                this.showWalletFundedNotification.set(true);
            }
        });
    }

    void onTakeOffer(TradeResultHandler tradeResultHandler, ErrorMessageHandler errorMessageHandler) {
        Preconditions.checkNotNull((Object)this.getTakerFee(), (Object)"takerFee must not be null");
        BigInteger fundsNeededForTrade = this.getFundsNeededForTrade();
        if (this.isBuyOffer()) {
            fundsNeededForTrade = fundsNeededForTrade.add((BigInteger)this.amount.get());
        }
        String errorMsg = null;
        if (this.filterManager.isCurrencyBanned(this.offer.getCounterCurrencyCode())) {
            errorMsg = Res.get((String)"offerbook.warning.currencyBanned");
        } else if (this.filterManager.isPaymentMethodBanned(this.offer.getPaymentMethod())) {
            errorMsg = Res.get((String)"offerbook.warning.paymentMethodBanned");
        } else if (this.filterManager.isOfferIdBanned(this.offer.getId())) {
            errorMsg = Res.get((String)"offerbook.warning.offerBlocked");
        } else if (this.filterManager.isNodeAddressBanned(this.offer.getMakerNodeAddress())) {
            errorMsg = Res.get((String)"offerbook.warning.nodeBlocked");
        } else if (this.filterManager.requireUpdateToNewVersionForTrading()) {
            errorMsg = Res.get((String)"offerbook.warning.requireUpdateToNewVersion");
        } else if (this.tradeManager.wasOfferAlreadyUsedInTrade(this.offer.getId())) {
            errorMsg = Res.get((String)"offerbook.warning.offerWasAlreadyUsedInTrade");
        } else {
            this.tradeManager.onTakeOffer((BigInteger)this.amount.get(), fundsNeededForTrade, this.offer, this.paymentAccount.getId(), this.useSavingsWallet, false, tradeResultHandler, errorMessage -> {
                this.log.warn(errorMessage);
                errorMessageHandler.handleErrorMessage(errorMessage);
            });
        }
        if (errorMsg != null) {
            ((Popup)new Popup().warning(errorMsg)).show();
            this.log.warn("Error taking offer " + this.offer.getId() + ": " + errorMsg);
            errorMessageHandler.handleErrorMessage(errorMsg);
        }
    }

    public void onPaymentAccountSelected(PaymentAccount paymentAccount) {
        if (paymentAccount != null) {
            this.paymentAccount = paymentAccount;
            this.amount.set((Object)this.getMaxTradeLimit());
            this.preferences.setTakeOfferSelectedPaymentAccountId(paymentAccount.getId());
        }
    }

    void fundFromSavingsWallet() {
        this.useSavingsWallet = true;
        this.updateBalances();
    }

    OfferDirection getDirection() {
        return this.offer.getDirection();
    }

    public Offer getOffer() {
        return this.offer;
    }

    ReadOnlyObjectProperty<Volume> getVolume() {
        return this.volume;
    }

    ObservableList<PaymentAccount> getPossiblePaymentAccounts() {
        Set paymentAccounts = this.user.getPaymentAccounts();
        Preconditions.checkNotNull((Object)paymentAccounts, (Object)"paymentAccounts must not be null");
        return PaymentAccountUtil.getPossiblePaymentAccounts((Offer)this.offer, (Set)paymentAccounts, (AccountAgeWitnessService)this.accountAgeWitnessService);
    }

    public PaymentAccount getLastSelectedPaymentAccount() {
        ObservableList<PaymentAccount> possiblePaymentAccounts = this.getPossiblePaymentAccounts();
        Preconditions.checkArgument((!possiblePaymentAccounts.isEmpty() ? 1 : 0) != 0, (Object)"possiblePaymentAccounts must not be empty");
        PaymentAccount firstItem = (PaymentAccount)possiblePaymentAccounts.get(0);
        String id = this.preferences.getTakeOfferSelectedPaymentAccountId();
        if (id == null) {
            return firstItem;
        }
        return possiblePaymentAccounts.stream().filter(e -> e.getId().equals(id)).findAny().orElse(firstItem);
    }

    BigInteger getMyMaxTradeLimit() {
        if (this.paymentAccount != null) {
            return BigInteger.valueOf(this.accountAgeWitnessService.getMyTradeLimit(this.paymentAccount, this.getCurrencyCode(), this.offer.getMirroredDirection(), this.offer.hasBuyerAsTakerWithoutDeposit()));
        }
        return BigInteger.ZERO;
    }

    BigInteger getMaxTradeLimit() {
        return this.offer.getAmount().min(this.getMyMaxTradeLimit());
    }

    boolean canTakeOffer() {
        return GUIUtil.canCreateOrTakeOfferOrShowPopup(this.user, this.navigation) && GUIUtil.isBootstrappedOrShowPopup(this.p2PService);
    }

    private void addListeners() {
        this.xmrWalletService.addBalanceListener(this.balanceListener);
    }

    private void removeListeners() {
        this.xmrWalletService.removeBalanceListener(this.balanceListener);
    }

    void calculateVolume() {
        if (this.tradePrice != null && this.offer != null && this.amount.get() != null && ((BigInteger)this.amount.get()).compareTo(BigInteger.ZERO) != 0) {
            Volume volumeByAmount = this.tradePrice.getVolumeByAmount((BigInteger)this.amount.get());
            volumeByAmount = VolumeUtil.getAdjustedVolume((Volume)volumeByAmount, (String)this.offer.getPaymentMethod().getId());
            this.volume.set((Object)volumeByAmount);
            this.updateBalances();
        }
    }

    void calculateAmount() {
        if (this.isNonZeroPrice.test(this.tradePrice) && this.isNonZeroVolume.test(this.volume) && this.allowAmountUpdate) {
            try {
                Volume volumeBefore = (Volume)this.volume.get();
                this.calculateVolume();
                if (this.amount.get() == null || !volumeBefore.equals((Object)this.tradePrice.getVolumeByAmount((BigInteger)this.amount.get()))) {
                    BigInteger value = this.tradePrice.getAmountByVolume(volumeBefore);
                    value = value.min(this.offer.getAmount());
                    value = value.max(this.offer.getMinAmount());
                    value = CoinUtil.getRoundedAmount((BigInteger)value, (Price)this.tradePrice, (BigInteger)this.offer.getMinAmount(), (BigInteger)this.getMaxTradeLimit(), (String)this.offer.getCounterCurrencyCode(), (String)this.paymentAccount.getPaymentMethod().getId());
                    this.amount.set((Object)value);
                }
                this.calculateTotalToPay();
            }
            catch (Throwable t) {
                this.log.error(t.toString());
            }
        }
    }

    protected void setVolume(Volume volume) {
        this.volume.set((Object)volume);
    }

    void maybeApplyAmount(BigInteger amount) {
        if (amount.compareTo(this.offer.getMinAmount()) >= 0 && amount.compareTo(this.getMaxTradeLimit()) <= 0) {
            this.amount.set((Object)amount);
        }
        this.calculateTotalToPay();
    }

    void calculateTotalToPay() {
        this.updateSecurityDeposit();
        BigInteger takerFee = this.getTakerFee();
        if (this.offer != null && this.amount.get() != null && takerFee != null) {
            BigInteger feeAndSecDeposit = this.securityDeposit.add(takerFee);
            if (this.isBuyOffer()) {
                this.totalToPay.set((Object)feeAndSecDeposit.add((BigInteger)this.amount.get()));
            } else {
                this.totalToPay.set((Object)feeAndSecDeposit);
            }
            this.updateBalances();
            this.log.debug("totalToPay {}", this.totalToPay.get());
        }
    }

    boolean isBuyOffer() {
        return this.getDirection() == OfferDirection.BUY;
    }

    boolean isSellOffer() {
        return this.getDirection() == OfferDirection.SELL;
    }

    boolean isCryptoCurrency() {
        return CurrencyUtil.isCryptoCurrency((String)this.getCurrencyCode());
    }

    @Nullable
    BigInteger getTakerFee() {
        return HavenoUtils.multiply((BigInteger)((BigInteger)this.amount.get()), (double)this.offer.getTakerFeePct());
    }

    public void swapTradeToSavings() {
        this.log.debug("swapTradeToSavings, offerId={}", (Object)this.offer.getId());
        this.xmrWalletService.resetAddressEntriesForOpenOffer(this.offer.getId());
    }

    boolean isMinAmountLessOrEqualAmount() {
        if (this.offer != null && this.amount.get() != null) {
            return this.offer.getMinAmount().compareTo((BigInteger)this.amount.get()) <= 0;
        }
        return true;
    }

    boolean isAmountLargerThanOfferAmount() {
        if (this.amount.get() != null && this.offer != null) {
            return ((BigInteger)this.amount.get()).compareTo(this.offer.getAmount()) > 0;
        }
        return true;
    }

    boolean wouldCreateDustForMaker() {
        return false;
    }

    ReadOnlyObjectProperty<BigInteger> getAmount() {
        return this.amount;
    }

    public PaymentMethod getPaymentMethod() {
        return this.offer.getPaymentMethod();
    }

    public String getCurrencyCode() {
        return this.offer.getCounterCurrencyCode();
    }

    public String getCurrencyNameAndCode() {
        return CurrencyUtil.getNameByCode((String)this.offer.getCounterCurrencyCode());
    }

    @NotNull
    private BigInteger getFundsNeededForTrade() {
        return this.getSecurityDeposit();
    }

    public XmrAddressEntry getAddressEntry() {
        return this.addressEntry;
    }

    public BigInteger getSecurityDeposit() {
        return this.securityDeposit;
    }

    private void updateSecurityDeposit() {
        this.securityDeposit = this.offer.getDirection() == OfferDirection.SELL ? this.getBuyerSecurityDeposit() : this.getSellerSecurityDeposit();
    }

    private BigInteger getBuyerSecurityDeposit() {
        return this.offer.getOfferPayload().getBuyerSecurityDepositForTradeAmount((BigInteger)this.amount.get());
    }

    private BigInteger getSellerSecurityDeposit() {
        return this.offer.getOfferPayload().getSellerSecurityDepositForTradeAmount((BigInteger)this.amount.get());
    }

    public boolean isRoundedForAtmCash() {
        return PaymentMethod.isRoundedForAtmCash((String)this.paymentAccount.getPaymentMethod().getId());
    }
}

