/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.signedoffer;

import com.google.inject.Inject;
import haveno.core.offer.OpenOfferManager;
import haveno.core.offer.SignedOffer;
import haveno.desktop.common.model.ActivatableDataModel;
import haveno.desktop.main.offer.signedoffer.SignedOfferListItem;
import java.sql.Date;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

class SignedOffersDataModel
extends ActivatableDataModel {
    private final OpenOfferManager openOfferManager;
    private final ObservableList<SignedOfferListItem> list = FXCollections.observableArrayList();
    private final ListChangeListener<SignedOffer> tradesListChangeListener;

    @Inject
    public SignedOffersDataModel(OpenOfferManager openOfferManager) {
        this.openOfferManager = openOfferManager;
        this.tradesListChangeListener = change -> this.applyList();
    }

    @Override
    protected void activate() {
        this.openOfferManager.getObservableSignedOffersList().addListener(this.tradesListChangeListener);
        this.applyList();
    }

    @Override
    protected void deactivate() {
        this.openOfferManager.getObservableSignedOffersList().removeListener(this.tradesListChangeListener);
    }

    public ObservableList<SignedOfferListItem> getList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyList() {
        this.list.clear();
        ObservableList observableList = this.openOfferManager.getObservableSignedOffersList();
        synchronized (observableList) {
            this.list.addAll((Collection)this.openOfferManager.getObservableSignedOffersList().stream().map(SignedOfferListItem::new).collect(Collectors.toList()));
        }
        this.list.sort((o1, o2) -> new Date(o2.getSignedOffer().getTimeStamp()).compareTo(new Date(o1.getSignedOffer().getTimeStamp())));
    }
}

