/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.signedoffer;

import com.google.inject.Inject;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.offer.SignedOffer;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.list.FilterBox;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.offer.signedoffer.SignedOfferListItem;
import haveno.desktop.main.offer.signedoffer.SignedOffersViewModel;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.filtering.FilterableListItem;
import java.util.Comparator;
import java.util.Date;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;

@FxmlView
public class SignedOfferView
extends ActivatableViewAndModel<VBox, SignedOffersViewModel> {
    @FXML
    FilterBox filterBox;
    @FXML
    protected TableView<SignedOfferListItem> tableView;
    @FXML
    TableColumn<SignedOfferListItem, SignedOfferListItem> dateColumn;
    @FXML
    TableColumn<SignedOfferListItem, SignedOfferListItem> traderIdColumn;
    @FXML
    TableColumn<SignedOfferListItem, SignedOfferListItem> offerIdColumn;
    @FXML
    TableColumn<SignedOfferListItem, SignedOfferListItem> reserveTxKeyImages;
    @FXML
    TableColumn<SignedOfferListItem, SignedOfferListItem> makerPenaltyFeeColumn;
    @FXML
    InputTextField filterTextField;
    @FXML
    Label numItems;
    @FXML
    Region footerSpacer;
    private SignedOfferListItem selectedSignedOffer;
    private final XmrWalletService xmrWalletService;
    private ContextMenu contextMenu;

    @Inject
    public SignedOfferView(SignedOffersViewModel model, XmrWalletService xmrWalletService) {
        super(model);
        this.xmrWalletService = xmrWalletService;
    }

    @Override
    public void initialize() {
        this.filterTextField = new InputTextField();
        Tooltip tooltip = new Tooltip();
        tooltip.setShowDelay(Duration.millis((double)100.0));
        tooltip.setShowDuration(Duration.seconds((double)10.0));
        this.filterTextField.setTooltip(tooltip);
        HBox.setHgrow((Node)this.filterTextField, (Priority)Priority.NEVER);
        this.filterTextField.setText("open");
        this.setupTable();
    }

    @Override
    protected void activate() {
        FilteredList filteredList = new FilteredList(((SignedOffersViewModel)this.model).getList());
        SortedList sortedList = new SortedList((ObservableList)filteredList);
        sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems((ObservableList)sortedList);
        this.filterBox.initialize((FilteredList<? extends FilterableListItem>)filteredList, this.tableView);
        this.filterBox.setPromptText(Res.get((String)"shared.filter"));
        this.filterBox.activate();
        this.contextMenu = new ContextMenu();
        MenuItem makerPenalization = new MenuItem(Res.get((String)"support.contextmenu.penalize.msg", (Object[])new Object[]{Res.get((String)"shared.maker").toLowerCase()}));
        MenuItem copyToClipboard = new MenuItem(Res.get((String)"shared.copyToClipboard"));
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{makerPenalization, copyToClipboard});
        this.tableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnContextMenuRequested(event -> this.contextMenu.show((Node)row, event.getScreenX(), event.getScreenY()));
            return row;
        });
        copyToClipboard.setOnAction(event -> {
            this.selectedSignedOffer = (SignedOfferListItem)this.tableView.getSelectionModel().getSelectedItem();
            Utilities.copyToClipboard((String)this.selectedSignedOffer.getSignedOffer().toJson());
        });
        makerPenalization.setOnAction(event -> {
            this.selectedSignedOffer = (SignedOfferListItem)this.tableView.getSelectionModel().getSelectedItem();
            if (this.selectedSignedOffer != null) {
                SignedOffer signedOffer = this.selectedSignedOffer.getSignedOffer();
                ((Popup)((Popup)new Popup().warning(Res.get((String)"support.prompt.signedOffer.penalty.msg", (Object[])new Object[]{signedOffer.getOfferId(), HavenoUtils.formatXmr((long)signedOffer.getPenaltyAmount(), (boolean)true), HavenoUtils.formatXmr((long)signedOffer.getReserveTxMinerFee(), (boolean)true), signedOffer.getReserveTxHash(), signedOffer.getReserveTxKeyImages()}))).onAction(() -> OfferViewUtil.submitTransactionHex(this.xmrWalletService, this.tableView, signedOffer.getReserveTxHex()))).show();
            } else {
                ((Popup)new Popup().error(Res.get((String)"support.prompt.signedOffer.error.msg"))).show();
            }
        });
        GUIUtil.requestFocus(this.tableView);
    }

    @Override
    protected void deactivate() {
        this.filterBox.deactivate();
    }

    protected void setupTable() {
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"support.noTickets"));
        placeholder.setWrapText(true);
        this.tableView.setPlaceholder((Node)placeholder);
        this.tableView.getSelectionModel().clearSelection();
        this.dateColumn = this.getDateColumn();
        this.tableView.getColumns().add(this.dateColumn);
        this.traderIdColumn = this.getTraderIdColumn();
        this.tableView.getColumns().add(this.traderIdColumn);
        this.offerIdColumn = this.getOfferIdColumn();
        this.tableView.getColumns().add(this.offerIdColumn);
        this.makerPenaltyFeeColumn = this.getMakerPenaltyFeeColumn();
        this.tableView.getColumns().add(this.makerPenaltyFeeColumn);
        this.reserveTxKeyImages = this.getReserveTxKeyImagesColumn();
        this.tableView.getColumns().add(this.reserveTxKeyImages);
        this.traderIdColumn.setComparator(Comparator.comparing(o -> o.getSignedOffer().getTraderId()));
        this.offerIdColumn.setComparator(Comparator.comparing(o -> o.getSignedOffer().getOfferId()));
        this.dateColumn.setComparator(Comparator.comparing(o -> o.getSignedOffer().getTimeStamp()));
        this.dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(this.dateColumn);
    }

    private TableColumn<SignedOfferListItem, SignedOfferListItem> getDateColumn() {
        AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem> column = new AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem>(this, Res.get((String)"shared.date")){
            {
                this.setMinWidth(180.0);
            }
        };
        column.setCellValueFactory(signedOffer -> new ReadOnlyObjectWrapper((Object)((SignedOfferListItem)signedOffer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SignedOfferListItem, SignedOfferListItem>, TableCell<SignedOfferListItem, SignedOfferListItem>>(this){

            public TableCell<SignedOfferListItem, SignedOfferListItem> call(TableColumn<SignedOfferListItem, SignedOfferListItem> column) {
                return new TableCell<SignedOfferListItem, SignedOfferListItem>(this){

                    public void updateItem(SignedOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(DisplayUtils.formatDateTime(new Date(item.getSignedOffer().getTimeStamp())));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SignedOfferListItem, SignedOfferListItem> getTraderIdColumn() {
        AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem> column = new AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem>(this, Res.get((String)"shared.traderId")){
            {
                this.setMinWidth(110.0);
            }
        };
        column.setCellValueFactory(signedOffer -> new ReadOnlyObjectWrapper((Object)((SignedOfferListItem)signedOffer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SignedOfferListItem, SignedOfferListItem>, TableCell<SignedOfferListItem, SignedOfferListItem>>(this){

            public TableCell<SignedOfferListItem, SignedOfferListItem> call(TableColumn<SignedOfferListItem, SignedOfferListItem> column) {
                return new TableCell<SignedOfferListItem, SignedOfferListItem>(this){
                    private HyperlinkWithIcon field;

                    public void updateItem(SignedOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(String.valueOf(item.getSignedOffer().getTraderId()));
                            this.setGraphic((Node)this.field);
                        } else {
                            this.setGraphic(null);
                            this.setText("");
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SignedOfferListItem, SignedOfferListItem> getOfferIdColumn() {
        AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem> column = new AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem>(this, Res.get((String)"shared.offerId")){
            {
                this.setMinWidth(110.0);
            }
        };
        column.setCellValueFactory(signedOffer -> new ReadOnlyObjectWrapper((Object)((SignedOfferListItem)signedOffer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SignedOfferListItem, SignedOfferListItem>, TableCell<SignedOfferListItem, SignedOfferListItem>>(this){

            public TableCell<SignedOfferListItem, SignedOfferListItem> call(TableColumn<SignedOfferListItem, SignedOfferListItem> column) {
                return new TableCell<SignedOfferListItem, SignedOfferListItem>(this){
                    private HyperlinkWithIcon field;

                    public void updateItem(SignedOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(String.valueOf(item.getSignedOffer().getOfferId()));
                            this.setGraphic((Node)this.field);
                        } else {
                            this.setGraphic(null);
                            this.setText("");
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SignedOfferListItem, SignedOfferListItem> getMakerPenaltyFeeColumn() {
        AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem> column = new AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem>(this, Res.get((String)"support.maker.penalty.fee")){
            {
                this.setMinWidth(160.0);
            }
        };
        column.setCellValueFactory(signedOffer -> new ReadOnlyObjectWrapper((Object)((SignedOfferListItem)signedOffer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SignedOfferListItem, SignedOfferListItem>, TableCell<SignedOfferListItem, SignedOfferListItem>>(this){

            public TableCell<SignedOfferListItem, SignedOfferListItem> call(TableColumn<SignedOfferListItem, SignedOfferListItem> column) {
                return new TableCell<SignedOfferListItem, SignedOfferListItem>(this){

                    public void updateItem(SignedOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(HavenoUtils.formatXmr((long)item.getSignedOffer().getPenaltyAmount(), (boolean)true));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<SignedOfferListItem, SignedOfferListItem> getReserveTxKeyImagesColumn() {
        AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem> column = new AutoTooltipTableColumn<SignedOfferListItem, SignedOfferListItem>(this, Res.get((String)"support.txKeyImages")){
            {
                this.setMinWidth(160.0);
            }
        };
        column.setCellValueFactory(signedOffer -> new ReadOnlyObjectWrapper((Object)((SignedOfferListItem)signedOffer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<SignedOfferListItem, SignedOfferListItem>, TableCell<SignedOfferListItem, SignedOfferListItem>>(this){

            public TableCell<SignedOfferListItem, SignedOfferListItem> call(TableColumn<SignedOfferListItem, SignedOfferListItem> column) {
                return new TableCell<SignedOfferListItem, SignedOfferListItem>(this){

                    public void updateItem(SignedOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(item.getSignedOffer().getReserveTxKeyImages().toString());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }
}

