/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.offerbook;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.api.CoreApi;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferFilterService;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.PriceUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.offerbook.OfferBook;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.main.offer.offerbook.OfferBookViewModel;
import haveno.network.p2p.P2PService;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jetbrains.annotations.NotNull;

public class OtherOfferBookViewModel
extends OfferBookViewModel {
    @Inject
    public OtherOfferBookViewModel(User user, OpenOfferManager openOfferManager, OfferBook offerBook, Preferences preferences, WalletsSetup walletsSetup, P2PService p2PService, PriceFeedService priceFeedService, ClosedTradableManager closedTradableManager, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, PriceUtil priceUtil, OfferFilterService offerFilterService, @Named(value="BTC") CoinFormatter btcFormatter, CoreApi coreApi) {
        super(user, openOfferManager, offerBook, preferences, walletsSetup, p2PService, priceFeedService, closedTradableManager, accountAgeWitnessService, navigation, priceUtil, offerFilterService, btcFormatter, coreApi);
    }

    @Override
    void saveSelectedCurrencyCodeInPreferences(OfferDirection direction, String code) {
        if (direction == OfferDirection.BUY) {
            this.preferences.setBuyScreenOtherCurrencyCode(code);
        } else {
            this.preferences.setBuyScreenOtherCurrencyCode(code);
        }
    }

    @Override
    protected ObservableList<PaymentMethod> filterPaymentMethods(ObservableList<PaymentMethod> list, TradeCurrency selectedTradeCurrency) {
        return FXCollections.observableArrayList((Collection)list.stream().filter(paymentMethod -> {
            if (paymentMethod.getSupportedAssetCodes() == null) {
                return true;
            }
            for (String assetCode : paymentMethod.getSupportedAssetCodes()) {
                if (CurrencyUtil.isFiatCurrency((String)assetCode)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList()));
    }

    @Override
    void fillCurrencies(ObservableList<TradeCurrency> tradeCurrencies, ObservableList<TradeCurrency> allCurrencies) {
        tradeCurrencies.add((Object)new CryptoCurrency("list.currency.showAll", ""));
        tradeCurrencies.addAll((Collection)CurrencyUtil.getMainTraditionalCurrencies().stream().filter(this.withoutFiatCurrency()).collect(Collectors.toList()));
        tradeCurrencies.add((Object)new CryptoCurrency("list.currency.editList", ""));
        allCurrencies.add((Object)new CryptoCurrency("list.currency.showAll", ""));
        allCurrencies.addAll((Collection)CurrencyUtil.getMainTraditionalCurrencies().stream().filter(this.withoutFiatCurrency()).collect(Collectors.toList()));
        allCurrencies.add((Object)new CryptoCurrency("list.currency.editList", ""));
    }

    @Override
    Predicate<OfferBookListItem> getCurrencyAndMethodPredicate(OfferDirection direction, TradeCurrency selectedTradeCurrency) {
        return offerBookListItem -> {
            Offer offer = offerBookListItem.getOffer();
            boolean directionResult = offer.getDirection() != direction;
            boolean currencyResult = CurrencyUtil.isTraditionalCurrency((String)offer.getCounterCurrencyCode()) && !CurrencyUtil.isFiatCurrency((String)offer.getCounterCurrencyCode()) && (this.showAllTradeCurrenciesProperty.get() || offer.getCounterCurrencyCode().equals(selectedTradeCurrency.getCode()));
            boolean paymentMethodResult = this.showAllPaymentMethods || offer.getPaymentMethod().equals((Object)this.selectedPaymentMethod);
            boolean notMyOfferOrShowMyOffersActivated = !this.isMyOffer(offerBookListItem.getOffer()) || this.preferences.isShowOwnOffersInOfferBook();
            return directionResult && currencyResult && paymentMethodResult && notMyOfferOrShowMyOffersActivated;
        };
    }

    @Override
    TradeCurrency getDefaultTradeCurrency() {
        TradeCurrency defaultTradeCurrency = GlobalSettings.getDefaultTradeCurrency();
        if (CurrencyUtil.isTraditionalCurrency((String)defaultTradeCurrency.getCode()) && !CurrencyUtil.isFiatCurrency((String)defaultTradeCurrency.getCode()) && this.hasPaymentAccountForCurrency(defaultTradeCurrency)) {
            return defaultTradeCurrency;
        }
        ObservableList tradeCurrencies = FXCollections.observableArrayList((Collection)this.getTradeCurrencies());
        if (!tradeCurrencies.isEmpty()) {
            tradeCurrencies.remove(0);
            List sortedList = tradeCurrencies.stream().sorted((o1, o2) -> Boolean.compare(!this.hasPaymentAccountForCurrency((TradeCurrency)o1), !this.hasPaymentAccountForCurrency((TradeCurrency)o2))).collect(Collectors.toList());
            return (TradeCurrency)sortedList.get(0);
        }
        return (TradeCurrency)CurrencyUtil.getMainTraditionalCurrencies().stream().filter(this.withoutFiatCurrency()).sorted((o1, o2) -> Boolean.compare(!this.hasPaymentAccountForCurrency((TradeCurrency)o1), !this.hasPaymentAccountForCurrency((TradeCurrency)o2))).collect(Collectors.toList()).get(0);
    }

    @Override
    String getCurrencyCodeFromPreferences(OfferDirection direction) {
        String currencyCode = direction == OfferDirection.BUY ? this.preferences.getBuyScreenOtherCurrencyCode() : this.preferences.getSellScreenOtherCurrencyCode();
        return CurrencyUtil.isTraditionalCurrency((String)currencyCode) ? currencyCode : null;
    }

    @NotNull
    private Predicate<TraditionalCurrency> withoutFiatCurrency() {
        return fiatCurrency -> !CurrencyUtil.isFiatCurrency((String)fiatCurrency.getCode());
    }
}

