/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.offerbook;

import com.google.common.base.Joiner;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.api.CoreApi;
import haveno.core.locale.BankUtil;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferFilterService;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.desktop.Navigation;
import haveno.desktop.common.model.ActivatableViewModel;
import haveno.desktop.main.MainView;
import haveno.desktop.main.offer.OfferView;
import haveno.desktop.main.offer.offerbook.CryptoOfferBookViewModel;
import haveno.desktop.main.offer.offerbook.OfferBook;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.main.settings.SettingsView;
import haveno.desktop.main.settings.preferences.PreferencesView;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OfferBookViewModel
extends ActivatableViewModel {
    private static final Logger log = LoggerFactory.getLogger(OfferBookViewModel.class);
    private final OpenOfferManager openOfferManager;
    private final User user;
    private final OfferBook offerBook;
    final Preferences preferences;
    private final WalletsSetup walletsSetup;
    private final P2PService p2PService;
    final PriceFeedService priceFeedService;
    private final ClosedTradableManager closedTradableManager;
    final AccountAgeWitnessService accountAgeWitnessService;
    private final Navigation navigation;
    private final PriceUtil priceUtil;
    final OfferFilterService offerFilterService;
    private final CoinFormatter btcFormatter;
    private final FilteredList<OfferBookListItem> filteredItems;
    private final CoreApi coreApi;
    private final SortedList<OfferBookListItem> sortedItems;
    private final ListChangeListener<TradeCurrency> tradeCurrencyListChangeListener;
    private final ListChangeListener<OfferBookListItem> filterItemsListener;
    private TradeCurrency selectedTradeCurrency;
    private final ObservableList<TradeCurrency> tradeCurrencies = FXCollections.observableArrayList();
    private final ObservableList<TradeCurrency> allCurrencies = FXCollections.observableArrayList();
    private OfferDirection direction;
    final StringProperty tradeCurrencyCode = new SimpleStringProperty();
    private OfferView.OfferActionHandler offerActionHandler;
    PaymentMethod selectedPaymentMethod = this.getShowAllEntryForPaymentMethod();
    boolean isTabSelected;
    String filterText = "";
    final BooleanProperty showAllTradeCurrenciesProperty = new SimpleBooleanProperty(true);
    final BooleanProperty disableMatchToggle = new SimpleBooleanProperty();
    final IntegerProperty maxPlacesForAmount = new SimpleIntegerProperty();
    final IntegerProperty maxPlacesForVolume = new SimpleIntegerProperty();
    final IntegerProperty maxPlacesForPrice = new SimpleIntegerProperty();
    final IntegerProperty maxPlacesForMarketPriceMargin = new SimpleIntegerProperty();
    boolean showAllPaymentMethods = true;
    boolean useOffersMatchingMyAccountsFilter;
    boolean showPrivateOffers;

    public OfferBookViewModel(User user, OpenOfferManager openOfferManager, OfferBook offerBook, Preferences preferences, WalletsSetup walletsSetup, P2PService p2PService, PriceFeedService priceFeedService, ClosedTradableManager closedTradableManager, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, PriceUtil priceUtil, OfferFilterService offerFilterService, CoinFormatter btcFormatter, CoreApi coreApi) {
        this.openOfferManager = openOfferManager;
        this.user = user;
        this.offerBook = offerBook;
        this.preferences = preferences;
        this.walletsSetup = walletsSetup;
        this.p2PService = p2PService;
        this.priceFeedService = priceFeedService;
        this.closedTradableManager = closedTradableManager;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.navigation = navigation;
        this.priceUtil = priceUtil;
        this.offerFilterService = offerFilterService;
        this.btcFormatter = btcFormatter;
        this.filteredItems = new FilteredList(offerBook.getOfferBookListItems());
        this.coreApi = coreApi;
        this.sortedItems = new SortedList(this.filteredItems);
        this.tradeCurrencyListChangeListener = c -> this.fillCurrencies();
        this.filterItemsListener = c -> {
            Optional<OfferBookListItem> highestAmountOffer = this.filteredItems.stream().max(Comparator.comparingLong(o -> o.getOffer().getAmount().longValueExact()));
            boolean containsRangeAmount = this.filteredItems.stream().anyMatch(o -> o.getOffer().isRange());
            if (highestAmountOffer.isPresent()) {
                OfferBookListItem item = highestAmountOffer.get();
                if (!item.getOffer().isRange() && containsRangeAmount) {
                    this.maxPlacesForAmount.set(this.formatAmount(item.getOffer(), false).length() * 2 + " - ".length());
                    this.maxPlacesForVolume.set(this.formatVolume(item.getOffer(), false).length() * 2 + " - ".length());
                } else {
                    this.maxPlacesForAmount.set(this.formatAmount(item.getOffer(), false).length());
                    this.maxPlacesForVolume.set(this.formatVolume(item.getOffer(), false).length());
                }
            }
            Optional<OfferBookListItem> highestPriceOffer = this.filteredItems.stream().filter(o -> o.getOffer().getPrice() != null).max(Comparator.comparingLong(o -> o.getOffer().getPrice() != null ? o.getOffer().getPrice().getValue() : 0L));
            highestPriceOffer.ifPresent(offerBookListItem -> this.maxPlacesForPrice.set(this.formatPrice(offerBookListItem.getOffer(), false).length()));
            Optional<OfferBookListItem> highestMarketPriceMarginOffer = this.filteredItems.stream().filter(o -> o.getOffer().isUseMarketBasedPrice()).max(Comparator.comparing(o -> new DecimalFormat("#0.00").format(o.getOffer().getMarketPriceMarginPct() * 100.0).length()));
            highestMarketPriceMarginOffer.ifPresent(offerBookListItem -> this.maxPlacesForMarketPriceMargin.set(this.formatMarketPriceMarginPct(offerBookListItem.getOffer()).length()));
        };
    }

    @Override
    protected void activate() {
        this.filteredItems.addListener(this.filterItemsListener);
        if (this.user != null) {
            this.disableMatchToggle.set(this.user.getPaymentAccounts() == null || this.user.getPaymentAccounts().isEmpty());
        }
        this.useOffersMatchingMyAccountsFilter = !this.disableMatchToggle.get() && this.isShowOffersMatchingMyAccounts();
        this.showPrivateOffers = this.preferences.isShowPrivateOffers();
        this.fillCurrencies();
        this.updateSelectedTradeCurrency();
        this.preferences.getTradeCurrenciesAsObservable().addListener(this.tradeCurrencyListChangeListener);
        this.offerBook.fillOfferBookListItems();
        this.filterOffers();
        this.setMarketPriceFeedCurrency();
    }

    @Override
    protected void deactivate() {
        this.filteredItems.removeListener(this.filterItemsListener);
        this.preferences.getTradeCurrenciesAsObservable().removeListener(this.tradeCurrencyListChangeListener);
    }

    void initWithDirection(OfferDirection direction) {
        this.direction = direction;
    }

    void onTabSelected(boolean isSelected) {
        this.isTabSelected = isSelected;
        this.setMarketPriceFeedCurrency();
        if (this.isTabSelected) {
            this.updateSelectedTradeCurrency();
            this.filterOffers();
        }
    }

    void onSetTradeCurrency(TradeCurrency tradeCurrency) {
        if (tradeCurrency != null) {
            String code = tradeCurrency.getCode();
            boolean showAllEntry = this.isShowAllEntry(code);
            this.showAllTradeCurrenciesProperty.set(showAllEntry);
            if (this.isEditEntry(code)) {
                this.navigation.navigateTo(MainView.class, SettingsView.class, PreferencesView.class);
            } else if (showAllEntry) {
                this.selectedTradeCurrency = this.getDefaultTradeCurrency();
                this.tradeCurrencyCode.set((Object)this.selectedTradeCurrency.getCode());
            } else {
                this.selectedTradeCurrency = tradeCurrency;
                this.tradeCurrencyCode.set((Object)code);
            }
            this.setMarketPriceFeedCurrency();
            this.filterOffers();
            this.saveSelectedCurrencyCodeInPreferences(this.direction, code);
        }
    }

    void onFilterKeyTyped(String filterText) {
        this.filterText = filterText;
        this.filterOffers();
    }

    abstract void saveSelectedCurrencyCodeInPreferences(OfferDirection var1, String var2);

    protected void onSetPaymentMethod(PaymentMethod paymentMethod) {
        if (paymentMethod == null) {
            return;
        }
        this.showAllPaymentMethods = this.isShowAllEntry(paymentMethod.getId());
        if (!this.showAllPaymentMethods) {
            this.selectedPaymentMethod = paymentMethod;
            if (paymentMethod.getId().equals("TRANSFERWISE")) {
                this.onSetTradeCurrency((TradeCurrency)new CryptoCurrency("list.currency.showAll", ""));
            }
        } else {
            this.selectedPaymentMethod = this.getShowAllEntryForPaymentMethod();
        }
        this.filterOffers();
    }

    void onRemoveOpenOffer(Offer offer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.openOfferManager.removeOffer(offer, resultHandler, errorMessageHandler);
    }

    void onShowOffersMatchingMyAccounts(boolean isSelected) {
        this.useOffersMatchingMyAccountsFilter = isSelected;
        this.preferences.setShowOffersMatchingMyAccounts(this.useOffersMatchingMyAccountsFilter);
        this.filterOffers();
    }

    void onShowPrivateOffers(boolean isSelected) {
        this.showPrivateOffers = isSelected;
        this.preferences.setShowPrivateOffers(isSelected);
        this.filterOffers();
    }

    boolean isShowOffersMatchingMyAccounts() {
        return this.preferences.isShowOffersMatchingMyAccounts();
    }

    SortedList<OfferBookListItem> getOfferList() {
        return this.sortedItems;
    }

    Map<String, Integer> getBuyOfferCounts() {
        return this.offerBook.getBuyOfferCountMap();
    }

    Map<String, Integer> getSellOfferCounts() {
        return this.offerBook.getSellOfferCountMap();
    }

    boolean isMyOffer(Offer offer) {
        return this.openOfferManager.isMyOffer(offer);
    }

    OfferDirection getDirection() {
        return this.direction;
    }

    boolean isBootstrappedOrShowPopup() {
        return GUIUtil.isBootstrappedOrShowPopup(this.p2PService);
    }

    TradeCurrency getSelectedTradeCurrency() {
        return this.selectedTradeCurrency;
    }

    ObservableList<PaymentMethod> getPaymentMethods() {
        Set supportedPaymentMethods;
        ObservableList list = FXCollections.observableArrayList((Collection)PaymentMethod.paymentMethods);
        if (this.preferences.isHideNonAccountPaymentMethods() && this.user.getPaymentAccounts() != null && !(supportedPaymentMethods = this.user.getPaymentAccounts().stream().map(PaymentAccount::getPaymentMethod).collect(Collectors.toSet())).isEmpty()) {
            list = FXCollections.observableArrayList(supportedPaymentMethods);
        }
        list = this.filterPaymentMethods((ObservableList<PaymentMethod>)list, this.selectedTradeCurrency);
        list.sort(Comparator.naturalOrder());
        list.add(0, (Object)this.getShowAllEntryForPaymentMethod());
        return list;
    }

    protected abstract ObservableList<PaymentMethod> filterPaymentMethods(ObservableList<PaymentMethod> var1, TradeCurrency var2);

    String getAmount(OfferBookListItem item) {
        return this.formatAmount(item.getOffer(), true);
    }

    private String formatAmount(Offer offer, boolean decimalAligned) {
        return DisplayUtils.formatAmount(offer, 4, decimalAligned, this.maxPlacesForAmount.get(), this.btcFormatter);
    }

    String getPrice(OfferBookListItem item) {
        if (item == null) {
            return "";
        }
        Offer offer = item.getOffer();
        Price price = offer.getPrice();
        if (price != null) {
            return this.formatPrice(offer, true);
        }
        return Res.get((String)"shared.na");
    }

    String getAbsolutePriceMargin(Offer offer) {
        return FormattingUtils.formatPercentagePrice((double)Math.abs(offer.getMarketPriceMarginPct()));
    }

    private String formatPrice(Offer offer, boolean decimalAligned) {
        return DisplayUtils.formatPrice(offer.getPrice(), decimalAligned, this.maxPlacesForPrice.get());
    }

    String getPriceAsPercentage(OfferBookListItem item) {
        return this.getMarketBasedPrice(item.getOffer()).map(price -> "(" + FormattingUtils.formatPercentagePrice((double)price) + ")").orElse("");
    }

    public Optional<Double> getMarketBasedPrice(Offer offer) {
        return this.priceUtil.getMarketBasedPrice(offer, this.direction);
    }

    String formatMarketPriceMarginPct(Offer offer) {
        Object postFix = "";
        if (offer.isUseMarketBasedPrice()) {
            postFix = " (" + FormattingUtils.formatPercentagePrice((double)offer.getMarketPriceMarginPct()) + ")";
        }
        return postFix;
    }

    String getVolume(OfferBookListItem item) {
        return this.formatVolume(item.getOffer(), true);
    }

    String getVolumeAmount(OfferBookListItem item) {
        return this.formatVolume(item.getOffer(), true, false);
    }

    private String formatVolume(Offer offer, boolean decimalAligned) {
        return this.formatVolume(offer, decimalAligned, this.showAllTradeCurrenciesProperty.get());
    }

    private String formatVolume(Offer offer, boolean decimalAligned, boolean appendCurrencyCode) {
        Volume offerVolume = offer.getVolume();
        Volume minOfferVolume = offer.getMinVolume();
        if (offerVolume != null && minOfferVolume != null) {
            String postFix = appendCurrencyCode ? " " + offer.getCounterCurrencyCode() : "";
            decimalAligned = decimalAligned && !this.showAllTradeCurrenciesProperty.get();
            return VolumeUtil.formatVolume((Offer)offer, (Boolean)decimalAligned, (int)this.maxPlacesForVolume.get()) + postFix;
        }
        return Res.get((String)"shared.na");
    }

    int getNumberOfDecimalsForVolume(OfferBookListItem item) {
        return CurrencyUtil.isVolumeRoundedToNearestUnit((String)item.getOffer().getCounterCurrencyCode()) ? 0 : 7;
    }

    String getPaymentMethod(OfferBookListItem item) {
        Object result = "";
        if (item != null) {
            Offer offer = item.getOffer();
            String method = Res.get((String)(offer.getPaymentMethod().getId() + "_SHORT"));
            String methodCountryCode = offer.getCountryCode();
            result = this.isF2F(offer) ? method + " (" + methodCountryCode + ", " + offer.getF2FCity() + ")" : (methodCountryCode != null ? method + " (" + methodCountryCode + ")" : method);
        }
        return result;
    }

    String getPaymentMethodToolTip(OfferBookListItem item) {
        Object result = "";
        if (item != null) {
            Offer offer = item.getOffer();
            result = Res.getWithCol((String)"shared.paymentMethod") + " " + Res.get((String)offer.getPaymentMethod().getId());
            result = (String)result + "\n" + Res.getWithCol((String)"shared.currency") + " " + CurrencyUtil.getNameAndCode((String)offer.getCounterCurrencyCode());
            String countryCode = offer.getCountryCode();
            if (this.isF2F(offer)) {
                if (countryCode != null) {
                    result = (String)result + "\n" + Res.get((String)"payment.f2f.offerbook.tooltip.countryAndCity", (Object[])new Object[]{CountryUtil.getNameByCode((String)countryCode), offer.getF2FCity()});
                }
            } else {
                String bankId;
                if (countryCode != null && (bankId = offer.getBankId()) != null && !bankId.equals("null")) {
                    if (BankUtil.isBankIdRequired((String)countryCode)) {
                        result = (String)result + "\n" + Res.get((String)"offerbook.offerersBankId", (Object[])new Object[]{bankId});
                    } else if (BankUtil.isBankNameRequired((String)countryCode)) {
                        result = (String)result + "\n" + Res.get((String)"offerbook.offerersBankName", (Object[])new Object[]{bankId});
                    }
                }
                if (countryCode != null) {
                    result = (String)result + "\n" + Res.get((String)"offerbook.offerersBankSeat", (Object[])new Object[]{CountryUtil.getNameByCode((String)countryCode)});
                }
                List acceptedCountryCodes = offer.getAcceptedCountryCodes();
                List acceptedBanks = offer.getAcceptedBankIds();
                if (acceptedCountryCodes != null && !acceptedCountryCodes.isEmpty()) {
                    result = CountryUtil.containsAllSepaEuroCountries((List)acceptedCountryCodes) ? (String)result + "\n" + Res.get((String)"offerbook.offerersAcceptedBankSeatsEuro") : (String)result + "\n" + Res.get((String)"offerbook.offerersAcceptedBankSeats", (Object[])new Object[]{CountryUtil.getNamesByCodesString((List)acceptedCountryCodes)});
                } else if (acceptedBanks != null && !acceptedBanks.isEmpty()) {
                    if (offer.getPaymentMethod().equals((Object)PaymentMethod.SAME_BANK)) {
                        result = (String)result + "\n" + Res.getWithCol((String)"shared.bankName") + " " + (String)acceptedBanks.get(0);
                    } else if (offer.getPaymentMethod().equals((Object)PaymentMethod.SPECIFIC_BANKS)) {
                        result = (String)result + "\n" + Res.getWithCol((String)"shared.acceptedBanks") + " " + Joiner.on((String)", ").join((Iterable)acceptedBanks);
                    }
                }
            }
            if (offer.getCombinedExtraInfo() != null && !offer.getCombinedExtraInfo().isEmpty()) {
                result = (String)result + "\n" + Res.get((String)"payment.shared.extraInfo.tooltip", (Object[])new Object[]{offer.getCombinedExtraInfo()});
            }
        }
        return result;
    }

    private boolean isF2F(Offer offer) {
        return offer.getPaymentMethod().equals((Object)PaymentMethod.F2F);
    }

    String getDirectionLabelTooltip(Offer offer) {
        return OfferBookViewModel.getDirectionWithCodeDetailed(offer.getMirroredDirection(), offer.getCounterCurrencyCode());
    }

    Optional<PaymentAccount> getMostMaturePaymentAccountForOffer(Offer offer) {
        return PaymentAccountUtil.getMostMaturePaymentAccountForOffer((Offer)offer, (Set)this.user.getPaymentAccounts(), (AccountAgeWitnessService)this.accountAgeWitnessService);
    }

    private void setMarketPriceFeedCurrency() {
        if (this.isTabSelected) {
            if (this.showAllTradeCurrenciesProperty.get()) {
                this.priceFeedService.setCurrencyCode(this.getDefaultTradeCurrency().getCode());
            } else {
                this.priceFeedService.setCurrencyCode((String)this.tradeCurrencyCode.get());
            }
        }
    }

    private void fillCurrencies() {
        this.tradeCurrencies.clear();
        this.allCurrencies.clear();
        this.fillCurrencies(this.tradeCurrencies, this.allCurrencies);
    }

    abstract void fillCurrencies(ObservableList<TradeCurrency> var1, ObservableList<TradeCurrency> var2);

    boolean hasPaymentAccountForCurrency() {
        return this.hasPaymentAccountForCurrency(this.selectedTradeCurrency);
    }

    boolean hasPaymentAccountForCurrency(TradeCurrency currency) {
        return this.user.hasPaymentAccountForCurrency(currency);
    }

    boolean canCreateOrTakeOffer() {
        return GUIUtil.canCreateOrTakeOfferOrShowPopup(this.user, this.navigation) && GUIUtil.isWalletSyncedWithinToleranceOrShowPopup(this.openOfferManager.getXmrWalletService()) && GUIUtil.isBootstrappedOrShowPopup(this.p2PService);
    }

    private void filterOffers() {
        Predicate<OfferBookListItem> predicate;
        Predicate<OfferBookListItem> predicate2 = predicate = this.useOffersMatchingMyAccountsFilter ? this.getCurrencyAndMethodPredicate(this.direction, this.selectedTradeCurrency).and(this.getOffersMatchingMyAccountsPredicate()) : this.getCurrencyAndMethodPredicate(this.direction, this.selectedTradeCurrency);
        if (this.direction == OfferDirection.BUY) {
            predicate = predicate.and(offerBookListItem -> offerBookListItem.getOffer().isPrivateOffer() == this.showPrivateOffers);
        }
        if (!this.filterText.isEmpty()) {
            Predicate<OfferBookListItem> nextPredicate = offerBookListItem -> offerBookListItem.getOffer().getOfferPayload().getOwnerNodeAddress().getFullAddress().toLowerCase().contains(this.filterText.toLowerCase());
            nextPredicate = nextPredicate.or(offerBookListItem -> offerBookListItem.getOffer().getId().toLowerCase().contains(this.filterText.toLowerCase()));
            nextPredicate = nextPredicate.or(offerBookListItem -> Res.get((String)offerBookListItem.getOffer().getPaymentMethod().getId()).toLowerCase().contains(this.filterText.toLowerCase()));
            nextPredicate = nextPredicate.or(offerBookListItem -> this.getPaymentMethod((OfferBookListItem)offerBookListItem).toLowerCase().contains(this.filterText.toLowerCase()));
            nextPredicate = nextPredicate.or(offerBookListItem -> offerBookListItem.getOffer().getCounterCurrencyCode().toLowerCase().contains(this.filterText.toLowerCase()) || offerBookListItem.getOffer().getBaseCurrencyCode().toLowerCase().contains(this.filterText.toLowerCase()) || CurrencyUtil.getNameAndCode((String)offerBookListItem.getOffer().getCounterCurrencyCode()).toLowerCase().contains(this.filterText.toLowerCase()) || CurrencyUtil.getNameAndCode((String)offerBookListItem.getOffer().getBaseCurrencyCode()).toLowerCase().contains(this.filterText.toLowerCase()));
            nextPredicate = nextPredicate.or(offerBookListItem -> offerBookListItem.getOffer().getCombinedExtraInfo() != null && offerBookListItem.getOffer().getCombinedExtraInfo().toLowerCase().contains(this.filterText.toLowerCase()));
            this.filteredItems.setPredicate(predicate.and(nextPredicate));
        } else {
            this.filteredItems.setPredicate(predicate);
        }
    }

    abstract Predicate<OfferBookListItem> getCurrencyAndMethodPredicate(OfferDirection var1, TradeCurrency var2);

    private Predicate<OfferBookListItem> getOffersMatchingMyAccountsPredicate() {
        return offerBookListItem -> this.offerFilterService.canTakeOffer(offerBookListItem.getOffer(), false).isValid();
    }

    boolean isOfferBanned(Offer offer) {
        return this.offerFilterService.isOfferBanned(offer);
    }

    private boolean isShowAllEntry(String id) {
        return id.equals("list.currency.showAll");
    }

    private boolean isEditEntry(String id) {
        return id.equals("list.currency.editList");
    }

    public int getNumTrades(Offer offer) {
        return this.closedTradableManager.getTradableList().stream().filter(e -> e instanceof Trade).filter(e -> {
            Optional tradePeerNodeAddress = e.getOptionalTradePeerNodeAddress();
            return tradePeerNodeAddress.isPresent() && ((NodeAddress)tradePeerNodeAddress.get()).getFullAddress().equals(offer.getMakerNodeAddress().getFullAddress());
        }).collect(Collectors.toSet()).size();
    }

    public boolean hasSelectionAccountSigning() {
        if (this.showAllTradeCurrenciesProperty.get()) {
            if (this.isShowAllEntry(this.selectedPaymentMethod.getId())) {
                return !(this instanceof CryptoOfferBookViewModel);
            }
            return PaymentMethod.hasChargebackRisk((PaymentMethod)this.selectedPaymentMethod);
        }
        if (this.isShowAllEntry(this.selectedPaymentMethod.getId())) {
            return CurrencyUtil.getMatureMarketCurrencies().stream().anyMatch(c -> c.getCode().equals(this.selectedTradeCurrency.getCode()));
        }
        return PaymentMethod.hasChargebackRisk((PaymentMethod)this.selectedPaymentMethod, (String)((String)this.tradeCurrencyCode.get()));
    }

    private static String getDirectionWithCodeDetailed(OfferDirection direction, String currencyCode) {
        return direction == OfferDirection.BUY ? Res.get((String)"shared.buyingXMRWith", (Object[])new Object[]{currencyCode}) : Res.get((String)"shared.sellingXMRFor", (Object[])new Object[]{currencyCode});
    }

    public String formatDepositString(BigInteger deposit, long amount) {
        String percentage = FormattingUtils.formatToRoundedPercentWithSymbol((double)HavenoUtils.divide((BigInteger)deposit, (BigInteger)BigInteger.valueOf(amount)));
        return HavenoUtils.formatXmr((BigInteger)deposit) + " (" + percentage + ")";
    }

    PaymentMethod getShowAllEntryForPaymentMethod() {
        return PaymentMethod.getDummyPaymentMethod((String)"list.currency.showAll");
    }

    public boolean isInstantPaymentMethod(Offer offer) {
        return offer.getPaymentMethod().equals((Object)PaymentMethod.BLOCK_CHAINS_INSTANT);
    }

    public void setOfferActionHandler(OfferView.OfferActionHandler offerActionHandler) {
        this.offerActionHandler = offerActionHandler;
    }

    public void onCreateOffer() {
        this.offerActionHandler.onCreateOffer(this.getSelectedTradeCurrency(), this.selectedPaymentMethod);
    }

    public void onTakeOffer(Offer offer) {
        this.offerActionHandler.onTakeOffer(offer);
    }

    private void updateSelectedTradeCurrency() {
        String code = this.getCurrencyCodeFromPreferences(this.direction);
        if (code != null && !code.isEmpty() && !this.isShowAllEntry(code) && CurrencyUtil.getTradeCurrency((String)code).isPresent()) {
            this.showAllTradeCurrenciesProperty.set(false);
            this.selectedTradeCurrency = (TradeCurrency)CurrencyUtil.getTradeCurrency((String)code).get();
        } else {
            this.showAllTradeCurrenciesProperty.set(true);
            this.selectedTradeCurrency = this.getDefaultTradeCurrency();
        }
        this.tradeCurrencyCode.set((Object)this.selectedTradeCurrency.getCode());
    }

    abstract TradeCurrency getDefaultTradeCurrency();

    public void updateSelectedPaymentMethod() {
        this.showAllPaymentMethods = this.getPaymentMethods().stream().noneMatch(paymentMethod -> paymentMethod.equals((Object)this.selectedPaymentMethod));
    }

    abstract String getCurrencyCodeFromPreferences(OfferDirection var1);

    public OpenOffer getOpenOffer(Offer offer) {
        return this.openOfferManager.getOpenOffer(offer.getId()).orElse(null);
    }

    public ObservableList<TradeCurrency> getTradeCurrencies() {
        return this.tradeCurrencies;
    }

    public ObservableList<TradeCurrency> getAllCurrencies() {
        return this.allCurrencies;
    }
}

