/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.offerbook;

import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIconView;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.util.Tuple3;
import haveno.core.account.sign.SignedWitnessService;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferFilterService;
import haveno.core.offer.OfferRestrictions;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.components.AccountStatusTooltipLabel;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.AutoTooltipTextField;
import haveno.desktop.components.AutocompleteComboBox;
import haveno.desktop.components.ColoredDecimalPlacesWithZerosText;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.InfoAutoTooltipLabel;
import haveno.desktop.components.PeerInfoIconTrading;
import haveno.desktop.main.MainView;
import haveno.desktop.main.account.AccountView;
import haveno.desktop.main.account.content.cryptoaccounts.CryptoAccountsView;
import haveno.desktop.main.account.content.traditionalaccounts.TraditionalAccountsView;
import haveno.desktop.main.funds.FundsView;
import haveno.desktop.main.funds.withdrawal.WithdrawalView;
import haveno.desktop.main.offer.OfferView;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.desktop.main.offer.offerbook.OfferBookViewModel;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.portfolio.PortfolioView;
import haveno.desktop.main.portfolio.editoffer.EditOfferView;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.jetbrains.annotations.NotNull;

public abstract class OfferBookView<R extends GridPane, M extends OfferBookViewModel>
extends ActivatableViewAndModel<R, M> {
    private final Navigation navigation;
    private final OfferDetailsWindow offerDetailsWindow;
    private final CoinFormatter formatter;
    private final PrivateNotificationManager privateNotificationManager;
    private final boolean useDevPrivilegeKeys;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final SignedWitnessService signedWitnessService;
    protected AutocompleteComboBox<TradeCurrency> currencyComboBox;
    private AutocompleteComboBox<PaymentMethod> paymentMethodComboBox;
    private AutoTooltipButton createOfferButton;
    private AutoTooltipTextField filterInputField;
    private ToggleButton matchingOffersToggleButton;
    private ToggleButton noDepositOffersToggleButton;
    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> amountColumn;
    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> volumeColumn;
    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> marketColumn;
    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> priceColumn;
    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> depositColumn;
    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> signingStateColumn;
    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> avatarColumn;
    private TableView<OfferBookListItem> tableView;
    private int gridRow = 0;
    private Label nrOfOffersLabel;
    private ListChangeListener<OfferBookListItem> offerListListener;
    private ChangeListener<Number> priceFeedUpdateCounterListener;
    private Subscription currencySelectionSubscriber;
    private static final int SHOW_ALL = 0;
    private Label disabledCreateOfferButtonTooltip;
    protected VBox currencyComboBoxContainer;

    OfferBookView(M model, Navigation navigation, OfferDetailsWindow offerDetailsWindow, CoinFormatter formatter, PrivateNotificationManager privateNotificationManager, boolean useDevPrivilegeKeys, AccountAgeWitnessService accountAgeWitnessService, SignedWitnessService signedWitnessService) {
        super(model);
        this.navigation = navigation;
        this.offerDetailsWindow = offerDetailsWindow;
        this.formatter = formatter;
        this.privateNotificationManager = privateNotificationManager;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.signedWitnessService = signedWitnessService;
    }

    @Override
    public void initialize() {
        ((GridPane)this.root).setPadding(new Insets(15.0, 15.0, 5.0, 15.0));
        HBox offerToolsBox = new HBox();
        offerToolsBox.setAlignment(Pos.BOTTOM_LEFT);
        offerToolsBox.setSpacing(10.0);
        offerToolsBox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        Tuple3 currencyBoxTuple = FormBuilder.addTopLabelAutocompleteComboBox(Res.get((String)"offerbook.filterByCurrency"));
        this.currencyComboBoxContainer = (VBox)currencyBoxTuple.first;
        this.currencyComboBox = (AutocompleteComboBox)((Object)currencyBoxTuple.third);
        this.currencyComboBox.setPrefWidth(250.0);
        this.currencyComboBox.getStyleClass().add((Object)"input-with-border");
        Tuple3 paymentBoxTuple = FormBuilder.addTopLabelAutocompleteComboBox(Res.get((String)"offerbook.filterByPaymentMethod"));
        this.paymentMethodComboBox = (AutocompleteComboBox)((Object)paymentBoxTuple.third);
        this.paymentMethodComboBox.setCellFactory(GUIUtil.getPaymentMethodCellFactory());
        this.paymentMethodComboBox.setPrefWidth(250.0);
        this.paymentMethodComboBox.getStyleClass().add((Object)"input-with-border");
        this.noDepositOffersToggleButton = new ToggleButton(Res.get((String)"offerbook.filterNoDeposit"));
        this.noDepositOffersToggleButton.getStyleClass().add((Object)"toggle-button-no-slider");
        Tooltip noDepositOffersTooltip = new Tooltip(Res.get((String)"offerbook.noDepositOffers"));
        Tooltip.install((Node)this.noDepositOffersToggleButton, (Tooltip)noDepositOffersTooltip);
        this.matchingOffersToggleButton = AwesomeDude.createIconToggleButton((AwesomeIcon)AwesomeIcon.USER, null, (String)"1.5em", null);
        this.matchingOffersToggleButton.getStyleClass().add((Object)"toggle-button-no-slider");
        Tooltip matchingOffersTooltip = new Tooltip(Res.get((String)"offerbook.matchingOffers"));
        Tooltip.install((Node)this.matchingOffersToggleButton, (Tooltip)matchingOffersTooltip);
        this.createOfferButton = new AutoTooltipButton("");
        this.createOfferButton.setMinHeight(40.0);
        this.createOfferButton.setGraphicTextGap(10.0);
        this.createOfferButton.setStyle("-fx-padding: 7 25 7 25;");
        this.disabledCreateOfferButtonTooltip = new Label("");
        this.disabledCreateOfferButtonTooltip.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.disabledCreateOfferButtonTooltip.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.disabledCreateOfferButtonTooltip.prefWidthProperty().bind((ObservableValue)this.createOfferButton.widthProperty());
        this.disabledCreateOfferButtonTooltip.prefHeightProperty().bind((ObservableValue)this.createOfferButton.heightProperty());
        this.disabledCreateOfferButtonTooltip.setTooltip(new Tooltip(Res.get((String)"offerbook.createOfferDisabled.tooltip")));
        this.disabledCreateOfferButtonTooltip.setManaged(false);
        this.disabledCreateOfferButtonTooltip.setVisible(false);
        VBox createOfferVBox = new VBox(new Node[]{this.createOfferButton, this.disabledCreateOfferButtonTooltip});
        createOfferVBox.setAlignment(Pos.BOTTOM_RIGHT);
        Tuple3<VBox, Label, AutoTooltipTextField> autoToolTipTextField = FormBuilder.addTopLabelAutoToolTipTextField("");
        VBox filterBox = (VBox)autoToolTipTextField.first;
        this.filterInputField = (AutoTooltipTextField)((Object)autoToolTipTextField.third);
        this.filterInputField.setPromptText(Res.get((String)"shared.filter"));
        this.filterInputField.getStyleClass().add((Object)"input-with-border");
        offerToolsBox.getChildren().addAll((Object[])new Node[]{(Node)currencyBoxTuple.first, (Node)paymentBoxTuple.first, filterBox, this.noDepositOffersToggleButton, this.matchingOffersToggleButton, this.getSpacer(), createOfferVBox});
        GridPane.setHgrow((Node)offerToolsBox, (Priority)Priority.ALWAYS);
        GridPane.setRowIndex((Node)offerToolsBox, (Integer)this.gridRow);
        GridPane.setColumnSpan((Node)offerToolsBox, (Integer)2);
        GridPane.setMargin((Node)offerToolsBox, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        ((GridPane)this.root).getChildren().add((Object)offerToolsBox);
        this.tableView = new TableView();
        GUIUtil.applyTableStyle(this.tableView);
        GridPane.setRowIndex(this.tableView, (Integer)(++this.gridRow));
        GridPane.setColumnIndex(this.tableView, (Integer)0);
        GridPane.setColumnSpan(this.tableView, (Integer)2);
        GridPane.setMargin(this.tableView, (Insets)new Insets(10.0, 0.0, -10.0, 0.0));
        GridPane.setVgrow(this.tableView, (Priority)Priority.ALWAYS);
        ((GridPane)this.root).getChildren().add(this.tableView);
        this.marketColumn = this.getMarketColumn();
        this.priceColumn = this.getPriceColumn();
        this.tableView.getColumns().add(this.priceColumn);
        this.amountColumn = this.getAmountColumn();
        this.tableView.getColumns().add(this.amountColumn);
        this.volumeColumn = this.getVolumeColumn();
        this.tableView.getColumns().add(this.volumeColumn);
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> paymentMethodColumn = this.getPaymentMethodColumn();
        this.tableView.getColumns().add(paymentMethodColumn);
        this.depositColumn = this.getDepositColumn();
        this.tableView.getColumns().add(this.depositColumn);
        this.signingStateColumn = this.getSigningStateColumn();
        this.tableView.getColumns().add(this.signingStateColumn);
        this.avatarColumn = this.getAvatarColumn();
        this.tableView.getColumns().add(this.getActionColumn());
        this.tableView.getColumns().add(this.avatarColumn);
        this.tableView.getSortOrder().add(this.priceColumn);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"table.placeholder.noItems", (Object[])new Object[]{Res.get((String)"shared.multipleOffers")}));
        placeholder.setWrapText(true);
        this.tableView.setPlaceholder((Node)placeholder);
        this.marketColumn.setComparator(Comparator.comparing(o -> CurrencyUtil.getCurrencyPair((String)o.getOffer().getCounterCurrencyCode()), Comparator.nullsFirst(Comparator.naturalOrder())));
        Comparator marketBasedPriceComparator = (o1, o2) -> {
            Optional<Double> marketBasedPrice1 = ((OfferBookViewModel)this.model).getMarketBasedPrice(o1.getOffer());
            Optional<Double> marketBasedPrice2 = ((OfferBookViewModel)this.model).getMarketBasedPrice(o2.getOffer());
            if (marketBasedPrice1.isPresent() && marketBasedPrice2.isPresent()) {
                return Double.compare(marketBasedPrice1.get(), marketBasedPrice2.get());
            }
            return 0;
        };
        this.priceColumn.setComparator(marketBasedPriceComparator.thenComparing((o1, o2) -> {
            Price price2 = o2.getOffer().getPrice();
            Price price1 = o1.getOffer().getPrice();
            if (price2 == null || price1 == null) {
                return 0;
            }
            if (OfferViewUtil.isShownAsSellOffer(((OfferBookViewModel)this.model).getSelectedTradeCurrency().getCode(), ((OfferBookViewModel)this.model).getDirection())) {
                return price1.compareTo(price2);
            }
            return price2.compareTo(price1);
        }));
        this.amountColumn.setComparator(Comparator.comparing(o -> o.getOffer().getMinAmount()));
        this.volumeColumn.setComparator(Comparator.comparing(o -> o.getOffer().getMinVolume(), Comparator.nullsFirst(Comparator.naturalOrder())));
        paymentMethodColumn.setComparator(Comparator.comparing(o -> Res.get((String)o.getOffer().getPaymentMethod().getId())));
        this.avatarColumn.setComparator(Comparator.comparing(o -> ((OfferBookViewModel)this.model).getNumTrades(o.getOffer())));
        this.depositColumn.setComparator(Comparator.comparing(item -> {
            boolean isSellOffer = item.getOffer().getDirection() == OfferDirection.SELL;
            BigInteger deposit = isSellOffer ? item.getOffer().getMaxBuyerSecurityDeposit() : item.getOffer().getMaxSellerSecurityDeposit();
            long amountValue = item.getOffer().getAmount().longValueExact();
            if (deposit == null || amountValue == 0L) {
                return 0.0;
            }
            return HavenoUtils.divide((BigInteger)deposit, (BigInteger)BigInteger.valueOf(amountValue));
        }, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.signingStateColumn.setComparator(Comparator.comparing(e -> e.getWitnessAgeData(this.accountAgeWitnessService, this.signedWitnessService), Comparator.nullsFirst(Comparator.naturalOrder())));
        this.nrOfOffersLabel = new AutoTooltipLabel("");
        this.nrOfOffersLabel.setId("num-offers");
        GridPane.setHalignment((Node)this.nrOfOffersLabel, (HPos)HPos.LEFT);
        GridPane.setVgrow((Node)this.nrOfOffersLabel, (Priority)Priority.NEVER);
        GridPane.setValignment((Node)this.nrOfOffersLabel, (VPos)VPos.TOP);
        GridPane.setRowIndex((Node)this.nrOfOffersLabel, (Integer)(++this.gridRow));
        GridPane.setColumnIndex((Node)this.nrOfOffersLabel, (Integer)0);
        GridPane.setMargin((Node)this.nrOfOffersLabel, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        ((GridPane)this.root).getChildren().add((Object)this.nrOfOffersLabel);
        this.offerListListener = c -> UserThread.execute(() -> this.nrOfOffersLabel.setText(Res.get((String)"offerbook.nrOffers", (Object[])new Object[]{((OfferBookViewModel)this.model).getOfferList().size()})));
        this.priceFeedUpdateCounterListener = (observable, oldValue, newValue) -> this.tableView.sort();
    }

    protected abstract String getMarketTitle();

    @Override
    protected void activate() {
        Map<String, Integer> offerCounts = OfferViewUtil.isShownAsBuyOffer(((OfferBookViewModel)this.model).getDirection(), ((OfferBookViewModel)this.model).getSelectedTradeCurrency()) ? ((OfferBookViewModel)this.model).getSellOfferCounts() : ((OfferBookViewModel)this.model).getBuyOfferCounts();
        this.currencyComboBox.setCellFactory(GUIUtil.getTradeCurrencyCellFactory(Res.get((String)"shared.oneOffer"), Res.get((String)"shared.multipleOffers"), offerCounts));
        this.currencyComboBox.setConverter(new CurrencyStringConverter((ComboBox<TradeCurrency>)this.currencyComboBox));
        this.currencyComboBox.getEditor().getStyleClass().add((Object)"combo-box-editor-bold");
        this.currencyComboBox.setAutocompleteItems((List<TradeCurrency>)((OfferBookViewModel)this.model).getTradeCurrencies(), (List<TradeCurrency>)((OfferBookViewModel)this.model).getAllCurrencies());
        this.currencyComboBox.setVisibleRowCount(Math.min(this.currencyComboBox.getItems().size(), 10));
        this.currencyComboBox.setOnChangeConfirmed((EventHandler<Event>)((EventHandler)e -> {
            if (this.currencyComboBox.getEditor().getText().isEmpty()) {
                return;
            }
            ((OfferBookViewModel)this.model).onSetTradeCurrency((TradeCurrency)this.currencyComboBox.getSelectionModel().getSelectedItem());
            this.paymentMethodComboBox.setAutocompleteItems((List<PaymentMethod>)((OfferBookViewModel)this.model).getPaymentMethods());
            ((OfferBookViewModel)this.model).updateSelectedPaymentMethod();
            this.updatePaymentMethodComboBoxEditor();
            ((OfferBookViewModel)this.model).onSetPaymentMethod((PaymentMethod)this.paymentMethodComboBox.getSelectionModel().getSelectedItem());
            this.updateCreateOfferButton();
        }));
        this.updateCurrencyComboBoxFromModel();
        this.currencyComboBox.getEditor().setText(new CurrencyStringConverter((ComboBox<TradeCurrency>)this.currencyComboBox).toString((TradeCurrency)this.currencyComboBox.getSelectionModel().getSelectedItem()));
        this.matchingOffersToggleButton.setSelected(((OfferBookViewModel)this.model).useOffersMatchingMyAccountsFilter);
        this.matchingOffersToggleButton.disableProperty().bind((ObservableValue)((OfferBookViewModel)this.model).disableMatchToggle);
        this.matchingOffersToggleButton.setOnAction(e -> ((OfferBookViewModel)this.model).onShowOffersMatchingMyAccounts(this.matchingOffersToggleButton.isSelected()));
        this.noDepositOffersToggleButton.setSelected(((OfferBookViewModel)this.model).showPrivateOffers);
        this.noDepositOffersToggleButton.setOnAction(e -> ((OfferBookViewModel)this.model).onShowPrivateOffers(this.noDepositOffersToggleButton.isSelected()));
        ((OfferBookViewModel)this.model).getOfferList().comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.amountColumn.sortTypeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == TableColumn.SortType.DESCENDING) {
                this.amountColumn.setComparator(Comparator.comparing(o -> o.getOffer().getAmount(), Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                this.amountColumn.setComparator(Comparator.comparing(o -> o.getOffer().getMinAmount(), Comparator.nullsFirst(Comparator.naturalOrder())));
            }
        });
        this.volumeColumn.sortTypeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == TableColumn.SortType.DESCENDING) {
                this.volumeColumn.setComparator(Comparator.comparing(o -> o.getOffer().getVolume(), Comparator.nullsFirst(Comparator.naturalOrder())));
            } else {
                this.volumeColumn.setComparator(Comparator.comparing(o -> o.getOffer().getMinVolume(), Comparator.nullsFirst(Comparator.naturalOrder())));
            }
        });
        this.paymentMethodComboBox.setConverter(new PaymentMethodStringConverter((ComboBox<PaymentMethod>)this.paymentMethodComboBox));
        this.paymentMethodComboBox.getEditor().getStyleClass().add((Object)"combo-box-editor-bold");
        this.paymentMethodComboBox.setAutocompleteItems((List<PaymentMethod>)((OfferBookViewModel)this.model).getPaymentMethods());
        this.paymentMethodComboBox.setVisibleRowCount(Math.min(this.paymentMethodComboBox.getItems().size(), 10));
        this.paymentMethodComboBox.setOnChangeConfirmed((EventHandler<Event>)((EventHandler)e -> {
            if (this.paymentMethodComboBox.getEditor().getText().isEmpty()) {
                this.paymentMethodComboBox.getSelectionModel().select(0);
            }
            ((OfferBookViewModel)this.model).onSetPaymentMethod((PaymentMethod)this.paymentMethodComboBox.getSelectionModel().getSelectedItem());
            this.updateCurrencyComboBoxFromModel();
            this.updateSigningStateColumn();
        }));
        this.updatePaymentMethodComboBoxEditor();
        this.createOfferButton.setOnAction(e -> this.onCreateOffer());
        MonadicBinding currencySelectionBinding = EasyBind.combine((ObservableValue)((OfferBookViewModel)this.model).showAllTradeCurrenciesProperty, (ObservableValue)((OfferBookViewModel)this.model).tradeCurrencyCode, (showAll, code) -> {
            if (showAll.booleanValue()) {
                this.volumeColumn.setTitleWithHelpText(Res.get((String)"shared.amountMinMax"), Res.get((String)"shared.amountHelp"));
                this.priceColumn.setTitle(Res.get((String)"shared.price"));
                if (!this.tableView.getColumns().contains(this.marketColumn)) {
                    this.tableView.getColumns().add(0, this.marketColumn);
                }
            } else {
                this.volumeColumn.setTitleWithHelpText(Res.get((String)"offerbook.volume", (Object[])new Object[]{code}), Res.get((String)"shared.amountHelp"));
                this.priceColumn.setTitle(CurrencyUtil.getPriceWithCurrencyCode((String)code));
                this.tableView.getColumns().remove(this.marketColumn);
            }
            this.updateSigningStateColumn();
            return null;
        });
        this.currencySelectionSubscriber = currencySelectionBinding.subscribe((observable, oldValue, newValue) -> {});
        UserThread.execute(() -> this.tableView.setItems(((OfferBookViewModel)this.model).getOfferList()));
        ((OfferBookViewModel)this.model).getOfferList().addListener(this.offerListListener);
        this.nrOfOffersLabel.setText(Res.get((String)"offerbook.nrOffers", (Object[])new Object[]{((OfferBookViewModel)this.model).getOfferList().size()}));
        ((OfferBookViewModel)this.model).priceFeedService.updateCounterProperty().addListener(this.priceFeedUpdateCounterListener);
        this.filterInputField.setOnKeyTyped(event -> ((OfferBookViewModel)this.model).onFilterKeyTyped(this.filterInputField.getText()));
    }

    private void updatePaymentMethodComboBoxEditor() {
        if (((OfferBookViewModel)this.model).showAllPaymentMethods) {
            this.paymentMethodComboBox.getSelectionModel().select(0);
        } else {
            this.paymentMethodComboBox.getSelectionModel().select((Object)((OfferBookViewModel)this.model).selectedPaymentMethod);
        }
        this.paymentMethodComboBox.getEditor().setText(new PaymentMethodStringConverter((ComboBox<PaymentMethod>)this.paymentMethodComboBox).toString((PaymentMethod)this.paymentMethodComboBox.getSelectionModel().getSelectedItem()));
    }

    protected void updateCurrencyComboBoxFromModel() {
        if (((OfferBookViewModel)this.model).showAllTradeCurrenciesProperty.get()) {
            this.currencyComboBox.getSelectionModel().select(0);
        } else {
            this.currencyComboBox.getSelectionModel().select((Object)((OfferBookViewModel)this.model).getSelectedTradeCurrency());
        }
    }

    private void updateSigningStateColumn() {
        if (((OfferBookViewModel)this.model).hasSelectionAccountSigning()) {
            if (!this.tableView.getColumns().contains(this.signingStateColumn)) {
                this.tableView.getColumns().add(this.tableView.getColumns().indexOf(this.depositColumn) + 1, this.signingStateColumn);
            }
        } else {
            this.tableView.getColumns().remove(this.signingStateColumn);
        }
    }

    @Override
    protected void deactivate() {
        this.createOfferButton.setOnAction(null);
        this.matchingOffersToggleButton.setOnAction(null);
        this.matchingOffersToggleButton.disableProperty().unbind();
        this.noDepositOffersToggleButton.setOnAction(null);
        this.noDepositOffersToggleButton.disableProperty().unbind();
        ((OfferBookViewModel)this.model).getOfferList().comparatorProperty().unbind();
        this.volumeColumn.sortableProperty().unbind();
        this.priceColumn.sortableProperty().unbind();
        this.amountColumn.sortableProperty().unbind();
        ((OfferBookViewModel)this.model).getOfferList().comparatorProperty().unbind();
        ((OfferBookViewModel)this.model).getOfferList().removeListener(this.offerListListener);
        ((OfferBookViewModel)this.model).priceFeedService.updateCounterProperty().removeListener(this.priceFeedUpdateCounterListener);
        this.currencySelectionSubscriber.unsubscribe();
    }

    public void enableCreateOfferButton() {
        this.createOfferButton.setDisable(false);
        this.disabledCreateOfferButtonTooltip.setManaged(false);
        this.disabledCreateOfferButtonTooltip.setVisible(false);
    }

    private void disableCreateOfferButton() {
        this.createOfferButton.setDisable(true);
        this.disabledCreateOfferButtonTooltip.setManaged(true);
        this.disabledCreateOfferButtonTooltip.setVisible(true);
        ((OfferBookViewModel)this.model).onCreateOffer();
    }

    public void setDirection(OfferDirection direction) {
        ((OfferBookViewModel)this.model).initWithDirection(direction);
        this.createOfferButton.setGraphic((Node)GUIUtil.getCurrencyIconWithBorder(Res.getBaseCurrencyCode()));
        this.createOfferButton.setContentDisplay(ContentDisplay.RIGHT);
        this.createOfferButton.setId(direction == OfferDirection.SELL ? "sell-button-big" : "buy-button-big");
        this.avatarColumn.setTitle(direction == OfferDirection.SELL ? Res.get((String)"shared.buyerUpperCase") : Res.get((String)"shared.sellerUpperCase"));
        if (direction == OfferDirection.SELL) {
            this.noDepositOffersToggleButton.setVisible(false);
            this.noDepositOffersToggleButton.setManaged(false);
        }
    }

    public void setOfferActionHandler(OfferView.OfferActionHandler offerActionHandler) {
        ((OfferBookViewModel)this.model).setOfferActionHandler(offerActionHandler);
    }

    public void onTabSelected(boolean isSelected) {
        if (((OfferBookViewModel)this.model).isTabSelected == isSelected) {
            return;
        }
        ((OfferBookViewModel)this.model).onTabSelected(isSelected);
        if (isSelected) {
            this.updateCurrencyComboBoxFromModel();
            ((GridPane)this.root).requestFocus();
            this.updateCreateOfferButton();
        }
        this.updateCreateOfferButton();
    }

    private void onCreateOffer() {
        if (((OfferBookViewModel)this.model).canCreateOrTakeOffer()) {
            if (!((OfferBookViewModel)this.model).hasPaymentAccountForCurrency()) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"offerbook.warning.noTradingAccountForCurrency.headline"))).instruction(Res.get((String)"offerbook.warning.noTradingAccountForCurrency.msg"))).actionButtonText(Res.get((String)"offerbook.setupNewAccount"))).onAction(() -> {
                    this.navigation.setReturnPath(this.navigation.getCurrentPath());
                    if (CurrencyUtil.isTraditionalCurrency((String)((OfferBookViewModel)this.model).getSelectedTradeCurrency().getCode())) {
                        this.navigation.navigateTo(MainView.class, AccountView.class, TraditionalAccountsView.class);
                    } else {
                        this.navigation.navigateTo(MainView.class, AccountView.class, CryptoAccountsView.class);
                    }
                })).width(725.0)).show();
                return;
            }
            this.disableCreateOfferButton();
        }
    }

    private void onShowInfo(Offer offer, OfferFilterService.Result result) {
        switch (result) {
            case API_DISABLED: {
                DevEnv.logErrorAndThrowIfDevMode((String)"We are in desktop and in the taker position viewing offers, so it cannot be that we got that result as we are not an API user.");
                break;
            }
            case HAS_NO_PAYMENT_ACCOUNT_VALID_FOR_OFFER: {
                this.openPopupForMissingAccountSetup(offer);
                break;
            }
            case HAS_NOT_SAME_PROTOCOL_VERSION: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.wrongTradeProtocol"))).show();
                break;
            }
            case IS_IGNORED: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.userIgnored"))).show();
                break;
            }
            case IS_OFFER_BANNED: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.offerBlocked"))).show();
                break;
            }
            case IS_CURRENCY_BANNED: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.currencyBanned"))).show();
                break;
            }
            case IS_PAYMENT_METHOD_BANNED: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.paymentMethodBanned"))).show();
                break;
            }
            case IS_NODE_ADDRESS_BANNED: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.nodeBlocked"))).show();
                break;
            }
            case REQUIRE_UPDATE_TO_NEW_VERSION: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.requireUpdateToNewVersion"))).show();
                break;
            }
            case IS_INSUFFICIENT_COUNTERPARTY_TRADE_LIMIT: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.counterpartyTradeRestrictions"))).show();
                break;
            }
            case IS_MY_INSUFFICIENT_TRADE_LIMIT: {
                Optional<PaymentAccount> account = ((OfferBookViewModel)this.model).getMostMaturePaymentAccountForOffer(offer);
                if (account.isPresent()) {
                    long tradeLimit = ((OfferBookViewModel)this.model).accountAgeWitnessService.getMyTradeLimit(account.get(), offer.getCounterCurrencyCode(), offer.getMirroredDirection(), offer.hasBuyerAsTakerWithoutDeposit());
                    ((Popup)new Popup().warning(Res.get((String)"popup.warning.tradeLimitDueAccountAgeRestriction.buyer", (Object[])new Object[]{HavenoUtils.formatXmr((long)tradeLimit, (boolean)true), Res.get((String)"offerbook.warning.newVersionAnnouncement")}))).show();
                    break;
                }
                DevEnv.logErrorAndThrowIfDevMode((String)"We don't found a payment account but got called the isInsufficientTradeLimit case.");
                break;
            }
            case ARBITRATOR_NOT_VALIDATED: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.arbitratorNotValidated"))).show();
                break;
            }
            case SIGNATURE_NOT_VALIDATED: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.signatureNotValidated"))).show();
                break;
            }
            case RESERVE_FUNDS_SPENT: {
                ((Popup)new Popup().warning(Res.get((String)"offerbook.warning.reserveFundsSpent"))).show();
                break;
            }
            case VALID: {
                break;
            }
            default: {
                this.log.warn("Unhandled offer filter service result: " + String.valueOf(result));
            }
        }
    }

    private void onTakeOffer(Offer offer) {
        if (((OfferBookViewModel)this.model).canCreateOrTakeOffer()) {
            if (offer.getDirection() == OfferDirection.SELL && offer.getPaymentMethod().getId().equals(PaymentMethod.CASH_DEPOSIT.getId())) {
                ((Popup)((Popup)((Popup)new Popup().confirmation(Res.get((String)"popup.info.cashDepositInfo", (Object[])new Object[]{offer.getBankId()}))).actionButtonText(Res.get((String)"popup.info.cashDepositInfo.confirm"))).onAction(() -> ((OfferBookViewModel)this.model).onTakeOffer(offer))).show();
            } else {
                ((OfferBookViewModel)this.model).onTakeOffer(offer);
            }
        }
    }

    private void onRemoveOpenOffer(Offer offer) {
        if (((OfferBookViewModel)this.model).isBootstrappedOrShowPopup()) {
            String key = "RemoveOfferWarning";
            if (DontShowAgainLookup.showAgain((String)key)) {
                String message = Res.get((String)"popup.warning.removeOffer");
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(message)).actionButtonText(Res.get((String)"shared.removeOffer"))).onAction(() -> this.doRemoveOffer(offer))).closeButtonText(Res.get((String)"shared.dontRemoveOffer"))).dontShowAgainId(key)).show();
            } else {
                this.doRemoveOffer(offer);
            }
        }
    }

    private void onEditOpenOffer(Offer offer) {
        OpenOffer openOffer = ((OfferBookViewModel)this.model).getOpenOffer(offer);
        if (openOffer != null) {
            this.navigation.navigateToWithData(openOffer, MainView.class, PortfolioView.class, EditOfferView.class);
        }
    }

    private void doRemoveOffer(Offer offer) {
        String key = "WithdrawFundsAfterRemoveOfferInfo";
        ((OfferBookViewModel)this.model).onRemoveOpenOffer(offer, () -> {
            this.log.debug(Res.get((String)"offerbook.removeOffer.success"));
            if (DontShowAgainLookup.showAgain((String)key)) {
                ((Popup)((Popup)((Popup)((Popup)new Popup().instruction(Res.get((String)"offerbook.withdrawFundsHint", (Object[])new Object[]{Res.get((String)"funds.tab.withdrawal")}))).actionButtonTextWithGoTo("funds.tab.withdrawal")).onAction(() -> this.navigation.navigateTo(MainView.class, FundsView.class, WithdrawalView.class))).dontShowAgainId(key)).show();
            }
        }, message -> {
            this.log.error(message);
            ((Popup)new Popup().warning(Res.get((String)"offerbook.removeOffer.failed", (Object[])new Object[]{message}))).show();
        });
    }

    private void openPopupForMissingAccountSetup(Offer offer) {
        String headline = Res.get((String)"offerbook.warning.noMatchingAccount.headline");
        Class accountViewClass = offer.isTraditionalOffer() ? TraditionalAccountsView.class : CryptoAccountsView.class;
        ((Popup)((Popup)((Popup)((Popup)new Popup().headLine(headline)).instruction(Res.get((String)"offerbook.warning.noMatchingAccount.msg"))).actionButtonTextWithGoTo("mainView.menu.account")).onAction(() -> {
            this.navigation.setReturnPath(this.navigation.getCurrentPath());
            this.navigation.navigateTo(MainView.class, AccountView.class, accountViewClass);
        })).show();
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getAmountColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(Res.get((String)"shared.XMRMinMax"), Res.get((String)"shared.amountHelp"));
        column.setMinWidth(100.0);
        column.setSortable(true);
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferBookListItem)offer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(((OfferBookViewModel)OfferBookView.this.model).getAmount(item), 3));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getMarketColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, Res.get((String)"shared.market")){
            {
                this.setMinWidth(40.0);
            }
        };
        column.getStyleClass().addAll((Object[])new String[]{"number-column"});
        column.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferBookListItem)offer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(this){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(this){

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(CurrencyUtil.getCurrencyPair((String)item.getOffer().getCounterCurrencyCode()));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private ObservableValue<OfferBookListItem> asPriceDependentObservable(OfferBookListItem item) {
        return item.getOffer().isUseMarketBasedPrice() ? EasyBind.map((ObservableValue)((OfferBookViewModel)this.model).priceFeedService.updateCounterProperty(), n -> item) : new ReadOnlyObjectWrapper((Object)item);
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getPriceColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, ""){
            {
                this.setMinWidth(130.0);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(offer -> this.asPriceDependentObservable((OfferBookListItem)offer.getValue()));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)this.getPriceAndPercentage(item));
                        } else {
                            this.setGraphic(null);
                        }
                    }

                    private HBox getPriceAndPercentage(OfferBookListItem item) {
                        String info;
                        MaterialDesignIcon icon;
                        Offer offer = item.getOffer();
                        boolean useMarketBasedPrice = offer.isUseMarketBasedPrice();
                        boolean isShownAsBuyOffer = OfferViewUtil.isShownAsBuyOffer(offer);
                        MaterialDesignIcon materialDesignIcon = icon = useMarketBasedPrice ? MaterialDesignIcon.CHART_LINE : MaterialDesignIcon.LOCK;
                        if (useMarketBasedPrice) {
                            double marketPriceMargin = offer.getMarketPriceMarginPct();
                            if (marketPriceMargin == 0.0) {
                                info = isShownAsBuyOffer ? Res.get((String)"offerbook.info.sellAtMarketPrice") : Res.get((String)"offerbook.info.buyAtMarketPrice");
                            } else {
                                String absolutePriceMargin = ((OfferBookViewModel)OfferBookView.this.model).getAbsolutePriceMargin(offer);
                                info = marketPriceMargin > 0.0 ? (isShownAsBuyOffer ? Res.get((String)"offerbook.info.sellBelowMarketPrice", (Object[])new Object[]{absolutePriceMargin}) : Res.get((String)"offerbook.info.buyAboveMarketPrice", (Object[])new Object[]{absolutePriceMargin})) : (isShownAsBuyOffer ? Res.get((String)"offerbook.info.sellAboveMarketPrice", (Object[])new Object[]{absolutePriceMargin}) : Res.get((String)"offerbook.info.buyBelowMarketPrice", (Object[])new Object[]{absolutePriceMargin}));
                            }
                        } else {
                            info = isShownAsBuyOffer ? Res.get((String)"offerbook.info.sellAtFixedPrice") : Res.get((String)"offerbook.info.buyAtFixedPrice");
                        }
                        InfoAutoTooltipLabel priceLabel = new InfoAutoTooltipLabel(((OfferBookViewModel)OfferBookView.this.model).getPrice(item), (GlyphIcons)icon, ContentDisplay.RIGHT, info);
                        priceLabel.setTextAlignment(TextAlignment.RIGHT);
                        AutoTooltipLabel percentageLabel = new AutoTooltipLabel(((OfferBookViewModel)OfferBookView.this.model).getPriceAsPercentage(item));
                        percentageLabel.setOpacity(useMarketBasedPrice ? 1.0 : 0.4);
                        HBox hBox = new HBox();
                        hBox.setSpacing(5.0);
                        hBox.getChildren().addAll((Object[])new Node[]{priceLabel, percentageLabel});
                        hBox.setAlignment(Pos.CENTER_LEFT);
                        return hBox;
                    }
                };
            }
        });
        return column;
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getVolumeColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, ""){
            {
                this.setMinWidth(125.0);
                this.setSortable(true);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(offer -> this.asPriceDependentObservable((OfferBookListItem)offer.getValue()));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (item.getOffer().getPrice() == null) {
                                this.setText(Res.get((String)"shared.na"));
                                this.setGraphic(null);
                            } else {
                                this.setText("");
                                ColoredDecimalPlacesWithZerosText volumeBox = new ColoredDecimalPlacesWithZerosText(((OfferBookViewModel)OfferBookView.this.model).getVolumeAmount(item), ((OfferBookViewModel)OfferBookView.this.model).getNumberOfDecimalsForVolume(item));
                                if (((OfferBookViewModel)((OfferBookView)OfferBookView.this).model).showAllTradeCurrenciesProperty.get()) {
                                    volumeBox.getChildren().add((Object)new Label(" " + item.getOffer().getCounterCurrencyCode()));
                                }
                                this.setGraphic((Node)volumeBox);
                            }
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getPaymentMethodColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, Res.get((String)"shared.paymentMethod")){
            {
                this.setMinWidth(80.0);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferBookListItem)offer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){
                    private HyperlinkWithIcon field;

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Offer offer = item.getOffer();
                            if (((OfferBookViewModel)OfferBookView.this.model).isOfferBanned(offer)) {
                                this.setGraphic((Node)new AutoTooltipLabel(((OfferBookViewModel)OfferBookView.this.model).getPaymentMethod(item)));
                            } else {
                                this.field = new HyperlinkWithIcon(((OfferBookViewModel)OfferBookView.this.model).getPaymentMethod(item));
                                this.field.setOnAction(event -> OfferBookView.this.offerDetailsWindow.show(offer));
                                this.field.setTooltip(new Tooltip(((OfferBookViewModel)OfferBookView.this.model).getPaymentMethodToolTip(item)));
                                this.setGraphic((Node)this.field);
                            }
                        } else {
                            this.setGraphic(null);
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
        return column;
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getDepositColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, Res.get((String)"offerbook.deposit"), Res.get((String)"offerbook.deposit.help")){
            {
                this.setMinWidth(70.0);
                this.setSortable(true);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferBookListItem)offer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            BigInteger deposit;
                            boolean isSellOffer = item.getOffer().getDirection() == OfferDirection.SELL;
                            BigInteger bigInteger = deposit = isSellOffer ? item.getOffer().getMaxBuyerSecurityDeposit() : item.getOffer().getMaxSellerSecurityDeposit();
                            if (deposit == null) {
                                this.setText(Res.get((String)"shared.na"));
                                this.setGraphic(null);
                            } else {
                                this.setText("");
                                String rangePrefix = item.getOffer().isRange() ? "<= " : "";
                                this.setGraphic((Node)new ColoredDecimalPlacesWithZerosText(rangePrefix + ((OfferBookViewModel)OfferBookView.this.model).formatDepositString(deposit, item.getOffer().getAmount().longValueExact()), 3));
                            }
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<OfferBookListItem, OfferBookListItem> getActionColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, Res.get((String)"shared.actions")){
            {
                this.setMinWidth(180.0);
                this.setSortable(false);
            }
        };
        column.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferBookListItem)offer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){
                    OfferFilterService.Result canTakeOfferResult = null;

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        ImageView iconView = new ImageView();
                        AutoTooltipButton button = new AutoTooltipButton();
                        button.setGraphic((Node)iconView);
                        button.setGraphicTextGap(10.0);
                        button.setPrefWidth(10000.0);
                        MaterialDesignIconView iconView2 = new MaterialDesignIconView(MaterialDesignIcon.PENCIL);
                        AutoTooltipButton button2 = new AutoTooltipButton();
                        button2.setGraphic((Node)iconView2);
                        button2.setGraphicTextGap(10.0);
                        button2.setPrefWidth(10000.0);
                        HBox hbox = new HBox();
                        hbox.setSpacing(8.0);
                        hbox.setAlignment(Pos.CENTER);
                        hbox.getChildren().add((Object)button);
                        hbox.getChildren().add((Object)button2);
                        HBox.setHgrow((Node)button, (Priority)Priority.ALWAYS);
                        HBox.setHgrow((Node)button2, (Priority)Priority.ALWAYS);
                        TableRow tableRow = this.getTableRow();
                        if (item != null && !empty) {
                            String title;
                            Offer offer = item.getOffer();
                            boolean myOffer = ((OfferBookViewModel)OfferBookView.this.model).isMyOffer(offer);
                            if (tableRow != null) {
                                this.canTakeOfferResult = ((OfferBookViewModel)((OfferBookView)OfferBookView.this).model).offerFilterService.canTakeOffer(offer, false);
                                if (this.canTakeOfferResult.isValid() || myOffer) {
                                    tableRow.getStyleClass().remove((Object)"row-faded");
                                } else {
                                    if (!tableRow.getStyleClass().contains((Object)"row-faded")) {
                                        tableRow.getStyleClass().add((Object)"row-faded");
                                    }
                                    hbox.getStyleClass().add((Object)"cell-faded");
                                }
                                if (myOffer) {
                                    button.setDefaultButton(false);
                                    tableRow.setOnMousePressed(null);
                                } else if (this.canTakeOfferResult.isValid()) {
                                    button.setDefaultButton(this.getIndex() == 0);
                                    tableRow.setOnMousePressed(null);
                                } else {
                                    button.setDefaultButton(false);
                                    tableRow.setOnMousePressed(e -> {
                                        if (!(e.getTarget() instanceof ImageView) && !(e.getTarget() instanceof Canvas)) {
                                            OfferBookView.this.onShowInfo(offer, this.canTakeOfferResult);
                                        }
                                    });
                                }
                            }
                            if (myOffer) {
                                iconView.setId("image-remove");
                                title = Res.get((String)"shared.remove");
                                button.setOnAction(e -> OfferBookView.this.onRemoveOpenOffer(offer));
                                iconView2.setSize("16px");
                                button2.updateText(Res.get((String)"shared.edit"));
                                button2.setOnAction(e -> OfferBookView.this.onEditOpenOffer(offer));
                                button2.setManaged(true);
                                button2.setVisible(true);
                            } else {
                                boolean isSellOffer = OfferViewUtil.isShownAsSellOffer(offer);
                                boolean isPrivateOffer = offer.isPrivateOffer();
                                if (isPrivateOffer) {
                                    button.setGraphic((Node)GUIUtil.getLockLabel());
                                } else {
                                    iconView.setId(isSellOffer ? "image-buy-white" : "image-sell-white");
                                    iconView.setFitHeight(16.0);
                                    iconView.setFitWidth(16.0);
                                }
                                button.setId(isSellOffer ? "buy-button" : "sell-button");
                                button.setStyle("-fx-text-fill: white");
                                title = Res.get((String)(isSellOffer ? "mainView.menu.buyXmr" : "mainView.menu.sellXmr"));
                                button.setTooltip(new Tooltip(Res.get((String)"offerbook.takeOfferButton.tooltip", (Object[])new Object[]{((OfferBookViewModel)OfferBookView.this.model).getDirectionLabelTooltip(offer)})));
                                button.setOnAction(e -> OfferBookView.this.onTakeOffer(offer));
                                button2.setManaged(false);
                                button2.setVisible(false);
                            }
                            if (!myOffer) {
                                if (this.canTakeOfferResult == null) {
                                    this.canTakeOfferResult = ((OfferBookViewModel)((OfferBookView)OfferBookView.this).model).offerFilterService.canTakeOffer(offer, false);
                                }
                                if (!this.canTakeOfferResult.isValid()) {
                                    button.setOnAction(e -> OfferBookView.this.onShowInfo(offer, this.canTakeOfferResult));
                                }
                            }
                            button.updateText(title);
                            this.setPadding(new Insets(0.0, 15.0, 0.0, 0.0));
                            this.setGraphic((Node)hbox);
                        } else {
                            this.setGraphic(null);
                            button.setOnAction(null);
                            button2.setOnAction(null);
                            if (tableRow != null) {
                                tableRow.setOnMousePressed(null);
                                tableRow.getStyleClass().remove((Object)"row-faded");
                            }
                        }
                    }
                };
            }
        });
        return column;
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getSigningStateColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, Res.get((String)"offerbook.timeSinceSigning"), Res.get((String)"offerbook.timeSinceSigning.help", (Object[])new Object[]{30L, HavenoUtils.formatXmr((BigInteger)OfferRestrictions.TOLERATED_SMALL_TRADE_AMOUNT, (boolean)true)})){
            {
                this.setMinWidth(60.0);
                this.setSortable(true);
            }
        };
        column.getStyleClass().add((Object)"number-column");
        column.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferBookListItem)offer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){

                    public void updateItem(OfferBookListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            OfferBookListItem.WitnessAgeData witnessAgeData = item.getWitnessAgeData(OfferBookView.this.accountAgeWitnessService, OfferBookView.this.signedWitnessService);
                            AutoTooltipLabel label = witnessAgeData.isSigningRequired() ? new AccountStatusTooltipLabel(witnessAgeData) : new InfoAutoTooltipLabel(witnessAgeData.getDisplayString(), witnessAgeData.getIcon(), ContentDisplay.RIGHT, witnessAgeData.getInfo());
                            this.setGraphic((Node)label);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    private AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> getAvatarColumn() {
        AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem> column = new AutoTooltipTableColumn<OfferBookListItem, OfferBookListItem>(this, Res.get((String)"offerbook.trader")){
            {
                this.setMinWidth(60.0);
                this.setMaxWidth(60.0);
                this.setSortable(true);
            }
        };
        column.getStyleClass().addAll((Object[])new String[]{"avatar-column"});
        column.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OfferBookListItem)offer.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<OfferBookListItem, OfferBookListItem>, TableCell<OfferBookListItem, OfferBookListItem>>(){

            public TableCell<OfferBookListItem, OfferBookListItem> call(TableColumn<OfferBookListItem, OfferBookListItem> column) {
                return new TableCell<OfferBookListItem, OfferBookListItem>(){

                    public void updateItem(OfferBookListItem newItem, boolean empty) {
                        super.updateItem((Object)newItem, empty);
                        if (newItem != null && !empty) {
                            Offer offer = newItem.getOffer();
                            NodeAddress makersNodeAddress = offer.getOwnerNodeAddress();
                            String role = Res.get((String)"peerInfoIcon.tooltip.maker");
                            int numTrades = ((OfferBookViewModel)OfferBookView.this.model).getNumTrades(offer);
                            PeerInfoIconTrading peerInfoIcon = new PeerInfoIconTrading(makersNodeAddress, role, numTrades, OfferBookView.this.privateNotificationManager, offer, ((OfferBookViewModel)((OfferBookView)OfferBookView.this).model).preferences, ((OfferBookViewModel)((OfferBookView)OfferBookView.this).model).accountAgeWitnessService, OfferBookView.this.useDevPrivilegeKeys);
                            this.setGraphic((Node)peerInfoIcon);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    @NotNull
    private Region getSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    private void updateCreateOfferButton() {
        this.createOfferButton.setText(Res.get((String)"offerbook.createNewOffer", (Object[])new Object[]{((OfferBookViewModel)this.model).getDirection() == OfferDirection.BUY ? Res.get((String)"shared.buy").toUpperCase() : Res.get((String)"shared.sell").toUpperCase(), this.getTradeCurrencyCode()}));
    }

    abstract String getTradeCurrencyCode();

    static class CurrencyStringConverter
    extends StringConverter<TradeCurrency> {
        private final ComboBox<TradeCurrency> comboBox;

        CurrencyStringConverter(ComboBox<TradeCurrency> comboBox) {
            this.comboBox = comboBox;
        }

        public String toString(TradeCurrency item) {
            return item != null ? this.asString(item) : "";
        }

        public TradeCurrency fromString(String query) {
            if (this.comboBox.getItems().isEmpty()) {
                return null;
            }
            if (query.isEmpty()) {
                return null;
            }
            return this.comboBox.getItems().stream().filter(item -> this.asString((TradeCurrency)item).equals(query)).findAny().orElse(null);
        }

        private String asString(TradeCurrency item) {
            if (this.isSpecialShowAllItem(item)) {
                return Res.get((String)"list.currency.showAll");
            }
            if (this.isSpecialEditItem(item)) {
                return Res.get((String)"list.currency.editList");
            }
            return item.getName() + " (" + item.getCode() + ")";
        }

        private boolean isSpecialShowAllItem(TradeCurrency item) {
            return item.getCode().equals("list.currency.showAll");
        }

        private boolean isSpecialEditItem(TradeCurrency item) {
            return item.getCode().equals("list.currency.editList");
        }

        private TradeCurrency specialShowAllItem() {
            return (TradeCurrency)this.comboBox.getItems().get(0);
        }
    }

    static class PaymentMethodStringConverter
    extends StringConverter<PaymentMethod> {
        private final ComboBox<PaymentMethod> comboBox;

        PaymentMethodStringConverter(ComboBox<PaymentMethod> comboBox) {
            this.comboBox = comboBox;
        }

        public String toString(PaymentMethod item) {
            return item != null ? this.asString(item) : "";
        }

        public PaymentMethod fromString(String query) {
            if (this.comboBox.getItems().isEmpty()) {
                return null;
            }
            if (query.isEmpty()) {
                return this.specialShowAllItem();
            }
            return this.comboBox.getItems().stream().filter(item -> this.asString((PaymentMethod)item).equals(query)).findAny().orElse(null);
        }

        private String asString(PaymentMethod item) {
            if (this.isSpecialShowAllItem(item)) {
                return Res.get((String)"list.currency.showAll");
            }
            return Res.get((String)item.getId());
        }

        private boolean isSpecialShowAllItem(PaymentMethod item) {
            return item.getId().equals("list.currency.showAll");
        }

        private PaymentMethod specialShowAllItem() {
            return (PaymentMethod)this.comboBox.getItems().get(0);
        }
    }
}

