/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.offerbook;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.core.account.sign.SignedWitnessService;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.payment.payload.PaymentMethod;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.storage.P2PDataStorage;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferBookListItem {
    private static final Logger log = LoggerFactory.getLogger(OfferBookListItem.class);
    private final Offer offer;
    P2PDataStorage.ByteArray hashOfPayload;
    private WitnessAgeData witnessAgeData;

    public OfferBookListItem(Offer offer) {
        this.offer = offer;
        this.hashOfPayload = new P2PDataStorage.ByteArray(offer.getOfferPayload().getHash());
    }

    public WitnessAgeData getWitnessAgeData(AccountAgeWitnessService accountAgeWitnessService, SignedWitnessService signedWitnessService) {
        if (this.witnessAgeData == null) {
            if (CurrencyUtil.isCryptoCurrency((String)this.offer.getCounterCurrencyCode())) {
                this.witnessAgeData = new WitnessAgeData(0L);
            } else if (PaymentMethod.hasChargebackRisk((PaymentMethod)this.offer.getPaymentMethod(), (String)this.offer.getCounterCurrencyCode())) {
                Optional optionalWitness = accountAgeWitnessService.findWitness(this.offer);
                AccountAgeWitnessService.SignState signState = optionalWitness.map(arg_0 -> ((AccountAgeWitnessService)accountAgeWitnessService).getSignState(arg_0)).orElse(AccountAgeWitnessService.SignState.UNSIGNED);
                boolean isSignedAccountAgeWitness = optionalWitness.map(arg_0 -> ((SignedWitnessService)signedWitnessService).isSignedAccountAgeWitness(arg_0)).orElse(false);
                this.witnessAgeData = isSignedAccountAgeWitness || !signState.equals((Object)AccountAgeWitnessService.SignState.UNSIGNED) ? new WitnessAgeData(signState.isLimitLifted() ? 4L : 3L, optionalWitness.map(witness -> accountAgeWitnessService.getWitnessSignAge(witness, new Date())).orElse(0L), signState) : new WitnessAgeData(2L, optionalWitness.map(e -> accountAgeWitnessService.getAccountAge(e, new Date())).orElse(0L), signState);
            } else {
                this.witnessAgeData = new WitnessAgeData(1L, accountAgeWitnessService.getAccountAge(this.offer));
            }
        }
        return this.witnessAgeData;
    }

    public String toString() {
        return "OfferBookListItem{offerId=" + this.offer.getId() + ", hashOfPayload=" + this.hashOfPayload.getHex() + ", witnessAgeData=" + (this.witnessAgeData == null ? "null" : this.witnessAgeData.displayString) + "}";
    }

    public Offer getOffer() {
        return this.offer;
    }

    public P2PDataStorage.ByteArray getHashOfPayload() {
        return this.hashOfPayload;
    }

    public static final class WitnessAgeData
    implements Comparable<WitnessAgeData> {
        private final String displayString;
        private final String info;
        private final GlyphIcons icon;
        private final Long type;
        private final Long days;
        public static final long TYPE_SIGNED_AND_LIMIT_LIFTED = 4L;
        public static final long TYPE_SIGNED_OR_BANNED = 3L;
        public static final long TYPE_NOT_SIGNED = 2L;
        public static final long TYPE_NOT_SIGNING_REQUIRED = 1L;
        public static final long TYPE_CRYPTOS = 0L;

        public WitnessAgeData(long type) {
            this(type, 0L, null);
        }

        public WitnessAgeData(long type, long days) {
            this(type, days, null);
        }

        public WitnessAgeData(long type, long age, AccountAgeWitnessService.SignState signState) {
            this.type = type;
            long days = age > -1L ? TimeUnit.MILLISECONDS.toDays(age) : 0L;
            this.days = days;
            if (type == 4L) {
                this.displayString = Res.get((String)"offerbook.timeSinceSigning.daysSinceSigning", (Object[])new Object[]{days});
                this.info = Res.get((String)"offerbook.timeSinceSigning.tooltip.info.signedAndLifted");
                this.icon = GUIUtil.getIconForSignState(signState);
            } else if (type == 3L) {
                this.displayString = Res.get((String)"offerbook.timeSinceSigning.daysSinceSigning", (Object[])new Object[]{days});
                this.info = Res.get((String)"offerbook.timeSinceSigning.tooltip.info.signed");
                this.icon = GUIUtil.getIconForSignState(signState);
            } else if (type == 2L) {
                this.displayString = Res.get((String)"offerbook.timeSinceSigning.notSigned");
                this.info = Res.get((String)"offerbook.timeSinceSigning.tooltip.info.unsigned");
                this.icon = GUIUtil.getIconForSignState(signState);
            } else if (type == 1L) {
                this.displayString = Res.get((String)"offerbook.timeSinceSigning.notSigned.ageDays", (Object[])new Object[]{days});
                this.info = Res.get((String)"shared.notSigned.noNeedDays", (Object[])new Object[]{days});
                this.icon = MaterialDesignIcon.CHECKBOX_MARKED_OUTLINE;
            } else {
                this.displayString = Res.get((String)"offerbook.timeSinceSigning.notSigned.noNeed");
                this.info = Res.get((String)"shared.notSigned.noNeedAlts");
                this.icon = MaterialDesignIcon.INFORMATION_OUTLINE;
            }
        }

        public boolean isAccountSigned() {
            return this.type == 4L || this.type == 3L;
        }

        public boolean isLimitLifted() {
            return this.type == 4L;
        }

        public boolean isSigningRequired() {
            return this.type != 1L && this.type != 0L;
        }

        @Override
        public int compareTo(@NotNull WitnessAgeData o) {
            return (int)(this.type.equals(o.getType()) ? this.days - o.getDays() : this.type - o.getType());
        }

        public String getDisplayString() {
            return this.displayString;
        }

        public String getInfo() {
            return this.info;
        }

        public GlyphIcons getIcon() {
            return this.icon;
        }

        public Long getType() {
            return this.type;
        }

        public Long getDays() {
            return this.days;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WitnessAgeData)) {
                return false;
            }
            WitnessAgeData other = (WitnessAgeData)o;
            Long this$type = this.getType();
            Long other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            Long this$days = this.getDays();
            Long other$days = other.getDays();
            if (this$days == null ? other$days != null : !((Object)this$days).equals(other$days)) {
                return false;
            }
            String this$displayString = this.getDisplayString();
            String other$displayString = other.getDisplayString();
            if (this$displayString == null ? other$displayString != null : !this$displayString.equals(other$displayString)) {
                return false;
            }
            String this$info = this.getInfo();
            String other$info = other.getInfo();
            if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
                return false;
            }
            GlyphIcons this$icon = this.getIcon();
            GlyphIcons other$icon = other.getIcon();
            return !(this$icon == null ? other$icon != null : !this$icon.equals(other$icon));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            Long $days = this.getDays();
            result = result * 59 + ($days == null ? 43 : ((Object)$days).hashCode());
            String $displayString = this.getDisplayString();
            result = result * 59 + ($displayString == null ? 43 : $displayString.hashCode());
            String $info = this.getInfo();
            result = result * 59 + ($info == null ? 43 : $info.hashCode());
            GlyphIcons $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            return result;
        }

        public String toString() {
            return "OfferBookListItem.WitnessAgeData(displayString=" + this.getDisplayString() + ", info=" + this.getInfo() + ", icon=" + String.valueOf(this.getIcon()) + ", type=" + this.getType() + ", days=" + this.getDays() + ")";
        }
    }
}

