/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.offerbook;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.UserThread;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferBookService;
import haveno.core.offer.OfferDirection;
import haveno.desktop.main.offer.offerbook.OfferBookListItem;
import haveno.network.p2p.storage.P2PDataStorage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OfferBook {
    private static final Logger log = LoggerFactory.getLogger(OfferBook.class);
    private final OfferBookService offerBookService;
    private final ObservableList<OfferBookListItem> offerBookListItems = FXCollections.observableArrayList();
    private final Map<String, Integer> buyOfferCountMap = new HashMap<String, Integer>();
    private final Map<String, Integer> sellOfferCountMap = new HashMap<String, Integer>();

    @Inject
    OfferBook(OfferBookService offerBookService) {
        this.offerBookService = offerBookService;
        offerBookService.addOfferBookChangedListener(new OfferBookService.OfferBookChangedListener(){

            public void onAdded(Offer offer) {
                UserThread.execute(() -> {
                    OfferBook.this.printOfferBookListItems("Before onAdded");
                    ObservableList<OfferBookListItem> observableList = OfferBook.this.offerBookListItems;
                    synchronized (observableList) {
                        boolean hasSameOffer = OfferBook.this.offerBookListItems.stream().anyMatch(item -> item.getOffer().equals((Object)offer));
                        if (!hasSameOffer) {
                            OfferBookListItem newOfferBookListItem = new OfferBookListItem(offer);
                            OfferBook.this.removeDuplicateItem(newOfferBookListItem);
                            OfferBook.this.offerBookListItems.add((Object)newOfferBookListItem);
                            if (log.isDebugEnabled()) {
                                log.debug("onAdded: Added new offer {}\n\twith newItem.payloadHash: {}", (Object)offer.getId(), (Object)newOfferBookListItem.hashOfPayload.getHex());
                            }
                        } else {
                            log.debug("We have the exact same offer already in our list and ignore the onAdded call. ID={}", (Object)offer.getId());
                        }
                        OfferBook.this.printOfferBookListItems("After onAdded");
                    }
                });
            }

            public void onRemoved(Offer offer) {
                UserThread.execute(() -> {
                    ObservableList<OfferBookListItem> observableList = OfferBook.this.offerBookListItems;
                    synchronized (observableList) {
                        OfferBook.this.printOfferBookListItems("Before onRemoved");
                        OfferBook.this.removeOffer(offer);
                        OfferBook.this.printOfferBookListItems("After onRemoved");
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDuplicateItem(OfferBookListItem newOfferBookListItem) {
        ObservableList<OfferBookListItem> observableList = this.offerBookListItems;
        synchronized (observableList) {
            String offerId = newOfferBookListItem.getOffer().getId();
            List<OfferBookListItem> duplicateItems = this.offerBookListItems.stream().filter(item -> item.getOffer().getId().equals(offerId)).collect(Collectors.toList());
            duplicateItems.forEach(oldOfferItem -> {
                this.offerBookListItems.remove(oldOfferItem);
                if (log.isDebugEnabled()) {
                    log.debug("onAdded: Removed old offer {}\n\twith payload hash {} from list.\n\tThis may make a subsequent onRemoved( {} ) call redundant.", new Object[]{offerId, oldOfferItem.getHashOfPayload().getHex(), oldOfferItem.getOffer().getId()});
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffer(Offer offer) {
        ObservableList<OfferBookListItem> observableList = this.offerBookListItems;
        synchronized (observableList) {
            Optional<OfferBookListItem> candidateWithMatchingPayloadHash;
            offer.setState(Offer.State.REMOVED);
            offer.cancelAvailabilityRequest();
            P2PDataStorage.ByteArray hashOfPayload = new P2PDataStorage.ByteArray(offer.getOfferPayload().getHash());
            if (log.isDebugEnabled()) {
                log.debug("onRemoved: id = {}\n\twith payload-hash = {}", (Object)offer.getId(), (Object)hashOfPayload.getHex());
            }
            if (!(candidateWithMatchingPayloadHash = this.offerBookListItems.stream().filter(item -> item.getOffer().getId().equals(offer.getId()) && item.hashOfPayload.equals((Object)hashOfPayload)).findAny()).isPresent()) {
                if (log.isDebugEnabled()) {
                    log.debug("UI view list does not contain offer with id {} and payload-hash {}", (Object)offer.getId(), (Object)hashOfPayload.getHex());
                }
                return;
            }
            OfferBookListItem candidate = candidateWithMatchingPayloadHash.get();
            if (candidate.getHashOfPayload().equals((Object)hashOfPayload)) {
                this.offerBookListItems.remove((Object)candidate);
                if (log.isDebugEnabled()) {
                    log.debug("Candidate.payload-hash: {} == onRemoved.payload-hash: {} ? Yes, removed old offer", (Object)candidate.hashOfPayload.getHex(), (Object)hashOfPayload.getHex());
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Candidate.payload-hash: {} == onRemoved.payload-hash: {} ? No, old offer not removed", (Object)candidate.hashOfPayload.getHex(), (Object)hashOfPayload.getHex());
            }
        }
    }

    public ObservableList<OfferBookListItem> getOfferBookListItems() {
        return this.offerBookListItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOfferBookListItems() {
        ObservableList<OfferBookListItem> observableList = this.offerBookListItems;
        synchronized (observableList) {
            try {
                this.offerBookListItems.clear();
                this.offerBookListItems.addAll((Collection)this.offerBookService.getOffers().stream().map(OfferBookListItem::new).collect(Collectors.toList()));
                log.debug("offerBookListItems.size {}", (Object)this.offerBookListItems.size());
                this.fillOfferCountMaps();
            }
            catch (Throwable t) {
                log.error("Error at fillOfferBookListItems: " + String.valueOf(t));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printOfferBookListItems(String msg) {
        ObservableList<OfferBookListItem> observableList = this.offerBookListItems;
        synchronized (observableList) {
            if (log.isDebugEnabled()) {
                if (this.offerBookListItems.size() == 0) {
                    log.debug("{} -> OfferBookListItems:  none", (Object)msg);
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(msg + " -> ").append("OfferBookListItems:").append("\n");
                this.offerBookListItems.forEach(i -> stringBuilder.append("\t").append(i.toString()).append("\n"));
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                log.debug(stringBuilder.toString());
            }
        }
    }

    public Map<String, Integer> getBuyOfferCountMap() {
        return this.buyOfferCountMap;
    }

    public Map<String, Integer> getSellOfferCountMap() {
        return this.sellOfferCountMap;
    }

    private void fillOfferCountMaps() {
        this.buyOfferCountMap.clear();
        this.sellOfferCountMap.clear();
        String[] ccyCode = new String[1];
        int[] offerCount = new int[1];
        this.offerBookListItems.forEach(o -> {
            ccyCode[0] = o.getOffer().getCounterCurrencyCode();
            if (o.getOffer().getDirection() == OfferDirection.BUY) {
                offerCount[0] = this.buyOfferCountMap.getOrDefault(ccyCode[0], 0) + 1;
                this.buyOfferCountMap.put(ccyCode[0], offerCount[0]);
            } else {
                offerCount[0] = this.sellOfferCountMap.getOrDefault(ccyCode[0], 0) + 1;
                this.sellOfferCountMap.put(ccyCode[0], offerCount[0]);
            }
        });
        log.debug("buyOfferCountMap.size {}   sellOfferCountMap.size {}", (Object)this.buyOfferCountMap.size(), (Object)this.sellOfferCountMap.size());
    }
}

