/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer.createoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.OfferDirection;
import haveno.core.payment.PaymentAccount;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.main.offer.MutableOfferView;
import haveno.desktop.main.offer.OfferView;
import haveno.desktop.main.offer.createoffer.CreateOfferViewModel;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

@FxmlView
public class CreateOfferView
extends MutableOfferView<CreateOfferViewModel> {
    @Inject
    private CreateOfferView(CreateOfferViewModel model, Navigation navigation, Preferences preferences, OfferDetailsWindow offerDetailsWindow, @Named(value="BTC") CoinFormatter btcFormatter) {
        super(model, navigation, preferences, offerDetailsWindow, btcFormatter);
    }

    public void initWithData(OfferDirection direction, TradeCurrency tradeCurrency, OfferView.OfferActionHandler offerActionHandler) {
        super.initWithData(direction, tradeCurrency, true, offerActionHandler);
    }

    @Override
    protected ObservableList<PaymentAccount> filterPaymentAccounts(ObservableList<PaymentAccount> paymentAccounts) {
        return FXCollections.observableArrayList((Collection)paymentAccounts.stream().filter(paymentAccount -> {
            if (CurrencyUtil.isFiatCurrency((String)((CreateOfferViewModel)this.model).getTradeCurrency().getCode())) {
                return paymentAccount.isFiat();
            }
            if (CurrencyUtil.isCryptoCurrency((String)((CreateOfferViewModel)this.model).getTradeCurrency().getCode())) {
                return paymentAccount.isCryptoCurrency();
            }
            return !paymentAccount.isFiat() && !paymentAccount.isCryptoCurrency();
        }).collect(Collectors.toList()));
    }
}

