/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer;

import haveno.common.UserThread;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.main.offer.offerbook.CryptoOfferBookView;
import haveno.desktop.main.offer.offerbook.FiatOfferBookView;
import haveno.desktop.main.offer.offerbook.OfferBookView;
import haveno.desktop.main.offer.offerbook.OtherOfferBookView;
import haveno.desktop.main.overlays.popups.Popup;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import monero.daemon.model.MoneroSubmitTxResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferViewUtil {
    private static final Logger log = LoggerFactory.getLogger(OfferViewUtil.class);

    public static Label createPopOverLabel(String text) {
        Label label = new Label(text);
        label.setPrefWidth(300.0);
        label.setWrapText(true);
        label.setLineSpacing(1.0);
        label.setPadding(new Insets(10.0));
        return label;
    }

    public static void showPaymentAccountWarning(String msgKey, HashMap<String, Boolean> paymentAccountWarningDisplayed) {
        if (msgKey == null || paymentAccountWarningDisplayed.getOrDefault(msgKey, false).booleanValue()) {
            return;
        }
        paymentAccountWarningDisplayed.put(msgKey, true);
        UserThread.runAfter(() -> ((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)msgKey))).width(900.0)).closeButtonText(Res.get((String)"shared.iConfirm"))).dontShowAgainId(msgKey)).show(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static void addPayInfoEntry(GridPane infoGridPane, int row, String labelText, String value) {
        AutoTooltipLabel label = new AutoTooltipLabel(labelText);
        TextField textField = new TextField(value);
        textField.setMinWidth(500.0);
        textField.setEditable(false);
        textField.setFocusTraversable(false);
        textField.setId("payment-info");
        GridPane.setConstraints((Node)label, (int)0, (int)row, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.CENTER);
        GridPane.setConstraints((Node)textField, (int)1, (int)row);
        infoGridPane.getChildren().addAll((Object[])new Node[]{label, textField});
    }

    public static Class<? extends OfferBookView<?, ?>> getOfferBookViewClass(String currencyCode) {
        Class offerBookViewClazz = CurrencyUtil.isFiatCurrency((String)currencyCode) ? FiatOfferBookView.class : (CurrencyUtil.isCryptoCurrency((String)currencyCode) ? CryptoOfferBookView.class : OtherOfferBookView.class);
        return offerBookViewClazz;
    }

    public static boolean isShownAsSellOffer(Offer offer) {
        return OfferViewUtil.isShownAsSellOffer(offer.getCounterCurrencyCode(), offer.getDirection());
    }

    public static boolean isShownAsSellOffer(TradeCurrency tradeCurrency, OfferDirection direction) {
        return OfferViewUtil.isShownAsSellOffer(tradeCurrency.getCode(), direction);
    }

    public static boolean isShownAsSellOffer(String currencyCode, OfferDirection direction) {
        return direction == OfferDirection.SELL;
    }

    public static boolean isShownAsBuyOffer(Offer offer) {
        return !OfferViewUtil.isShownAsSellOffer(offer);
    }

    public static boolean isShownAsBuyOffer(OfferDirection direction, TradeCurrency tradeCurrency) {
        return !OfferViewUtil.isShownAsSellOffer(tradeCurrency.getCode(), direction);
    }

    public static TradeCurrency getAnyOfMainCryptoCurrencies() {
        return (TradeCurrency)OfferViewUtil.getMainCryptoCurrencies().findAny().get();
    }

    public static TradeCurrency getAnyOfOtherCurrencies() {
        return (TradeCurrency)OfferViewUtil.getOtherCurrencies().findAny().get();
    }

    @NotNull
    public static Stream<CryptoCurrency> getMainCryptoCurrencies() {
        return CurrencyUtil.getMainCryptoCurrencies().stream();
    }

    @NotNull
    public static Stream<TraditionalCurrency> getOtherCurrencies() {
        return CurrencyUtil.getTraditionalNonFiatCurrencies().stream();
    }

    public static void submitTransactionHex(XmrWalletService xmrWalletService, TableView tableView, String reserveTxHex) {
        MoneroSubmitTxResult result = xmrWalletService.getMonerod().submitTxHex(reserveTxHex);
        log.info("submitTransactionHex: reserveTxHex={} result={}", (Object)result);
        tableView.refresh();
        if (result.isGood().booleanValue()) {
            ((Popup)new Popup().information(Res.get((String)"support.result.success"))).show();
        } else {
            ((Popup)new Popup().attention(result.toString())).show();
        }
    }
}

