/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer;

import haveno.core.locale.Res;
import haveno.core.offer.OfferUtil;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import java.math.BigInteger;
import java.util.Optional;

public class OfferViewModelUtil {
    public static String getTradeFeeWithFiatEquivalent(OfferUtil offerUtil, BigInteger tradeFee, CoinFormatter formatter) {
        Optional optionalBtcFeeInFiat = offerUtil.getFeeInUserFiatCurrency(tradeFee, formatter);
        return DisplayUtils.getFeeWithFiatAmount(tradeFee, optionalBtcFeeInFiat, formatter);
    }

    public static String getTradeFeeWithFiatEquivalentAndPercentage(OfferUtil offerUtil, BigInteger tradeFee, BigInteger tradeAmount, CoinFormatter formatter) {
        String feeAsXmr = HavenoUtils.formatXmr((BigInteger)tradeFee, (boolean)true);
        String percentage = GUIUtil.getPercentage(tradeFee, tradeAmount) + " " + Res.get((String)"guiUtil.ofTradeAmount");
        return offerUtil.getFeeInUserFiatCurrency(tradeFee, formatter).map(VolumeUtil::formatAverageVolumeWithCode).map(feeInFiat -> Res.get((String)"feeOptionWindow.xmrFeeWithFiatAndPercentage", (Object[])new Object[]{feeAsXmr, feeInFiat, percentage})).orElseGet(() -> Res.get((String)"feeOptionWindow.xmrFeeWithPercentage", (Object[])new Object[]{feeAsXmr, percentage}));
    }
}

