/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer;

import haveno.common.UserThread;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.main.MainView;
import haveno.desktop.main.offer.ClosableView;
import haveno.desktop.main.offer.InitializableViewWithTakeOfferData;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.offer.SelectableView;
import haveno.desktop.main.offer.createoffer.CreateOfferView;
import haveno.desktop.main.offer.offerbook.CryptoOfferBookView;
import haveno.desktop.main.offer.offerbook.FiatOfferBookView;
import haveno.desktop.main.offer.offerbook.OfferBookView;
import haveno.desktop.main.offer.offerbook.OtherOfferBookView;
import haveno.desktop.main.offer.takeoffer.TakeOfferView;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class OfferView
extends ActivatableView<TabPane, Void> {
    private OfferBookView<?, ?> fiatOfferBookView;
    private OfferBookView<?, ?> cryptoOfferBookView;
    private OfferBookView<?, ?> otherOfferBookView;
    private Tab labelTab;
    private Tab fiatOfferBookTab;
    private Tab cryptoOfferBookTab;
    private Tab otherOfferBookTab;
    private final ViewLoader viewLoader;
    private final Navigation navigation;
    private final Preferences preferences;
    private final User user;
    private final P2PService p2PService;
    private final OfferDirection direction;
    private Offer offer;
    private TradeCurrency tradeCurrency;
    private Navigation.Listener navigationListener;
    private ChangeListener<Tab> tabChangeListener;
    private OfferActionHandler offerActionHandler;

    protected OfferView(ViewLoader viewLoader, Navigation navigation, Preferences preferences, User user, P2PService p2PService, OfferDirection direction) {
        this.viewLoader = viewLoader;
        this.navigation = navigation;
        this.preferences = preferences;
        this.user = user;
        this.p2PService = p2PService;
        this.direction = direction;
    }

    @Override
    protected void initialize() {
        this.navigationListener = (viewPath, data) -> UserThread.execute(() -> {
            if (viewPath.size() == 3 && viewPath.indexOf(this.getClass()) == 1) {
                this.loadView(viewPath.tip(), null, data);
            } else if (viewPath.size() == 4 && viewPath.indexOf(this.getClass()) == 1) {
                this.loadView((Class)viewPath.get(2), viewPath.tip(), data);
            }
        });
        this.tabChangeListener = (observableValue, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue != null) {
                if (newValue.equals(this.fiatOfferBookTab)) {
                    if (this.fiatOfferBookView != null) {
                        this.fiatOfferBookView.onTabSelected(true);
                    } else {
                        this.loadView(FiatOfferBookView.class, null, null);
                    }
                } else if (newValue.equals(this.cryptoOfferBookTab)) {
                    if (this.cryptoOfferBookView != null) {
                        this.cryptoOfferBookView.onTabSelected(true);
                    } else {
                        this.loadView(CryptoOfferBookView.class, null, null);
                    }
                } else if (newValue.equals(this.otherOfferBookTab)) {
                    if (this.otherOfferBookView != null) {
                        this.otherOfferBookView.onTabSelected(true);
                    } else {
                        this.loadView(OtherOfferBookView.class, null, null);
                    }
                }
            }
            if (oldValue != null) {
                if (oldValue.equals(this.fiatOfferBookTab) && this.fiatOfferBookView != null) {
                    this.fiatOfferBookView.onTabSelected(false);
                } else if (oldValue.equals(this.cryptoOfferBookTab) && this.cryptoOfferBookView != null) {
                    this.cryptoOfferBookView.onTabSelected(false);
                } else if (oldValue.equals(this.otherOfferBookTab) && this.otherOfferBookView != null) {
                    this.otherOfferBookView.onTabSelected(false);
                }
            }
        });
        this.offerActionHandler = new OfferActionHandler(){

            @Override
            public void onCreateOffer(TradeCurrency tradeCurrency, PaymentMethod paymentMethod) {
                if (OfferView.this.canCreateOrTakeOffer(tradeCurrency)) {
                    OfferView.this.showCreateOffer(tradeCurrency, paymentMethod);
                }
            }

            @Override
            public void onTakeOffer(Offer offer) {
                Optional optionalTradeCurrency = CurrencyUtil.getTradeCurrency((String)offer.getCounterCurrencyCode());
                if (optionalTradeCurrency.isPresent() && OfferView.this.canCreateOrTakeOffer((TradeCurrency)optionalTradeCurrency.get())) {
                    OfferView.this.showTakeOffer(offer);
                }
            }
        };
    }

    @Override
    protected void activate() {
        Optional tradeCurrencyOptional = this.direction == OfferDirection.SELL ? CurrencyUtil.getTradeCurrency((String)this.preferences.getSellScreenCurrencyCode()) : CurrencyUtil.getTradeCurrency((String)this.preferences.getBuyScreenCurrencyCode());
        this.tradeCurrency = tradeCurrencyOptional.orElseGet(GlobalSettings::getDefaultTradeCurrency);
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().addListener(this.tabChangeListener);
        this.navigation.addListener(this.navigationListener);
        if (this.fiatOfferBookView == null) {
            this.navigation.navigateTo(MainView.class, this.getClass(), FiatOfferBookView.class);
        }
    }

    @Override
    protected void deactivate() {
        this.navigation.removeListener(this.navigationListener);
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().removeListener(this.tabChangeListener);
    }

    protected abstract String getOfferLabel();

    private void loadView(Class<? extends View> viewClass, Class<? extends View> childViewClass, @Nullable Object data) {
        TabPane tabPane = (TabPane)this.root;
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        if (OfferBookView.class.isAssignableFrom(viewClass)) {
            if (viewClass == FiatOfferBookView.class && this.fiatOfferBookTab != null && this.fiatOfferBookView != null) {
                if (childViewClass == null) {
                    this.fiatOfferBookTab.setContent(this.fiatOfferBookView.getRoot());
                } else if (childViewClass == TakeOfferView.class) {
                    this.loadTakeViewClass(viewClass, childViewClass, this.fiatOfferBookTab);
                } else {
                    this.loadCreateViewClass(this.fiatOfferBookView, viewClass, childViewClass, this.fiatOfferBookTab, (PaymentMethod)data);
                }
                tabPane.getSelectionModel().select((Object)this.fiatOfferBookTab);
            } else if (viewClass == CryptoOfferBookView.class && this.cryptoOfferBookTab != null && this.cryptoOfferBookView != null) {
                if (childViewClass == null) {
                    this.cryptoOfferBookTab.setContent(this.cryptoOfferBookView.getRoot());
                } else if (childViewClass == TakeOfferView.class) {
                    this.loadTakeViewClass(viewClass, childViewClass, this.cryptoOfferBookTab);
                } else {
                    Optional tradeCurrencyOptional = this.direction == OfferDirection.SELL ? CurrencyUtil.getTradeCurrency((String)this.preferences.getSellScreenCryptoCurrencyCode()) : CurrencyUtil.getTradeCurrency((String)this.preferences.getBuyScreenCryptoCurrencyCode());
                    this.tradeCurrency = tradeCurrencyOptional.isEmpty() ? OfferViewUtil.getAnyOfMainCryptoCurrencies() : (TradeCurrency)tradeCurrencyOptional.get();
                    this.loadCreateViewClass(this.cryptoOfferBookView, viewClass, childViewClass, this.cryptoOfferBookTab, (PaymentMethod)data);
                }
                tabPane.getSelectionModel().select((Object)this.cryptoOfferBookTab);
            } else if (viewClass == OtherOfferBookView.class && this.otherOfferBookTab != null && this.otherOfferBookView != null) {
                if (childViewClass == null) {
                    this.otherOfferBookTab.setContent(this.otherOfferBookView.getRoot());
                } else if (childViewClass == TakeOfferView.class) {
                    this.loadTakeViewClass(viewClass, childViewClass, this.otherOfferBookTab);
                } else {
                    this.loadCreateViewClass(this.otherOfferBookView, viewClass, childViewClass, this.otherOfferBookTab, (PaymentMethod)data);
                }
                tabPane.getSelectionModel().select((Object)this.otherOfferBookTab);
            } else {
                if (this.fiatOfferBookTab == null) {
                    this.labelTab = new Tab();
                    this.labelTab.setDisable(true);
                    this.labelTab.setContent((Node)new Label());
                    this.labelTab.setClosable(false);
                    Label offerLabel = new Label(this.getOfferLabel());
                    offerLabel.getStyleClass().add((Object)"titled-group-bg-label");
                    offerLabel.setStyle("-fx-font-size: 1.3em;");
                    this.labelTab.setGraphic((Node)offerLabel);
                    this.fiatOfferBookTab = new Tab(Res.get((String)"shared.fiat"));
                    this.fiatOfferBookTab.setClosable(false);
                    this.cryptoOfferBookTab = new Tab(Res.get((String)"shared.crypto"));
                    this.cryptoOfferBookTab.setClosable(false);
                    this.otherOfferBookTab = new Tab(Res.get((String)"shared.other"));
                    this.otherOfferBookTab.setClosable(false);
                    tabPane.getTabs().addAll((Object[])new Tab[]{this.labelTab, this.fiatOfferBookTab, this.cryptoOfferBookTab, this.otherOfferBookTab});
                }
                if (viewClass == FiatOfferBookView.class) {
                    this.fiatOfferBookView = (FiatOfferBookView)this.viewLoader.load(FiatOfferBookView.class);
                    this.fiatOfferBookView.setOfferActionHandler(this.offerActionHandler);
                    this.fiatOfferBookView.setDirection(this.direction);
                    this.fiatOfferBookView.onTabSelected(true);
                    tabPane.getSelectionModel().select((Object)this.fiatOfferBookTab);
                    this.fiatOfferBookTab.setContent(this.fiatOfferBookView.getRoot());
                } else if (viewClass == CryptoOfferBookView.class) {
                    this.cryptoOfferBookView = (CryptoOfferBookView)this.viewLoader.load(CryptoOfferBookView.class);
                    this.cryptoOfferBookView.setOfferActionHandler(this.offerActionHandler);
                    this.cryptoOfferBookView.setDirection(this.direction);
                    this.cryptoOfferBookView.onTabSelected(true);
                    tabPane.getSelectionModel().select((Object)this.cryptoOfferBookTab);
                    this.cryptoOfferBookTab.setContent(this.cryptoOfferBookView.getRoot());
                } else if (viewClass == OtherOfferBookView.class) {
                    this.otherOfferBookView = (OtherOfferBookView)this.viewLoader.load(OtherOfferBookView.class);
                    this.otherOfferBookView.setOfferActionHandler(this.offerActionHandler);
                    this.otherOfferBookView.setDirection(this.direction);
                    this.otherOfferBookView.onTabSelected(true);
                    tabPane.getSelectionModel().select((Object)this.otherOfferBookTab);
                    this.otherOfferBookTab.setContent(this.otherOfferBookView.getRoot());
                }
            }
        }
    }

    private void loadCreateViewClass(OfferBookView<?, ?> offerBookView, Class<? extends View> viewClass, Class<? extends View> childViewClass, Tab marketOfferBookTab, @Nullable PaymentMethod paymentMethod) {
        if (this.tradeCurrency == null) {
            return;
        }
        View view = this.viewLoader.load(childViewClass);
        ((CreateOfferView)view).initWithData(this.direction, this.tradeCurrency, this.offerActionHandler);
        ((SelectableView)((Object)view)).onTabSelected(true);
        ((ClosableView)((Object)view)).setCloseHandler(() -> {
            offerBookView.enableCreateOfferButton();
            ((SelectableView)((Object)view)).onTabSelected(false);
            this.navigation.navigateTo(MainView.class, this.getClass(), viewClass);
        });
        marketOfferBookTab.setContent(view.getRoot());
    }

    private void loadTakeViewClass(Class<? extends View> viewClass, Class<? extends View> childViewClass, Tab marketOfferBookTab) {
        if (this.offer == null) {
            return;
        }
        View view = this.viewLoader.load(childViewClass);
        ((InitializableViewWithTakeOfferData)((Object)view)).initWithData(this.offer);
        ((SelectableView)((Object)view)).onTabSelected(true);
        ((ClosableView)((Object)view)).setCloseHandler(() -> {
            ((SelectableView)((Object)view)).onTabSelected(false);
            this.navigation.navigateTo(MainView.class, this.getClass(), viewClass);
        });
        marketOfferBookTab.setContent(view.getRoot());
    }

    protected boolean canCreateOrTakeOffer(TradeCurrency tradeCurrency) {
        return GUIUtil.isBootstrappedOrShowPopup(this.p2PService) && GUIUtil.canCreateOrTakeOfferOrShowPopup(this.user, this.navigation);
    }

    private void showTakeOffer(Offer offer) {
        this.offer = offer;
        Class<? extends OfferBookView<?, ?>> offerBookViewClass = this.getOfferBookViewClassFor(offer.getCounterCurrencyCode());
        this.navigation.navigateTo(MainView.class, this.getClass(), offerBookViewClass, TakeOfferView.class);
    }

    private void showCreateOffer(TradeCurrency tradeCurrency, PaymentMethod paymentMethod) {
        this.tradeCurrency = tradeCurrency;
        Class<? extends OfferBookView<?, ?>> offerBookViewClass = this.getOfferBookViewClassFor(tradeCurrency.getCode());
        this.navigation.navigateToWithData(paymentMethod, MainView.class, this.getClass(), offerBookViewClass, CreateOfferView.class);
    }

    @NotNull
    private Class<? extends OfferBookView<?, ?>> getOfferBookViewClassFor(String currencyCode) {
        Class offerBookViewClass = CurrencyUtil.isFiatCurrency((String)currencyCode) ? FiatOfferBookView.class : (CurrencyUtil.isCryptoCurrency((String)currencyCode) ? CryptoOfferBookView.class : OtherOfferBookView.class);
        return offerBookViewClass;
    }

    public static interface OfferActionHandler {
        public void onCreateOffer(TradeCurrency var1, PaymentMethod var2);

        public void onTakeOffer(Offer var1);
    }

    public static interface CloseHandler {
        public void close();
    }
}

