/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.offer;

import haveno.common.UserThread;
import haveno.core.offer.OfferUtil;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.common.model.ActivatableDataModel;
import java.math.BigInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public abstract class OfferDataModel
extends ActivatableDataModel {
    protected final XmrWalletService xmrWalletService;
    protected final OfferUtil offerUtil;
    protected final BooleanProperty isXmrWalletFunded = new SimpleBooleanProperty();
    protected final ObjectProperty<BigInteger> totalToPay = new SimpleObjectProperty();
    protected final ObjectProperty<BigInteger> balance = new SimpleObjectProperty();
    protected final ObjectProperty<BigInteger> availableBalance = new SimpleObjectProperty();
    protected final ObjectProperty<BigInteger> missingCoin = new SimpleObjectProperty((Object)BigInteger.ZERO);
    protected final BooleanProperty showWalletFundedNotification = new SimpleBooleanProperty();
    protected BigInteger totalBalance;
    protected BigInteger totalAvailableBalance;
    protected XmrAddressEntry addressEntry;
    protected boolean useSavingsWallet;

    public OfferDataModel(XmrWalletService xmrWalletService, OfferUtil offerUtil) {
        this.xmrWalletService = xmrWalletService;
        this.offerUtil = offerUtil;
    }

    protected void updateBalances() {
        BigInteger tradeWalletBalance = this.xmrWalletService.getBalanceForSubaddress(this.addressEntry.getSubaddressIndex());
        BigInteger tradeWalletAvailableBalance = this.xmrWalletService.getAvailableBalanceForSubaddress(this.addressEntry.getSubaddressIndex());
        BigInteger walletBalance = this.xmrWalletService.getBalance();
        BigInteger walletAvailableBalance = this.xmrWalletService.getAvailableBalance();
        UserThread.await(() -> {
            if (this.useSavingsWallet) {
                this.totalBalance = walletBalance;
                this.totalAvailableBalance = walletAvailableBalance;
                if (this.totalToPay.get() != null) {
                    this.balance.set((Object)((BigInteger)this.totalToPay.get()).min(this.totalBalance));
                    this.availableBalance.set((Object)((BigInteger)this.totalToPay.get()).min(this.totalAvailableBalance));
                }
            } else {
                this.totalBalance = tradeWalletBalance;
                this.totalAvailableBalance = tradeWalletAvailableBalance;
                this.balance.set((Object)tradeWalletBalance);
                this.availableBalance.set((Object)tradeWalletAvailableBalance);
            }
        });
    }

    public boolean hasTotalToPay() {
        return this.totalToPay.get() != null && ((BigInteger)this.totalToPay.get()).compareTo(BigInteger.ZERO) > 0;
    }

    public XmrWalletService getXmrWalletService() {
        return this.xmrWalletService;
    }

    public BooleanProperty getIsXmrWalletFunded() {
        return this.isXmrWalletFunded;
    }

    public ObjectProperty<BigInteger> getTotalToPay() {
        return this.totalToPay;
    }

    public ObjectProperty<BigInteger> getBalance() {
        return this.balance;
    }

    public ObjectProperty<BigInteger> getAvailableBalance() {
        return this.availableBalance;
    }

    public ObjectProperty<BigInteger> getMissingCoin() {
        return this.missingCoin;
    }

    public BooleanProperty getShowWalletFundedNotification() {
        return this.showWalletFundedNotification;
    }

    public BigInteger getTotalBalance() {
        return this.totalBalance;
    }

    public BigInteger getTotalAvailableBalance() {
        return this.totalAvailableBalance;
    }
}

